/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.property;

import com.iplanet.idar.objectmodel.bean.LogPropertyBean;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.nmclf.SuiConstants;
import com.netscape.management.nmclf.SuiTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class FilesView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "Server-Configuration-Logs-Output";
    private JRadioButton radDefaultLogFile;
    private JRadioButton radLogFile;
    private SuiTextField tfLogFile;
    private JRadioButton radDefaultAuditFile;
    private JRadioButton radAuditFile;
    private SuiTextField tfAuditFile;
    private BlankPanel pnlLogFile;
    private BlankPanel pnlAuditFile;
    private JRadioButton radLogFacCode;
    private JComboBox cboLogFacCode;
    private JRadioButton radAuditFacCode;
    private JComboBox cboAuditFacCode;
    protected static final String[] FAC_CODES = new String[]{"LOG_DAEMON", "LOG_USER", "LOG_MAIL", "LOG_AUTH", "LOG_LPR", "LOG_NEWS", "LOG_UUCP", "LOG_CRON", "LOG_LOCAL0", "LOG_LOCAL1", "LOG_LOCAL2", "LOG_LOCAL3", "LOG_LOCAL4", "LOG_LOCAL5", "LOG_LOCAL6", "LOG_LOCAL7"};

    public FilesView() {
        this.initComponents(true);
    }

    public FilesView(boolean bl, ConsoleInfo consoleInfo) {
        this.setConsoleInfo(consoleInfo);
        if (bl) {
            this.initComponents(true);
        } else {
            this.initComponents(false);
        }
    }

    public FilesView(boolean bl) {
        if (bl) {
            this.initComponents(true);
        } else {
            this.initComponents(false);
        }
    }

    public void resetContent() throws ConfigurationViewException {
        LogPropertyBean logPropertyBean = (LogPropertyBean)this.getDataModel();
        if (logPropertyBean != null) {
            String string;
            this.setViewEnabled(true);
            String string2 = logPropertyBean.getLogFileName();
            if (string2 != null && !string2.trim().equals("")) {
                this.radLogFile.setSelected(true);
                this.tfLogFile.setText(string2);
            } else {
                string = logPropertyBean.getLogSyslogCode();
                if (string != null && !string.trim().equals("")) {
                    this.radLogFacCode.setSelected(true);
                    this.cboLogFacCode.setSelectedItem(string);
                } else {
                    this.radDefaultLogFile.setSelected(true);
                }
            }
            this.setLogFileEnablement();
            string = logPropertyBean.getAuditFileName();
            if (string != null && !string.trim().equals("")) {
                this.radAuditFile.setSelected(true);
                this.tfAuditFile.setText(logPropertyBean.getAuditFileName());
            } else {
                String string3 = logPropertyBean.getAuditSyslogCode();
                if (string3 != null && !string3.trim().equals("")) {
                    this.radAuditFacCode.setSelected(true);
                    this.cboAuditFacCode.setSelectedItem(string3);
                } else {
                    this.radDefaultAuditFile.setSelected(true);
                }
            }
            this.setAuditFileEnablement();
        } else {
            this.setViewDefaults();
            this.setViewEnabled(false);
        }
    }

    public void applyChanges() throws ConfigurationViewException {
        LogPropertyBean logPropertyBean = (LogPropertyBean)this.getDataModel();
        if (logPropertyBean != null) {
            if (this.radLogFile.isSelected()) {
                if (this.tfLogFile.getText().trim().equals("")) {
                    throw new ConfigurationViewException(IDARResourceSet.getString("error", "ERR_NO_LOG_FILE"));
                }
                logPropertyBean.setLogFileName(this.tfLogFile.getText());
                logPropertyBean.setLogSyslogCode("");
            } else {
                logPropertyBean.setLogFileName("");
                if (this.radLogFacCode.isSelected()) {
                    logPropertyBean.setLogSyslogCode(this.cboLogFacCode.getSelectedItem().toString());
                } else {
                    logPropertyBean.setLogSyslogCode("");
                }
            }
            if (this.radAuditFile.isSelected()) {
                if (this.tfAuditFile.getText().trim().equals("")) {
                    throw new ConfigurationViewException(IDARResourceSet.getString("error", "ERR_NO_AUDIT_FILE"));
                }
                logPropertyBean.setAuditFileName(this.tfAuditFile.getText());
                logPropertyBean.setAuditSyslogCode("");
            } else {
                logPropertyBean.setAuditFileName("");
                if (this.radAuditFacCode.isSelected()) {
                    logPropertyBean.setAuditSyslogCode(this.cboAuditFacCode.getSelectedItem().toString());
                } else {
                    logPropertyBean.setAuditSyslogCode("");
                }
            }
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("propertyLogOutput", "TITLE");
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    protected void initComponents() {
        this.initComponents(true);
    }

    protected void initComponents(boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilesView.this.setLogFileEnablement();
            }
        };
        this.radDefaultLogFile = new JRadioButton(IDARResourceSet.getString("propertyLogOutput", "DEFAULT_LOG_FILE"));
        this.radDefaultLogFile.addActionListener(actionListener);
        this.radLogFile = new JRadioButton(IDARResourceSet.getString("propertyLogOutput", "CUSTOM_LOG_FILE") + ":");
        this.radLogFile.addActionListener(actionListener);
        this.radLogFacCode = new JRadioButton(IDARResourceSet.getString("propertyLogOutput", "LOG_FAC_CODE") + ":");
        this.radLogFacCode.addActionListener(actionListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radDefaultLogFile);
        buttonGroup.add(this.radLogFile);
        buttonGroup.add(this.radLogFacCode);
        this.tfLogFile = new SuiTextField();
        this.tfLogFile.setEnabled(bl);
        this.tfLogFile.getAccessibleContext().setAccessibleDescription(IDARResourceSet.getString("propertyLogOutput", "CUSTOM_LOG_FILE"));
        this.cboLogFacCode = new JComboBox<String>(FAC_CODES);
        this.cboLogFacCode.getAccessibleContext().setAccessibleDescription(IDARResourceSet.getString("propertyLogOutput", "LOG_FAC_CODE"));
        this.pnlLogFile = new BlankPanel();
        this.pnlLogFile.setLayout(new GridBagLayout());
        this.pnlLogFile.setBorder(BorderFactory.createTitledBorder(IDARResourceSet.getString("propertyLogOutput", "LOG_FILE")));
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilesView.this.setAuditFileEnablement();
            }
        };
        this.radDefaultAuditFile = new JRadioButton(IDARResourceSet.getString("propertyLogOutput", "DEFAULT_AUDIT_FILE"));
        this.radDefaultAuditFile.addActionListener(actionListener2);
        this.radAuditFile = new JRadioButton(IDARResourceSet.getString("propertyLogOutput", "CUSTOM_AUDIT_FILE") + ":");
        this.radAuditFile.addActionListener(actionListener2);
        this.radAuditFacCode = new JRadioButton(IDARResourceSet.getString("propertyLogOutput", "AUDIT_FAC_CODE") + ":");
        this.radAuditFacCode.addActionListener(actionListener2);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.radDefaultAuditFile);
        buttonGroup2.add(this.radAuditFile);
        buttonGroup2.add(this.radAuditFacCode);
        this.tfAuditFile = new SuiTextField();
        this.tfAuditFile.setEnabled(bl);
        this.tfAuditFile.getAccessibleContext().setAccessibleDescription(IDARResourceSet.getString("propertyLogOutput", "CUSTOM_AUDIT_FILE"));
        this.cboAuditFacCode = new JComboBox<String>(FAC_CODES);
        this.cboAuditFacCode.getAccessibleContext().setAccessibleDescription(IDARResourceSet.getString("propertyLogOutput", "AUDIT_FAC_CODE"));
        this.pnlAuditFile = new BlankPanel();
        this.pnlAuditFile.setLayout(new GridBagLayout());
        this.pnlAuditFile.setBorder(BorderFactory.createTitledBorder(IDARResourceSet.getString("propertyLogOutput", "AUDIT_FILE")));
        int n = 0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.right = 0;
        this.pnlLogFile.add((Component)this.radDefaultLogFile, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.right = 0;
        this.pnlLogFile.add((Component)this.radLogFile, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.right = 9;
        this.pnlLogFile.add((Component)this.tfLogFile, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.right = 0;
        this.pnlLogFile.add((Component)this.radLogFacCode, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.right = 9;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 29;
        gridBagConstraints.insets.right = 9;
        gridBagConstraints.insets.bottom = 9;
        this.pnlLogFile.add((Component)this.cboLogFacCode, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.right = 9;
        gridBagConstraints.insets.bottom = 0;
        this.add((Component)this.pnlLogFile, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.right = 0;
        this.pnlAuditFile.add((Component)this.radDefaultAuditFile, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.right = 0;
        this.pnlAuditFile.add((Component)this.radAuditFile, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.right = 9;
        this.pnlAuditFile.add((Component)this.tfAuditFile, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.right = 0;
        this.pnlAuditFile.add((Component)this.radAuditFacCode, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 29;
        gridBagConstraints.insets.right = 9;
        gridBagConstraints.insets.bottom = 9;
        this.pnlAuditFile.add((Component)this.cboAuditFacCode, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.right = 9;
        gridBagConstraints.insets.bottom = 9;
        this.add((Component)this.pnlAuditFile, gridBagConstraints);
    }

    private void setLogFileEnablement() {
        if (this.radLogFile.isSelected()) {
            this.tfLogFile.setEnabled(true);
        } else {
            this.tfLogFile.setEnabled(false);
        }
        if (this.radLogFacCode.isSelected()) {
            this.cboLogFacCode.setEnabled(true);
        } else {
            this.cboLogFacCode.setEnabled(false);
        }
    }

    private void setAuditFileEnablement() {
        if (this.radAuditFile.isSelected()) {
            this.tfAuditFile.setEnabled(true);
        } else {
            this.tfAuditFile.setEnabled(false);
        }
        if (this.radAuditFacCode.isSelected()) {
            this.cboAuditFacCode.setEnabled(true);
        } else {
            this.cboAuditFacCode.setEnabled(false);
        }
    }

    private void setViewEnabled(boolean bl) {
        this.radDefaultLogFile.setEnabled(true);
        this.radLogFile.setEnabled(bl);
        this.tfLogFile.setEnabled(bl);
        this.radDefaultAuditFile.setEnabled(true);
        this.radAuditFile.setEnabled(bl);
        this.tfAuditFile.setEnabled(bl);
        this.pnlLogFile.setEnabled(bl);
        this.pnlAuditFile.setEnabled(bl);
        this.radLogFacCode.setEnabled(bl);
        this.cboLogFacCode.setEnabled(bl);
        this.radAuditFacCode.setEnabled(bl);
        this.cboAuditFacCode.setEnabled(bl);
    }

    private void setViewDefaults() {
        this.radDefaultLogFile.doClick();
        this.radDefaultAuditFile.doClick();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new FilesView(false));
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

