/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.property;

import com.iplanet.idar.objectmodel.bean.LDAPServerPropertyBean;
import com.iplanet.idar.ui.common.DirBrowserCombo;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.common.components.IDARJButtonFactory;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.BlankPanelEvent;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.netscape.management.client.components.ButtonFactory;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import netscape.ldap.util.DN;

public class EncryptionView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "Property-LDAPServer-Encryption";
    private LDAPServerPropertyBean model;
    private JTextArea txtNote;
    private JLabel lblCertSubject;
    private JTextField tfCertSubject;
    private BlankPanel pnlPolicy;
    private JRadioButton radSSLClient;
    private JRadioButton radSSLAlways;
    private JRadioButton radSSLNever;
    private JButton butBrowse;

    public EncryptionView(ConsoleInfo consoleInfo) {
        this.setConsoleInfo(consoleInfo);
        this.initComponents();
    }

    public EncryptionView(ConsoleInfo consoleInfo, LDAPServerPropertyBean lDAPServerPropertyBean) {
        this.setDataModel(lDAPServerPropertyBean);
        this.setConsoleInfo(consoleInfo);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            // empty catch block
        }
    }

    public void resetContent() throws ConfigurationViewException {
        LDAPServerPropertyBean lDAPServerPropertyBean = (LDAPServerPropertyBean)this.getDataModel();
        if (lDAPServerPropertyBean != null) {
            this.tfCertSubject.setText(lDAPServerPropertyBean.getX509certSubject());
            String string = lDAPServerPropertyBean.getSecurityPolicy();
            if (string.equals("ssl_always")) {
                this.radSSLAlways.setSelected(true);
            } else if (string.equals("ssl_never")) {
                this.radSSLNever.setSelected(true);
            } else {
                this.radSSLClient.setSelected(true);
            }
        }
    }

    public void applyChanges() throws ConfigurationViewException {
        LDAPServerPropertyBean lDAPServerPropertyBean = (LDAPServerPropertyBean)this.getDataModel();
        if (lDAPServerPropertyBean != null) {
            Object object;
            String string = this.tfCertSubject.getText().trim();
            if (!string.equals("") && (object = new DN(string)).toString().trim().equals("")) {
                throw new ConfigurationViewException(IDARResourceSet.getString("dialogDN", "ILLEGAL_DN_MESSAGE"));
            }
            object = this.tfCertSubject.getText().trim();
            if (!((String)object).equals("")) {
                lDAPServerPropertyBean.setX509certSubject((String)object);
            } else {
                lDAPServerPropertyBean.setX509certSubject(null);
            }
            if (this.radSSLClient.isSelected()) {
                lDAPServerPropertyBean.setSecurityPolicy("ssl_optional");
            } else if (this.radSSLAlways.isSelected()) {
                lDAPServerPropertyBean.setSecurityPolicy("ssl_always");
            } else if (this.radSSLNever.isSelected()) {
                lDAPServerPropertyBean.setSecurityPolicy("ssl_never");
            }
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("propertyLDAPServerEncryption", "TITLE");
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    protected void initComponents() {
        this.txtNote = new JTextArea();
        this.txtNote.setText(IDARResourceSet.getString("propertyLDAPServerEncryption", "NOTE"));
        this.txtNote.setEditable(false);
        this.txtNote.setBackground(this.getBackground());
        this.txtNote.setLineWrap(true);
        this.txtNote.setWrapStyleWord(true);
        this.pnlPolicy = new BlankPanel();
        this.pnlPolicy.addBlankPanelListener(this);
        this.pnlPolicy.setBorder(BorderFactory.createTitledBorder(IDARResourceSet.getString("propertyLDAPServerEncryption", "SSL_POLICY")));
        this.radSSLClient = new JRadioButton(IDARResourceSet.getString("propertyLDAPServerEncryption", "SSL_OPTIONAL"));
        this.radSSLAlways = new JRadioButton(IDARResourceSet.getString("propertyLDAPServerEncryption", "SSL_ALWAYS"));
        this.radSSLNever = new JRadioButton(IDARResourceSet.getString("propertyLDAPServerEncryption", "SSL_NEVER"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radSSLClient);
        buttonGroup.add(this.radSSLAlways);
        buttonGroup.add(this.radSSLNever);
        this.tfCertSubject = new JTextField();
        this.lblCertSubject = new JLabel();
        this.lblCertSubject.setText(IDARResourceSet.getString("propertyLDAPServerEncryption", "SUBJECT") + ":");
        this.lblCertSubject.setLabelFor(this.tfCertSubject);
        this.butBrowse = IDARJButtonFactory.create(IDARResourceSet.getString("button", "BROWSE"));
        this.butBrowse.setToolTipText(IDARResourceSet.getString("tooltip", "browse_dn"));
        ButtonFactory.resizeButton((JButton)this.butBrowse);
        this.butBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleInfo consoleInfo = EncryptionView.this.getConsoleInfo();
                if (consoleInfo != null) {
                    DirBrowserCombo dirBrowserCombo = new DirBrowserCombo(IDARUtilities.getParentJFrame(EncryptionView.this), consoleInfo, EncryptionView.this.getDataModel().getParentConfiguration());
                    dirBrowserCombo.setModal(true);
                    dirBrowserCombo.setBaseDN(EncryptionView.this.tfCertSubject.getText());
                    dirBrowserCombo.show();
                    if (!dirBrowserCombo.isCancel()) {
                        EncryptionView.this.tfCertSubject.setText(dirBrowserCombo.getSelectedDN());
                        EncryptionView.this.fireBlankPanelEvent(new BlankPanelEvent(null));
                    }
                    dirBrowserCombo = null;
                } else {
                    Debug.println((int)6, (String)("EncryptionView:BrowseButton: consoleInfo = " + consoleInfo));
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.pnlPolicy.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.pnlPolicy.add((Component)this.radSSLClient, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.pnlPolicy.add((Component)this.radSSLAlways, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.pnlPolicy.add((Component)this.radSSLNever, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        this.add((Component)this.txtNote, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 12;
        this.add((Component)this.lblCertSubject, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.tfCertSubject, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.butBrowse, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.pnlPolicy, gridBagConstraints);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new EncryptionView(null, new LDAPServerPropertyBean()));
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

