/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.property;

import com.iplanet.idar.objectmodel.bean.AttributeRenamingPropertyBean;
import com.iplanet.idar.objectmodel.bean.UniqueNameException;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.ImageFactory;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.netscape.management.client.ug.TitlePanel;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class AttributeRenamingPropertyView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "Property-AttributeRenaming";
    private TitlePanel pnlTitle;
    private JLabel lblName;
    private JTextField tfName;
    private JLabel lblServer;
    private JTextField tfServer;
    private JLabel lblClient;
    private JTextField tfClient;

    public AttributeRenamingPropertyView() {
        this.initComponents();
    }

    public void resetContent() throws ConfigurationViewException {
        try {
            AttributeRenamingPropertyBean attributeRenamingPropertyBean = (AttributeRenamingPropertyBean)super.getDataModel();
            if (attributeRenamingPropertyBean != null) {
                this.tfName.setText(attributeRenamingPropertyBean.getId());
                this.tfServer.setText(attributeRenamingPropertyBean.getServerAttributeName());
                this.tfClient.setText(attributeRenamingPropertyBean.getClientAttributeName());
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void applyChanges() throws ConfigurationViewException {
        AttributeRenamingPropertyBean attributeRenamingPropertyBean = (AttributeRenamingPropertyBean)super.getDataModel();
        if (attributeRenamingPropertyBean != null) {
            if (this.tfName.getText().trim().equals("")) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "ERR_NO_ID"));
            }
            if (!attributeRenamingPropertyBean.getName().equals(this.tfName.getText())) {
                try {
                    attributeRenamingPropertyBean.setName(this.tfName.getText());
                }
                catch (UniqueNameException uniqueNameException) {
                    throw new ConfigurationViewException(IDARResourceSet.getString("error", "UNIQUE_NAME", this.tfName.getText()));
                }
            }
            if (this.tfServer.getText().trim().equals("")) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "NO_SERVER_ATTRIBUTE_NAME"));
            }
            if (this.tfClient.getText().trim().equals("")) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "NO_CLIENT_ATTRIBUTE_NAME"));
            }
            attributeRenamingPropertyBean.setServerAttributeName(this.tfServer.getText());
            attributeRenamingPropertyBean.setClientAttributeName(this.tfClient.getText());
        }
    }

    public String getTitleText() {
        return IDARResourceSet.getString("propertyAttributeRenaming", "TITLE");
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    protected void initComponents() {
        this.pnlTitle = new TitlePanel();
        this.pnlTitle.setIcon((Icon)ImageFactory.getImage("PROPERTY"));
        this.pnlTitle.setText(this.getTitleText());
        this.tfName = new JTextField();
        this.lblName = new JLabel(IDARResourceSet.getString("propertyGeneral", "PROPERTY") + ":");
        this.lblName.setLabelFor(this.tfName);
        this.tfServer = new JTextField(12);
        this.lblServer = new JLabel(IDARResourceSet.getString("propertyAttributeRenaming", "SERVER_ATTR_NAME") + ":");
        this.lblServer.setLabelFor(this.tfServer);
        this.tfClient = new JTextField(12);
        this.lblClient = new JLabel(IDARResourceSet.getString("propertyAttributeRenaming", "CLIENT_ATTR_NAME") + ":");
        this.lblClient.setLabelFor(this.tfClient);
        this.setLayout(new GridBagLayout());
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.pnlTitle, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.lblName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.tfName, gridBagConstraints);
        BlankPanel blankPanel = new BlankPanel();
        blankPanel.setBorder(BorderFactory.createTitledBorder(IDARResourceSet.getString("propertyAttributeRenaming", "ATTRIBUTE")));
        blankPanel.setLayout(new GridBagLayout());
        int n2 = 0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        blankPanel.add((Component)this.lblServer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        blankPanel.add((Component)this.tfServer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        blankPanel.add((Component)this.lblClient, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        blankPanel.add((Component)this.tfClient, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)blankPanel, gridBagConstraints);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new AttributeRenamingPropertyView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

