/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.property;

import com.iplanet.idar.objectmodel.bean.ForbiddenEntryPropertyBean;
import com.iplanet.idar.ui.common.AttributeDialog;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.common.components.IDARJButtonFactory;
import com.iplanet.idar.ui.common.configuration.BlankPanelEvent;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.netscape.management.client.components.ButtonFactory;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AttributeFilteringView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "Property-ForbiddenEntry-AttributeFiltering";
    private JLabel lblIfMatch;
    private JRadioButton radExcludeEntry;
    private JRadioButton radExcludeAttributes;
    private JRadioButton radIncludeAttributes;
    private JButton butAddAttribute;
    private JButton butRemoveAttribute;
    private JButton butEditAttribute;
    private JPanel pnlAttributeBar;
    private JList lstAttributes;
    private DefaultListModel listModel;

    public AttributeFilteringView() {
        this.initComponents();
    }

    public AttributeFilteringView(ConsoleInfo consoleInfo) {
        this.setConsoleInfo(consoleInfo);
        this.initComponents();
    }

    public void applyChanges() throws ConfigurationViewException {
        Vector vector;
        ForbiddenEntryPropertyBean forbiddenEntryPropertyBean = (ForbiddenEntryPropertyBean)this.getDataModel();
        if (forbiddenEntryPropertyBean != null) {
            if ((this.radExcludeAttributes.isSelected() || this.radIncludeAttributes.isSelected()) && this.listModel.getSize() == 0) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "MISSING_ATTRIBUTES"));
            }
            if (this.radExcludeEntry.isSelected()) {
                forbiddenEntryPropertyBean.setMode(0);
            } else if (this.radExcludeAttributes.isSelected()) {
                forbiddenEntryPropertyBean.setMode(1);
            } else if (this.radIncludeAttributes.isSelected()) {
                forbiddenEntryPropertyBean.setMode(2);
            }
            vector = new Vector();
            Enumeration enumeration = this.listModel.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        } else {
            throw new ConfigurationViewException("Model is null");
        }
        forbiddenEntryPropertyBean.setAttributes(vector);
    }

    public void resetContent() throws ConfigurationViewException {
        ForbiddenEntryPropertyBean forbiddenEntryPropertyBean = (ForbiddenEntryPropertyBean)this.getDataModel();
        if (forbiddenEntryPropertyBean != null) {
            int n = forbiddenEntryPropertyBean.getMode();
            this.radExcludeEntry.setSelected(n == 0);
            this.radExcludeAttributes.setSelected(n == 1);
            this.radIncludeAttributes.setSelected(n == 2);
            this.listModel.clear();
            Vector vector = forbiddenEntryPropertyBean.getAttributes();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.listModel.addElement(enumeration.nextElement().toString());
            }
            this.setButtonEnablement();
        }
    }

    protected void initComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.lblIfMatch = new JLabel();
        this.lblIfMatch.setText(IDARResourceSet.getString("propertyForbiddenEntryAttribute", "IF_MATCH") + ":");
        this.radExcludeEntry = new JRadioButton();
        this.radExcludeEntry.setText(IDARResourceSet.getString("propertyForbiddenEntryAttribute", "EXCLUDE_ENTIRE_ENTRY"));
        this.radExcludeEntry.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeFilteringView.this.setButtonEnablement();
            }
        });
        this.radExcludeAttributes = new JRadioButton();
        this.radExcludeAttributes.setText(IDARResourceSet.getString("propertyForbiddenEntryAttribute", "EXCLUDE_ATTRIBUTES"));
        this.radExcludeAttributes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeFilteringView.this.setButtonEnablement();
            }
        });
        this.radIncludeAttributes = new JRadioButton();
        this.radIncludeAttributes.setText(IDARResourceSet.getString("propertyForbiddenEntryAttribute", "INCLUDE_ATTRIBUTES"));
        this.radIncludeAttributes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeFilteringView.this.setButtonEnablement();
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radExcludeEntry);
        buttonGroup.add(this.radExcludeAttributes);
        buttonGroup.add(this.radIncludeAttributes);
        buttonGroup.setSelected(this.radExcludeEntry.getModel(), true);
        this.butAddAttribute = IDARJButtonFactory.create(IDARResourceSet.getString("button", "ADD"));
        this.butAddAttribute.setToolTipText(IDARResourceSet.getString("tooltip", "add_attribute"));
        ButtonFactory.resizeButton((JButton)this.butAddAttribute);
        this.butAddAttribute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Frame frame = IDARUtilities.getParentFrame(AttributeFilteringView.this);
                AttributeDialog attributeDialog = new AttributeDialog(frame);
                attributeDialog.showModal();
                if (!attributeDialog.isCancel()) {
                    String string = attributeDialog.getAttribute();
                    AttributeFilteringView.this.listModel.addElement(string);
                    AttributeFilteringView.this.fireBlankPanelEvent(new BlankPanelEvent(null));
                }
            }
        });
        this.butAddAttribute.setEnabled(false);
        this.butRemoveAttribute = IDARJButtonFactory.create(IDARResourceSet.getString("button", "REMOVE"));
        this.butRemoveAttribute.setToolTipText(IDARResourceSet.getString("tooltip", "remove_attribute"));
        ButtonFactory.resizeButton((JButton)this.butRemoveAttribute);
        this.butRemoveAttribute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = AttributeFilteringView.this.lstAttributes.getSelectedIndex();
                if (n != -1) {
                    AttributeFilteringView.this.listModel.remove(n);
                    int n2 = AttributeFilteringView.this.listModel.size();
                    if (n >= n2) {
                        n = n2 - 1;
                    }
                    AttributeFilteringView.this.lstAttributes.addSelectionInterval(n, n);
                    AttributeFilteringView.this.fireBlankPanelEvent(new BlankPanelEvent(null));
                }
            }
        });
        this.butRemoveAttribute.setEnabled(false);
        this.butEditAttribute = IDARJButtonFactory.create(IDARResourceSet.getString("button", "EDIT"));
        this.butEditAttribute.setToolTipText(IDARResourceSet.getString("tooltip", "edit_attribute"));
        ButtonFactory.resizeButton((JButton)this.butEditAttribute);
        this.butEditAttribute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = AttributeFilteringView.this.lstAttributes.getSelectedIndex();
                String string = AttributeFilteringView.this.listModel.get(n).toString();
                Frame frame = IDARUtilities.getParentFrame(AttributeFilteringView.this);
                AttributeDialog attributeDialog = new AttributeDialog(frame, string);
                attributeDialog.showModal();
                if (!attributeDialog.isCancel()) {
                    AttributeFilteringView.this.listModel.set(n, attributeDialog.getAttribute());
                    AttributeFilteringView.this.fireBlankPanelEvent(new BlankPanelEvent(null));
                }
            }
        });
        this.butEditAttribute.setEnabled(false);
        this.pnlAttributeBar = new JPanel();
        this.pnlAttributeBar.setLayout(new FlowLayout(0));
        this.pnlAttributeBar.add(this.butAddAttribute);
        this.pnlAttributeBar.add(this.butEditAttribute);
        this.pnlAttributeBar.add(this.butRemoveAttribute);
        this.listModel = new DefaultListModel();
        this.lstAttributes = new JList(this.listModel);
        this.lstAttributes.setToolTipText(IDARResourceSet.getString("tooltip", "list_of_attributes_to_include_or_exclude"));
        this.lstAttributes.setVisibleRowCount(5);
        this.lstAttributes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                AttributeFilteringView.this.setButtonEnablement();
            }
        });
        this.lstAttributes.getModel().addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent listDataEvent) {
                AttributeFilteringView.this.setButtonEnablement();
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
                AttributeFilteringView.this.setButtonEnablement();
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                AttributeFilteringView.this.setButtonEnablement();
            }
        });
        this.lstAttributes.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    AttributeFilteringView.this.butEditAttribute.doClick();
                }
            }
        });
        int n = 0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 2;
        this.add((Component)this.lblIfMatch, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.radExcludeEntry, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.radExcludeAttributes, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.radExcludeAttributes, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.radIncludeAttributes, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.pnlAttributeBar, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new JScrollPane(this.lstAttributes), gridBagConstraints);
    }

    private void setButtonEnablement() {
        if (this.radExcludeEntry.isSelected()) {
            this.butAddAttribute.setEnabled(false);
            this.butRemoveAttribute.setEnabled(false);
            this.butEditAttribute.setEnabled(false);
            this.lstAttributes.setEnabled(false);
            this.lstAttributes.setBackground(null);
        } else {
            this.butAddAttribute.setEnabled(true);
            this.lstAttributes.setEnabled(true);
            this.lstAttributes.setBackground(Color.white);
            boolean bl = this.lstAttributes.getModel().getSize() != 0 && this.lstAttributes.getSelectedIndex() != -1 && this.lstAttributes.getModel().getSize() > this.lstAttributes.getSelectedIndex();
            this.butRemoveAttribute.setEnabled(bl);
            this.butEditAttribute.setEnabled(bl);
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("propertyForbiddenEntryAttribute", "TITLE");
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new AttributeFilteringView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

