/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.group;

import com.iplanet.idar.objectmodel.BeanListenable;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.NetworkGroupBean;
import com.iplanet.idar.ui.common.AbstractChooserDialog;
import com.iplanet.idar.ui.common.FilteredInputDocument;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.BlankPanelEvent;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.iplanet.idar.ui.configurator.ObjectTableModel;
import com.iplanet.idar.ui.task.TaskButton;
import com.iplanet.idar.ui.task.configuration.IplanetEditObjectTask;
import com.netscape.management.client.components.ButtonFactory;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class SearchSizeView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "NetworkGroup-Search-Size";
    private ObjectTableModel tableModel;
    private int selectedRow;
    private JTable tblTable;
    private Vector vSearchSize;
    final String[] descriptors = new String[]{"search-size-limit"};
    private JTextArea txtNote;
    private JTextArea txtDefaultNote;
    private JCheckBox chkMaximumResultSize;
    private JTextField tfMaximumResultSize;
    private BlankPanel pnlSearchSize;
    private JPanel pnlButtons;
    private JButton butAdd;
    private JButton butEdit;
    private JButton butRemove;
    private DefaultListModel listModel;
    protected final IplanetEditObjectTask editTask = new IplanetEditObjectTask();

    public SearchSizeView() {
        this.initComponents();
    }

    public SearchSizeView(ConsoleInfo consoleInfo, NetworkGroupBean networkGroupBean) {
        this.setConsoleInfo(consoleInfo);
        this.setDataModel(networkGroupBean);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            Debug.println((int)6, (String)("Unable to resetContent in Constructor. Model = " + networkGroupBean));
        }
    }

    public void setConsoleInfo(ConsoleInfo consoleInfo) {
        super.setConsoleInfo(consoleInfo);
        this.editTask.setConsoleInfo(consoleInfo);
    }

    protected void initComponents() {
        this.txtNote = new JTextArea();
        this.txtNote.setText(IDARResourceSet.getString("groupSearchSizeView", "NOTE"));
        this.txtNote.setEditable(false);
        this.txtNote.setBackground(this.getBackground());
        this.txtNote.setLineWrap(true);
        this.txtNote.setWrapStyleWord(true);
        this.txtDefaultNote = new JTextArea();
        this.txtDefaultNote.setText(IDARResourceSet.getString("groupSearchSizeView", "DEFAULT_NOTE"));
        this.txtDefaultNote.setEditable(false);
        this.txtDefaultNote.setBackground(this.getBackground());
        this.txtDefaultNote.setLineWrap(true);
        this.txtDefaultNote.setWrapStyleWord(true);
        this.chkMaximumResultSize = new JCheckBox(IDARResourceSet.getString("groupSearchSizeView", "MAX_RESULT_SIZE"));
        this.chkMaximumResultSize.setSelected(false);
        this.chkMaximumResultSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SearchSizeView.this.chkMaximumResultSize.isSelected()) {
                    SearchSizeView.this.tfMaximumResultSize.setEnabled(true);
                    SearchSizeView.this.tfMaximumResultSize.setBackground(Color.white);
                } else {
                    SearchSizeView.this.tfMaximumResultSize.setEnabled(false);
                    SearchSizeView.this.tfMaximumResultSize.setBackground(null);
                }
            }
        });
        this.tfMaximumResultSize = new JTextField(6);
        this.tfMaximumResultSize.getAccessibleContext().setAccessibleDescription(IDARResourceSet.getString("groupSearchSizeView", "MAX_RESULT_SIZE"));
        this.tfMaximumResultSize.setDocument(FilteredInputDocument.allowDigitsOnly());
        this.tfMaximumResultSize.setMinimumSize(this.tfMaximumResultSize.getPreferredSize());
        this.tfMaximumResultSize.setEnabled(false);
        this.tfMaximumResultSize.setBackground(null);
        this.pnlSearchSize = new BlankPanel();
        this.pnlSearchSize.setBorder(BorderFactory.createTitledBorder(IDARResourceSet.getString("groupSearchSizeView", "SEARCH_PROPERTIES")));
        this.pnlButtons = this.initButtonBar();
        this.tableModel = new ObjectTableModel(false);
        this.tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                SearchSizeView.this.setEnablement();
            }
        });
        this.tblTable = new JTable(this.tableModel);
        this.tblTable.setToolTipText(IDARResourceSet.getString("tooltip", "list_of_search_size_limit_property"));
        this.tblTable.setPreferredScrollableViewportSize(new Dimension(300, 100));
        this.tblTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SearchSizeView.this.setEnablement();
            }
        });
        this.tblTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    SearchSizeView.this.butEdit.doClick();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.tblTable);
        jScrollPane.setVerticalScrollBarPolicy(20);
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.pnlSearchSize.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.pnlSearchSize.add((Component)this.txtDefaultNote, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.pnlSearchSize.add((Component)this.pnlButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        this.pnlSearchSize.add((Component)jScrollPane, gridBagConstraints);
        n = 0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.txtNote, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.chkMaximumResultSize, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 0, 0, 9);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.tfMaximumResultSize, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        this.add((Component)this.pnlSearchSize, gridBagConstraints);
    }

    protected JPanel initButtonBar() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        this.butAdd = ButtonFactory.createButton((String)IDARResourceSet.getString("button", "ADD"));
        this.butAdd.setToolTipText(IDARResourceSet.getString("tooltip", "add_search_size_limit_property"));
        this.butAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IDARModelBean iDARModelBean = SearchSizeView.this.getDataModel();
                if (iDARModelBean != null) {
                    AbstractChooserDialog abstractChooserDialog = new AbstractChooserDialog(IDARUtilities.getParentFrame(SearchSizeView.this), IDARResourceSet.getString("groupSearchSizeView", "CHOOSER_SEARCH_TITLE"), IDARResourceSet.getString("groupSearchSizeView", "CHOOSER_SEARCH_NOTE"), iDARModelBean.getParentConfiguration(), SearchSizeView.this.descriptors, SearchSizeView.this.getConsoleInfo(), true);
                    abstractChooserDialog.show();
                    if (!abstractChooserDialog.isCancel()) {
                        SearchSizeView.this.vSearchSize = abstractChooserDialog.getSelectedBeans();
                        for (int i = 0; i < SearchSizeView.this.vSearchSize.size(); ++i) {
                            SearchSizeView.this.tableModel.addElement((BeanListenable)SearchSizeView.this.vSearchSize.elementAt(i));
                            SearchSizeView.this.tblTable.revalidate();
                        }
                        SearchSizeView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(SearchSizeView.this.tableModel)));
                    }
                }
            }
        });
        this.butAdd.setEnabled(true);
        this.butEdit = new TaskButton(this.editTask);
        this.butRemove = ButtonFactory.createButton((String)IDARResourceSet.getString("button", "REMOVE"));
        this.butRemove.setToolTipText(IDARResourceSet.getString("tooltip", "remove_search_size_limit_property"));
        this.butRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = SearchSizeView.this.tblTable.getSelectedRow();
                if (n != -1) {
                    SearchSizeView.this.tableModel.removeElement(n);
                }
                SearchSizeView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(SearchSizeView.this.tableModel)));
            }
        });
        this.butRemove.setEnabled(false);
        ButtonFactory.resizeButton((JButton)this.butAdd);
        ButtonFactory.resizeButton((JButton)this.butEdit);
        ButtonFactory.resizeButton((JButton)this.butRemove);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.butAdd);
        jPanel2.add(Box.createHorizontalStrut(6));
        jPanel2.add(this.butEdit);
        jPanel2.add(Box.createHorizontalStrut(6));
        jPanel2.add(this.butRemove);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private void setEnablement() {
        boolean bl = this.tblTable.getRowCount() != 0 && this.tblTable.getSelectedRow() != -1 && this.tblTable.getRowCount() > this.tblTable.getSelectedRow();
        this.butRemove.setEnabled(bl);
        this.editTask.setObject(this.tableModel.getReference(this.tblTable.getSelectedRow()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void applyChanges() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        if (networkGroupBean == null) throw new ConfigurationViewException();
        if (this.chkMaximumResultSize.isSelected()) {
            String string = this.tfMaximumResultSize.getText().trim();
            if (string.equals("")) throw new ConfigurationViewException(IDARResourceSet.getString("error", "MISSING_MAX_RESULT_SIZE"));
            Integer n = null;
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "NUMBER_FORMAT") + ": " + string);
            }
            if (n == 0) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "ZERO_MAX_RESULT_SIZE"));
            }
            networkGroupBean.setMaxResultSize(n);
        } else {
            networkGroupBean.setMaxResultSize(null);
        }
        networkGroupBean.setSearchSizeLimitProperties(this.tableModel.getElements());
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("groupSearchSizeView", "TITLE");
    }

    public void resetContent() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        Debug.println((String)("SearchSizeView.resetContent: model=" + networkGroupBean));
        if (networkGroupBean != null) {
            Integer n = networkGroupBean.getMaxResultSize();
            if (n != null) {
                this.chkMaximumResultSize.setSelected(true);
                this.tfMaximumResultSize.setEnabled(true);
                this.tfMaximumResultSize.setBackground(Color.white);
                this.tfMaximumResultSize.setText(n.toString());
            } else {
                this.chkMaximumResultSize.setSelected(false);
                this.tfMaximumResultSize.setEnabled(false);
                this.tfMaximumResultSize.setBackground(null);
                this.tfMaximumResultSize.setText("");
            }
        } else {
            throw new ConfigurationViewException();
        }
        this.tableModel.removeAllElements();
        this.tableModel.setElements(networkGroupBean.getSearchSizeLimitProperties());
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new SearchSizeView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

