/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.group;

import com.iplanet.idar.objectmodel.bean.NetworkGroupBean;
import com.iplanet.idar.ui.common.DirBrowserCombo;
import com.iplanet.idar.ui.common.FilteredInputDocument;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.BlankPanelEvent;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.netscape.management.client.components.ButtonFactory;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import netscape.ldap.util.DN;

public class SearchControlView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "NetworkGroup-Search-Control";
    private JTextArea txtNote;
    private JTextArea txtNoteMod;
    private JCheckBox chkAllowInequality;
    private JCheckBox chkMinimumSubstringSize;
    private JTextField tfMinimumSubstringSize;
    private JCheckBox chkRestrictOperationsToDN;
    private JTextField tfRestrictOperationsToDN;
    private JCheckBox chkMaxTimeLimit;
    private JTextField tfMaxTimeLimit;
    private JButton butBrowse;
    private BlankPanel pnlOperations;
    private BlankPanel pnlMinSubString;

    public SearchControlView() {
        this.initComponents();
    }

    public SearchControlView(ConsoleInfo consoleInfo, NetworkGroupBean networkGroupBean) {
        this.setConsoleInfo(consoleInfo);
        this.setDataModel(networkGroupBean);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            Debug.println((int)6, (String)("Unable to resetContent in SearchControlView Constructor. Model = " + networkGroupBean));
        }
    }

    protected void initComponents() {
        this.txtNote = new JTextArea();
        this.txtNote.setText(IDARResourceSet.getString("groupSearchControl", "NOTE"));
        this.txtNote.setEditable(false);
        this.txtNote.setBackground(this.getBackground());
        this.txtNote.setLineWrap(true);
        this.txtNote.setWrapStyleWord(true);
        this.chkAllowInequality = new JCheckBox();
        this.chkAllowInequality.setText(IDARResourceSet.getString("groupSearchControl", "ALLOW_INEQUALITY"));
        this.chkMaxTimeLimit = new JCheckBox();
        this.chkMaxTimeLimit.setText(IDARResourceSet.getString("groupSearchControl", "MAXIMUM_TIME_LIMIT") + ":");
        this.chkMaxTimeLimit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SearchControlView.this.chkMaxTimeLimit.isSelected()) {
                    SearchControlView.this.tfMaxTimeLimit.setEnabled(true);
                    SearchControlView.this.tfMaxTimeLimit.setBackground(Color.white);
                } else {
                    SearchControlView.this.tfMaxTimeLimit.setEnabled(false);
                    SearchControlView.this.tfMaxTimeLimit.setBackground(null);
                }
            }
        });
        this.tfMaxTimeLimit = new JTextField(6);
        this.tfMaxTimeLimit.getAccessibleContext().setAccessibleDescription(IDARResourceSet.getString("groupSearchControl", "MAXIMUM_TIME_LIMIT"));
        this.tfMaxTimeLimit.setMinimumSize(this.tfMaxTimeLimit.getPreferredSize());
        this.tfMaxTimeLimit.setDocument(FilteredInputDocument.allowDigitsOnly());
        this.tfMaxTimeLimit.setEnabled(false);
        this.tfMaxTimeLimit.setBackground(null);
        this.pnlOperations = new BlankPanel();
        this.pnlOperations.setBorder(BorderFactory.createTitledBorder(IDARResourceSet.getString("groupSearchControl", "MOD_SEARCH")));
        this.pnlMinSubString = new BlankPanel();
        this.chkMinimumSubstringSize = new JCheckBox();
        this.chkMinimumSubstringSize.setText(IDARResourceSet.getString("groupSearchControl", "SUBSTRING_MINIMUM") + ":");
        this.chkMinimumSubstringSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SearchControlView.this.chkMinimumSubstringSize.isSelected()) {
                    SearchControlView.this.tfMinimumSubstringSize.setEnabled(true);
                    SearchControlView.this.tfMinimumSubstringSize.setBackground(Color.white);
                } else {
                    SearchControlView.this.tfMinimumSubstringSize.setEnabled(false);
                    SearchControlView.this.tfMinimumSubstringSize.setBackground(null);
                }
            }
        });
        this.tfMinimumSubstringSize = new JTextField(6);
        this.tfMinimumSubstringSize.getAccessibleContext().setAccessibleDescription(IDARResourceSet.getString("groupSearchControl", "SUBSTRING_MINIMUM"));
        this.tfMinimumSubstringSize.setMinimumSize(this.tfMinimumSubstringSize.getPreferredSize());
        this.tfMinimumSubstringSize.setDocument(FilteredInputDocument.allowDigitsOnly());
        this.tfMinimumSubstringSize.setEnabled(false);
        this.tfMinimumSubstringSize.setBackground(null);
        this.txtNoteMod = new JTextArea();
        this.txtNoteMod.setText(IDARResourceSet.getString("groupSearchControl", "NOTE_MOD"));
        this.txtNoteMod.setEditable(false);
        this.txtNoteMod.setBackground(this.getBackground());
        this.txtNoteMod.setLineWrap(true);
        this.txtNoteMod.setWrapStyleWord(true);
        this.chkRestrictOperationsToDN = new JCheckBox();
        this.chkRestrictOperationsToDN.setText(IDARResourceSet.getString("groupSearchControl", "RESTRICT_OPERATIONS") + ":");
        this.chkRestrictOperationsToDN.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SearchControlView.this.chkRestrictOperationsToDN.isSelected()) {
                    SearchControlView.this.tfRestrictOperationsToDN.setEnabled(true);
                    SearchControlView.this.tfRestrictOperationsToDN.setBackground(Color.white);
                    SearchControlView.this.butBrowse.setEnabled(true);
                } else {
                    SearchControlView.this.tfRestrictOperationsToDN.setEnabled(false);
                    SearchControlView.this.tfRestrictOperationsToDN.setBackground(null);
                    SearchControlView.this.butBrowse.setEnabled(false);
                }
            }
        });
        this.tfRestrictOperationsToDN = new JTextField();
        this.tfRestrictOperationsToDN.getAccessibleContext().setAccessibleDescription(IDARResourceSet.getString("groupSearchControl", "RESTRICT_OPERATIONS"));
        this.tfRestrictOperationsToDN.setMinimumSize(this.tfRestrictOperationsToDN.getPreferredSize());
        this.tfRestrictOperationsToDN.setEnabled(false);
        this.tfRestrictOperationsToDN.setBackground(null);
        this.butBrowse = ButtonFactory.createButton((String)IDARResourceSet.getString("button", "BROWSE"));
        this.butBrowse.setToolTipText(IDARResourceSet.getString("tooltip", "browse_dn"));
        ButtonFactory.resizeButton((JButton)this.butBrowse);
        this.butBrowse.setEnabled(false);
        this.butBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleInfo consoleInfo = SearchControlView.this.getConsoleInfo();
                if (consoleInfo != null) {
                    DirBrowserCombo dirBrowserCombo = new DirBrowserCombo(IDARUtilities.getParentJFrame(SearchControlView.this), consoleInfo, SearchControlView.this.getDataModel().getParentConfiguration());
                    dirBrowserCombo.setModal(true);
                    dirBrowserCombo.setBaseDN(SearchControlView.this.tfRestrictOperationsToDN.getText());
                    dirBrowserCombo.show();
                    if (!dirBrowserCombo.isCancel()) {
                        SearchControlView.this.tfRestrictOperationsToDN.setText(dirBrowserCombo.getSelectedDN());
                        SearchControlView.this.fireBlankPanelEvent(new BlankPanelEvent(null));
                    }
                    dirBrowserCombo = null;
                } else {
                    Debug.println((int)6, (String)("SearchControlView:BrowseButton: consoleInfo = " + consoleInfo));
                }
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        this.pnlMinSubString.setLayout(new GridBagLayout());
        this.pnlMinSubString.addBlankPanelListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        this.pnlMinSubString.add((Component)this.chkMinimumSubstringSize, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.left = 9;
        this.pnlMinSubString.add((Component)this.tfMinimumSubstringSize, gridBagConstraints);
        n = 0;
        this.pnlOperations.setLayout(new GridBagLayout());
        this.pnlOperations.addBlankPanelListener(this);
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 3;
        this.pnlOperations.add((Component)this.txtNoteMod, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        this.pnlOperations.add((Component)this.pnlMinSubString, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 3;
        this.pnlOperations.add((Component)this.chkRestrictOperationsToDN, gridBagConstraints);
        gridBagConstraints.insets = new Insets(9, 26, 9, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.pnlOperations.add((Component)this.tfRestrictOperationsToDN, gridBagConstraints);
        gridBagConstraints.insets.right = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        this.pnlOperations.add((Component)this.butBrowse, gridBagConstraints);
        n = 0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.txtNote, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.chkAllowInequality, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)this.chkMaxTimeLimit, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.tfMaxTimeLimit, gridBagConstraints);
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.pnlOperations, gridBagConstraints);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void applyChanges() throws ConfigurationViewException {
        Integer n;
        String string;
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        if (networkGroupBean == null) throw new ConfigurationViewException();
        networkGroupBean.setFilterInequality(this.chkAllowInequality.isSelected());
        if (this.chkMinimumSubstringSize.isSelected()) {
            string = this.tfMinimumSubstringSize.getText().trim();
            string.trim();
            if (string.equals("")) throw new ConfigurationViewException(IDARResourceSet.getString("error", "MISSING_SUBSTRING_SIZE"));
            n = null;
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "NUMBER_FORMAT") + ": " + string);
            }
            if (n <= 1) throw new ConfigurationViewException(IDARResourceSet.getString("error", "ILLEGAL_SUBSTRING_SIZE"));
            networkGroupBean.setSubstringSize(n);
        } else {
            networkGroupBean.setSubstringSize(null);
        }
        if (this.chkMaxTimeLimit.isSelected()) {
            string = this.tfMaxTimeLimit.getText().trim();
            if (string.equals("")) throw new ConfigurationViewException(IDARResourceSet.getString("error", "MISSING_TIME_LIMIT"));
            n = null;
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "NUMBER_FORMAT") + ": " + string);
            }
            networkGroupBean.setTimelimit(n);
        } else {
            networkGroupBean.setTimelimit(null);
        }
        if (this.chkRestrictOperationsToDN.isSelected()) {
            string = this.tfRestrictOperationsToDN.getText().trim();
            if (string.equals("")) throw new ConfigurationViewException(IDARResourceSet.getString("error", "MISSING_MINIMUM_BASE_DN"));
            n = new DN(string);
            if (n.toString().trim().equals("")) throw new ConfigurationViewException(IDARResourceSet.getString("dialogDN", "ILLEGAL_DN_MESSAGE"));
            networkGroupBean.setMinimumBase((DN)n);
            return;
        } else {
            networkGroupBean.setMinimumBase(null);
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("groupSearchControl", "TITLE");
    }

    public void resetContent() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        Debug.println((String)("SearchControlView.resetContent: model=" + networkGroupBean));
        if (networkGroupBean != null) {
            this.chkAllowInequality.setSelected(networkGroupBean.getFilterInequality());
            Integer n = networkGroupBean.getSubstringSize();
            if (n != null) {
                this.chkMinimumSubstringSize.setSelected(true);
                this.tfMinimumSubstringSize.setEnabled(true);
                this.tfMinimumSubstringSize.setBackground(Color.white);
                this.tfMinimumSubstringSize.setText(n.toString());
            } else {
                this.chkMinimumSubstringSize.setSelected(false);
                this.tfMinimumSubstringSize.setEnabled(false);
                this.tfMinimumSubstringSize.setBackground(null);
            }
            DN dN = networkGroupBean.getMinimumBase();
            if (dN != null) {
                this.chkRestrictOperationsToDN.setSelected(true);
                this.tfRestrictOperationsToDN.setEnabled(true);
                this.tfRestrictOperationsToDN.setBackground(Color.white);
                this.tfRestrictOperationsToDN.setText(dN.toString());
            } else {
                this.chkRestrictOperationsToDN.setSelected(false);
                this.tfRestrictOperationsToDN.setEnabled(false);
                this.tfRestrictOperationsToDN.setBackground(null);
                this.tfRestrictOperationsToDN.setText("");
            }
            Integer n2 = networkGroupBean.getTimelimit();
            if (n2 != null) {
                this.chkMaxTimeLimit.setSelected(true);
                this.tfMaxTimeLimit.setEnabled(true);
                this.tfMaxTimeLimit.setBackground(Color.white);
                this.tfMaxTimeLimit.setText(n2.toString());
            } else {
                this.chkMaxTimeLimit.setSelected(false);
                this.tfMaxTimeLimit.setEnabled(false);
                this.tfMaxTimeLimit.setBackground(null);
            }
        } else {
            throw new ConfigurationViewException();
        }
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new SearchControlView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

