/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.group;

import com.iplanet.idar.objectmodel.bean.IPAddressData;
import com.iplanet.idar.objectmodel.bean.IPBitMaskData;
import com.iplanet.idar.objectmodel.bean.IPQuadMaskData;
import com.iplanet.idar.objectmodel.bean.NetworkGroupBean;
import com.iplanet.idar.ui.common.FilteredInputDocument;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.BlankPanelEvent;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.iplanet.idar.ui.configurator.IDARDialog;
import com.iplanet.idar.ui.configurator.group.NetworkBitMaskCriteriaView;
import com.iplanet.idar.ui.configurator.group.NetworkDomainCriteriaView;
import com.iplanet.idar.ui.configurator.group.NetworkIPCriteriaView;
import com.iplanet.idar.ui.configurator.group.NetworkQuadMaskCriteriaView;
import com.netscape.management.client.components.ButtonFactory;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public class NetworkView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "NetworkGroup-Network";
    private JTextArea txtNoteReverseDNS;
    private JTextArea txtNoDelayNote;
    private JCheckBox chkTCPNoDelay;
    private JCheckBox chkReverseDNSLookup;
    private JRadioButton radNoIPBinding;
    private JRadioButton radAllIPBinding;
    private JRadioButton radBindingCriteria;
    private JButton butAddCriteria;
    private JButton butRemoveCriteria;
    private JButton butEditCriteria;
    private BlankPanel pnlAttributeBar;
    private BlankPanel pnlBinding;
    private JTextField tfClientValue;
    private JTextArea txtClient;
    private JButton butClientEdit;
    private JCheckBox chkTimeout;
    private JTextField tfTimeout;
    private JTextArea txtNoIPBinding;
    private JTextArea txtAllIPBinding;
    private JTextArea txtBindingCriteria;
    private JPopupMenu popup;
    private String[] colNames = new String[]{"Name"};
    private Vector vCriteria;
    private int selectedRow;
    private JTable tblCriteria;
    private CriteriaTableModel tableModel;
    protected JOptionPane opMessage;
    protected JDialog dMessage;
    protected boolean boolNoIP;
    protected boolean boolAllIP;
    protected static final String CRITERIA = IDARResourceSet.getString("groupNetwork", "CRITERIA");
    protected static final String TYPE = IDARResourceSet.getString("groupNetwork", "TYPE");

    public NetworkView() {
        this.initComponents();
    }

    public NetworkView(ConsoleInfo consoleInfo, NetworkGroupBean networkGroupBean) {
        this.setConsoleInfo(consoleInfo);
        this.setDataModel(networkGroupBean);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            Debug.println((int)6, (String)("Unable to resetContent in Constructor. Model = " + networkGroupBean));
        }
    }

    protected void initComponents() {
        this.opMessage = new JOptionPane();
        this.dMessage = new JDialog();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.txtNoteReverseDNS = new JTextArea();
        this.txtNoteReverseDNS.setText(IDARResourceSet.getString("groupNetwork", "REVERSE_NOTE"));
        this.txtNoteReverseDNS.setEditable(false);
        this.txtNoteReverseDNS.setBackground(this.getBackground());
        this.txtNoteReverseDNS.setLineWrap(true);
        this.txtNoteReverseDNS.setWrapStyleWord(true);
        this.txtNoDelayNote = new JTextArea();
        this.txtNoDelayNote.setText(IDARResourceSet.getString("dialogTCPNoDelay", "NOTE"));
        this.txtNoDelayNote.setEditable(false);
        this.txtNoDelayNote.setBackground(this.getBackground());
        this.txtNoDelayNote.setLineWrap(true);
        this.txtNoDelayNote.setWrapStyleWord(true);
        this.chkTCPNoDelay = new JCheckBox(IDARResourceSet.getString("groupNetwork", "NO_DELAY"));
        this.chkTCPNoDelay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!NetworkView.this.chkTCPNoDelay.isSelected()) {
                    NetworkView.this.opMessage.setMessage(NetworkView.this.txtNoDelayNote);
                    JOptionPane cfr_ignored_0 = NetworkView.this.opMessage;
                    NetworkView.this.opMessage.setMessageType(2);
                    JOptionPane cfr_ignored_1 = NetworkView.this.opMessage;
                    NetworkView.this.opMessage.setOptionType(0);
                    NetworkView.this.dMessage = NetworkView.this.opMessage.createDialog(IDARUtilities.getParentFrame(NetworkView.this), IDARResourceSet.getString("dialogTCPNoDelay", "TITLE"));
                    NetworkView.this.opMessage.revalidate();
                    NetworkView.this.dMessage.setModal(true);
                    NetworkView.this.dMessage.pack();
                    NetworkView.this.dMessage.show();
                    Object object = NetworkView.this.opMessage.getValue();
                    if (object == null) {
                        NetworkView.this.chkTCPNoDelay.setSelected(false);
                    } else if (object instanceof Integer) {
                        int n = (Integer)object;
                        if (n == 1) {
                            NetworkView.this.chkTCPNoDelay.setSelected(true);
                        } else if (n == 0) {
                            NetworkView.this.chkTCPNoDelay.setSelected(false);
                        } else {
                            NetworkView.this.chkTCPNoDelay.setSelected(true);
                        }
                    } else {
                        NetworkView.this.chkTCPNoDelay.setSelected(true);
                    }
                    NetworkView.this.opMessage.setValue(JOptionPane.UNINITIALIZED_VALUE);
                }
            }
        });
        this.chkReverseDNSLookup = new JCheckBox();
        this.chkReverseDNSLookup.setText(IDARResourceSet.getString("groupNetwork", "REVERSE_DNS"));
        this.chkReverseDNSLookup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!NetworkView.this.chkReverseDNSLookup.isSelected() && NetworkView.this.radBindingCriteria.isSelected()) {
                    NetworkView.this.showReverseDNSMessage();
                }
            }
        });
        this.pnlBinding = new BlankPanel();
        this.pnlBinding.addBlankPanelListener(this);
        this.radNoIPBinding = new JRadioButton();
        this.txtNoIPBinding = new JTextArea();
        this.radNoIPBinding.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NetworkView.this.enableCriteriaPanel(false);
            }
        });
        this.radAllIPBinding = new JRadioButton();
        this.txtAllIPBinding = new JTextArea();
        this.radAllIPBinding.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NetworkView.this.enableCriteriaPanel(false);
                NetworkGroupBean networkGroupBean = (NetworkGroupBean)NetworkView.this.getDataModel();
                if (networkGroupBean != null && NetworkView.this.radAllIPBinding.isSelected() && !networkGroupBean.getPriority().equals(new Integer("0"))) {
                    JOptionPane.showMessageDialog(NetworkView.this, IDARResourceSet.getString("error", "ERR_GROUP_PRIORITY"), IDARResourceSet.getString("error", "INFORMATION_TITLE"), 1);
                }
            }
        });
        this.radBindingCriteria = new JRadioButton();
        this.txtBindingCriteria = new JTextArea();
        this.radBindingCriteria.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!NetworkView.this.chkReverseDNSLookup.isSelected() && NetworkView.this.radBindingCriteria.isSelected()) {
                    NetworkView.this.showNetworkCriteriaMessage();
                }
                NetworkView.this.enableCriteriaPanel(true);
            }
        });
        this.initPopUpMenu();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radNoIPBinding);
        buttonGroup.add(this.radAllIPBinding);
        buttonGroup.add(this.radBindingCriteria);
        this.butAddCriteria = ButtonFactory.createButton((String)IDARResourceSet.getString("button", "ADD"));
        this.butAddCriteria.setToolTipText(IDARResourceSet.getString("tooltip", "add_criteria"));
        ButtonFactory.resizeButton((JButton)this.butAddCriteria);
        this.butAddCriteria.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NetworkView.this.popup.show(NetworkView.this.butAddCriteria, NetworkView.this.butAddCriteria.getX() + NetworkView.this.butAddCriteria.getWidth() - 5, NetworkView.this.butAddCriteria.getY() - 5);
            }
        });
        this.butRemoveCriteria = ButtonFactory.createButton((String)IDARResourceSet.getString("button", "REMOVE"));
        this.butRemoveCriteria.setToolTipText(IDARResourceSet.getString("tooltip", "remove_criteria"));
        ButtonFactory.resizeButton((JButton)this.butRemoveCriteria);
        this.butRemoveCriteria.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = NetworkView.this.tblCriteria.getSelectedRow();
                if (n != -1) {
                    NetworkView.this.tableModel.removeElement(n);
                }
                NetworkView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(NetworkView.this.tableModel)));
            }
        });
        this.butEditCriteria = ButtonFactory.createButton((String)IDARResourceSet.getString("button", "EDIT"));
        this.butEditCriteria.setToolTipText(IDARResourceSet.getString("tooltip", "edit_criteria"));
        ButtonFactory.resizeButton((JButton)this.butEditCriteria);
        this.butEditCriteria.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = NetworkView.this.tblCriteria.getSelectedRow();
                if (n != -1) {
                    Object object = NetworkView.this.tableModel.getValueAt(n, 0);
                    JFrame jFrame = IDARUtilities.getParentJFrame(NetworkView.this);
                    if (object instanceof String) {
                        String string = (String)object;
                        NetworkDomainCriteriaView networkDomainCriteriaView = new NetworkDomainCriteriaView();
                        networkDomainCriteriaView.setDomainName(string);
                        IDARDialog iDARDialog = new IDARDialog(jFrame, networkDomainCriteriaView);
                        iDARDialog.show();
                        if (!iDARDialog.isCancel()) {
                            NetworkView.this.tableModel.setValueAt(networkDomainCriteriaView.getDomainName(), n, 0);
                            NetworkView.this.fireBlankPanelEvent(new BlankPanelEvent(actionEvent));
                        }
                    } else if (object instanceof IPAddressData) {
                        IPAddressData iPAddressData = (IPAddressData)object;
                        NetworkIPCriteriaView networkIPCriteriaView = new NetworkIPCriteriaView();
                        networkIPCriteriaView.setIP(iPAddressData.getIP());
                        IDARDialog iDARDialog = new IDARDialog(jFrame, networkIPCriteriaView);
                        iDARDialog.show();
                        if (!iDARDialog.isCancel()) {
                            IPAddressData iPAddressData2 = new IPAddressData(networkIPCriteriaView.getIPAddress());
                            NetworkView.this.tableModel.setValueAt(iPAddressData2, n, 0);
                            NetworkView.this.fireBlankPanelEvent(new BlankPanelEvent(actionEvent));
                        }
                    } else if (object instanceof IPBitMaskData) {
                        IPBitMaskData iPBitMaskData = (IPBitMaskData)object;
                        NetworkBitMaskCriteriaView networkBitMaskCriteriaView = new NetworkBitMaskCriteriaView();
                        networkBitMaskCriteriaView.setIP(iPBitMaskData.getIP());
                        networkBitMaskCriteriaView.setBit(iPBitMaskData.getBit());
                        IDARDialog iDARDialog = new IDARDialog(jFrame, networkBitMaskCriteriaView);
                        iDARDialog.show();
                        if (!iDARDialog.isCancel()) {
                            IPBitMaskData iPBitMaskData2 = new IPBitMaskData(networkBitMaskCriteriaView.getIPAddress(), networkBitMaskCriteriaView.getBitMask());
                            NetworkView.this.tableModel.setValueAt(iPBitMaskData2, n, 0);
                            NetworkView.this.fireBlankPanelEvent(new BlankPanelEvent(actionEvent));
                        }
                    } else if (object instanceof IPQuadMaskData) {
                        IPQuadMaskData iPQuadMaskData = (IPQuadMaskData)object;
                        NetworkQuadMaskCriteriaView networkQuadMaskCriteriaView = new NetworkQuadMaskCriteriaView();
                        networkQuadMaskCriteriaView.setIP(iPQuadMaskData.getIP());
                        networkQuadMaskCriteriaView.setQuad(iPQuadMaskData.getQuad());
                        IDARDialog iDARDialog = new IDARDialog(jFrame, networkQuadMaskCriteriaView);
                        iDARDialog.show();
                        if (!iDARDialog.isCancel()) {
                            IPQuadMaskData iPQuadMaskData2 = new IPQuadMaskData(networkQuadMaskCriteriaView.getIPAddress(), networkQuadMaskCriteriaView.getQuad());
                            NetworkView.this.tableModel.setValueAt(iPQuadMaskData2, n, 0);
                            NetworkView.this.fireBlankPanelEvent(new BlankPanelEvent(actionEvent));
                        }
                    }
                }
            }
        });
        this.pnlAttributeBar = new BlankPanel();
        this.pnlAttributeBar.addBlankPanelListener(this);
        this.pnlAttributeBar.setLayout(new FlowLayout(0));
        this.pnlAttributeBar.add(this.butAddCriteria);
        this.pnlAttributeBar.add(this.butEditCriteria);
        this.pnlAttributeBar.add(this.butRemoveCriteria);
        this.chkTimeout = new JCheckBox();
        this.chkTimeout.setText(IDARResourceSet.getString("groupNetwork", "TIMEOUT") + ":");
        this.chkTimeout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (NetworkView.this.chkTimeout.isSelected()) {
                    NetworkView.this.tfTimeout.setEnabled(true);
                    NetworkView.this.tfTimeout.setBackground(Color.white);
                } else {
                    NetworkView.this.tfTimeout.setEnabled(false);
                    NetworkView.this.tfTimeout.setBackground(null);
                }
            }
        });
        this.tfTimeout = new JTextField(6);
        this.tfTimeout.getAccessibleContext().setAccessibleDescription(IDARResourceSet.getString("groupNetwork", "TIMEOUT"));
        this.tfTimeout.setMinimumSize(this.tfTimeout.getPreferredSize());
        this.tfTimeout.setDocument(FilteredInputDocument.allowDigitsOnly());
        this.tfTimeout.setEnabled(false);
        this.tfTimeout.setBackground(null);
        this.tableModel = new CriteriaTableModel();
        if (this.tableModel != null) {
            this.tableModel.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent tableModelEvent) {
                    NetworkView.this.setEnablement();
                }
            });
        }
        this.tblCriteria = new JTable(this.tableModel);
        this.tblCriteria.setToolTipText(IDARResourceSet.getString("tooltip", "list_of_criteria"));
        this.tblCriteria.setPreferredScrollableViewportSize(new Dimension(400, 25));
        this.tblCriteria.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                NetworkView.this.setEnablement();
            }
        });
        this.tblCriteria.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    NetworkView.this.butEditCriteria.doClick();
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        int n = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        this.add((Component)this.chkTimeout, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 0;
        this.add((Component)this.tfTimeout, gridBagConstraints);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        this.add((Component)this.chkReverseDNSLookup, gridBagConstraints);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        this.add((Component)this.chkTCPNoDelay, gridBagConstraints);
        this.pnlBinding.setBorder(BorderFactory.createTitledBorder(IDARResourceSet.getString("groupNetwork", "PNL_CRITERIA_NAME")));
        this.pnlBinding.setLayout(new GridBagLayout());
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.pnlBinding.add((Component)this.radNoIPBinding, gridBagConstraints);
        this.txtNoIPBinding.setText(IDARResourceSet.getString("groupNetwork", "NO_CLIENT"));
        this.txtNoIPBinding.setEditable(false);
        this.txtNoIPBinding.setBackground(this.getBackground());
        this.txtNoIPBinding.setLineWrap(true);
        this.txtNoIPBinding.setWrapStyleWord(true);
        gridBagConstraints.insets.top = 1;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.pnlBinding.add((Component)this.txtNoIPBinding, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 9, 9, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        this.pnlBinding.add((Component)this.radAllIPBinding, gridBagConstraints);
        this.txtAllIPBinding.setText(IDARResourceSet.getString("groupNetwork", "ANY_CLIENT"));
        this.txtAllIPBinding.setEditable(false);
        this.txtAllIPBinding.setBackground(this.getBackground());
        this.txtAllIPBinding.setLineWrap(true);
        this.txtAllIPBinding.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 0, 9, 9);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.pnlBinding.add((Component)this.txtAllIPBinding, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 9, 9, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        this.pnlBinding.add((Component)this.radBindingCriteria, gridBagConstraints);
        this.txtBindingCriteria.setText(IDARResourceSet.getString("groupNetwork", "CRITERIA_CLIENT"));
        this.txtBindingCriteria.setEditable(false);
        this.txtBindingCriteria.setBackground(this.getBackground());
        this.txtBindingCriteria.setLineWrap(true);
        this.txtBindingCriteria.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 0, 9, 9);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.pnlBinding.add((Component)this.txtBindingCriteria, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.pnlBinding.add((Component)this.pnlAttributeBar, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.pnlBinding.add((Component)new JScrollPane(this.tblCriteria), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.pnlBinding, gridBagConstraints);
    }

    private void enableCriteriaPanel(boolean bl) {
        this.butAddCriteria.setEnabled(bl);
        this.tblCriteria.setEnabled(bl);
        if (bl) {
            this.tblCriteria.setBackground(Color.white);
        } else {
            this.tblCriteria.setBackground(null);
        }
        if (bl && this.tblCriteria.getRowCount() > 0 && this.tblCriteria.getSelectedRow() > -1) {
            this.butRemoveCriteria.setEnabled(true);
            this.butEditCriteria.setEnabled(true);
        } else {
            this.butRemoveCriteria.setEnabled(false);
            this.butEditCriteria.setEnabled(false);
        }
    }

    private void setEnablement() {
        if (this.radAllIPBinding.isSelected()) {
            this.enableCriteriaPanel(false);
        } else if (this.radNoIPBinding.isSelected()) {
            this.enableCriteriaPanel(false);
        } else {
            this.radBindingCriteria.setSelected(true);
            this.enableCriteriaPanel(true);
        }
    }

    protected void initPopUpMenu() {
        final JFrame jFrame = IDARUtilities.getParentJFrame(this);
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setText(IDARResourceSet.getString("groupNetwork", "B_DOMAIN_NET_CLIENTS"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NetworkDomainCriteriaView networkDomainCriteriaView = new NetworkDomainCriteriaView();
                IDARDialog iDARDialog = new IDARDialog(jFrame, networkDomainCriteriaView);
                iDARDialog.show();
                if (!iDARDialog.isCancel()) {
                    NetworkView.this.tableModel.addDomainName(networkDomainCriteriaView.getDomainName());
                    NetworkView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(NetworkView.this.tableModel)));
                }
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem();
        jMenuItem2.setText(IDARResourceSet.getString("groupNetwork", "B_IP_NET_CLIENTS"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NetworkIPCriteriaView networkIPCriteriaView = new NetworkIPCriteriaView();
                IDARDialog iDARDialog = new IDARDialog(jFrame, networkIPCriteriaView);
                iDARDialog.show();
                if (!iDARDialog.isCancel()) {
                    NetworkView.this.tableModel.addIP(new IPAddressData(networkIPCriteriaView.getIPAddress()));
                    NetworkView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(NetworkView.this.tableModel)));
                }
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem();
        jMenuItem3.setText(IDARResourceSet.getString("groupNetwork", "B_BITS_NET_CLIENTS"));
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NetworkBitMaskCriteriaView networkBitMaskCriteriaView = new NetworkBitMaskCriteriaView();
                IDARDialog iDARDialog = new IDARDialog(jFrame, networkBitMaskCriteriaView);
                iDARDialog.show();
                if (!iDARDialog.isCancel()) {
                    NetworkView.this.tableModel.addBitMask(new IPBitMaskData(networkBitMaskCriteriaView.getIPAddress(), networkBitMaskCriteriaView.getBitMask()));
                    NetworkView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(NetworkView.this.tableModel)));
                }
            }
        });
        JMenuItem jMenuItem4 = new JMenuItem();
        jMenuItem4.setText(IDARResourceSet.getString("groupNetwork", "B_QUAD_NET_CLIENTS"));
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NetworkQuadMaskCriteriaView networkQuadMaskCriteriaView = new NetworkQuadMaskCriteriaView();
                IDARDialog iDARDialog = new IDARDialog(jFrame, networkQuadMaskCriteriaView);
                iDARDialog.show();
                if (!iDARDialog.isCancel()) {
                    NetworkView.this.tableModel.addQuadMask(new IPQuadMaskData(networkQuadMaskCriteriaView.getIPAddress(), networkQuadMaskCriteriaView.getQuad()));
                    NetworkView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(NetworkView.this.tableModel)));
                }
            }
        });
        this.popup = new JPopupMenu();
        this.popup.add(jMenuItem);
        this.popup.add(jMenuItem2);
        this.popup.add(jMenuItem3);
        this.popup.add(jMenuItem4);
    }

    private void showReverseDNSMessage() {
        if (!this.chkReverseDNSLookup.isSelected() && this.radBindingCriteria.isSelected()) {
            this.opMessage.setMessage(this.txtNoteReverseDNS);
            this.opMessage.setMessageType(2);
            this.opMessage.setOptionType(2);
            this.dMessage = this.opMessage.createDialog(IDARUtilities.getParentFrame(this), IDARResourceSet.getString("groupNetwork", "REVERSE_TITLE"));
            this.opMessage.revalidate();
            this.dMessage.setModal(true);
            this.dMessage.pack();
            this.dMessage.show();
            Object object = this.opMessage.getValue();
            if (object == null) {
                this.chkReverseDNSLookup.setSelected(false);
            } else if (object instanceof Integer) {
                int n = (Integer)object;
                if (n == 2) {
                    this.chkReverseDNSLookup.setSelected(true);
                } else if (n == 0) {
                    this.chkReverseDNSLookup.setSelected(false);
                }
            }
            this.opMessage.setValue(JOptionPane.UNINITIALIZED_VALUE);
        }
    }

    private void showNetworkCriteriaMessage() {
        if (!this.chkReverseDNSLookup.isSelected() && this.radBindingCriteria.isSelected()) {
            this.opMessage.setMessage(this.txtNoteReverseDNS);
            this.opMessage.setMessageType(2);
            this.opMessage.setOptionType(2);
            this.dMessage = this.opMessage.createDialog(IDARUtilities.getParentFrame(this), IDARResourceSet.getString("groupNetwork", "REVERSE_TITLE"));
            this.opMessage.revalidate();
            this.dMessage.setModal(true);
            this.dMessage.pack();
            this.dMessage.show();
            Object object = this.opMessage.getValue();
            if (object == null) {
                this.radBindingCriteria.setSelected(false);
            } else if (object instanceof Integer) {
                int n = (Integer)object;
                if (n == 2) {
                    this.radBindingCriteria.setSelected(false);
                    if (this.boolNoIP) {
                        this.radNoIPBinding.setSelected(true);
                    } else {
                        this.radAllIPBinding.setSelected(true);
                    }
                } else if (n == 0) {
                    this.radBindingCriteria.setSelected(true);
                }
            }
            this.opMessage.setValue(JOptionPane.UNINITIALIZED_VALUE);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void applyChanges() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        if (networkGroupBean == null) throw new ConfigurationViewException();
        if (this.chkTimeout.isSelected()) {
            String string = this.tfTimeout.getText().trim();
            if (string.equals("")) throw new ConfigurationViewException(IDARResourceSet.getString("error", "MISSING_TIMEOUT"));
            Integer n = null;
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "NUMBER_FORMAT") + ": " + string.toString());
            }
            networkGroupBean.setTimeout(n);
        } else {
            networkGroupBean.setTimeout(null);
        }
        networkGroupBean.setReverseDNSLookup(this.chkReverseDNSLookup.isSelected());
        networkGroupBean.setTCPNoDelay(this.chkTCPNoDelay.isSelected());
        networkGroupBean.setAllIPBinding(this.radAllIPBinding.isSelected());
        networkGroupBean.setNoIPBinding(this.radNoIPBinding.isSelected());
        if (this.radBindingCriteria.isSelected() && this.tblCriteria.getRowCount() == 0) {
            throw new ConfigurationViewException(this.getTitleText(), IDARResourceSet.getString("error", "ERR_NO_CRITERIA_SPECIFIED"));
        }
        networkGroupBean.clearCriteria();
        networkGroupBean.setDomainNames(this.tableModel.getDomainNames());
        networkGroupBean.setIPAddresses(this.tableModel.getIPAddresses());
        networkGroupBean.setBitMasks(this.tableModel.getBitMasks());
        networkGroupBean.setQuadMasks(this.tableModel.getQuadMasks());
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("groupNetwork", "TITLE");
    }

    public void resetContent() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        Debug.println((String)("NetworkView.resetContent: model=" + networkGroupBean));
        if (networkGroupBean != null) {
            Integer n = networkGroupBean.getTimeout();
            if (n != null) {
                this.chkTimeout.setSelected(true);
                this.tfTimeout.setEnabled(true);
                this.tfTimeout.setBackground(Color.white);
                this.tfTimeout.setText(networkGroupBean.getTimeout().toString());
            } else {
                this.chkTimeout.setSelected(false);
                this.tfTimeout.setEnabled(false);
                this.tfTimeout.setBackground(null);
            }
            this.chkReverseDNSLookup.setSelected(networkGroupBean.getReverseDNSLookup());
            this.chkTCPNoDelay.setSelected(networkGroupBean.getTCPNoDelay());
            if (networkGroupBean.getAllIPBinding()) {
                this.radAllIPBinding.setSelected(true);
                this.enableCriteriaPanel(false);
            } else if (networkGroupBean.getNoIPBinding()) {
                this.radNoIPBinding.setSelected(true);
                this.enableCriteriaPanel(false);
            } else {
                this.radBindingCriteria.setSelected(true);
                this.enableCriteriaPanel(true);
            }
        } else {
            throw new ConfigurationViewException();
        }
        this.tableModel.removeAll();
        Vector vector = new Vector();
        vector.addAll(networkGroupBean.getDomainNames());
        vector.addAll(networkGroupBean.getIPAddresses());
        vector.addAll(networkGroupBean.getBitMasks());
        vector.addAll(networkGroupBean.getQuadMasks());
        this.tableModel.setData(vector);
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new NetworkView());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public class CriteriaTableModel
    extends AbstractTableModel {
        private Vector data = new Vector();

        public Object getValueAt(int n, int n2) {
            Object object = null;
            try {
                ClientData clientData = (ClientData)this.data.elementAt(n);
                switch (n2) {
                    case 0: {
                        object = clientData.value;
                        break;
                    }
                    case 1: {
                        object = clientData.type;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                arrayIndexOutOfBoundsException.printStackTrace();
            }
            return object;
        }

        public void setValueAt(Object object, int n, int n2) {
            try {
                ClientData clientData = (ClientData)this.data.elementAt(n);
                switch (n2) {
                    case 0: {
                        clientData.value = object;
                        break;
                    }
                    case 1: {
                        clientData.type = object.toString();
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                arrayIndexOutOfBoundsException.printStackTrace();
            }
            this.fireTableDataChanged();
        }

        public void setData(Vector vector) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e instanceof String) {
                    this.addDomainName((String)e);
                    continue;
                }
                if (e instanceof IPAddressData) {
                    this.addIP((IPAddressData)e);
                    continue;
                }
                if (e instanceof IPBitMaskData) {
                    this.addBitMask((IPBitMaskData)e);
                    continue;
                }
                if (!(e instanceof IPQuadMaskData)) continue;
                this.addQuadMask((IPQuadMaskData)e);
            }
            this.fireTableDataChanged();
        }

        public void addDomainName(String string) {
            this.data.addElement(new ClientData(string, IDARResourceSet.getString("groupNetwork", "DOMAIN_NAME")));
            this.fireTableDataChanged();
        }

        public void addIP(IPAddressData iPAddressData) {
            this.data.addElement(new ClientData(iPAddressData, IDARResourceSet.getString("groupNetwork", "IP")));
            this.fireTableDataChanged();
        }

        public void addBitMask(IPBitMaskData iPBitMaskData) {
            this.data.addElement(new ClientData(iPBitMaskData, IDARResourceSet.getString("groupNetwork", "BIT_MASK")));
            this.fireTableDataChanged();
        }

        public void addQuadMask(IPQuadMaskData iPQuadMaskData) {
            this.data.addElement(new ClientData(iPQuadMaskData, IDARResourceSet.getString("groupNetwork", "QUAD_MASK")));
            this.fireTableDataChanged();
        }

        public Vector getDomainNames() {
            Vector<String> vector = new Vector<String>();
            Enumeration enumeration = this.data.elements();
            while (enumeration.hasMoreElements()) {
                ClientData clientData = (ClientData)enumeration.nextElement();
                if (!clientData.type.equals(IDARResourceSet.getString("groupNetwork", "DOMAIN_NAME"))) continue;
                vector.addElement((String)clientData.value);
            }
            return vector;
        }

        public Vector getIPAddresses() {
            Vector<IPAddressData> vector = new Vector<IPAddressData>();
            Enumeration enumeration = this.data.elements();
            while (enumeration.hasMoreElements()) {
                ClientData clientData = (ClientData)enumeration.nextElement();
                if (!clientData.type.equals(IDARResourceSet.getString("groupNetwork", "IP"))) continue;
                vector.addElement((IPAddressData)clientData.value);
            }
            return vector;
        }

        public Vector getBitMasks() {
            Vector<IPBitMaskData> vector = new Vector<IPBitMaskData>();
            Enumeration enumeration = this.data.elements();
            while (enumeration.hasMoreElements()) {
                ClientData clientData = (ClientData)enumeration.nextElement();
                if (!clientData.type.equals(IDARResourceSet.getString("groupNetwork", "BIT_MASK"))) continue;
                vector.addElement((IPBitMaskData)clientData.value);
            }
            return vector;
        }

        public Vector getQuadMasks() {
            Vector<IPQuadMaskData> vector = new Vector<IPQuadMaskData>();
            Enumeration enumeration = this.data.elements();
            while (enumeration.hasMoreElements()) {
                ClientData clientData = (ClientData)enumeration.nextElement();
                if (!clientData.type.equals(IDARResourceSet.getString("groupNetwork", "QUAD_MASK"))) continue;
                vector.addElement((IPQuadMaskData)clientData.value);
            }
            return vector;
        }

        public void removeElement(int n) {
            this.data.removeElementAt(n);
            this.fireTableDataChanged();
        }

        public int getRowCount() {
            return this.data.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return n == 0 ? CRITERIA : TYPE;
        }

        public void removeAll() {
            this.data.clear();
        }

        public class ClientData {
            public Object value;
            public String type;

            ClientData(Object object, String string) {
                this.value = object;
                this.type = string;
            }

            public String toString() {
                return "value=" + this.value.toString() + " type=" + this.type;
            }
        }
    }
}

