/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.group;

import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.ui.common.FilteredInputDocument;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.configuration.InvalidInputEvent;
import com.iplanet.idar.ui.common.configuration.ValidInputEvent;
import com.iplanet.idar.ui.configurator.group.NetworkDialogView;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NetworkBitMaskCriteriaView
extends NetworkDialogView
implements SuiConstants {
    private JTextArea txtBindMaskBits;
    private JTextField ipMaskWithBits;
    private JLabel lblBits;
    private JTextField tfBits;
    private ConsoleInfo info;
    private IDARModelBean model;

    public NetworkBitMaskCriteriaView() {
        this.initComponents();
    }

    public NetworkBitMaskCriteriaView(ConsoleInfo consoleInfo) {
        this.info = consoleInfo;
        this.initComponents();
    }

    public void setIP(String string) {
        this.ipMaskWithBits.setText(string);
    }

    public void setBit(String string) {
        this.tfBits.setText(string);
    }

    public boolean isValidInput() {
        String string = "^0[.]0[.]0[.]0$";
        String string2 = "^(\\d{1,3}[.]\\d{1,3}[.]\\d{1,3}[.]\\d{1,3})$";
        Pattern pattern = null;
        Pattern pattern2 = null;
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        Perl5Matcher perl5Matcher = new Perl5Matcher();
        try {
            pattern = perl5Compiler.compile(string);
            pattern2 = perl5Compiler.compile(string2);
        }
        catch (MalformedPatternException malformedPatternException) {
            Debug.println((int)6, (String)"Bad regular expression pattern in NetworkBitMaskCriteriaView.isValidInput()");
            Debug.println((String)malformedPatternException.getMessage());
            malformedPatternException.printStackTrace();
        }
        String string3 = this.ipMaskWithBits.getText().trim();
        boolean bl = false;
        if (string3 != null && perl5Matcher.matches(string3, pattern2) && !perl5Matcher.matches(string3, pattern)) {
            bl = true;
        }
        return bl;
    }

    public void checkValidity() {
        if (this.ipMaskWithBits.getText().trim().equals("") || this.tfBits.getText().trim().equals("")) {
            this.fireInvalidInputEvent(new InvalidInputEvent(null));
        } else {
            this.fireValidInputEvent(new ValidInputEvent(null));
        }
    }

    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        this.txtBindMaskBits = new JTextArea();
        this.ipMaskWithBits = new JTextField(15);
        this.ipMaskWithBits.setMinimumSize(this.ipMaskWithBits.getPreferredSize());
        this.ipMaskWithBits.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                NetworkBitMaskCriteriaView.this.checkValidity();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                NetworkBitMaskCriteriaView.this.checkValidity();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                NetworkBitMaskCriteriaView.this.checkValidity();
            }
        });
        this.lblBits = new JLabel();
        this.tfBits = new JTextField(6);
        this.tfBits.setDocument(FilteredInputDocument.allowDigitsOnly());
        this.tfBits.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                NetworkBitMaskCriteriaView.this.checkValidity();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                NetworkBitMaskCriteriaView.this.checkValidity();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                NetworkBitMaskCriteriaView.this.checkValidity();
            }
        });
        this.lblBits.setLabelFor(this.tfBits);
        int n = 0;
        this.txtBindMaskBits.setText(IDARResourceSet.getString("groupNetworkBitCriteria", "BITS_CLIENTS"));
        this.txtBindMaskBits.setEditable(false);
        this.txtBindMaskBits.setBackground(this.getBackground());
        this.txtBindMaskBits.setLineWrap(true);
        this.txtBindMaskBits.setWrapStyleWord(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.txtBindMaskBits, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.ipMaskWithBits, gridBagConstraints);
        this.lblBits.setText(IDARResourceSet.getString("groupNetworkBitCriteria", "BITS") + ":");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.lblBits, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.tfBits, gridBagConstraints);
    }

    public String getIPAddress() {
        return this.ipMaskWithBits.getText().trim();
    }

    public String getBitMask() {
        return this.tfBits.getText().trim();
    }

    public JPanel getPanel() {
        return this;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new NetworkBitMaskCriteriaView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

