/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.group;

import com.iplanet.idar.objectmodel.bean.NetworkGroupBean;
import com.iplanet.idar.ui.common.DirBrowserCombo;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.BlankPanelEvent;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.netscape.management.client.components.ButtonFactory;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import netscape.ldap.util.DN;

public class ForwardingBindsView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "NetworkGroup-Forwarding-Bind";
    private JCheckBox chkPermitAnonymousBind;
    private JCheckBox chkPermitSimpleBind;
    private JCheckBox chkPermitSASLBind;
    private BlankPanel pnlClientDN;
    private JRadioButton radAllowAll;
    private JRadioButton radRestrictToDN;
    private JTextField tfBindName;
    private JButton butBrowse;

    public ForwardingBindsView() {
        this.initComponents();
    }

    public ForwardingBindsView(ConsoleInfo consoleInfo, NetworkGroupBean networkGroupBean) {
        this.setConsoleInfo(consoleInfo);
        this.setDataModel(networkGroupBean);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            // empty catch block
        }
    }

    protected void initComponents() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ForwardingBindsView.this.radRestrictToDN.isSelected()) {
                    ForwardingBindsView.this.tfBindName.setEnabled(true);
                    ForwardingBindsView.this.tfBindName.setBackground(Color.white);
                    ForwardingBindsView.this.butBrowse.setEnabled(true);
                } else {
                    ForwardingBindsView.this.tfBindName.setEnabled(false);
                    ForwardingBindsView.this.tfBindName.setBackground(null);
                    ForwardingBindsView.this.butBrowse.setEnabled(false);
                }
            }
        };
        this.radAllowAll = new JRadioButton(IDARResourceSet.getString("groupForwardingBinds", "ALLOW_ALL"));
        this.radAllowAll.addActionListener(actionListener);
        this.radRestrictToDN = new JRadioButton(IDARResourceSet.getString("groupForwardingBinds", "RESTRICT") + ":");
        this.radRestrictToDN.addActionListener(actionListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radAllowAll);
        buttonGroup.add(this.radRestrictToDN);
        this.tfBindName = new JTextField();
        this.tfBindName.setToolTipText(IDARResourceSet.getString("tooltip", "client_subordinate_dn"));
        this.tfBindName.setEnabled(false);
        this.tfBindName.setBackground(null);
        this.chkPermitAnonymousBind = new JCheckBox();
        this.chkPermitSimpleBind = new JCheckBox();
        this.chkPermitSASLBind = new JCheckBox();
        this.butBrowse = ButtonFactory.createButton((String)IDARResourceSet.getString("button", "BROWSE"));
        this.butBrowse.setToolTipText(IDARResourceSet.getString("tooltip", "browse_dn"));
        ButtonFactory.resizeButton((JButton)this.butBrowse);
        this.butBrowse.setEnabled(false);
        this.butBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleInfo consoleInfo = ForwardingBindsView.this.getConsoleInfo();
                if (consoleInfo != null) {
                    DirBrowserCombo dirBrowserCombo = new DirBrowserCombo(IDARUtilities.getParentJFrame(ForwardingBindsView.this), consoleInfo, ForwardingBindsView.this.getDataModel().getParentConfiguration());
                    dirBrowserCombo.setModal(true);
                    dirBrowserCombo.show();
                    if (!dirBrowserCombo.isCancel()) {
                        ForwardingBindsView.this.tfBindName.setText(dirBrowserCombo.getSelectedDN());
                        ForwardingBindsView.this.fireBlankPanelEvent(new BlankPanelEvent(null));
                    }
                    dirBrowserCombo = null;
                } else {
                    Debug.println((int)6, (String)("SearchControlView:BrowseButton: consoleInfo = " + consoleInfo));
                }
            }
        });
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.pnlClientDN = new BlankPanel();
        this.pnlClientDN.setBorder(BorderFactory.createTitledBorder(IDARResourceSet.getString("groupForwardingBinds", "CLIENT")));
        this.pnlClientDN.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 18;
        this.pnlClientDN.add((Component)this.radAllowAll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 18;
        this.pnlClientDN.add((Component)this.radRestrictToDN, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 26, 9, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.pnlClientDN.add((Component)this.tfBindName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.pnlClientDN.add((Component)this.butBrowse, gridBagConstraints);
        n = 0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.pnlClientDN, gridBagConstraints);
        this.chkPermitAnonymousBind.setText(IDARResourceSet.getString("groupForwardingBinds", "PERMIT_ANON"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.chkPermitAnonymousBind, gridBagConstraints);
        this.chkPermitSimpleBind.setText(IDARResourceSet.getString("groupForwardingBinds", "PERMIT_SIMP"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.chkPermitSimpleBind, gridBagConstraints);
        this.chkPermitSASLBind.setText(IDARResourceSet.getString("groupForwardingBinds", "PERMIT_SASL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.chkPermitSASLBind, gridBagConstraints);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void applyChanges() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        if (networkGroupBean == null) return;
        DN dN = null;
        if (this.radRestrictToDN.isSelected()) {
            String string = this.tfBindName.getText().trim();
            if (string.equals("")) throw new ConfigurationViewException(IDARResourceSet.getString("error", "MISSING_BIND_DN"));
            dN = new DN(string);
            if (dN.toString().trim().equals("")) {
                throw new ConfigurationViewException(IDARResourceSet.getString("dialogDN", "ILLEGAL_DN_MESSAGE"));
            }
        } else {
            dN = new DN("");
        }
        networkGroupBean.setBindName(dN);
        networkGroupBean.setPermitAuthNone(this.chkPermitAnonymousBind.isSelected());
        networkGroupBean.setPermitAuthSimple(this.chkPermitSimpleBind.isSelected());
        networkGroupBean.setPermitAuthSASL(this.chkPermitSASLBind.isSelected());
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("groupForwardingBinds", "TITLE");
    }

    public void resetContent() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        Debug.println((String)("ForwardingBindsView.resetContent: model=" + networkGroupBean));
        if (networkGroupBean != null) {
            DN dN = networkGroupBean.getBindName();
            boolean bl = dN.toString().trim().equals("");
            this.radAllowAll.setSelected(bl);
            this.radRestrictToDN.setSelected(!bl);
            if (bl) {
                this.tfBindName.setEnabled(false);
                this.tfBindName.setBackground(null);
                this.butBrowse.setEnabled(false);
            } else {
                this.tfBindName.setEnabled(true);
                this.tfBindName.setBackground(Color.white);
                this.butBrowse.setEnabled(true);
            }
            this.tfBindName.setText(dN.toString());
            this.chkPermitAnonymousBind.setSelected(networkGroupBean.getPermitAuthNone());
            this.chkPermitSimpleBind.setSelected(networkGroupBean.getPermitAuthSimple());
            this.chkPermitSASLBind.setSelected(networkGroupBean.getPermitAuthSASL());
        }
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new ForwardingBindsView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

