/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.group;

import com.iplanet.idar.objectmodel.bean.NetworkGroupBean;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.iplanet.idar.ui.configurator.group.SSLPolicyPanel;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class EncryptionView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "NetworkGroup-Encryption";
    private BlankPanel pnlClientSSLPolicy;
    private JRadioButton radClientUnavailable;
    private JRadioButton radClientOptional;
    private JRadioButton radClientRequired;
    private SSLPolicyPanel pnlReferralSSLPolicy;

    public EncryptionView() {
        this.initComponents();
    }

    public EncryptionView(ConsoleInfo consoleInfo, NetworkGroupBean networkGroupBean) {
        this.setConsoleInfo(consoleInfo);
        this.setDataModel(networkGroupBean);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            // empty catch block
        }
    }

    protected void initComponents() {
        this.pnlClientSSLPolicy = new BlankPanel();
        this.pnlClientSSLPolicy.addBlankPanelListener(this);
        this.radClientUnavailable = new JRadioButton();
        this.radClientOptional = new JRadioButton();
        this.radClientRequired = new JRadioButton();
        this.pnlReferralSSLPolicy = new SSLPolicyPanel();
        this.pnlReferralSSLPolicy.addBlankPanelListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radClientUnavailable);
        buttonGroup.add(this.radClientOptional);
        buttonGroup.add(this.radClientRequired);
        this.setLayout(new GridBagLayout());
        this.pnlClientSSLPolicy.setBorder(BorderFactory.createTitledBorder(IDARResourceSet.getString("groupEncryption", "CLIENT_SSL_POLICY")));
        this.pnlClientSSLPolicy.setLayout(new GridBagLayout());
        this.radClientUnavailable.setText(IDARResourceSet.getString("groupEncryption", "CLIENT_UNAVAILABLE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        this.pnlClientSSLPolicy.add((Component)this.radClientUnavailable, gridBagConstraints);
        this.radClientOptional.setText(IDARResourceSet.getString("groupEncryption", "CLIENT_OPTIONAL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        this.pnlClientSSLPolicy.add((Component)this.radClientOptional, gridBagConstraints);
        this.radClientRequired.setText(IDARResourceSet.getString("groupEncryption", "CLIENT_REQUIRED"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        this.pnlClientSSLPolicy.add((Component)this.radClientRequired, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.pnlClientSSLPolicy, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.pnlReferralSSLPolicy, gridBagConstraints);
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("groupEncryption", "TITLE");
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    public void resetContent() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        Debug.println((String)("EncryptionViewView.resetContent: model=" + networkGroupBean));
        if (networkGroupBean != null) {
            String string = networkGroupBean.getSSLPolicy();
            if (string.equals("ssl_unavailable")) {
                this.radClientUnavailable.setSelected(true);
                this.radClientRequired.setSelected(false);
                this.radClientOptional.setSelected(false);
            } else if (string.equals("ssl_required")) {
                this.radClientUnavailable.setSelected(false);
                this.radClientRequired.setSelected(true);
                this.radClientOptional.setSelected(false);
            } else if (string.equals("ssl_optional")) {
                this.radClientUnavailable.setSelected(false);
                this.radClientRequired.setSelected(false);
                this.radClientOptional.setSelected(true);
            }
            String string2 = networkGroupBean.getRefSSLPolicy();
            if (string2.equals("ssl_unavailable")) {
                this.pnlReferralSSLPolicy.setRadSSLUnavailable();
            } else if (string2.equals("ssl_required")) {
                this.pnlReferralSSLPolicy.setRadSSLRequired();
            } else {
                this.pnlReferralSSLPolicy.setRadSSLOptional();
            }
        }
    }

    public void applyChanges() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        if (networkGroupBean != null) {
            if (this.radClientUnavailable.isSelected()) {
                networkGroupBean.setSSLPolicy("ssl_unavailable");
            } else if (this.radClientRequired.isSelected()) {
                networkGroupBean.setSSLPolicy("ssl_required");
            } else {
                networkGroupBean.setSSLPolicy("ssl_optional");
            }
            if (this.pnlReferralSSLPolicy.isPanelEnabled()) {
                if (this.pnlReferralSSLPolicy.isSSLUnavailable()) {
                    networkGroupBean.setRefSSLPolicy("ssl_unavailable");
                } else if (this.pnlReferralSSLPolicy.isSSLRequired()) {
                    networkGroupBean.setRefSSLPolicy("ssl_required");
                } else {
                    networkGroupBean.setRefSSLPolicy("ssl_optional");
                }
            } else {
                networkGroupBean.setRefSSLPolicy("ssl_unavailable");
            }
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new EncryptionView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

