/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.group;

import com.iplanet.idar.objectmodel.bean.NetworkGroupBean;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class CompatibilityView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "NetworkGroup-Compatibility";
    private JTextArea txtNote;
    private JTextArea txtAllowNullNote;
    private JLabel lblMultLDAPv2Bind;
    private JCheckBox chkEnableLDAPv2Bind;
    private JCheckBox chkEnableNullSADL;

    public CompatibilityView() {
        this.initComponents();
    }

    public CompatibilityView(ConsoleInfo consoleInfo, NetworkGroupBean networkGroupBean) {
        this.setConsoleInfo(consoleInfo);
        this.setDataModel(networkGroupBean);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            // empty catch block
        }
    }

    protected void initComponents() {
        this.txtNote = new JTextArea();
        this.txtAllowNullNote = new JTextArea();
        this.chkEnableLDAPv2Bind = new JCheckBox(IDARResourceSet.getString("groupCompatibility", "ENABLE_V2_BIND"));
        this.chkEnableNullSADL = new JCheckBox(IDARResourceSet.getString("groupCompatibility", "ENABLE_NULL_SADL"));
        this.chkEnableLDAPv2Bind.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                if (CompatibilityView.this.chkEnableLDAPv2Bind.isSelected() && (n = JOptionPane.showConfirmDialog(null, IDARResourceSet.getString("groupCompatibility", "NOTE_WARNING"), IDARResourceSet.getString("groupCompatibility", "TITLE_WARNING"), 0)) == 1) {
                    CompatibilityView.this.chkEnableLDAPv2Bind.setSelected(false);
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.txtNote.setText(IDARResourceSet.getString("groupCompatibility", "NOTE"));
        this.txtNote.setEditable(false);
        this.txtNote.setBackground(this.getBackground());
        this.txtNote.setLineWrap(true);
        this.txtNote.setWrapStyleWord(true);
        this.txtNote.setMaximumSize(this.txtNote.getPreferredSize());
        this.txtAllowNullNote.setText(IDARResourceSet.getString("groupCompatibility", "ALLOW_SADL_NULL_NOTE"));
        this.txtAllowNullNote.setEditable(false);
        this.txtAllowNullNote.setBackground(this.getBackground());
        this.txtAllowNullNote.setLineWrap(true);
        this.txtAllowNullNote.setWrapStyleWord(true);
        this.txtAllowNullNote.setMaximumSize(this.txtAllowNullNote.getPreferredSize());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 2;
        this.add((Component)this.txtNote, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.chkEnableLDAPv2Bind, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 2;
        this.add((Component)this.txtAllowNullNote, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.chkEnableNullSADL, gridBagConstraints);
    }

    public void applyChanges() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        if (networkGroupBean != null) {
            networkGroupBean.setAllowMultiLdapV2Bind(this.chkEnableLDAPv2Bind.isSelected());
            networkGroupBean.setAllowNullSADL(this.chkEnableNullSADL.isSelected());
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("groupCompatibility", "TITLE");
    }

    public void resetContent() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        Debug.println((String)("CompatibilityView.resetContent: model=" + networkGroupBean));
        if (networkGroupBean != null) {
            this.chkEnableLDAPv2Bind.setSelected(networkGroupBean.getAllowMultiLdapV2Bind());
            this.chkEnableNullSADL.setSelected(networkGroupBean.getAllowNullSADL());
        }
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new CompatibilityView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

