/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.action;

import com.iplanet.idar.objectmodel.bean.ActionBean;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.UniqueNameException;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ActionView
extends ConfigurationView
implements SuiConstants {
    private ActionBean model;
    private JLabel lblName;
    private JTextField tfName;

    public ActionView() {
        this.initComponents();
    }

    public IDARModelBean getDataModel() {
        return this.model;
    }

    public void setDataModel(IDARModelBean iDARModelBean) {
        if (iDARModelBean != null && iDARModelBean instanceof ActionBean) {
            this.model = (ActionBean)iDARModelBean;
        }
    }

    public void resetContent() throws ConfigurationViewException {
        if (this.model != null) {
            this.tfName.setText(this.model.getId());
        }
    }

    public void applyChanges() throws ConfigurationViewException {
        if (this.model != null) {
            if (this.tfName.getText().trim().equals("")) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "ERR_NO_ID"));
            }
            if (!this.model.getName().equals(this.tfName.getText())) {
                try {
                    this.model.setName(this.tfName.getText());
                }
                catch (UniqueNameException uniqueNameException) {
                    throw new ConfigurationViewException(IDARResourceSet.getString("error", "UNIQUE_NAME", this.tfName.getText()));
                }
            }
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("actionGeneral", "TITLE");
    }

    public String getHelpTopic() {
        String string = "TODO";
        return string;
    }

    protected void initComponents() {
        this.tfName = new JTextField();
        this.lblName = new JLabel();
        this.lblName.setText(IDARResourceSet.getString("actionGeneral", "ACTION_NAME") + ":");
        this.lblName.setLabelFor(this.tfName);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.lblName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.tfName, gridBagConstraints);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new ActionView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

