/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator;

import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.AdminConfigData;
import com.iplanet.idar.objectmodel.bean.ConfigurationBean;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.NoSuchBeanException;
import com.iplanet.idar.objectmodel.bean.RetrievalException;
import com.iplanet.idar.task.TaskAdapter;
import com.iplanet.idar.task.TaskEvent;
import com.iplanet.idar.task.configuration.DeleteObjectTask;
import com.iplanet.idar.task.configuration.SaveObjectTask;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.common.components.IDARAbstractDialog;
import com.iplanet.idar.ui.common.configuration.BlankPanelEvent;
import com.iplanet.idar.ui.common.configuration.ConfigurationManager;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.iplanet.idar.ui.common.configuration.IBlankPanelListener;
import com.iplanet.idar.ui.common.enterprise.RestartIdarsPanel;
import com.netscape.management.client.IFramework;
import com.netscape.management.client.IPage;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.Help;
import java.awt.Component;
import java.awt.Cursor;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class Editor
extends IDARAbstractDialog
implements IBlankPanelListener,
ConfigurationManager {
    ConfigurationView view = null;
    protected static final String TITLE = IDARResourceSet.getString("commonEditor", "TITLE");
    protected static final String MSG_CONFIRM = IDARResourceSet.getString("commonEditor", "MSG_CONFIRM");
    protected static final String MSG_TITLE = IDARResourceSet.getString("commonEditor", "MSG_TITLE");
    private static final String ERROR_TITLE = IDARResourceSet.getString("error", "TITLE");
    private static final String BEAN_ERROR_MESSAGE = IDARResourceSet.getString("error", "MODEL_RETRIEVAL_MESSAGE");
    private static final String ILLEGAL_DATA_TITLE = IDARResourceSet.getString("commonEditor", "ILLEGAL_DATA_TITLE");
    private static final String ILLEGAL_DATA = IDARResourceSet.getString("commonEditor", "ILLEGAL_DATA");
    private static final String ASK_DELETE = IDARResourceSet.getString("commonEditor", "ASK_DELETE");
    private static final String NOTICE_TITLE = IDARResourceSet.getString("notice", "NOTICE_TITLE");
    protected static final int BUTTONS = 60;
    private SaveObjectTask saveTask = new SaveObjectTask();
    private DeleteObjectTask deleteTask = new DeleteObjectTask();

    public Editor(ConfigurationView configurationView) {
        this(null, configurationView);
    }

    public Editor(Component component, ConfigurationView configurationView) {
        super(JOptionPane.getFrameForComponent(component), TITLE, true, 60);
        this.view = configurationView;
        this.saveTask = new SaveObjectTask();
        this.deleteTask = new DeleteObjectTask();
        this.deleteTask.confirmWithUserBeforeDelete(false);
        if (this.view != null) {
            this.view.getDataModel();
            this.setTitle(this.view.getTitleText());
            this.setComponent(this.view);
            IDARModelBean iDARModelBean = this.view.getDataModel();
            boolean bl = false;
            boolean bl2 = true;
            if (iDARModelBean != null) {
                bl = iDARModelBean.isDirty();
                bl2 = iDARModelBean.isEthereal();
            }
            this.setSaveButtonEnabled(bl);
            this.setResetButtonEnabled(bl && !bl2);
            this.view.addBlankPanelListener(this);
        }
        this.pack();
        this.center();
    }

    public void panelChanged(BlankPanelEvent blankPanelEvent) {
        if (this.view != null) {
            IDARModelBean iDARModelBean = this.view.getDataModel();
            if (iDARModelBean != null) {
                iDARModelBean.setDirty(true);
                this.setResetButtonEnabled(!iDARModelBean.isEthereal());
            }
            this.setSaveButtonEnabled(true);
        }
    }

    public void helpInvoked() {
        AdminConfigData[] adminConfigDataArray = BeanSpace.getInstance().getUrls();
        AdminConfigData adminConfigData = null;
        for (int i = 0; i < adminConfigDataArray.length && (adminConfigData = adminConfigDataArray[i]) == null; ++i) {
        }
        URL uRL = null;
        if (adminConfigData != null) {
            uRL = adminConfigData.getAdminServerURL();
        } else {
            Debug.println((int)0, (String)"ERROR: UNABLE TO FIND ADMIN-SERVER URL");
        }
        if (uRL != null) {
            Help.showContextHelp((String)"dps", (String)this.view.getHelpTopic(), (URL)uRL);
        } else {
            Debug.println((int)0, (String)"ERROR: UNABLE TO FIND ADMIN-SERVER URL");
        }
    }

    public void okInvoked() {
    }

    public void saveInvoked() {
        this.saveModel();
    }

    public void saveModel() {
        this.saveModel(false);
    }

    public void saveModel(final boolean bl) {
        try {
            this.view.applyChanges();
            final IDARModelBean iDARModelBean = this.view.getDataModel();
            this.saveTask.setObject(iDARModelBean);
            this.saveTask.execute(new TaskAdapter(){

                public void taskStopped(TaskEvent taskEvent) {
                    int n = Editor.this.saveTask.getExecutionStatus();
                    Editor.this.saveTask;
                    if (n == 0) {
                        Editor.this.setSaveButtonEnabled(false);
                        Editor.this.setResetButtonEnabled(false);
                        try {
                            IDARReference iDARReference = iDARModelBean.getParentConfiguration();
                            ConfigurationBean configurationBean = (ConfigurationBean)iDARReference.getBean();
                            IDARReference[] iDARReferenceArray = configurationBean.getSubscribers();
                            if (iDARReferenceArray != null && iDARReferenceArray.length > 0) {
                                RestartIdarsPanel restartIdarsPanel = new RestartIdarsPanel(configurationBean.getSubscribers());
                                JDialog jDialog = new JOptionPane(restartIdarsPanel, 1, 0, null, new Object[]{RestartIdarsPanel.DONE}).createDialog(Editor.this, NOTICE_TITLE);
                                jDialog.pack();
                                jDialog.show();
                            }
                        }
                        catch (IDARBeanException iDARBeanException) {
                            iDARBeanException.printStackTrace();
                        }
                        if (bl) {
                            Editor.this.closeInvoked();
                        }
                    }
                }
            });
        }
        catch (ConfigurationViewException configurationViewException) {
            JOptionPane.showMessageDialog(IDARUtilities.getParentFrame(this), configurationViewException.getMessage(), ILLEGAL_DATA_TITLE, 0);
        }
    }

    public void resetInvoked() {
        this.resetConfiguration();
    }

    public void cancelInvoked() {
        this.closeInvoked();
    }

    public void closeInvoked() {
        IDARModelBean iDARModelBean = this.view.getDataModel();
        if (iDARModelBean.isDirty()) {
            int n = JOptionPane.showConfirmDialog(IDARUtilities.getParentFrame(this), MSG_CONFIRM, MSG_TITLE, 0, 3);
            if (n == 0) {
                this.saveModel(true);
            } else if (iDARModelBean.isEthereal() && !iDARModelBean.isLegal()) {
                n = JOptionPane.showConfirmDialog(IDARUtilities.getParentFrame(this), iDARModelBean.getIllegalityExplanationMessage() + "\n" + ASK_DELETE, ILLEGAL_DATA_TITLE, 0, 2);
                if (n == 0) {
                    this.deleteModel(iDARModelBean);
                    super.closeInvoked();
                }
            } else {
                this.resetModelInBackground(iDARModelBean);
                super.closeInvoked();
            }
        } else if (iDARModelBean.isEthereal() && !iDARModelBean.isLegal()) {
            int n = JOptionPane.showConfirmDialog(IDARUtilities.getParentFrame(this), iDARModelBean.getIllegalityExplanationMessage() + "\n" + ASK_DELETE, ILLEGAL_DATA_TITLE, 0, 2);
            if (n == 0) {
                this.deleteModel(iDARModelBean);
                super.closeInvoked();
            } else {
                JOptionPane.showMessageDialog(IDARUtilities.getParentFrame(this), iDARModelBean.getIllegalityExplanationMessage() + "\n" + ILLEGAL_DATA, ILLEGAL_DATA_TITLE, 0);
            }
        } else {
            iDARModelBean.setEthereal(false);
            super.closeInvoked();
        }
    }

    private void deleteModel(IDARModelBean iDARModelBean) {
        this.deleteTask.setObject(iDARModelBean.getSelfReference());
        this.deleteTask.execute();
    }

    private void resetModelInBackground(final IDARModelBean iDARModelBean) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    iDARModelBean.synchronize();
                }
                catch (IDARBeanException iDARBeanException) {
                    Debug.println((String)"Editor.resetInBackground: could not resync bean");
                }
            }
        }).start();
    }

    private void resetConfiguration() {
        Object object;
        final IPage iPage = IDARUtilities.getPage(this);
        if (iPage != null && (object = iPage.getFramework()) != null) {
            object.changeStatusItemState("StatusItemProgress", (Object)new Integer(-1));
        }
        object = new Thread(new Runnable(){
            String errorMessage = null;

            public void run() {
                Object object;
                try {
                    Editor.this.setCursor(Cursor.getPredefinedCursor(3));
                    object = Editor.this.view.getDataModel();
                    if (object != null) {
                        ((IDARModelBean)object).synchronize();
                    }
                    Editor.this.view.resetContent();
                    Editor.this.setSaveButtonEnabled(false);
                    Editor.this.setResetButtonEnabled(false);
                    Editor.this.view.getDataModel().setDirty(false);
                }
                catch (ConfigurationViewException configurationViewException) {
                    this.errorMessage = BEAN_ERROR_MESSAGE;
                    configurationViewException.printStackTrace();
                }
                catch (RetrievalException retrievalException) {
                    this.errorMessage = BEAN_ERROR_MESSAGE;
                    retrievalException.printStackTrace();
                }
                catch (NoSuchBeanException noSuchBeanException) {
                    noSuchBeanException.printStackTrace();
                }
                object = this.errorMessage;
                SwingUtilities.invokeLater(new Runnable(this, (String)object){
                    private final /* synthetic */ String val$finalErrorMessage;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$finalErrorMessage = string;
                    }

                    public void run() {
                        IFramework iFramework;
                        JFrame jFrame = null;
                        if (3.access$300(this.this$1) != null && (iFramework = 3.access$300(this.this$1).getFramework()) != null) {
                            iFramework.changeStatusItemState("StatusItemProgress", (Object)new Integer(0));
                            jFrame = iFramework.getJFrame();
                        }
                        if (this.val$finalErrorMessage != null) {
                            JOptionPane.showMessageDialog(jFrame, this.val$finalErrorMessage, Editor.access$400(), 0);
                        }
                    }
                });
                Editor.this.setCursor(Cursor.getPredefinedCursor(0));
            }

            static /* synthetic */ IPage access$300(3 var0) {
                return var0.iPage;
            }
        });
        ((Thread)object).start();
    }

    static /* synthetic */ String access$400() {
        return ERROR_TITLE;
    }
}

