/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator;

import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.bean.AdminConfigData;
import com.iplanet.idar.task.TaskManagerFactory;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.configurator.ConfigurationTopResource;
import com.netscape.management.client.ResourceObject;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.topology.AdminGroupNode;
import com.netscape.management.client.topology.DomainNode;
import com.netscape.management.client.topology.ITopologyPlugin;
import com.netscape.management.client.topology.ServiceLocator;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class ConfiguratorTopologyPlugin
implements ITopologyPlugin {
    private static final ResourceSet dirResource = new ResourceSet("com.iplanet.idar.common.directory");
    private static final String IDAR_ISIE = dirResource.getString("dir", "ISIE");
    private static final String IDAR_NICKNAME = dirResource.getString("dir", "NICKNAME");
    Vector nodes;
    ConsoleInfo info;
    ConfigurationTopResource top = null;

    public void initialize(ConsoleInfo consoleInfo) {
        Debug.println((String)"ConfiguratorTopologyPlugin.initialize");
        this.info = consoleInfo;
        ConfiguratorTopologyPlugin.initBeanSpace(consoleInfo);
        this.nodes = new Vector();
        this.top = ConfiguratorTopologyPlugin.createResources(consoleInfo);
        this.nodes.add(this.top);
    }

    public static ConfigurationTopResource createResources(ConsoleInfo consoleInfo) {
        return new ConfigurationTopResource(consoleInfo);
    }

    public static void initBeanSpace(ConsoleInfo consoleInfo) {
        Debug.println((String)"ConfiguratorTopologyPlugin.initBeanSpace");
        AdminConfigData[] adminConfigDataArray = ConfiguratorTopologyPlugin.getTaskUrls(consoleInfo);
        if (!BeanSpace.isInitialized()) {
            BeanSpace.initialize(consoleInfo, adminConfigDataArray);
        } else {
            BeanSpace.getInstance().addAccessUrls(adminConfigDataArray);
        }
        TaskManagerFactory.setContextIndicator(3);
    }

    public static AdminConfigData[] getTaskUrls(ConsoleInfo consoleInfo) {
        Object[] objectArray;
        Debug.println((String)"discovering DPS admin-servers...");
        Vector vector = new Vector();
        ServiceLocator serviceLocator = new ServiceLocator(consoleInfo);
        Enumeration enumeration = serviceLocator.getDomains();
        if (enumeration != null) {
            objectArray = (Object[])enumeration;
            while (objectArray.hasMoreElements()) {
                try {
                    LDAPEntry lDAPEntry = objectArray.next();
                    String string = lDAPEntry.getDN();
                    Debug.println((int)5, (String)("found domain: " + string));
                    Enumeration enumeration2 = serviceLocator.getHosts(string);
                    if (enumeration2 != null) {
                        LDAPSearchResults lDAPSearchResults = (LDAPSearchResults)enumeration2;
                        while (lDAPSearchResults.hasMoreElements()) {
                            try {
                                lDAPEntry = lDAPSearchResults.next();
                                String string2 = lDAPEntry.getDN();
                                Debug.println((int)5, (String)("found host=" + string2));
                                Enumeration enumeration3 = serviceLocator.getAdminGroup(string2);
                                if (enumeration3 == null) continue;
                                LDAPSearchResults lDAPSearchResults2 = (LDAPSearchResults)enumeration3;
                                while (lDAPSearchResults2.hasMoreElements()) {
                                    try {
                                        lDAPEntry = lDAPSearchResults2.next();
                                        AdminGroupNode adminGroupNode = new AdminGroupNode(serviceLocator, lDAPEntry);
                                        String string3 = lDAPEntry.getDN();
                                        String string4 = serviceLocator.getAdminServer(string3);
                                        String string5 = AdminGroupNode.findAdminURL((ConsoleInfo)consoleInfo, (String)string4);
                                        Debug.println((int)5, (String)("found admin group =" + string3));
                                        Debug.println((int)5, (String)("found admin server=" + string4));
                                        Debug.println((int)5, (String)("found admin URL=" + string5));
                                        ConfiguratorTopologyPlugin.findAndRegisterDPSInstance(adminGroupNode, string5, vector);
                                    }
                                    catch (LDAPException lDAPException) {
                                        Debug.println((int)0, (String)("LDAP-EXCEPTION GETTING ADMIN URLS: " + lDAPException.getLDAPErrorMessage()));
                                        Debug.println((int)0, (String)("LDAP-EXCEPTION GETTING ADMIN URLS: " + lDAPException.getMatchedDN()));
                                    }
                                }
                            }
                            catch (LDAPException lDAPException) {
                                Debug.println((int)0, (String)("LDAP-EXCEPTION GETTING ADMIN URLS: " + lDAPException.getLDAPErrorMessage()));
                                Debug.println((int)0, (String)("LDAP-EXCEPTION GETTING ADMIN URLS: " + lDAPException.getMatchedDN()));
                            }
                        }
                        continue;
                    }
                    Debug.println((int)0, (String)("ERROR: NO HOST FOUND FOR DOMAIN, " + string));
                }
                catch (LDAPException lDAPException) {
                    Debug.println((int)0, (String)("LDAP-EXCEPTION GETTING ADMIN URLS: " + lDAPException.getLDAPErrorMessage()));
                    Debug.println((int)0, (String)("LDAP-EXCEPTION GETTING ADMIN URLS: " + lDAPException.getMatchedDN()));
                }
            }
        } else {
            Debug.println((int)0, (String)"ERROR: NO DOMAINS FOUND!");
        }
        objectArray = new AdminConfigData[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static void findAndRegisterDPSInstance(AdminGroupNode adminGroupNode, String string, Vector vector) {
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        if (adminGroupNode != null) {
            String string4;
            Debug.println((int)5, (String)("\nSearching for admin servers in group: \n " + adminGroupNode.getDN() + "\n"));
            Object object = adminGroupNode.getServerIDs().elements();
            while (object.hasMoreElements()) {
                string4 = object.nextElement().toString();
                if (string4.startsWith("admin-serv")) {
                    string2 = string4;
                    Debug.println((String)("found Admin-Server: " + string2));
                }
                if (!string4.startsWith(IDAR_NICKNAME)) continue;
                bl = true;
                string3 = string4;
                Debug.println((String)("found DPS Server ID: " + string4));
            }
            if (bl) {
                object = null;
                try {
                    string4 = string + URLEncoder.encode(string3, "UTF-8") + "/tasks/xtl";
                    object = new AdminConfigData(string2, string4);
                    Debug.println((int)5, (String)("\nAdding new URL for Tasks: \n\n" + string4 + "\n"));
                    vector.add(object);
                    IDARUtilities.registerIdarServerId(string3);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Debug.println((int)0, (String)("FAILED TO ADD ADMIN-SERVER URL: " + unsupportedEncodingException.getMessage()));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Debug.println((int)0, (String)("FAILED TO ADD ADMIN-SERVER URL: " + illegalArgumentException.getMessage()));
                }
            } else {
                Debug.println((int)5, (String)("\nNo Admin-Servers for DPS in Group: \n " + adminGroupNode.getDN() + "\n"));
            }
            bl = false;
        }
    }

    public Vector getTopNodes() {
        return null;
    }

    public Vector getAdditionalChildren(ResourceObject resourceObject) {
        Debug.println((String)("ConfiguratorTopologyPlugin.getAdditionalChildren: t=" + resourceObject));
        Vector vector = null;
        if (resourceObject instanceof DomainNode) {
            this.top.createChildren();
            vector = (Vector)this.nodes.clone();
        }
        return vector;
    }

    public String getIDByResourceObject(ResourceObject resourceObject) {
        return resourceObject.toString();
    }

    public ResourceObject getResourceObjectByID(String string) {
        Debug.println((int)6, (String)("ConfiguratorTopologyPlugin.getResourceObjectByID: id=" + string));
        ResourceObject resourceObject = null;
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!string.equals(e.toString())) continue;
            resourceObject = (ResourceObject)e;
            break;
        }
        return resourceObject;
    }
}

