/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator;

import com.iplanet.idar.objectmodel.BeanEvent;
import com.iplanet.idar.objectmodel.BeanListenerAdapter;
import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.AdminConfigData;
import com.iplanet.idar.objectmodel.bean.ConfigurationBean;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.NoSuchBeanException;
import com.iplanet.idar.objectmodel.bean.RetrievalException;
import com.iplanet.idar.task.configuration.DeleteObjectTask;
import com.iplanet.idar.task.configuration.RenameConfigurationTask;
import com.iplanet.idar.ui.common.IDARFramework;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.common.ImageFactory;
import com.iplanet.idar.ui.configurator.ConfigurationTopResource;
import com.iplanet.idar.ui.configurator.ConfiguratorFrameworkInitializer;
import com.netscape.management.client.Framework;
import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.IStatusItem;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.ResourceModel;
import com.netscape.management.client.ResourceObject;
import com.netscape.management.client.ResourcePage;
import com.netscape.management.client.StatusItemSecureMode;
import com.netscape.management.client.StatusItemSpacer;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.topology.INodeInfo;
import com.netscape.management.client.topology.NodeData;
import com.netscape.management.client.topology.NodeDataPanel;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UtilConsoleGlobals;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.MutableTreeNode;

public class ConfigurationResource
extends ResourceObject
implements IMenuInfo,
INodeInfo {
    public static final int INDEX_NAME = 0;
    public static final int INDEX_DESCRIPTION = 1;
    public static final int INDEX_BASE_DN = 2;
    public static final int INDEX_MODIFY_DATE = 3;
    public static final int INDEX_SUBSCRIBERS = 4;
    private static final ResourceSet resource = new ResourceSet("com.iplanet.idar.ui.configurator.configurator");
    private static final String NEW = resource.getString("topologyMenu", "NEW");
    private static final String NEW_DESC = resource.getString("topologyMenu", "NEW_DESC");
    private static final String DELETE = resource.getString("topologyMenu", "DELETE");
    private static final String DELETE_DESC = resource.getString("topologyMenu", "DELETE_DESC");
    private static final String NAME = IDARResourceSet.getString("configTopology", "NAME");
    private static final String NAME_ID = "cn";
    private static final String DESCRIPTION = IDARResourceSet.getString("configTopology", "DESCRIPTION");
    private static final String BASE_DN = IDARResourceSet.getString("configTopology", "BASE_DN");
    private static final String DEFAULT_DESCRIPTION = IDARResourceSet.getString("configTopology", "DEFAULT_DESCRIPTION");
    private static final String HELP_TOPIC = "Configuration-Topology";
    private static final String ERROR_TITLE = IDARResourceSet.getString("error", "TITLE");
    private static final String RENAME_FAILURE = IDARResourceSet.getString("error", "RENAME_FAILURE");
    protected Framework framework;
    protected StatusItemSpacer _statusSpacer = new StatusItemSpacer("SECURE_MODE_SPACER");
    protected StatusItemSecureMode _statusSecureMode = new StatusItemSecureMode("StatusItemSecureMode");
    private ConsoleInfo consoleInfo;
    private ConfigurationBean model;
    private IDARReference reference;
    private MenuItemText mnuCreateConfiguration = new MenuItemText(NEW, NEW, NEW_DESC);
    private MenuItemText mnuDeleteConfiguration = new MenuItemText(DELETE, DELETE, DELETE_DESC);
    private NodeDataPanel pnlData;
    private IPage viewInstance;
    private ResourceObject nodeObject;
    private Vector changeListeners = new Vector();

    public ConfigurationResource(ConsoleInfo consoleInfo, ConfigurationBean configurationBean) {
        this(consoleInfo, configurationBean.getSelfReference());
    }

    public ConfigurationResource(ConsoleInfo consoleInfo, IDARReference iDARReference) {
        Debug.println((int)6, (String)("ConfigurationResource<init>: consoleinfo=" + consoleInfo + " ref=" + iDARReference));
        this.consoleInfo = consoleInfo;
        this.reference = iDARReference;
        super.setName(iDARReference.getId());
        super.setIcon((Icon)ImageFactory.getImage("CONFIGURATION"));
        boolean bl = consoleInfo.get((Object)"ldapSecurity").equals("on");
        this._statusSecureMode.setSecureMode(bl);
        IDARUtilities.registerConfigurationResource(iDARReference.getId(), this);
        this.initComponents();
    }

    public IDARReference getReference() {
        return this.reference;
    }

    public ConfigurationBean getModel() {
        if (this.model == null) {
            try {
                this.model = (ConfigurationBean)this.reference.getBean();
            }
            catch (NoSuchBeanException noSuchBeanException) {
                noSuchBeanException.printStackTrace();
            }
            catch (RetrievalException retrievalException) {
                retrievalException.printStackTrace();
            }
            catch (ClassCastException classCastException) {
                classCastException.printStackTrace();
            }
        }
        return this.model;
    }

    public String getDn() {
        return this.reference.getHandle();
    }

    public void initComponents() {
        Debug.println((int)0, (String)("creating node data panel for :" + super.getName()));
        this.pnlData = new NodeDataPanel(super.getIcon(), super.getName(), (INodeInfo)this, true);
        Debug.println((int)0, (String)("nodeDataPanel=" + this.pnlData));
        this.pnlData.setHelpTopic("dps", HELP_TOPIC);
    }

    public Component getCustomPanel() {
        return this.pnlData;
    }

    public void select(IPage iPage) {
        this.viewInstance = iPage;
    }

    public void setNodeObject(ResourceObject resourceObject) {
        this.nodeObject = resourceObject;
    }

    protected void populateStatusItems() {
        Debug.println((int)7, (String)"ConfigurationResource.populateStatusItems");
        this.framework.addStatusItem((IStatusItem)this._statusSpacer, "LF");
        this.framework.addStatusItem((IStatusItem)this._statusSecureMode, "LF");
    }

    public void actionMenuSelected(final IPage iPage, IMenuItem iMenuItem) {
        ConfigurationBean configurationBean;
        final ConfigurationTopResource configurationTopResource = (ConfigurationTopResource)((Object)this.getParent());
        if (iMenuItem.getID().equals(NEW)) {
            configurationTopResource.actionMenuSelected(iPage, iMenuItem);
        } else if (iMenuItem.getID().equals(DELETE) && (configurationBean = this.getModel()) != null) {
            configurationBean.addBeanListener(new BeanListenerAdapter(){

                public void beanDeleted(BeanEvent beanEvent) {
                    SwingUtilities.invokeLater(new Runnable(this, beanEvent){
                        private final /* synthetic */ BeanEvent val$event;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$event = beanEvent;
                        }

                        public void run() {
                            IDARFramework.destroyInstance(this.val$event.getReference().getId());
                            if (1.access$000(this.this$1) != null && 1.access$100(this.this$1).getParent() != null) {
                                1.access$000(this.this$1).remove((MutableTreeNode)((Object)1.access$100(this.this$1)));
                                1.access$000(this.this$1).update(1.access$200(this.this$1));
                                1.access$000(this.this$1).select(1.access$200(this.this$1));
                            }
                        }
                    });
                }

                static /* synthetic */ ConfigurationTopResource access$000(1 var0) {
                    return var0.configurationTopResource;
                }

                static /* synthetic */ ConfigurationResource access$100(1 var0) {
                    return var0.ConfigurationResource.this;
                }

                static /* synthetic */ IPage access$200(1 var0) {
                    return var0.iPage;
                }
            });
            DeleteObjectTask deleteObjectTask = new DeleteObjectTask();
            deleteObjectTask.setObject(configurationBean.getSelfReference());
            deleteObjectTask.execute();
        }
    }

    public String[] getMenuCategoryIDs() {
        return new String[]{"OBJECT"};
    }

    public IMenuItem[] getMenuItems(String string) {
        IMenuItem[] iMenuItemArray = null;
        if (string.equals("OBJECT")) {
            iMenuItemArray = new IMenuItem[]{this.mnuCreateConfiguration, this.mnuDeleteConfiguration};
        }
        return iMenuItemArray;
    }

    private NodeData[] getNodeData() {
        return new NodeData[]{new NodeData(NAME_ID, NAME, (Object)this.getName(), true), new NodeData(DESCRIPTION, DESCRIPTION, (Object)DEFAULT_DESCRIPTION), new NodeData(BASE_DN, BASE_DN, (Object)this.getDn())};
    }

    protected void createFramework() {
        String string = null;
        IDARReference iDARReference = this.getReference();
        if (iDARReference != null) {
            string = iDARReference.getId();
        }
        Debug.println((String)"ConfigurationResource.createFramework");
        this.framework = IDARFramework.getInstance(string);
        ConfiguratorFrameworkInitializer configuratorFrameworkInitializer = null;
        if (this.framework == null) {
            configuratorFrameworkInitializer = new ConfiguratorFrameworkInitializer(this.consoleInfo, this);
            this.framework = IDARFramework.getInstance(configuratorFrameworkInitializer);
            AdminConfigData[] adminConfigDataArray = BeanSpace.getInstance().getUrls();
            if (adminConfigDataArray.length > 0) {
                Debug.println((String)("ConfigurationResource.createFramework : setHelpAdminURL:" + adminConfigDataArray[0].getAdminServerURL()));
                this.framework.setHelpAdminURL(adminConfigDataArray[0].getAdminServerURL());
            } else {
                Debug.println((String)"ConfigurationResource.createFramework : can't setHelpAdminURL, adminUrls.length <= 0");
            }
        }
        if (this.framework.getState() == 1) {
            this.framework.setState(0);
        }
        this.populateStatusItems();
    }

    private boolean run(IPage iPage) {
        this.createFramework();
        return true;
    }

    public boolean run(IPage iPage, IResourceObject[] iResourceObjectArray) {
        if (iResourceObjectArray.length == 1) {
            return this.run(iPage);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionNodeDataChanged(NodeData nodeData) {
        block12: {
            if (nodeData.getID().equals(NodeDataPanel.ID_OPEN)) {
                this.createFramework();
                return;
            }
            if (!nodeData.getID().equals(NAME_ID)) return;
            Debug.println((String)("ConfigurationResource.actionNodeDataChanged: name value=" + nodeData.getValue()));
            String string = null;
            try {
                block11: {
                    try {
                        ConfigurationBean configurationBean = (ConfigurationBean)this.reference.getBean();
                        String string2 = configurationBean.getId();
                        RenameConfigurationTask renameConfigurationTask = new RenameConfigurationTask();
                        renameConfigurationTask.setObject(configurationBean);
                        renameConfigurationTask.setNewId((String)nodeData.getValue());
                        if (!IDARUtilities.isServerIdInUse((String)nodeData.getValue())) {
                            if (string2.equals(nodeData.getValue())) break block11;
                            if (renameConfigurationTask.executeAndWait() != -1) {
                                ResourcePage resourcePage;
                                IDARUtilities.removeConfigurationResource(string2);
                                IDARUtilities.registerConfigurationResource(configurationBean.getId(), this);
                                this.pnlData.setTitle((String)nodeData.getValue());
                                this.setName((String)nodeData.getValue());
                                if (this.viewInstance != null && this.viewInstance instanceof ResourcePage && (resourcePage = (ResourcePage)this.viewInstance).getTreeModel() instanceof ResourceModel && this.nodeObject != null) {
                                    this.nodeObject.setName(this.getName());
                                    ((ResourceModel)resourcePage.getTreeModel()).fireTreeNodeChanged(this.nodeObject);
                                }
                                break block11;
                            }
                            string = renameConfigurationTask.getExecutionFailureMessage();
                            break block11;
                        }
                        string = IDARResourceSet.getString("error", "NAME_IN_USE_BY_SERVER", (String)nodeData.getValue());
                    }
                    catch (IDARBeanException iDARBeanException) {
                        string = RENAME_FAILURE;
                        Object var8_9 = null;
                        if (string != null) {
                            JOptionPane.showMessageDialog(UtilConsoleGlobals.getActivatedFrame(), string, ERROR_TITLE, 0);
                        }
                        this.fireStateChanged(this.getNodeData(0));
                        return;
                    }
                }
                Object var8_8 = null;
                if (string == null) break block12;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (string != null) {
                    JOptionPane.showMessageDialog(UtilConsoleGlobals.getActivatedFrame(), string, ERROR_TITLE, 0);
                }
                this.fireStateChanged(this.getNodeData(0));
                throw throwable;
            }
            JOptionPane.showMessageDialog(UtilConsoleGlobals.getActivatedFrame(), string, ERROR_TITLE, 0);
        }
        this.fireStateChanged(this.getNodeData(0));
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void fireStateChanged(NodeData nodeData) {
        Enumeration enumeration = this.changeListeners.elements();
        while (enumeration.hasMoreElements()) {
            ChangeListener changeListener = (ChangeListener)enumeration.nextElement();
            changeListener.stateChanged(new ChangeEvent(nodeData));
        }
    }

    public NodeData getNodeData(int n) {
        NodeData nodeData = null;
        NodeData[] nodeDataArray = this.getNodeData();
        if (n >= 0 && n < nodeDataArray.length) {
            nodeData = nodeDataArray[n];
        }
        return nodeData;
    }

    public int getNodeDataCount() {
        NodeData[] nodeDataArray = this.getNodeData();
        return nodeDataArray.length;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }
}

