/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.common.enterprise;

import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.IDARBean;
import com.iplanet.idar.objectmodel.bean.IDARBeanCollection;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.server.ServerStatusEvent;
import com.iplanet.idar.server.ServerStatusListener;
import com.iplanet.idar.task.TaskAdapter;
import com.iplanet.idar.task.TaskEvent;
import com.iplanet.idar.task.TaskListener;
import com.iplanet.idar.task.idar.IdarTask;
import com.netscape.management.client.util.Debug;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class EnterpriseTableModel
extends AbstractTableModel {
    public static final int SERVER_NAME_COLUMN = 0;
    public static final int STATUS_COLUMN = 1;
    public static final int RESTART_NEEDED_COLUMN = 2;
    public static final int START_COLUMN = 3;
    public static final int STOP_COLUMN = 4;
    public static final String YES = "yes";
    public static final String NO = "no";
    String[] headers;
    Class[] columnClasses;
    protected Vector servers = new Vector();
    TaskListener[] taskListeners = null;
    ServerStatusListener[] serverStatusListeners = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$iplanet$idar$task$AbstractTask;

    public EnterpriseTableModel() {
        this.headers = new String[]{"iDAR", "Status", "Needs Restart", "", ""};
        this.columnClasses = new Class[]{class$java$lang$String == null ? (class$java$lang$String = EnterpriseTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = EnterpriseTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = EnterpriseTableModel.class$("java.lang.String")) : class$java$lang$String, class$com$iplanet$idar$task$AbstractTask == null ? (class$com$iplanet$idar$task$AbstractTask = EnterpriseTableModel.class$("com.iplanet.idar.task.AbstractTask")) : class$com$iplanet$idar$task$AbstractTask, class$com$iplanet$idar$task$AbstractTask == null ? (class$com$iplanet$idar$task$AbstractTask = EnterpriseTableModel.class$("com.iplanet.idar.task.AbstractTask")) : class$com$iplanet$idar$task$AbstractTask};
    }

    public EnterpriseTableModel(IDARReference[] iDARReferenceArray) {
        this();
        this.setServers(iDARReferenceArray);
    }

    public void setServers(IDARBeanCollection iDARBeanCollection) {
        this.servers = iDARBeanCollection.toReferenceVector();
        this.fireTableStructureChanged();
    }

    public void setServers(IDARReference[] iDARReferenceArray) {
        if (iDARReferenceArray != null) {
            for (int i = 0; i < iDARReferenceArray.length; ++i) {
                this.servers.add(iDARReferenceArray[i]);
            }
            this.fireTableStructureChanged();
        }
    }

    public void addServer(IDARBean iDARBean) {
        this.servers.add(iDARBean);
        this.fireTableStructureChanged();
    }

    public int getRowCount() {
        return this.servers.size();
    }

    public int getColumnCount() {
        return this.headers.length;
    }

    public Class getColumnClass(int n) {
        return this.columnClasses[n];
    }

    public String getColumnName(int n) {
        return this.headers[n];
    }

    public boolean isCellEditable(int n, int n2) {
        return this.getColumnClass(n2).equals(class$com$iplanet$idar$task$AbstractTask == null ? (class$com$iplanet$idar$task$AbstractTask = EnterpriseTableModel.class$("com.iplanet.idar.task.AbstractTask")) : class$com$iplanet$idar$task$AbstractTask);
    }

    public Object getValueAt(final int n, int n2) {
        Object object = null;
        try {
            final IDARReference iDARReference = (IDARReference)this.servers.elementAt(n);
            if (iDARReference.beanHasBeenLoaded()) {
                try {
                    IDARBean iDARBean = (IDARBean)iDARReference.getBean();
                    iDARBean.addServerStatusListener(this.getServerStatusListener(n));
                    IdarTask idarTask = null;
                    switch (n2) {
                        case 0: {
                            object = iDARBean.getId();
                            break;
                        }
                        case 1: {
                            object = iDARBean.getStatusMessage();
                            break;
                        }
                        case 2: {
                            object = iDARBean.isNeedingRestart() ? YES : NO;
                            break;
                        }
                        case 3: {
                            idarTask = iDARBean.getStartTask();
                            idarTask.addTaskListener(this.getTaskListener(n));
                            object = idarTask;
                            break;
                        }
                        case 4: {
                            idarTask = iDARBean.getStopTask();
                            idarTask.addTaskListener(this.getTaskListener(n));
                            object = idarTask;
                            break;
                        }
                    }
                }
                catch (IDARBeanException iDARBeanException) {}
            } else {
                switch (n2) {
                    case 0: {
                        object = iDARReference.getId();
                        break;
                    }
                    case 1: {
                        object = "Loading...";
                    }
                }
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                        try {
                            iDARReference.getBean();
                            EnterpriseTableModel.this.fireTableRowsUpdated(n, n);
                        }
                        catch (IDARBeanException iDARBeanException) {
                            iDARBeanException.printStackTrace();
                        }
                    }
                });
                thread.start();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return object;
    }

    private TaskListener getTaskListener(final int n) {
        TaskListener taskListener;
        if (this.taskListeners == null) {
            this.taskListeners = new TaskListener[this.servers.size()];
        }
        if ((taskListener = this.taskListeners[n]) == null) {
            this.taskListeners[n] = taskListener = new TaskAdapter(){

                public void taskStarted(TaskEvent taskEvent) {
                    EnterpriseTableModel.this.fireTableRowsUpdated(n, n);
                }

                public void taskStopped(TaskEvent taskEvent) {
                    EnterpriseTableModel.this.fireTableRowsUpdated(n, n);
                }

                public void taskEnabled(TaskEvent taskEvent) {
                    Debug.println((int)7, (String)"EnterpriseTableModel.taskEnabled");
                    EnterpriseTableModel.this.fireTableRowsUpdated(n, n);
                }

                public void taskDisabled(TaskEvent taskEvent) {
                    Debug.println((int)7, (String)"EnterpriseTableModel.taskDisabled");
                    EnterpriseTableModel.this.fireTableRowsUpdated(n, n);
                }
            };
        }
        return taskListener;
    }

    private ServerStatusListener getServerStatusListener(final int n) {
        ServerStatusListener serverStatusListener;
        if (this.serverStatusListeners == null) {
            this.serverStatusListeners = new ServerStatusListener[this.servers.size()];
        }
        if ((serverStatusListener = this.serverStatusListeners[n]) == null) {
            this.serverStatusListeners[n] = serverStatusListener = new ServerStatusListener(){

                public void statusMessageChanged(ServerStatusEvent serverStatusEvent) {
                    EnterpriseTableModel.this.fireTableRowsUpdated(n, n);
                }

                public void statusChanged(ServerStatusEvent serverStatusEvent) {
                    EnterpriseTableModel.this.fireTableRowsUpdated(n, n);
                }
            };
        }
        return serverStatusListener;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

