/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.common.configuration;

import com.iplanet.idar.objectmodel.BeanEvent;
import com.iplanet.idar.objectmodel.BeanListener;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.BlankPanelEvent;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class ConfigurationView
extends BlankPanel
implements PropertyChangeListener,
BeanListener {
    protected IDARModelBean model = null;
    ConsoleInfo consoleInfo = null;
    IDARReference beanRef = null;
    IDARReference configuration = null;
    String id = null;
    String descriptor = null;
    private boolean dirty;

    public abstract void resetContent() throws ConfigurationViewException;

    public void resetContentEventlessly() throws ConfigurationViewException {
        Debug.println((String)"ConfigurationView.resetContentEventlessly");
        if (SwingUtilities.isEventDispatchThread()) {
            this.setEventFiringEnabled(false);
            this.resetContent();
            this.setEventFiringEnabled(true);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ConfigurationView.this.setEventFiringEnabled(false);
                        try {
                            ConfigurationView.this.resetContent();
                        }
                        catch (ConfigurationViewException configurationViewException) {
                            configurationViewException.printStackTrace();
                        }
                        ConfigurationView.this.setEventFiringEnabled(true);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
        this.dirty = false;
    }

    public abstract void applyChanges() throws ConfigurationViewException;

    public abstract String getTitleText();

    public abstract String getHelpTopic();

    protected abstract void initComponents();

    public ConsoleInfo getConsoleInfo() {
        return this.consoleInfo;
    }

    public void setConsoleInfo(ConsoleInfo consoleInfo) {
        this.consoleInfo = consoleInfo;
    }

    public IDARModelBean getDataModel() {
        Debug.println((int)7, (String)("ConfigurationView.getDataModel: model=" + this.model));
        return this.model;
    }

    public void setDataModel(IDARModelBean iDARModelBean) {
        this.setDataModel(iDARModelBean, true);
    }

    public void setDataModel(IDARModelBean iDARModelBean, boolean bl) {
        Debug.println((String)("ConfigurationView.setDataModel: model=" + iDARModelBean + " reset=" + bl));
        if (this.model != null) {
            this.model.removePropertyChangeListener(this);
            this.model.removeBeanListener(this);
        }
        this.model = iDARModelBean;
        if (this.model != null) {
            this.model.addPropertyChangeListener(this);
            this.model.addBeanListener(this);
        }
        if (bl) {
            try {
                this.resetContentEventlessly();
            }
            catch (ConfigurationViewException configurationViewException) {
                configurationViewException.printStackTrace();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void beanLoaded(BeanEvent beanEvent) {
    }

    public void beanDeleted(BeanEvent beanEvent) {
    }

    public void beanPersisted(BeanEvent beanEvent) {
        Debug.println((int)6, (String)("ConfigurationView.propertyChange: evt=" + beanEvent));
        try {
            this.resetContentEventlessly();
        }
        catch (ConfigurationViewException configurationViewException) {
            // empty catch block
        }
    }

    public void beanRenamed(BeanEvent beanEvent) {
    }

    public JPanel getPanel() {
        return this;
    }

    public void fireBlankPanelEvent(BlankPanelEvent blankPanelEvent) {
        super.fireBlankPanelEvent(blankPanelEvent);
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public String toString() {
        return "ConfigurationView[" + this.getTitleText() + "]";
    }
}

