/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.common;

import com.iplanet.idar.objectmodel.BeanListenable;
import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.IDARBeanCollection;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.LDAPServerPropertyBean;
import com.iplanet.idar.ui.common.DynamicComboBoxModel;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.common.NewItemListener;
import com.iplanet.idar.ui.common.ToggleBorder;
import com.iplanet.idar.ui.task.TaskButton;
import com.iplanet.idar.ui.task.configuration.IplanetCreateAndEditObjectTask;
import com.iplanet.idar.ui.task.configuration.IplanetEditObjectTask;
import com.netscape.management.client.components.ButtonFactory;
import com.netscape.management.client.components.DirBrowserDialog;
import com.netscape.management.client.components.DirModel;
import com.netscape.management.client.components.IDirModel;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.KingpinLDAPConnection;
import com.netscape.management.client.util.LDAPUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;

public class DirBrowserCombo
extends DirBrowserDialog {
    private static final String LOGIN_BUTTON = IDARResourceSet.getString("button", "LOGIN_BUTTON");
    private static final String LDAP_ERROR = IDARResourceSet.getString("error", "LDAP_ERROR");
    private static final String LOGIN = IDARResourceSet.getString("common", "LOGIN");
    private static final String INPUT_ERROR = IDARResourceSet.getString("error", "ERR_MSG_TITLE");
    private static final String UNABLE_TO_CONNECT_ERROR = IDARResourceSet.getString("error", "UNABLE_TO_CONNECT_ERROR");
    private static final String USER_NAME_AND_PASSWORD_ERROR = IDARResourceSet.getString("error", "USER_NAME_AND_PASSWORD_ERROR");
    private static final String LOGIN_TO_SERVER = IDARResourceSet.getString("common", "LOGIN_TO_SERVER");
    private static final String LOGIN_USER_NAME = IDARResourceSet.getString("common", "LOGIN_USER_NAME");
    private static final String LOGIN_ANONYMOUS = IDARResourceSet.getString("common", "LOGIN_ANONYMOUS");
    private static final String LOGIN_SIMPLE = IDARResourceSet.getString("common", "LOGIN_SIMPLE");
    private static final String LOGIN_PASSWORD = IDARResourceSet.getString("common", "LOGIN_PASSWORD");
    public static final String DEFAULT = IDARResourceSet.getString("common", "DEFAULT_SERVER");
    protected Hashtable connections = new Hashtable();
    JComboBox cboServer;
    JButton butNewServer;
    JButton butEditServer;
    JButton butLogin;
    NewItemListener newServerListener;
    IplanetEditObjectTask editTask;
    IplanetCreateAndEditObjectTask createTask;

    public DirBrowserCombo(JFrame jFrame, ConsoleInfo consoleInfo, IDARReference iDARReference) {
        super(jFrame, consoleInfo.getLDAPConnection());
        this.setLdapConnectionForServer(DEFAULT, (KingpinLDAPConnection)consoleInfo.getLDAPConnection());
        this.createTask.setConsoleInfo(consoleInfo);
        this.createTask.setParentConfiguration(iDARReference);
        this.editTask.setConsoleInfo(consoleInfo);
        try {
            IDARBeanCollection iDARBeanCollection = BeanSpace.getInstance().retrieveBeanCollection(iDARReference, "ldap-server");
            this.cboServer.setModel(new DirBrowserComboBoxModel(iDARBeanCollection));
        }
        catch (IDARBeanException iDARBeanException) {
            iDARBeanException.printStackTrace();
        }
        this.cboServer.setSelectedItem(DEFAULT);
    }

    protected JPanel createPanel() {
        this.cboServer = new JComboBox();
        this.cboServer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DirBrowserCombo.this.editTask.setObject(((DynamicComboBoxModel)DirBrowserCombo.this.cboServer.getModel()).getSelectedReference());
                DirBrowserCombo.this.setConnection();
            }
        });
        this.editTask = new IplanetEditObjectTask();
        this.createTask = new IplanetCreateAndEditObjectTask("ldap-server");
        this.butNewServer = new TaskButton(this.createTask);
        ButtonFactory.resizeButton((JButton)this.butNewServer);
        this.newServerListener = new NewItemListener(this.butNewServer);
        this.butEditServer = new TaskButton(this.editTask);
        ButtonFactory.resizeButton((JButton)this.butEditServer);
        this.butLogin = ButtonFactory.createButton((String)LOGIN);
        this.butLogin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DirBrowserCombo.this.authenticateCurrentConnection();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.right = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets.bottom = 0;
        jPanel.add((Component)this.cboServer, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.butNewServer, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.butEditServer, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.butLogin, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)super.createPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)jPanel, gridBagConstraints);
        return jPanel2;
    }

    public void authenticateCurrentConnection() {
        KingpinLDAPConnection kingpinLDAPConnection = this.getCurrentConnection();
        if (kingpinLDAPConnection != null) {
            LoginDialog loginDialog = new LoginDialog(IDARUtilities.getParentJFrame((Component)((Object)this)));
            loginDialog.setUser(kingpinLDAPConnection.getAuthenticationDN());
            loginDialog.setPassword(kingpinLDAPConnection.getAuthenticationPassword());
            loginDialog.showModal();
            if (!loginDialog.isCancel()) {
                try {
                    kingpinLDAPConnection.setConnectTimeout(5);
                    kingpinLDAPConnection.bind(loginDialog.getUser(), loginDialog.getPassword());
                }
                catch (LDAPException lDAPException) {
                    String string = LDAPUtil.getDNFromUID((String)kingpinLDAPConnection.getHost(), (int)kingpinLDAPConnection.getPort(), (String)this.editTask.getConsoleInfo().getBaseDN(), (String)loginDialog.getUser());
                    Debug.println((String)("DirBrowserDialog.authenticateCurrentConnection: got " + string + " from " + loginDialog.getUser()));
                    if (string != null) {
                        try {
                            kingpinLDAPConnection.bind(string, loginDialog.getPassword());
                        }
                        catch (LDAPException lDAPException2) {
                            JOptionPane.showMessageDialog(this.getOwner(), LDAP_ERROR + ": " + LDAPException.errorCodeToString((int)lDAPException2.getLDAPResultCode()), LDAP_ERROR, 0);
                        }
                    }
                    JOptionPane.showMessageDialog(this.getOwner(), LDAP_ERROR + ": " + LDAPException.errorCodeToString((int)lDAPException.getLDAPResultCode()), LDAP_ERROR, 0);
                }
                this.setCurrentConnection(kingpinLDAPConnection);
            }
        }
    }

    public KingpinLDAPConnection getCurrentConnection() {
        return (KingpinLDAPConnection)this.getLDAPConnection();
    }

    public void setCurrentConnection(KingpinLDAPConnection kingpinLDAPConnection) {
        Debug.println((String)("DirBrowserCombo.setCurrentConnection: ldc=" + kingpinLDAPConnection));
        this.setLDAPConnection((LDAPConnection)kingpinLDAPConnection);
        DirModel dirModel = new DirModel((LDAPConnection)kingpinLDAPConnection);
        dirModel.setShowsPrivateSuffixes(true);
        dirModel.setAllowsLeafNodes(true);
        dirModel.setReferralsEnabled(true);
        dirModel.initialize(null);
        this.setDirModel((IDirModel)dirModel);
    }

    public void setConnection() {
        Debug.println((String)"DirBrowserDCombo.setConnection");
        KingpinLDAPConnection kingpinLDAPConnection = null;
        String string = (String)this.cboServer.getSelectedItem();
        kingpinLDAPConnection = this.getLdapConnectionForServer(string);
        if (kingpinLDAPConnection == null) {
            LDAPServerPropertyBean lDAPServerPropertyBean = (LDAPServerPropertyBean)((DynamicComboBoxModel)this.cboServer.getModel()).getSelectedBean();
            if (lDAPServerPropertyBean != null) {
                String string2 = lDAPServerPropertyBean.getHost();
                int n = lDAPServerPropertyBean.getPort();
                int n2 = 3;
                if ("2".equals(lDAPServerPropertyBean.getUseVersion())) {
                    n2 = 2;
                }
                kingpinLDAPConnection = new KingpinLDAPConnection("", "");
                kingpinLDAPConnection.setConnectTimeout(5);
                try {
                    kingpinLDAPConnection.connect(n2, string2, n, "", "");
                    this.setLdapConnectionForServer(string, kingpinLDAPConnection);
                }
                catch (LDAPException lDAPException) {
                    JOptionPane.showMessageDialog(this.getOwner(), UNABLE_TO_CONNECT_ERROR, INPUT_ERROR, 0);
                }
            } else {
                Debug.println((String)("DirBrowserCombo.setConnection: ERROR - could not access bean " + string));
            }
        }
        this.setCurrentConnection(kingpinLDAPConnection);
    }

    protected KingpinLDAPConnection getLdapConnectionForServer(String string) {
        KingpinLDAPConnection kingpinLDAPConnection = null;
        if (string != null) {
            kingpinLDAPConnection = (KingpinLDAPConnection)this.connections.get(string);
        }
        return kingpinLDAPConnection;
    }

    protected void setLdapConnectionForServer(String string, KingpinLDAPConnection kingpinLDAPConnection) {
        if (string != null && kingpinLDAPConnection != null) {
            this.connections.put(string, kingpinLDAPConnection);
        }
    }

    class DirBrowserComboBoxModel
    extends DynamicComboBoxModel {
        public DirBrowserComboBoxModel() {
        }

        public DirBrowserComboBoxModel(IDARBeanCollection iDARBeanCollection) {
            super(iDARBeanCollection);
        }

        public void setSelectedItem(Object object) {
            if (this.selectedItem != null && !this.selectedItem.equals(object) || this.selectedItem == null && object != null) {
                if (this.contains(object)) {
                    this.selectedItem = object;
                    if (this.selectedItem.equals(DEFAULT)) {
                        this.selectedBean = null;
                    } else if (this.selectedItem instanceof String) {
                        this.selectedBean = this.getReference((String)this.selectedItem);
                    } else if (this.selectedItem instanceof BeanListenable) {
                        this.selectedBean = (BeanListenable)this.selectedItem;
                    }
                    if (this.selectedBean != null) {
                        this.selectedBean.addBeanListener(this.beanListener);
                    }
                } else {
                    this.selectedItem = null;
                }
                super.fireContentsChanged(this, -1, -1);
            }
        }

        public boolean contains(Object object) {
            boolean bl = false;
            if (object instanceof String && !object.equals(DEFAULT)) {
                Enumeration enumeration = this.v.elements();
                while (enumeration.hasMoreElements()) {
                    String string;
                    Object e = enumeration.nextElement();
                    if (!(e instanceof BeanListenable) || !object.equals(string = ((BeanListenable)e).getId())) continue;
                    bl = true;
                    break;
                }
            } else {
                bl = this.v.contains(object);
            }
            return bl;
        }

        public void setBeanCollection(IDARBeanCollection iDARBeanCollection) {
            super.setBeanCollection(iDARBeanCollection);
            this.v.setElementAt(DEFAULT, 0);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            this.v.setElementAt(DEFAULT, 0);
        }
    }

    class LoginDialog
    extends AbstractDialog {
        protected LoginView view = new LoginView();
        protected static final int BUTTONS = 3;

        public LoginDialog(Frame frame) {
            super(frame, LOGIN, 3);
            this.setComponent(this.view.getPanel());
            this.pack();
            this.center();
        }

        public String getUser() {
            return new String(this.view.getUser());
        }

        public void setUser(String string) {
            this.view.setUser(string);
        }

        public String getPassword() {
            return new String(this.view.getPassword());
        }

        public void setPassword(String string) {
            this.view.setPassword(string);
        }

        public void okInvoked() {
            if (this.view.radSimple.isSelected() && (this.getUser().trim().equals("") || this.getPassword().trim().equals(""))) {
                JOptionPane.showMessageDialog((Component)((Object)this), USER_NAME_AND_PASSWORD_ERROR, INPUT_ERROR, 0);
            } else {
                super.okInvoked();
            }
        }

        class LoginView
        extends JPanel {
            public String dn;
            public JLabel lbUser;
            public JLabel lbPassword;
            public JTextField tfUser;
            public JPasswordField tfPassword;
            public JRadioButton radSimple;
            public JRadioButton radAnonymous;

            LoginView() {
                this.initComponents();
            }

            public String getUser() {
                if (this.radSimple.isSelected()) {
                    return this.tfUser.getText();
                }
                return "";
            }

            public void setUser(String string) {
                if (string != null && !string.trim().equals("")) {
                    this.radSimple.setSelected(true);
                }
                this.tfUser.setText(string);
            }

            public String getPassword() {
                if (this.radSimple.isSelected()) {
                    return new String(this.tfPassword.getPassword());
                }
                return "";
            }

            public void setPassword(String string) {
                if (string != null && !string.trim().equals("")) {
                    this.radSimple.setSelected(true);
                }
                this.tfPassword.setText(string);
            }

            void initComponents() {
                JPanel jPanel = new JPanel();
                this.radAnonymous = new JRadioButton(LOGIN_ANONYMOUS);
                this.radAnonymous.addActionListener(new ActionListener(this){
                    private final /* synthetic */ LoginView this$2;
                    {
                        this.this$2 = loginView;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.this$2.setSimpleLoginEnabled(false);
                    }
                });
                this.radSimple = new JRadioButton(LOGIN_SIMPLE);
                this.radSimple.addActionListener(new ActionListener(this){
                    private final /* synthetic */ LoginView this$2;
                    {
                        this.this$2 = loginView;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.this$2.setSimpleLoginEnabled(true);
                    }
                });
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add(this.radAnonymous);
                buttonGroup.add(this.radSimple);
                this.radAnonymous.setSelected(true);
                this.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(9, 17, 0, 0);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 18;
                this.add((Component)this.radAnonymous, gridBagConstraints);
                JPanel jPanel2 = new JPanel();
                jPanel2.setAlignmentX(5.0f);
                jPanel2.setLayout(new BoxLayout(jPanel2, 0));
                jPanel2.add(this.radSimple);
                jPanel.setBorder(new CompoundBorder(new ToggleBorder(jPanel2, 1), new EmptyBorder(0, 6, 6, 0)));
                jPanel.setLayout(new GridBagLayout());
                this.lbUser = new JLabel(LOGIN_USER_NAME);
                this.tfUser = new JTextField(25);
                this.lbPassword = new JLabel(LOGIN_PASSWORD);
                this.tfPassword = new JPasswordField(25);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.anchor = 18;
                jPanel.add((Component)jPanel2, gridBagConstraints);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(9, 0, 0, 9);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.fill = 0;
                jPanel.add((Component)this.lbUser, gridBagConstraints);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(9, 0, 0, 9);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 18;
                jPanel.add((Component)this.tfUser, gridBagConstraints);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(9, 0, 9, 9);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 18;
                jPanel.add((Component)this.lbPassword, gridBagConstraints);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(9, 0, 9, 9);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 18;
                jPanel.add((Component)this.tfPassword, gridBagConstraints);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.insets = new Insets(6, 9, 9, 9);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 4;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.gridheight = 0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                this.add((Component)jPanel, gridBagConstraints);
            }

            void setSimpleLoginEnabled(boolean bl) {
                if (bl) {
                    this.lbUser.setEnabled(true);
                    this.tfUser.setEnabled(true);
                    this.tfUser.setBackground(Color.white);
                    this.lbPassword.setEnabled(true);
                    this.tfPassword.setEnabled(true);
                    this.tfPassword.setBackground(Color.white);
                } else {
                    this.lbUser.setEnabled(false);
                    this.tfUser.setEnabled(false);
                    this.tfUser.setBackground(null);
                    this.lbPassword.setEnabled(false);
                    this.tfPassword.setEnabled(false);
                    this.tfPassword.setBackground(null);
                }
            }

            public JPanel getPanel() {
                return this;
            }
        }
    }
}

