/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.common;

import com.iplanet.idar.objectmodel.bean.AttributeValuePair;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.AbstractDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AttributeValueDialog
extends AbstractDialog {
    protected static final String TITLE = IDARResourceSet.getString("dialogAttributeValue", "TITLE");
    protected static final String NOTE = IDARResourceSet.getString("dialogAttributeValue", "NOTE");
    protected static final String ATTRIBUTE = IDARResourceSet.getString("dialogAttributeValue", "ATTRIBUTE");
    protected static final String VALUE = IDARResourceSet.getString("dialogAttributeValue", "VALUE");
    protected ConsoleInfo info;
    protected AttributeValueView view;
    protected static final int BUTTONS = 3;

    public AttributeValueDialog(Frame frame) {
        this(frame, null, null);
    }

    public AttributeValueDialog(Frame frame, ConsoleInfo consoleInfo) {
        this(frame, consoleInfo, null);
    }

    public AttributeValueDialog(Frame frame, ConsoleInfo consoleInfo, AttributeValuePair attributeValuePair) {
        super(frame, TITLE, 3);
        this.info = consoleInfo;
        this.view = new AttributeValueView(attributeValuePair);
        this.view.tfAttribute.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.validate();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.validate();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.validate();
            }

            private void validate() {
                AttributeValueDialog.this.setOKButtonEnabled(!AttributeValueDialog.this.view.tfAttribute.getText().trim().equals(""));
            }
        });
        this.view.tfValue.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.validate();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.validate();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.validate();
            }

            private void validate() {
                AttributeValueDialog.this.setOKButtonEnabled(!AttributeValueDialog.this.view.tfValue.getText().trim().equals(""));
            }
        });
        this.setOKButtonEnabled(false);
        this.setComponent(this.view.getPanel());
        this.pack();
        this.center();
    }

    public AttributeValuePair getAttributeValuePair() {
        return this.view.getAttributeValuePair();
    }

    public void setAttributeValuePair(AttributeValuePair attributeValuePair) {
        this.view.setAttributeValuePair(attributeValuePair);
    }

    public void okInvoked() {
        super.okInvoked();
    }

    public class AttributeValueView
    extends JPanel {
        JTextField tfAttribute;
        JTextField tfValue;
        JButton butBrowse;

        AttributeValueView() {
            this(null);
        }

        AttributeValueView(AttributeValuePair attributeValuePair) {
            this.initComponents();
            this.setAttributeValuePair(attributeValuePair);
        }

        void setAttributeValuePair(AttributeValuePair attributeValuePair) {
            if (attributeValuePair != null) {
                this.tfAttribute.setText(attributeValuePair.getAttributeName());
                this.tfValue.setText(attributeValuePair.getValue());
            }
        }

        AttributeValuePair getAttributeValuePair() {
            return new AttributeValuePair(this.tfAttribute.getText().trim(), this.tfValue.getText().trim());
        }

        void initComponents() {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setText(NOTE);
            jTextArea.setEditable(false);
            jTextArea.setBackground(this.getBackground());
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            this.tfAttribute = new JTextField(25);
            this.tfValue = new JTextField(25);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(9, 9, 0, 9);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 12;
            gridBagConstraints.fill = 2;
            this.add((Component)jTextArea, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(9, 9, 0, 0);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 18;
            this.add((Component)new JLabel(ATTRIBUTE + ":"), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(9, 9, 0, 0);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            this.add((Component)this.tfAttribute, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(9, 9, 0, 0);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 18;
            this.add((Component)new JLabel(VALUE + ":"), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(9, 9, 0, 0);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            this.add((Component)this.tfValue, gridBagConstraints);
        }

        public JPanel getPanel() {
            return this;
        }
    }
}

