/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.task.idar;

import com.iplanet.idar.objectmodel.bean.IDARBean;
import com.iplanet.idar.task.TaskDialogManager;
import com.iplanet.idar.task.idar.IdarTask;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.netscape.management.client.util.DARTask;
import com.netscape.management.client.util.Debug;

public class RestartTask
extends IdarTask {
    public RestartTask(IDARBean iDARBean) {
        this(iDARBean, null, null);
    }

    public RestartTask(IDARBean iDARBean, String string, String string2) {
        super(iDARBean, string, string2);
    }

    public String getName() {
        return IDARResourceSet.getString("taskRestart", "NAME_SHORT");
    }

    public String getDescription() {
        return IDARResourceSet.getString("taskRestart", "DESCRIPTION");
    }

    public boolean isCancelable() {
        return true;
    }

    public int doExecute() {
        Debug.println((String)"RestartTask.doExecute");
        int n = -2;
        this.fireTaskStatusChanged(IDARResourceSet.getString("taskRestart", "PREPARE_RESTART", new String[]{this.idar.getId()}));
        if (!IDARUtilities.isSSLServerOn(this.idar) || IDARUtilities.isSSLServerOn(this.idar) && IDARUtilities.isPINFilePresent(this.idar)) {
            int n2;
            int n3 = this.idar.getStatusCode();
            n = n3 == 2 ? this.startIdar() : ((n2 = this.stopIdar()) == 0 ? this.startIdar() : -1);
        } else {
            Debug.println((int)0, (String)"RestartTask.doExecute: ERROR - SSL IS ENABLE BUT NO PIN FILE IS FOUND");
            TaskDialogManager taskDialogManager = this.getDialogManager();
            taskDialogManager.showMessage(IDARResourceSet.getString("error", "ERR_SSL_NO_PIN_FILE_FOUND_MSG"), IDARResourceSet.getString("error", "ERR_SSL_NO_PIN_FILE_FOUND_TITLE"), 0);
        }
        return n;
    }

    private int stopIdar() {
        Debug.println((String)"RestartTask.stopIdar");
        int n = -2;
        this.fireTaskStatusChanged(IDARResourceSet.getString("taskRestart", "PREPARE_STOP", new String[]{this.idar.getId()}));
        DARTask dARTask = this.getHttpTask("/tasks/operation/stop");
        if (dARTask != null) {
            if (!this.isCanceled()) {
                this.fireTaskStatusChanged(IDARResourceSet.getString("taskRestart", "STOPPING", new String[]{this.idar.getId()}));
                int n2 = dARTask.exec();
                if (n2 != -1) {
                    int n3 = dARTask.getStatus();
                    if (n3 == 2) {
                        n = 0;
                        this.failureMessage = "";
                        Debug.println((String)"RestartTask.stopIdar: SUCCESS");
                    } else {
                        n = -1;
                        this.failureMessage = IDARResourceSet.getString("taskRestart", "UNKNOWN");
                        Debug.println((String)("RestartTask.stopIdar: FAILURE(" + n3 + ")"));
                    }
                } else {
                    n = -1;
                    Debug.println((String)("RestartTask.stopIdar: FAILURE(httpstatus=" + n2 + ") idar=" + this.idar.getId()));
                    this.failureMessage = IDARResourceSet.getString("error", "ADMIN_SERVER_NOT_RESPONDING");
                }
            } else {
                n = -3;
                this.failureMessage = "";
                Debug.println((String)"RestartTask.stopIdar: CANCELED");
            }
        }
        return n;
    }

    private int startIdar() {
        Debug.println((String)"RestartTask.startIdar");
        int n = -2;
        this.fireTaskStatusChanged(IDARResourceSet.getString("taskRestart", "PREPARE_START", new String[]{this.idar.getId()}));
        DARTask dARTask = this.getHttpTask("/tasks/operation/start");
        if (dARTask != null) {
            if (!this.isCanceled()) {
                this.fireTaskStatusChanged(IDARResourceSet.getString("taskRestart", "STARTING", new String[]{this.idar.getId()}));
                int n2 = dARTask.exec();
                if (n2 != -1) {
                    int n3 = dARTask.getStatus();
                    if (n3 == 1) {
                        n = 0;
                        Debug.println((String)"RestartTask.startIdar: SUCCESS");
                    } else {
                        n = -1;
                        this.failureMessage = IDARResourceSet.getString("taskRestart", "UNKNOWN");
                        Debug.println((String)("RestartTask.startIdar: FAILURE(" + n3 + ")"));
                    }
                } else {
                    n = -1;
                    Debug.println((String)("RestartTask.doExecute: FAILURE(httpstatus=" + n2 + ") idar=" + this.idar.getId()));
                    this.failureMessage = IDARResourceSet.getString("error", "ADMIN_SERVER_NOT_RESPONDING");
                }
            } else {
                n = -3;
                Debug.println((String)"RestartTask.startIdar: CANCELED");
            }
        }
        return n;
    }
}

