/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.task.configuration;

import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.ConfigurationBean;
import com.iplanet.idar.objectmodel.bean.IDARBean;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.UniqueNameException;
import com.iplanet.idar.task.AbstractTask;
import com.iplanet.idar.task.TaskDialogManager;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.netscape.management.client.util.Debug;
import java.util.Iterator;

public class RenameConfigurationTask
extends AbstractTask {
    ConfigurationBean config = null;
    String newId = null;
    String executionFailureMessage = null;

    public RenameConfigurationTask() {
        this(null);
    }

    public RenameConfigurationTask(ConfigurationBean configurationBean) {
        this.setObject(configurationBean);
    }

    public String getName() {
        return IDARResourceSet.getString("taskRenameConfiguration", "NAME_SHORT");
    }

    public String getDescription() {
        return IDARResourceSet.getString("taskRenameConfiguration", "DESCRIPTION");
    }

    public String getUnexecutableMessage() {
        String string = "";
        if (this.config == null) {
            string = IDARResourceSet.getString("taskRenameConfiguration", "NO_CONFIG");
        } else if (this.newId == null) {
            string = IDARResourceSet.getString("taskRenameConfiguration", "NO_NEW_ID");
        }
        return string;
    }

    public void setObject(ConfigurationBean configurationBean) {
        Debug.println((String)("RenameConfigurationTask.setObject: model=" + configurationBean));
        this.config = configurationBean;
        this.setExecutable(this.config != null);
    }

    public void setNewId(String string) {
        this.newId = string;
    }

    public int doExecute() {
        Debug.println((String)"RenameConfigurationTask.doExecute");
        int n = -2;
        TaskDialogManager taskDialogManager = this.getDialogManager();
        if (n != -1 && n != -3) {
            String[] stringArray = new String[]{this.config.getId(), this.newId};
            this.fireTaskStatusChanged(IDARResourceSet.getString("taskRenameConfiguration", "RENAMING_OBJECT", stringArray));
            try {
                this.config.setId(this.newId);
                this.config.persist();
                IDARReference[] iDARReferenceArray = BeanSpace.getInstance().getExistingInstanceReferences(IDARReference.NULL_REFERENCE, "idar-server");
                n = 0;
                Iterator iterator = this.config.getBelongsTo().iterator();
                block5: while (iterator.hasNext()) {
                    String string = iterator.next().toString();
                    if (string == null) continue;
                    for (int i = 0; i < iDARReferenceArray.length; ++i) {
                        if (!string.equals(iDARReferenceArray[i].getId())) continue;
                        this.fireTaskStatusChanged(IDARResourceSet.getString("taskRenameConfiguration", "UPDATING_REFS", new String[]{string}));
                        IDARBean iDARBean = (IDARBean)iDARReferenceArray[i].getBean();
                        iDARBean.setSharedConfiguration(this.config);
                        try {
                            Debug.println((String)("RenameConfigurationTask: persisting idar server " + iDARBean.getId() + " to reflect new configuration name " + this.config.getId()));
                            iDARBean.persist();
                        }
                        catch (IDARBeanException iDARBeanException) {
                            taskDialogManager.showMessage(IDARResourceSet.getString("error", "UPDATE_IDAR_CONFIG", string), IDARResourceSet.getString("error", "TITLE"), 0);
                            n = -1;
                        }
                        continue block5;
                    }
                }
            }
            catch (UniqueNameException uniqueNameException) {
                this.setExecutionFailureMessage(IDARResourceSet.getString("error", "ERR_UNIQUE_NAME"));
                n = -1;
            }
            catch (IDARBeanException iDARBeanException) {
                this.setExecutionFailureMessage(IDARResourceSet.getString("error", "RENAME_FAILURE"));
                n = -1;
            }
        }
        return n;
    }

    public String getExecutionFailureMessage() {
        if (this.executionFailureMessage == null) {
            return IDARResourceSet.getString("error", "RENAME_FAILURE");
        }
        return this.executionFailureMessage;
    }

    public void setExecutionFailureMessage(String string) {
        this.executionFailureMessage = string;
    }
}

