/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.task.configuration;

import com.iplanet.idar.common.ContextNotSupportedException;
import com.iplanet.idar.dialog.ObjectNotDeletableDialog;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.task.AbstractTask;
import com.iplanet.idar.task.TaskDialogManager;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.netscape.management.client.util.Debug;

public class DeleteObjectTask
extends AbstractTask {
    protected static final String DELETE_TITLE = IDARResourceSet.getString("delete", "title");
    IDARReference objectRef = null;
    boolean confirm = true;

    public DeleteObjectTask() {
        this(null);
    }

    public DeleteObjectTask(IDARReference iDARReference) {
        this.setObject(iDARReference);
    }

    public String getName() {
        return IDARResourceSet.getString("taskDeleteObject", "NAME_SHORT");
    }

    public String getDescription() {
        return IDARResourceSet.getString("taskDeleteObject", "DESCRIPTION");
    }

    public String getUnexecutableMessage() {
        String string = "";
        if (this.objectRef != null) {
            string = IDARResourceSet.getString("delete", "undeletable");
        }
        return string;
    }

    public boolean isCancelable() {
        return false;
    }

    public void setObject(IDARReference iDARReference) {
        Debug.println((String)("DeleteObjectTask.setObject: ref=" + iDARReference));
        this.objectRef = iDARReference;
        this.setExecutable(this.objectRef != null);
    }

    public void confirmWithUserBeforeDelete(boolean bl) {
        this.confirm = bl;
    }

    public int doExecute() {
        Debug.println((String)"DeleteObjectTask.doExecute");
        int n = -2;
        IDARReference iDARReference = this.objectRef;
        String[] stringArray = new String[]{iDARReference.getId()};
        TaskDialogManager taskDialogManager = this.getDialogManager();
        this.fireTaskStatusChanged(IDARResourceSet.getString("delete", "preparing", stringArray));
        IDARModelBean iDARModelBean = null;
        try {
            iDARModelBean = iDARReference.getBean();
        }
        catch (IDARBeanException iDARBeanException) {
            taskDialogManager.showMessage(iDARBeanException.getMessage(), IDARResourceSet.getString("delete", "title"), 0);
            n = -1;
        }
        if (iDARModelBean != null) {
            if (iDARModelBean.isDeletable()) {
                if (!this.isCanceled()) {
                    boolean bl = true;
                    if (this.confirm) {
                        String string = iDARModelBean.getPredeletionMessage();
                        String[] stringArray2 = new String[]{string == null ? "" : string, iDARModelBean.getId()};
                        int n2 = taskDialogManager.showConfirmation(IDARResourceSet.getString("delete", "confirm", stringArray2), IDARResourceSet.getString("delete", "title"), 0, 2);
                        if (n2 == 1) {
                            bl = false;
                        }
                    }
                    if (!this.isCanceled() && bl) {
                        try {
                            this.fireTaskStatusChanged(IDARResourceSet.getString("delete", "deleting", stringArray));
                            iDARModelBean.delete();
                            this.setObject(null);
                            n = 0;
                        }
                        catch (IDARBeanException iDARBeanException) {
                            taskDialogManager.showMessage(iDARBeanException.getMessage(), IDARResourceSet.getString("delete", "title"), 0);
                        }
                    } else {
                        n = -3;
                        Debug.println((String)"DeleteObjectTask.doExecute: CANCELED");
                    }
                } else {
                    n = -3;
                    Debug.println((String)"DeleteObjectTask.doExecute: CANCELED");
                }
            } else {
                this.fireTaskStatusChanged(IDARResourceSet.getString("delete", "failure", stringArray));
                try {
                    taskDialogManager.showCustomDialog(new ObjectNotDeletableDialog(iDARModelBean));
                }
                catch (ContextNotSupportedException contextNotSupportedException) {
                    contextNotSupportedException.printStackTrace();
                }
                n = -3;
            }
        }
        return n;
    }
}

