/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.task.configuration;

import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.task.AbstractTask;
import com.iplanet.idar.task.TaskDialogManager;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.netscape.management.client.util.Debug;

public class CreateObjectTask
extends AbstractTask {
    protected static final String MSG_DELETE = IDARResourceSet.getString("priorityTableObjectView", "MSG_DELETE");
    protected static final String MSG_DELETE_TITLE = IDARResourceSet.getString("priorityTableObjectView", "MSG_DELETE_TITLE");
    protected static final String MSG_CANT_DELETE_TITLE = IDARResourceSet.getString("priorityTableObjectView", "MSG_CANT_DELETE_TITLE");
    String descriptor = null;
    IDARReference configRef = null;
    IDARReference newObjectReference = null;

    public CreateObjectTask() {
        this(null, null);
    }

    public CreateObjectTask(String string, IDARReference iDARReference) {
        this.setDescriptor(string);
        this.setParentConfiguration(iDARReference);
    }

    public String getName() {
        return IDARResourceSet.getString("taskCreateObject", "NAME_SHORT");
    }

    public String getDescription() {
        return IDARResourceSet.getString("taskCreateObject", "DESCRIPTION");
    }

    public String getUnexecutableMessage() {
        String string = "";
        if (this.descriptor == null) {
            string = IDARResourceSet.getString("taskCreateObject", "MISSING_DESCRIPTOR");
        } else if (this.configRef == null) {
            string = IDARResourceSet.getString("taskCreateObject", "MISSING_CONFIG_REF");
        }
        return string;
    }

    public void setDescriptor(String string) {
        Debug.println((String)("CreateObjectTask.setDescriptor: desc=" + string));
        this.descriptor = string;
        this.setExecutablness();
    }

    public void setParentConfiguration(IDARReference iDARReference) {
        Debug.println((String)("CreateObjectTask.setParentConfiguration: ref=" + iDARReference));
        this.configRef = iDARReference;
        this.setExecutablness();
    }

    public IDARReference getNewObjectReference() {
        return this.newObjectReference;
    }

    public int doExecute() {
        Debug.println((String)"CreateObjectTask.doExecute");
        int n = -2;
        String[] stringArray = new String[]{this.descriptor};
        this.fireTaskStatusChanged(IDARResourceSet.getString("taskCreateObject", "CREATING_NEW", stringArray));
        try {
            IDARModelBean iDARModelBean = BeanSpace.getInstance().createBean(this.configRef, this.descriptor);
            this.newObjectReference = iDARModelBean.getSelfReference();
            n = 0;
        }
        catch (IDARBeanException iDARBeanException) {
            TaskDialogManager taskDialogManager = this.getDialogManager();
            taskDialogManager.showMessage(iDARBeanException.getMessage(), IDARResourceSet.getString("taskCreateObject", "CREATE_ERROR"), 0);
            n = -1;
        }
        return n;
    }

    private void setExecutablness() {
        this.setExecutable(this.descriptor != null && this.configRef != null);
    }
}

