/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.objectmodel.bean;

import com.iplanet.idar.objectmodel.BeanListenable;
import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.BeanData;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;

public class RuleData
implements BeanData,
Cloneable {
    private static final char DELIMITER = '#';
    private BeanListenable action;
    private IDARReference config = null;
    private boolean isValid = false;
    Integer precedence = new Integer(0);

    public RuleData() {
    }

    public RuleData(IDARReference iDARReference, String string) {
        String[] stringArray = RuleData.parseData(string);
        this.setActionId(iDARReference, stringArray[0]);
        try {
            Integer n = new Integer(stringArray[1]);
            this.setPrecedence(n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public RuleData(IDARReference iDARReference, String string, Integer n) {
        this.setActionId(iDARReference, string);
        this.setPrecedence(n);
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String getActionId() {
        String string = null;
        if (this.action != null) {
            string = this.action.getId();
        }
        return string;
    }

    public void setActionId(IDARReference iDARReference, String string) {
        if (iDARReference != null) {
            this.config = iDARReference;
        }
        try {
            this.setAction(BeanSpace.getInstance().getBeanReference(string, "action", iDARReference));
        }
        catch (IDARBeanException iDARBeanException) {
            iDARBeanException.printStackTrace();
        }
    }

    public void setAction(BeanListenable beanListenable) {
        this.isValid = beanListenable != null;
        this.action = beanListenable;
    }

    public BeanListenable getAction() {
        return this.action;
    }

    public Integer getPrecedence() {
        return this.precedence;
    }

    public void setPrecedence(Integer n) {
        this.precedence = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getActionId();
        if (string != null) {
            stringBuffer.append(string);
        }
        if (this.precedence != null) {
            stringBuffer.append('#');
            stringBuffer.append(this.precedence.toString());
        }
        return stringBuffer.toString();
    }

    private static String[] parseData(String string) {
        String[] stringArray = new String[2];
        int n = string.indexOf(35);
        if (n == -1) {
            stringArray[0] = string;
        } else {
            stringArray[0] = string.substring(0, n);
            stringArray[1] = string.substring(n + 1);
        }
        return stringArray;
    }

    public BeanListenable getBeanListenable() {
        return this.getAction();
    }

    public Object getDataElement(int n) {
        Object object = null;
        switch (n) {
            case 0: {
                object = this.getActionId();
            }
            case 1: {
                object = this.getPrecedence();
            }
        }
        return object;
    }

    public Object clone() {
        RuleData ruleData = null;
        try {
            ruleData = (RuleData)super.clone();
            ruleData.setPrecedence(new Integer(this.precedence));
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return ruleData;
    }
}

