/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.objectmodel.bean;

import com.iplanet.idar.objectmodel.BeanEvent;
import com.iplanet.idar.objectmodel.BeanListenable;
import com.iplanet.idar.objectmodel.BeanReferenceMonitor;
import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.ActionToGroupData;
import com.iplanet.idar.objectmodel.bean.ChangeGroupActionBean;
import com.iplanet.idar.objectmodel.bean.GroupBean;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.IPAddressData;
import com.iplanet.idar.objectmodel.bean.IPBitMaskData;
import com.iplanet.idar.objectmodel.bean.IPQuadMaskData;
import com.iplanet.idar.objectmodel.bean.IllegalPropertyException;
import com.iplanet.idar.objectmodel.bean.NoSuchBeanException;
import com.iplanet.idar.objectmodel.bean.PersistenceException;
import com.iplanet.idar.objectmodel.bean.RetrievalException;
import com.iplanet.idar.objectmodel.bean.TaskParameters;
import com.iplanet.idar.objectmodel.bean.TaskResult;
import com.iplanet.idar.objectmodel.bean.UniqueNameException;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.MatchResult;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import java.nio.charset.CharacterCodingException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import netscape.ldap.util.DN;

public class NetworkGroupBean
extends GroupBean {
    private ConsoleInfo info;
    private String serverId;
    private BeanListenable onBindRule;
    private BeanListenable onSSLRule;
    private Vector vPropertyRefs = new Vector();
    private Vector vDomainNames = new Vector();
    private Vector vIPAddresses = new Vector();
    private Vector vBitMasks = new Vector();
    private Vector vQuadMasks = new Vector();
    private boolean allIPBinding = false;
    private boolean noIPBinding = true;
    private boolean tcpNoDelay = true;
    private boolean reverseDNSLookup = true;
    private Integer timeout = null;
    private String sslPolicy = "ssl_unavailable";
    private String refSSLPolicy = "ssl_unavailable";
    private boolean allowMultiLdapV2Bind = false;
    private boolean allowNullSADL = true;
    private DN bindName = new DN("");
    private boolean permitAuthNone = true;
    private boolean permitAuthSimple = true;
    private boolean permitAuthSASL = true;
    private boolean permitOpSearch = true;
    private boolean permitOpCompare = true;
    private boolean permitOpAdd = false;
    private boolean permitOpDelete = false;
    private boolean permitOpModify = false;
    private boolean permitOpModRdn = false;
    private boolean permitOpExtended = false;
    private Vector forbiddenSubtree = new Vector();
    private Integer maxResultSize;
    private boolean filterInequality = true;
    private Integer substringSize;
    private Integer timelimit;
    private DN minimumBase;
    private Integer maxScope = new Integer(2);
    private boolean allowAllCompare = true;
    private boolean forbiddenCompare = false;
    private boolean permittedCompare = false;
    private Vector vForbiddenPermitCompare = new Vector();
    private boolean allowAllReturn = true;
    private boolean forbiddenReturn = false;
    private boolean permittedReturn = false;
    private Vector vForbiddenPermitReturn = new Vector();
    private String searchReference = "discard";
    private String reference = "forward";
    private String refBindPolicy = "bind_any";
    private Integer maxRefcount = new Integer(15);
    private Integer maxSimulOpsPerConn;
    private Integer maxOpsPerConn;
    private Integer maxConn;
    private Integer maxSimulConnFromIp;
    private NetworkGroupBeanReferenceMonitor includeMonitor = new NetworkGroupBeanReferenceMonitor(this);
    private String legalityMessage;
    String questionableMessage;

    public boolean isLegal() {
        String string;
        int n;
        boolean bl = true;
        this.legalityMessage = null;
        Vector vector = this.getLoadBalanceProperties();
        if (vector.size() == 0 && (vector = this.getLdapServerProperties()).size() == 0) {
            this.legalityMessage = IDARResourceSet.getString("groupError", "NO_LDAP_SERVERS");
            bl = false;
        }
        for (n = 0; n < this.vForbiddenPermitCompare.size(); ++n) {
            string = (String)this.vForbiddenPermitCompare.elementAt(n);
            try {
                IDARUtilities.toUSASCII(string.toCharArray());
                continue;
            }
            catch (CharacterCodingException characterCodingException) {
                this.legalityMessage = IDARResourceSet.getString("illegal", "NON_ASCII_CHARACTER_SET", string);
                return false;
            }
        }
        for (n = 0; n < this.vForbiddenPermitReturn.size(); ++n) {
            string = (String)this.vForbiddenPermitReturn.elementAt(n);
            try {
                IDARUtilities.toUSASCII(string.toCharArray());
                continue;
            }
            catch (CharacterCodingException characterCodingException) {
                this.legalityMessage = IDARResourceSet.getString("illegal", "NON_ASCII_CHARACTER_SET", string);
                return false;
            }
        }
        return bl;
    }

    public String getIllegalityExplanationMessage() {
        this.isLegal();
        return this.legalityMessage;
    }

    public boolean isQuestionable() {
        boolean bl = false;
        if (!this.isEnabled()) {
            this.questionableMessage = IDARResourceSet.getString("questionable", "DISABLED");
            bl = true;
        } else {
            this.questionableMessage = null;
        }
        return bl;
    }

    public String getQuestionableExplanationMessage() {
        this.isQuestionable();
        return this.questionableMessage;
    }

    public boolean isDeletable() {
        return true;
    }

    public String getPredeletionMessage() {
        return super.getPredeletionMessage();
    }

    public IDARReference[] getSubscribers() {
        Object[] objectArray;
        Vector<IDARReference> vector = new Vector<IDARReference>();
        try {
            objectArray = BeanSpace.getInstance().retrieveBeanCollection(this.getParentConfiguration(), "change-group");
            Vector vector2 = objectArray.toBeanVector();
            String string = this.getId();
            Enumeration enumeration = vector2.elements();
            block2: while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e instanceof ChangeGroupActionBean) {
                    ChangeGroupActionBean changeGroupActionBean = (ChangeGroupActionBean)e;
                    ActionToGroupData[] actionToGroupDataArray = changeGroupActionBean.getGroupData();
                    if (actionToGroupDataArray == null) continue;
                    for (int i = 0; i < actionToGroupDataArray.length; ++i) {
                        String string2 = actionToGroupDataArray[i].getGroupId();
                        if (string2 == null || !string2.equals(string)) continue;
                        vector.add(changeGroupActionBean.getSelfReference());
                        continue block2;
                    }
                    continue;
                }
                Debug.println((String)"NetworkGroupBean.getSubscribers: WARNING: could not interogate bean");
            }
        }
        catch (IDARBeanException iDARBeanException) {
            Debug.println((String)"NetworkGroupBean.getSubscribers: WARNING: could not get bean collection");
        }
        objectArray = new IDARReference[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    protected static String getIdPrefix() {
        return "network-group";
    }

    public Integer getMaxSimulConnFromIp() {
        return this.maxSimulConnFromIp;
    }

    public void setMaxSimulConnFromIp(Integer n) {
        if (this.maxSimulConnFromIp != null && n != null && !this.maxSimulConnFromIp.equals(n)) {
            this.setDirty(true);
        }
        this.maxSimulConnFromIp = n;
    }

    public Integer getMaxConn() {
        return this.maxConn;
    }

    public void setMaxConn(Integer n) {
        if (this.maxConn != null && n != null && !this.maxConn.equals(n)) {
            this.setDirty(true);
        }
        this.maxConn = n;
    }

    public Integer getMaxOpsPerConn() {
        return this.maxOpsPerConn;
    }

    public void setMaxOpsPerConn(Integer n) {
        if (this.maxOpsPerConn != null && n != null && !this.maxOpsPerConn.equals(n)) {
            this.setDirty(true);
        }
        this.maxOpsPerConn = n;
    }

    public Integer getMaxSimulOpsPerConn() {
        return this.maxSimulOpsPerConn;
    }

    public void setMaxSimulOpsPerConn(Integer n) {
        if (this.maxSimulOpsPerConn != null && n != null && !this.maxSimulOpsPerConn.equals(n)) {
            this.setDirty(true);
        }
        this.maxSimulOpsPerConn = n;
    }

    public Integer getMaxRefcount() {
        return this.maxRefcount;
    }

    public void setMaxRefcount(Integer n) {
        if (this.maxRefcount != null && n != null) {
            if (!this.maxRefcount.equals(n)) {
                this.setDirty(true);
            }
            this.maxRefcount = n;
        }
    }

    public String getRefBindPolicy() {
        return this.refBindPolicy;
    }

    public void setRefBindPolicy(String string) {
        if (this.refBindPolicy != null && string != null) {
            if (!this.refBindPolicy.equals(string)) {
                this.setDirty(true);
            }
            this.refBindPolicy = string;
        }
    }

    public String getRefSSLPolicy() {
        return this.refSSLPolicy;
    }

    public void setRefSSLPolicy(String string) {
        if (this.refSSLPolicy != null && string != null) {
            if (!this.refSSLPolicy.equals(string)) {
                this.setDirty(true);
            }
            this.refSSLPolicy = string;
        }
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String string) {
        if (this.reference != null && string != null) {
            if (!this.reference.equals(string)) {
                this.setDirty(true);
            }
            this.reference = string;
        }
    }

    public String getSearchReference() {
        return this.searchReference;
    }

    public void setSearchReference(String string) {
        if (this.searchReference != null && string != null) {
            if (!this.searchReference.equals(string)) {
                this.setDirty(true);
            }
            this.searchReference = string;
        }
    }

    public boolean getAllowAllReturn() {
        return this.allowAllReturn;
    }

    public void setAllowAllReturn(boolean bl) {
        if (this.allowAllReturn != bl) {
            this.setDirty(true);
            this.allowAllReturn = bl;
        }
    }

    public boolean getForbiddenReturn() {
        return this.forbiddenReturn;
    }

    public void setForbiddenReturn(boolean bl) {
        if (this.forbiddenReturn != bl) {
            this.setDirty(true);
            this.forbiddenReturn = bl;
        }
    }

    public boolean getPermittedReturn() {
        return this.permittedReturn;
    }

    public void setPermittedReturn(boolean bl) {
        if (this.permittedReturn != bl) {
            this.setDirty(true);
            this.permittedReturn = bl;
        }
    }

    public Vector getForbiddenPermitReturn() {
        return this.vForbiddenPermitReturn;
    }

    public void setForbiddenPermitReturn(Vector vector) {
        if (!this.isEqual(this.vForbiddenPermitReturn, vector)) {
            this.setDirty(true);
            this.vForbiddenPermitReturn = vector;
        }
    }

    public Integer getMaxResultSize() {
        return this.maxResultSize;
    }

    public void setMaxResultSize(Integer n) {
        if (this.maxResultSize != null && !this.maxResultSize.equals(n)) {
            this.setDirty(true);
        }
        this.maxResultSize = n;
    }

    public Integer getTimelimit() {
        return this.timelimit;
    }

    public void setTimelimit(Integer n) {
        if (this.timelimit != null && !this.timelimit.equals(n)) {
            this.setDirty(true);
        }
        this.timelimit = n;
    }

    public Integer getMaxScope() {
        return this.maxScope;
    }

    public void setMaxScope(Integer n) {
        if (this.maxScope == null) {
            this.maxScope = n;
        }
        if (!this.maxScope.equals(n)) {
            this.setDirty(true);
            this.maxScope = n;
        }
    }

    public DN getMinimumBase() {
        return this.minimumBase;
    }

    public void setMinimumBase(DN dN) {
        if (this.minimumBase != null && dN != null && !this.minimumBase.equals(dN)) {
            this.setDirty(true);
        }
        this.minimumBase = dN;
    }

    public boolean getAllowAllCompare() {
        return this.allowAllCompare;
    }

    public void setAllowAllCompare(boolean bl) {
        if (this.allowAllCompare != bl) {
            this.setDirty(true);
            this.allowAllCompare = bl;
        }
    }

    public boolean getForbiddenCompare() {
        return this.forbiddenCompare;
    }

    public void setForbiddenCompare(boolean bl) {
        if (this.forbiddenCompare != bl) {
            this.setDirty(true);
            this.forbiddenCompare = bl;
        }
    }

    public boolean getPermittedCompare() {
        return this.permittedCompare;
    }

    public void setPermittedCompare(boolean bl) {
        if (this.permittedCompare != bl) {
            this.setDirty(true);
            this.permittedCompare = bl;
        }
    }

    public Vector getForbiddenPermitCompare() {
        return this.vForbiddenPermitCompare;
    }

    public void setForbiddenPermitCompare(Vector vector) {
        if (!this.vForbiddenPermitCompare.equals(vector)) {
            this.setDirty(true);
            this.vForbiddenPermitCompare = vector;
        }
    }

    public Integer getSubstringSize() {
        return this.substringSize;
    }

    public void setSubstringSize(Integer n) {
        if (this.substringSize != null && n != null && !this.substringSize.equals(n)) {
            this.setDirty(true);
        }
        this.substringSize = n;
    }

    public boolean getFilterInequality() {
        return this.filterInequality;
    }

    public void setFilterInequality(boolean bl) {
        if (this.filterInequality != bl) {
            this.setDirty(true);
            this.filterInequality = bl;
        }
    }

    public void addForbiddenSubtree(DN dN) {
        this.forbiddenSubtree.add(dN);
        this.setDirty(true);
    }

    public void setForbiddenSubtree(Vector vector) {
        if (!this.isEqual(this.forbiddenSubtree, vector)) {
            this.setDirty(true);
            this.forbiddenSubtree = vector;
        }
    }

    public Vector getForbiddenSubtree() {
        return this.forbiddenSubtree;
    }

    public boolean getPermitOpExtended() {
        return this.permitOpExtended;
    }

    public void setPermitOpExtended(boolean bl) {
        if (this.permitOpExtended != bl) {
            this.setDirty(true);
            this.permitOpExtended = bl;
        }
    }

    public boolean getPermitOpModRdn() {
        return this.permitOpModRdn;
    }

    public void setPermitOpModRdn(boolean bl) {
        if (this.permitOpModRdn != bl) {
            this.setDirty(true);
            this.permitOpModRdn = bl;
        }
    }

    public boolean getPermitOpModify() {
        return this.permitOpModify;
    }

    public void setPermitOpModify(boolean bl) {
        if (this.permitOpModify != bl) {
            this.setDirty(true);
            this.permitOpModify = bl;
        }
    }

    public boolean getPermitOpDelete() {
        return this.permitOpDelete;
    }

    public void setPermitOpDelete(boolean bl) {
        if (this.permitOpDelete != bl) {
            this.setDirty(true);
            this.permitOpDelete = bl;
        }
    }

    public boolean getPermitOpAdd() {
        return this.permitOpAdd;
    }

    public void setPermitOpAdd(boolean bl) {
        if (this.permitOpAdd != bl) {
            this.setDirty(true);
            this.permitOpAdd = bl;
        }
    }

    public boolean getPermitOpCompare() {
        return this.permitOpCompare;
    }

    public void setPermitOpCompare(boolean bl) {
        if (this.permitOpCompare != bl) {
            this.setDirty(true);
            this.permitOpCompare = bl;
        }
    }

    public boolean getPermitOpSearch() {
        return this.permitOpSearch;
    }

    public void setPermitOpSearch(boolean bl) {
        if (this.permitOpSearch != bl) {
            this.setDirty(true);
            this.permitOpSearch = bl;
        }
    }

    public DN getBindName() {
        return this.bindName;
    }

    public void setBindName(DN dN) {
        if (dN != null) {
            if (!this.bindName.equals(dN)) {
                this.setDirty(true);
            }
            this.bindName = dN;
        }
    }

    public boolean getPermitAuthSASL() {
        return this.permitAuthSASL;
    }

    public void setPermitAuthSASL(boolean bl) {
        if (this.permitAuthSASL != bl) {
            this.setDirty(true);
            this.permitAuthSASL = bl;
        }
    }

    public boolean getPermitAuthSimple() {
        return this.permitAuthSimple;
    }

    public void setPermitAuthSimple(boolean bl) {
        if (this.permitAuthSimple != bl) {
            this.setDirty(true);
            this.permitAuthSimple = bl;
        }
    }

    public boolean getPermitAuthNone() {
        return this.permitAuthNone;
    }

    public void setPermitAuthNone(boolean bl) {
        if (this.permitAuthNone != bl) {
            this.setDirty(true);
            this.permitAuthNone = bl;
        }
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer n) {
        if (n != null && !n.equals(this.timeout) || n == null && this.timeout != null) {
            this.setDirty(true);
        }
        this.timeout = n;
    }

    public void setReverseDNSLookup(boolean bl) {
        if (this.reverseDNSLookup != bl) {
            this.setDirty(true);
            this.reverseDNSLookup = bl;
        }
    }

    public boolean getReverseDNSLookup() {
        return this.reverseDNSLookup;
    }

    public void setAllowMultiLdapV2Bind(boolean bl) {
        if (this.allowMultiLdapV2Bind != bl) {
            this.setDirty(true);
            this.allowMultiLdapV2Bind = bl;
        }
    }

    public boolean getAllowMultiLdapV2Bind() {
        return this.allowMultiLdapV2Bind;
    }

    public void setAllowNullSADL(boolean bl) {
        if (this.allowNullSADL != bl) {
            this.setDirty(true);
            this.allowNullSADL = bl;
        }
    }

    public boolean getAllowNullSADL() {
        return this.allowNullSADL;
    }

    public void setTCPNoDelay(boolean bl) {
        if (this.tcpNoDelay != bl) {
            this.setDirty(true);
            this.tcpNoDelay = bl;
        }
    }

    public boolean getTCPNoDelay() {
        return this.tcpNoDelay;
    }

    public String getSSLPolicy() {
        return this.sslPolicy;
    }

    public void setSSLPolicy(String string) {
        if (this.sslPolicy != null && string != null) {
            if (!this.sslPolicy.equals(string)) {
                this.setDirty(true);
            }
            this.sslPolicy = string;
        }
    }

    public void addRuleId(String string) {
        Debug.println((int)6, (String)("NetworkGroupBean.addRule: id=" + string));
        if (string != null) {
            BeanSpace beanSpace = BeanSpace.getInstance();
            IDARReference iDARReference = null;
            try {
                iDARReference = beanSpace.getBeanReference(string, "rule", this.getParentConfiguration());
            }
            catch (IDARBeanException iDARBeanException) {
                iDARBeanException.printStackTrace();
            }
            if (iDARReference != null) {
                String string2 = iDARReference.getDescriptor();
                if (string2.equals("on-bind")) {
                    if (this.onBindRule == null || !this.onBindRule.getId().equals(string)) {
                        this.setDirty(true);
                    }
                    Debug.println((int)6, (String)("NetworkGroupBean.addRule: set on bind rule " + string));
                    if (this.onBindRule != null) {
                        this.includeMonitor.removeMonitor(this.onBindRule);
                    }
                    this.onBindRule = iDARReference;
                } else if (string2.equals("on-ssl")) {
                    if (this.onSSLRule == null || !this.onSSLRule.getId().equals(string)) {
                        this.setDirty(true);
                    }
                    Debug.println((int)6, (String)("NetworkGroupBean.addRule: set on ssl rule " + string));
                    if (this.onSSLRule != null) {
                        this.includeMonitor.removeMonitor(this.onSSLRule);
                    }
                    this.onSSLRule = iDARReference;
                }
                this.includeMonitor.addMonitor(iDARReference);
            } else {
                Debug.println((String)("NetworkGroupBean.addRule:  ERROR:  can't determine type of rule " + string));
            }
        }
    }

    public Vector getRules() {
        Vector<String> vector = new Vector<String>();
        vector.add(this.getOnBindRuleId());
        vector.add(this.getOnSSLRuleId());
        return vector;
    }

    public void removeAllRules() {
        this.removeRules("on-bind");
        this.removeRules("on-ssl");
    }

    public void removeRules(String string) {
        if ("on-bind".equals(string)) {
            this.removeRule(this.onBindRule);
        } else if ("on-ssl".equals(string)) {
            this.removeRule(this.onSSLRule);
        }
    }

    public void removeRule(BeanListenable beanListenable) {
        IDARReference iDARReference;
        if (beanListenable != null && (iDARReference = beanListenable.getSelfReference()) != null) {
            this.includeMonitor.removeMonitor(iDARReference);
            if (iDARReference.equals(this.onBindRule)) {
                this.onBindRule = null;
            } else if (iDARReference.equals(this.onSSLRule)) {
                this.onSSLRule = null;
            }
            this.setDirty(true);
        }
    }

    public String getOnBindRuleId() {
        String string = null;
        if (this.onBindRule != null) {
            string = this.onBindRule.getId();
        }
        return string;
    }

    public void setOnBindRuleId(String string) {
        if (string != null && !string.equals(this.onBindRule) || string == null && this.onBindRule != null) {
            this.setDirty(true);
        }
        this.removeRules("on-bind");
        this.addRuleId(string);
    }

    public Vector getOnBindRuleIds() {
        Vector<String> vector = new Vector<String>();
        String string = this.getOnBindRuleId();
        if (string != null) {
            vector.add(string);
        }
        return vector;
    }

    public String getOnSSLRuleId() {
        String string = null;
        if (this.onSSLRule != null) {
            string = this.onSSLRule.getId();
        }
        return string;
    }

    public void setOnSSLRuleId(String string) {
        if (string != null && !string.equals(this.onSSLRule) || string == null && this.onSSLRule != null) {
            this.setDirty(true);
        }
        this.removeRules("on-ssl");
        this.addRuleId(string);
    }

    public Vector getOnSSLRuleIds() {
        Vector<String> vector = new Vector<String>();
        String string = this.getOnSSLRuleId();
        if (string != null) {
            vector.add(string);
        }
        return vector;
    }

    public void addPropertyId(String string) {
        Debug.println((int)6, (String)("NetworkGroupBean.addPropertyId: id=" + string));
        if (string != null) {
            BeanSpace beanSpace = BeanSpace.getInstance();
            IDARReference iDARReference = null;
            try {
                iDARReference = beanSpace.getBeanReference(string, "property", this.getParentConfiguration());
                if (iDARReference != null) {
                    String string2 = iDARReference.getDescriptor();
                    if (string2.equals("search-size-limit")) {
                        this.addSearchSizeLimitProperty(iDARReference);
                    } else if (string2.equals("attribute-renaming")) {
                        this.addAttributeRenamingProperty(iDARReference);
                    } else if (string2.equals("forbidden-entry")) {
                        this.addForbiddenEntryProperty(iDARReference);
                    } else if (string2.equals("ldap-server")) {
                        this.addLdapServerProperty(iDARReference);
                    } else if (string2.equals("load-balancing")) {
                        this.addLoadBalanceProperty(iDARReference);
                    } else {
                        Debug.println((String)("NetworkGroupBean.addPropertyId: ERROR - can't determine type of property " + string));
                    }
                    this.includeMonitor.addMonitor(iDARReference);
                } else {
                    Debug.println((String)("NetworkGroupBean.addPropertyId: ERROR - can't determine retrieve bean for " + string));
                }
            }
            catch (IDARBeanException iDARBeanException) {
                iDARBeanException.printStackTrace();
            }
        }
    }

    public void removeAllProperties() {
        this.includeMonitor.removeAllMonitors();
        this.vPropertyRefs.clear();
    }

    public void removeProperty(BeanListenable beanListenable) {
        IDARReference iDARReference;
        if (beanListenable != null && (iDARReference = beanListenable.getSelfReference()) != null) {
            this.includeMonitor.removeMonitor(iDARReference);
            this.vPropertyRefs.remove(iDARReference.getSelfReference());
            this.setDirty(true);
        }
    }

    public void removeProperties(String string) {
        Vector vector;
        if (string != null && (vector = this.getPropertiesByDescriptor(string)).size() != 0) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                BeanListenable beanListenable = (BeanListenable)enumeration.nextElement();
                if (beanListenable == null) continue;
                this.removeProperty(beanListenable.getSelfReference());
            }
        }
    }

    public void addProperty(BeanListenable beanListenable) {
        IDARReference iDARReference;
        if (beanListenable != null && (iDARReference = beanListenable.getSelfReference()) != null) {
            this.includeMonitor.addMonitor(iDARReference);
            this.vPropertyRefs.add(iDARReference);
            this.setDirty(true);
        }
    }

    public void addSearchSizeLimitProperty(BeanListenable beanListenable) {
        this.addProperty(beanListenable);
    }

    public void addAttributeRenamingProperty(BeanListenable beanListenable) {
        this.addProperty(beanListenable);
    }

    public void addForbiddenEntryProperty(BeanListenable beanListenable) {
        this.removeProperties("forbidden-entry");
        this.addProperty(beanListenable);
    }

    public void addLdapServerProperty(BeanListenable beanListenable) {
        this.removeProperties("ldap-server");
        this.addProperty(beanListenable);
    }

    public void addLoadBalanceProperty(BeanListenable beanListenable) {
        this.removeProperties("load-balancing");
        this.addProperty(beanListenable);
    }

    public void setSearchSizeLimitProperties(Vector vector) {
        this.removeProperties("search-size-limit");
        this.addProperties(vector);
    }

    public void setAttributeRenamingProperties(Vector vector) {
        this.removeProperties("attribute-renaming");
        this.addProperties(vector);
    }

    public void setForbiddenEntryProperties(Vector vector) {
        this.removeProperties("forbidden-entry");
        this.addProperties(vector);
    }

    public void setLdapServerProperties(Vector vector) {
        this.removeProperties("ldap-server");
        this.addProperties(vector);
    }

    public void setLoadBalanceProperties(Vector vector) {
        this.removeProperties("load-balancing");
        this.addProperties(vector);
    }

    public void addPropertyIds(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e == null) continue;
            this.addPropertyId(e.toString());
        }
    }

    public void addProperties(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e == null || !(e instanceof BeanListenable)) continue;
            this.addProperty((BeanListenable)e);
        }
    }

    public void addSearchSizePropertyId(String string) {
        this.addPropertyId(string);
    }

    public void setSearchSizePropertyIds(Vector vector) {
        this.removeProperties("search-size-limit");
        this.addPropertyIds(vector);
    }

    public void setForbiddenEntryPropertyId(String string) {
        this.addForbiddenEntryPropertyId(string);
    }

    public void addForbiddenEntryPropertyId(String string) {
        this.removeProperties("forbidden-entry");
        this.addPropertyId(string);
    }

    public void setForbiddenEntryPropertyIds(Vector vector) {
        this.removeProperties("forbidden-entry");
        this.addPropertyIds(vector);
    }

    public void addAttributeRenamingPropertyId(String string) {
        this.addPropertyId(string);
    }

    public void setAttributeRenamingPropertyIds(Vector vector) {
        this.removeProperties("attribute-renaming");
        this.addPropertyIds(vector);
    }

    public void addLdapServerPropertyId(String string) {
        this.addPropertyId(string);
    }

    public void setLdapServerPropertyIds(Vector vector) {
        this.removeProperties("ldap-server");
        this.addPropertyIds(vector);
    }

    public void removeAllLdapServerProperties() {
        this.removeProperties("ldap-server");
    }

    public void addLoadBalancePropertyId(String string) {
        this.addPropertyId(string);
    }

    public void setLoadBalancePropertyIds(Vector vector) {
        this.removeProperties("load-balancing");
        this.addPropertyIds(vector);
    }

    public void removeAllLoadBalanceProperties() {
        this.removeProperties("load-balancing");
    }

    public void removeAllSearchSizeProperties() {
        this.removeProperties("search-size-limit");
    }

    public void removeAllRenamingAttributes() {
        this.removeProperties("attribute-renaming");
    }

    public Vector getLoadBalancePropertyIds() {
        return this.getPropertyIdsByDescriptor("load-balancing");
    }

    public Vector getSearchSizeLimitPropertyIds() {
        return this.getPropertyIdsByDescriptor("search-size-limit");
    }

    public Vector getAttributeRenamingPropertyIds() {
        return this.getPropertyIdsByDescriptor("attribute-renaming");
    }

    public Vector getForbiddenEntryPropertyIds() {
        return this.getPropertyIdsByDescriptor("forbidden-entry");
    }

    public Vector getLdapServerPropertyIds() {
        return this.getPropertyIdsByDescriptor("ldap-server");
    }

    public Vector getLoadBalanceProperties() {
        return this.getPropertiesByDescriptor("load-balancing");
    }

    public Vector getSearchSizeLimitProperties() {
        return this.getPropertiesByDescriptor("search-size-limit");
    }

    public Vector getAttributeRenamingProperties() {
        return this.getPropertiesByDescriptor("attribute-renaming");
    }

    public Vector getForbiddenEntryProperties() {
        return this.getPropertiesByDescriptor("forbidden-entry");
    }

    public Vector getLdapServerProperties() {
        return this.getPropertiesByDescriptor("ldap-server");
    }

    public String getLdapServerPropertyId() {
        String string = null;
        Vector vector = this.getLdapServerPropertyIds();
        if (vector != null) {
            try {
                Object e = vector.firstElement();
                string = e.toString();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return string;
    }

    public Vector getDomainNames() {
        return this.vDomainNames;
    }

    public void addDomainName(String string) {
        this.setDirty(true);
        this.vDomainNames.addElement(string);
    }

    public Vector getIPAddresses() {
        return this.vIPAddresses;
    }

    public void setIPAddresses(Vector vector) {
        if (!this.isEqual(this.vIPAddresses, vector)) {
            this.setDirty(true);
            this.vIPAddresses = vector;
        }
    }

    public void setDomainNames(Vector vector) {
        if (!this.isEqual(this.vDomainNames, vector)) {
            this.setDirty(true);
            this.vDomainNames = vector;
        }
    }

    public Vector getBitMasks() {
        return this.vBitMasks;
    }

    public void addBitMasks(IPBitMaskData iPBitMaskData) {
        this.setDirty(true);
        this.vBitMasks.addElement(iPBitMaskData);
    }

    public void setBitMasks(Vector vector) {
        if (!this.isEqual(this.vBitMasks, vector)) {
            this.setDirty(true);
            this.vBitMasks = vector;
        }
    }

    public Vector getQuadMasks() {
        return this.vQuadMasks;
    }

    public void addQuadMasks(IPQuadMaskData iPQuadMaskData) {
        this.setDirty(true);
        this.vQuadMasks.addElement(iPQuadMaskData);
    }

    public void setQuadMasks(Vector vector) {
        if (!this.isEqual(this.vQuadMasks, vector)) {
            this.setDirty(true);
            this.vQuadMasks = vector;
        }
    }

    public void clearCriteria() {
        this.vDomainNames.clear();
        this.vIPAddresses.clear();
        this.vBitMasks.clear();
        this.vQuadMasks.clear();
    }

    public boolean getAllIPBinding() {
        return this.allIPBinding;
    }

    public void setAllIPBinding(boolean bl) {
        this.allIPBinding = bl;
    }

    public boolean getNoIPBinding() {
        return this.noIPBinding;
    }

    public void setNoIPBinding(boolean bl) {
        this.noIPBinding = bl;
    }

    public void setNetworkCriteria(String[] stringArray) {
        String string = "^[Aa][Ll]{2}$";
        String string2 = "^0[.]0[.]0[.]0$";
        String string3 = "^\\D+$";
        String string4 = "^(\\d{1,3}[.]\\d{1,3}[.]\\d{1,3}[.]\\d{1,3})$";
        String string5 = "^(\\d{1,3}[.]\\d{1,3}[.]\\d{1,3}[.]\\d{1,3})/(\\d*)$";
        String string6 = "(\\d{1,3}[.]\\d{1,3}[.]\\d{1,3}[.]\\d{1,3})/(\\d{1,3}[.]\\d{1,3}[.]\\d{1,3}[.]\\d{1,3})";
        Pattern pattern = null;
        Pattern pattern2 = null;
        Pattern pattern3 = null;
        Pattern pattern4 = null;
        Pattern pattern5 = null;
        Pattern pattern6 = null;
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        Perl5Matcher perl5Matcher = new Perl5Matcher();
        try {
            pattern = perl5Compiler.compile(string);
            pattern2 = perl5Compiler.compile(string2);
            pattern3 = perl5Compiler.compile(string4);
            pattern4 = perl5Compiler.compile(string3);
            pattern5 = perl5Compiler.compile(string5);
            pattern6 = perl5Compiler.compile(string6);
        }
        catch (MalformedPatternException malformedPatternException) {
            System.err.println("Bad pattern.");
            System.err.println(malformedPatternException.getMessage());
            System.exit(1);
        }
        if (stringArray != null) {
            if (perl5Matcher.matches(stringArray[0], pattern)) {
                this.allIPBinding = true;
                this.noIPBinding = false;
            } else if (perl5Matcher.matches(stringArray[0], pattern2)) {
                this.noIPBinding = true;
                this.allIPBinding = false;
            } else {
                this.noIPBinding = false;
                this.allIPBinding = false;
                this.clearCriteria();
                for (int i = 0; i < stringArray.length; ++i) {
                    MatchResult matchResult;
                    if (perl5Matcher.matches(stringArray[i], pattern4)) {
                        this.vDomainNames.addElement(stringArray[i]);
                        continue;
                    }
                    if (perl5Matcher.matches(stringArray[i], pattern3)) {
                        matchResult = perl5Matcher.getMatch();
                        if (matchResult.groups() <= 1) continue;
                        this.vIPAddresses.addElement(new IPAddressData(matchResult.group(1)));
                        continue;
                    }
                    if (perl5Matcher.matches(stringArray[i], pattern5)) {
                        matchResult = perl5Matcher.getMatch();
                        if (matchResult.groups() <= 1) continue;
                        this.vBitMasks.addElement(new IPBitMaskData(matchResult.group(1), matchResult.group(2)));
                        continue;
                    }
                    if (!perl5Matcher.matches(stringArray[i], pattern6) || (matchResult = perl5Matcher.getMatch()).groups() <= 1) continue;
                    this.vQuadMasks.addElement(new IPQuadMaskData(matchResult.group(1), matchResult.group(2)));
                }
            }
        }
    }

    public boolean isEqual(Vector vector, Vector vector2) {
        if (vector == null || vector2 == null) {
            return false;
        }
        return vector.size() != vector2.size() ? false : vector.containsAll(vector2);
    }

    public String getDescriptor() {
        return NetworkGroupBean.getIdPrefix();
    }

    public void persist() throws IllegalPropertyException, NoSuchBeanException, PersistenceException, UniqueNameException {
        Object object;
        TaskParameters taskParameters = new TaskParameters();
        taskParameters.addParameter("ids-proxy-con-include-rule", this.getOnBindRuleId());
        taskParameters.addParameter("ids-proxy-con-include-rule", this.getOnSSLRuleId());
        if (this.timeout != null) {
            taskParameters.addParameter("ids-proxy-con-timeout", this.timeout.toString());
        }
        if (!this.reverseDNSLookup) {
            taskParameters.addParameter("ids-proxy-con-reverse-dns-lookup", this.boolToString(this.reverseDNSLookup));
        }
        if (!this.tcpNoDelay) {
            taskParameters.addParameter("ids-proxy-con-tcp-no-delay", this.boolToString(this.tcpNoDelay));
        }
        this.persistNetworkCriteria(taskParameters);
        if (this.sslPolicy != "ssl_unavailable") {
            taskParameters.addParameter("ids-proxy-con-ssl-policy", this.sslPolicy);
        }
        if (this.refSSLPolicy != "ssl_unavailable") {
            taskParameters.addParameter("ids-proxy-con-referral-ssl-policy", this.refSSLPolicy);
        }
        if (this.allowMultiLdapV2Bind) {
            taskParameters.addParameter("ids-proxy-con-allow-multi-ldapv2-bind", this.boolToString(this.allowMultiLdapV2Bind));
        }
        if (!this.allowNullSADL) {
            taskParameters.addParameter("ids-proxy-con-allow-null-in-sadl", this.boolToString(this.allowNullSADL));
        }
        taskParameters.addParameter("ids-proxy-con-bind-name", this.bindName.toString());
        if (!this.permitAuthNone) {
            taskParameters.addParameter("ids-proxy-con-permit-auth-none", this.boolToString(this.permitAuthNone));
        }
        if (!this.permitAuthSimple) {
            taskParameters.addParameter("ids-proxy-con-permit-auth-simple", this.boolToString(this.permitAuthSimple));
        }
        if (!this.permitAuthSASL) {
            taskParameters.addParameter("ids-proxy-con-permit-auth-sasl", this.boolToString(this.permitAuthSASL));
        }
        if (!this.permitOpSearch) {
            taskParameters.addParameter("ids-proxy-con-permit-op-search", this.boolToString(this.permitOpSearch));
        }
        if (!this.permitOpCompare) {
            taskParameters.addParameter("ids-proxy-con-permit-op-compare", this.boolToString(this.permitOpCompare));
        }
        if (this.permitOpAdd) {
            taskParameters.addParameter("ids-proxy-con-permit-op-add", this.boolToString(this.permitOpAdd));
        }
        if (this.permitOpDelete) {
            taskParameters.addParameter("ids-proxy-con-permit-op-delete", this.boolToString(this.permitOpDelete));
        }
        if (this.permitOpModify) {
            taskParameters.addParameter("ids-proxy-con-permit-op-modify", this.boolToString(this.permitOpModify));
        }
        if (this.permitOpModRdn) {
            taskParameters.addParameter("ids-proxy-con-permit-op-modrdn", this.boolToString(this.permitOpModRdn));
        }
        if (this.permitOpExtended) {
            taskParameters.addParameter("ids-proxy-con-permit-op-extended", this.boolToString(this.permitOpExtended));
        }
        Object object2 = this.vPropertyRefs.elements();
        while (object2.hasMoreElements()) {
            object = (BeanListenable)object2.nextElement();
            if (object == null || object.getDescriptor().equals("ldap-server")) continue;
            taskParameters.addParameter("ids-proxy-con-include-property", object.getId());
        }
        object2 = this.getLdapServerPropertyId();
        if (object2 != null) {
            taskParameters.addParameter("ids-proxy-con-server", (String)object2);
        }
        if (this.maxResultSize != null) {
            taskParameters.addParameter("ids-proxy-con-max-result-size", this.maxResultSize.toString());
        }
        if (!this.filterInequality) {
            taskParameters.addParameter("ids-proxy-con-filter-inequality", this.boolToString(this.filterInequality));
        }
        if (this.substringSize != null) {
            taskParameters.addParameter("ids-proxy-con-min-substring-size", this.substringSize.toString());
        }
        if (this.minimumBase != null) {
            taskParameters.addParameter("ids-proxy-con-minimum-base", this.minimumBase.toString());
        }
        if (this.timelimit != null) {
            taskParameters.addParameter("ids-proxy-con-max-timelimit", this.timelimit.toString());
        }
        if (!this.maxScope.equals(new Integer(2))) {
            taskParameters.addParameter("ids-proxy-con-max-scope", this.maxScope.toString());
        }
        if (!this.allowAllCompare) {
            if (this.forbiddenCompare) {
                object = this.vForbiddenPermitCompare.elements();
                while (object.hasMoreElements()) {
                    taskParameters.addParameter("ids-proxy-con-forbidden-compare", object.nextElement().toString());
                }
            } else if (this.permittedCompare) {
                object = this.vForbiddenPermitCompare.elements();
                while (object.hasMoreElements()) {
                    taskParameters.addParameter("ids-proxy-con-permitted-compare", object.nextElement().toString());
                }
            }
        }
        if (!this.allowAllReturn) {
            if (this.forbiddenReturn) {
                object = this.vForbiddenPermitReturn.elements();
                while (object.hasMoreElements()) {
                    taskParameters.addParameter("ids-proxy-con-forbidden-return", object.nextElement().toString());
                }
            } else if (this.permittedReturn) {
                object = this.vForbiddenPermitReturn.elements();
                while (object.hasMoreElements()) {
                    taskParameters.addParameter("ids-proxy-con-permitted-return", object.nextElement().toString());
                }
            }
        }
        if (!this.reference.equals("forward")) {
            taskParameters.addParameter("ids-proxy-con-reference", this.reference);
        }
        if (!this.refBindPolicy.equals("bind_any")) {
            taskParameters.addParameter("ids-proxy-con-referral-bind-policy", this.refBindPolicy);
        }
        if (this.maxRefcount != 15) {
            taskParameters.addParameter("ids-proxy-con-max-refcount", this.maxRefcount.toString());
        }
        object = this.forbiddenSubtree.elements();
        while (object.hasMoreElements()) {
            taskParameters.addParameter("ids-proxy-con-forbidden-subtree", object.nextElement().toString());
        }
        if (!this.searchReference.equals("discard")) {
            taskParameters.addParameter("ids-proxy-con-search-reference", this.searchReference);
        }
        if (this.maxSimulOpsPerConn != null) {
            taskParameters.addParameter("ids-proxy-con-max-simultaneous-operations-per-connection", this.maxSimulOpsPerConn.toString());
        }
        if (this.maxOpsPerConn != null) {
            taskParameters.addParameter("ids-proxy-con-max-operations-per-connection", this.maxOpsPerConn.toString());
        }
        if (this.maxConn != null) {
            taskParameters.addParameter("ids-proxy-con-max-conns", this.maxConn.toString());
        }
        if (this.maxSimulConnFromIp != null && this.maxSimulConnFromIp != 0) {
            taskParameters.addParameter("ids-proxy-con-max-simultaneous-conns-from-ip", this.maxSimulConnFromIp.toString());
        }
        super.doPersist(taskParameters);
    }

    public void persistNetworkCriteria(TaskParameters taskParameters) {
        if (this.noIPBinding) {
            taskParameters.addParameter("ids-proxy-con-client", "0.0.0.0");
        } else if (this.allIPBinding) {
            taskParameters.addParameter("ids-proxy-con-client", "ALL");
        } else {
            Enumeration enumeration = this.vDomainNames.elements();
            while (enumeration.hasMoreElements()) {
                taskParameters.addParameter("ids-proxy-con-client", enumeration.nextElement().toString());
            }
            enumeration = this.vIPAddresses.elements();
            while (enumeration.hasMoreElements()) {
                taskParameters.addParameter("ids-proxy-con-client", ((IPAddressData)enumeration.nextElement()).toString());
            }
            enumeration = this.vBitMasks.elements();
            while (enumeration.hasMoreElements()) {
                taskParameters.addParameter("ids-proxy-con-client", ((IPBitMaskData)enumeration.nextElement()).toString());
            }
            enumeration = this.vQuadMasks.elements();
            while (enumeration.hasMoreElements()) {
                taskParameters.addParameter("ids-proxy-con-client", ((IPQuadMaskData)enumeration.nextElement()).toString());
            }
        }
    }

    public void synchronize() throws RetrievalException, NoSuchBeanException {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String[] stringArray;
        String[] stringArray2;
        String string9;
        String string10;
        String string11;
        String string12;
        String string13;
        String string14;
        String string15;
        String string16;
        String string17;
        String string18;
        String string19;
        String string20;
        String string21;
        String string22;
        String string23;
        String string24;
        String string25;
        String string26;
        String string27;
        String string28;
        String string29;
        String string30;
        String[] stringArray3;
        String string31;
        String string32;
        TaskResult taskResult = super.doSynchronize();
        this.removeAllRules();
        String[] stringArray4 = taskResult.getAttributeValues("ids-proxy-con-include-rule");
        if (stringArray4 != null) {
            for (int i = 0; i < stringArray4.length; ++i) {
                this.addRuleId(stringArray4[i]);
            }
        }
        if ((string32 = taskResult.getAttributeValue("ids-proxy-con-timeout")) != null) {
            this.setTimeout(new Integer(string32));
        } else {
            this.setTimeout(null);
        }
        String string33 = taskResult.getAttributeValue("ids-proxy-con-reverse-dns-lookup");
        if (string33 != null) {
            this.setReverseDNSLookup(this.stringTobool(string33));
        }
        if ((string31 = taskResult.getAttributeValue("ids-proxy-con-tcp-no-delay")) != null) {
            this.setTCPNoDelay(this.stringTobool(string31));
        }
        if ((stringArray3 = taskResult.getAttributeValues("ids-proxy-con-client")) != null) {
            this.setNetworkCriteria(stringArray3);
        }
        if ((string30 = taskResult.getAttributeValue("ids-proxy-con-ssl-policy")) != null) {
            this.setSSLPolicy(string30);
        }
        if ((string29 = taskResult.getAttributeValue("ids-proxy-con-referral-ssl-policy")) != null) {
            this.setRefSSLPolicy(string29);
        }
        if ((string28 = taskResult.getAttributeValue("ids-proxy-con-allow-multi-ldapv2-bind")) != null) {
            this.setAllowMultiLdapV2Bind(this.stringTobool(string28));
        }
        if ((string27 = taskResult.getAttributeValue("ids-proxy-con-allow-null-in-sadl")) != null) {
            this.setAllowNullSADL(this.stringTobool(string27));
        }
        if ((string26 = taskResult.getAttributeValue("ids-proxy-con-bind-name")) != null) {
            this.setBindName(new DN(string26));
        }
        if ((string25 = taskResult.getAttributeValue("ids-proxy-con-permit-auth-none")) != null) {
            this.setPermitAuthNone(this.stringTobool(string25));
        }
        if ((string24 = taskResult.getAttributeValue("ids-proxy-con-permit-auth-simple")) != null) {
            this.setPermitAuthSimple(this.stringTobool(string24));
        }
        if ((string23 = taskResult.getAttributeValue("ids-proxy-con-permit-auth-sasl")) != null) {
            this.setPermitAuthSASL(this.stringTobool(string23));
        }
        if ((string22 = taskResult.getAttributeValue("ids-proxy-con-permit-op-search")) != null) {
            this.setPermitOpSearch(this.stringTobool(string22));
        }
        if ((string21 = taskResult.getAttributeValue("ids-proxy-con-permit-op-compare")) != null) {
            this.setPermitOpCompare(this.stringTobool(string21));
        }
        if ((string20 = taskResult.getAttributeValue("ids-proxy-con-permit-op-add")) != null) {
            this.setPermitOpAdd(this.stringTobool(string20));
        }
        if ((string19 = taskResult.getAttributeValue("ids-proxy-con-permit-op-delete")) != null) {
            this.setPermitOpDelete(this.stringTobool(string19));
        }
        if ((string18 = taskResult.getAttributeValue("ids-proxy-con-permit-op-modify")) != null) {
            this.setPermitOpModify(this.stringTobool(string18));
        }
        if ((string17 = taskResult.getAttributeValue("ids-proxy-con-permit-op-modrdn")) != null) {
            this.setPermitOpModRdn(this.stringTobool(string17));
        }
        if ((string16 = taskResult.getAttributeValue("ids-proxy-con-permit-op-extended")) != null) {
            this.setPermitOpExtended(this.stringTobool(string16));
        }
        this.removeAllProperties();
        String[] stringArray5 = taskResult.getAttributeValues("ids-proxy-con-include-property");
        if (stringArray5 != null) {
            for (int i = 0; i < stringArray5.length; ++i) {
                this.addPropertyId(stringArray5[i]);
            }
        }
        if ((string15 = taskResult.getAttributeValue("ids-proxy-con-server")) != null) {
            this.addPropertyId(string15);
        }
        if ((string14 = taskResult.getAttributeValue("ids-proxy-con-max-result-size")) != null) {
            this.setMaxResultSize(new Integer(string14));
        }
        if ((string13 = taskResult.getAttributeValue("ids-proxy-con-filter-inequality")) != null) {
            this.setFilterInequality(this.stringTobool(string13));
        }
        if ((string12 = taskResult.getAttributeValue("ids-proxy-con-minimum-base")) != null) {
            this.setMinimumBase(new DN(string12));
        }
        if ((string11 = taskResult.getAttributeValue("ids-proxy-con-max-timelimit")) != null) {
            this.setTimelimit(new Integer(string11));
        }
        if ((string10 = taskResult.getAttributeValue("ids-proxy-con-min-substring-size")) != null) {
            this.setSubstringSize(new Integer(string10));
        }
        if ((string9 = taskResult.getAttributeValue("ids-proxy-con-max-scope")) != null) {
            this.setMaxScope(new Integer(string9));
        }
        this.vForbiddenPermitCompare.clear();
        String[] stringArray6 = taskResult.getAttributeValues("ids-proxy-con-forbidden-compare");
        if (stringArray6 != null) {
            for (int i = 0; i < stringArray6.length; ++i) {
                this.vForbiddenPermitCompare.addElement(stringArray6[i]);
            }
            this.forbiddenCompare = true;
            this.permittedCompare = false;
            this.allowAllCompare = false;
        }
        if ((stringArray2 = taskResult.getAttributeValues("ids-proxy-con-permitted-compare")) != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                this.vForbiddenPermitCompare.addElement(stringArray2[i]);
            }
            this.permittedCompare = true;
            this.forbiddenCompare = false;
            this.allowAllCompare = false;
        }
        this.vForbiddenPermitReturn.clear();
        String[] stringArray7 = taskResult.getAttributeValues("ids-proxy-con-forbidden-return");
        if (stringArray7 != null) {
            for (int i = 0; i < stringArray7.length; ++i) {
                this.vForbiddenPermitReturn.addElement(stringArray7[i]);
            }
            this.forbiddenReturn = true;
            this.allowAllReturn = false;
            this.permittedReturn = false;
        }
        if ((stringArray = taskResult.getAttributeValues("ids-proxy-con-permitted-return")) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.vForbiddenPermitReturn.addElement(stringArray[i]);
            }
            this.permittedReturn = true;
            this.forbiddenReturn = false;
            this.allowAllReturn = false;
        }
        if ((string8 = taskResult.getAttributeValue("ids-proxy-con-reference")) != null) {
            this.setReference(string8);
        }
        if ((string7 = taskResult.getAttributeValue("ids-proxy-con-referral-bind-policy")) != null) {
            this.setRefBindPolicy(string7);
        }
        if ((string6 = taskResult.getAttributeValue("ids-proxy-con-max-refcount")) != null) {
            this.setMaxRefcount(new Integer(string6));
        }
        this.forbiddenSubtree.clear();
        String[] stringArray8 = taskResult.getAttributeValues("ids-proxy-con-forbidden-subtree");
        if (stringArray8 != null) {
            for (int i = 0; i < stringArray8.length; ++i) {
                this.forbiddenSubtree.addElement(new DN(stringArray8[i]));
            }
        }
        if ((string5 = taskResult.getAttributeValue("ids-proxy-con-search-reference")) != null) {
            this.setSearchReference(string5);
        }
        if ((string4 = taskResult.getAttributeValue("ids-proxy-con-max-simultaneous-operations-per-connection")) != null) {
            this.setMaxSimulOpsPerConn(new Integer(string4));
        }
        if ((string3 = taskResult.getAttributeValue("ids-proxy-con-max-operations-per-connection")) != null) {
            this.setMaxOpsPerConn(new Integer(string3));
        }
        if ((string2 = taskResult.getAttributeValue("ids-proxy-con-max-conns")) != null) {
            this.setMaxConn(new Integer(string2));
        }
        if ((string = taskResult.getAttributeValue("ids-proxy-con-max-simultaneous-conns-from-ip")) != null) {
            this.setMaxSimulConnFromIp(new Integer(string));
        }
        this.setDirty(false);
    }

    private Integer convertStringParameterToInteger(String string, Integer n) {
        Integer n2 = null;
        if (string == null) {
            n2 = n;
        } else {
            try {
                n2 = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                Debug.println((String)("NetworkGroupBean: illegal numeric value " + string));
            }
        }
        return n2;
    }

    private String boolToString(boolean bl) {
        return bl ? "true" : "false";
    }

    private boolean stringTobool(String string) {
        boolean bl = false;
        if (string.equalsIgnoreCase("true")) {
            bl = true;
        } else if (string.equalsIgnoreCase("false")) {
            bl = false;
        } else {
            Debug.println((String)("NetworkGroupBean: illegal boolean value " + string));
        }
        return bl;
    }

    private Vector getPropertyIdsByDescriptor(String string) {
        Vector<String> vector = new Vector<String>();
        if (string != null) {
            Vector vector2 = this.getPropertiesByDescriptor(string);
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                BeanListenable beanListenable = (BeanListenable)enumeration.nextElement();
                if (beanListenable == null) continue;
                vector.add(beanListenable.getId());
            }
        }
        return vector;
    }

    private Vector getPropertiesByDescriptor(String string) {
        Vector<BeanListenable> vector = new Vector<BeanListenable>();
        if (string != null) {
            Enumeration enumeration = this.vPropertyRefs.elements();
            while (enumeration.hasMoreElements()) {
                BeanListenable beanListenable = (BeanListenable)enumeration.nextElement();
                if (beanListenable == null || !string.equals(beanListenable.getDescriptor())) continue;
                vector.add(beanListenable);
            }
        }
        return vector;
    }

    public String getLocalizableDescriptor() {
        return IDARResourceSet.getString("configType", "NETWORK_GROUP_DESCRIPTOR");
    }

    class NetworkGroupBeanReferenceMonitor
    extends BeanReferenceMonitor {
        NetworkGroupBeanReferenceMonitor(IDARModelBean iDARModelBean) {
            super(iDARModelBean);
        }

        NetworkGroupBeanReferenceMonitor(IDARModelBean iDARModelBean, BeanListenable beanListenable) {
            super(iDARModelBean, beanListenable);
        }

        public void beanDeleted(BeanEvent beanEvent) {
            Debug.println((int)6, (String)("NetworkGroupBeanReferenceMonitor.beanDeleted: evt=" + beanEvent));
            IDARReference iDARReference = beanEvent.getReference();
            if (iDARReference != null) {
                String string = iDARReference.getDescriptor();
                if ("rule".equals(string) || "rule".equals(IDARUtilities.getDescriptorSuperclass(string))) {
                    Debug.println((int)6, (String)("NetworkGroupBeanReferenceMonitor.beanDeleted: rule " + iDARReference));
                    NetworkGroupBean.this.removeRule(iDARReference);
                } else if ("property".equals(string) || "property".equals(IDARUtilities.getDescriptorSuperclass(string))) {
                    Debug.println((int)6, (String)("NetworkGroupBeanReferenceMonitor.beanDeleted: property " + iDARReference));
                    NetworkGroupBean.this.removeProperty(iDARReference);
                } else {
                    Debug.println((String)("NetworkGroupBeanReferenceMonitor.beanDeleted: ERROR - could not determine type for " + iDARReference));
                }
                super.beanDeleted(beanEvent);
            }
        }
    }
}

