/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.objectmodel.bean;

import com.iplanet.idar.objectmodel.BeanEvent;
import com.iplanet.idar.objectmodel.BeanListenable;
import com.iplanet.idar.objectmodel.BeanListener;
import com.iplanet.idar.objectmodel.BeanListenerAdapter;
import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.IModelBean;
import com.iplanet.idar.objectmodel.bean.NoSuchBeanException;
import com.iplanet.idar.objectmodel.bean.RetrievalException;
import com.netscape.management.client.util.Debug;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class IDARBeanCollection
implements IModelBean {
    private HashSet descriptorSet;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private PropertyChangeSupport persistSupport = new PropertyChangeSupport(this);
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private PropertyChangeListener persistListener;
    private PropertyChangeListener propertyListener;
    private BeanListener beanListener;
    private IDARReference configuration = null;
    private HashSet references = new HashSet();
    private HashSet beans = new HashSet();
    Hashtable refCache = new Hashtable();

    public IDARBeanCollection() {
        this.persistListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Debug.println((int)6, (String)("IDARBeanCollection.persistenceListener.propertyChange: evt=" + propertyChangeEvent));
                IDARBeanCollection.this.persistSupport.firePropertyChange(propertyChangeEvent);
            }
        };
        this.propertyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Debug.println((int)6, (String)("IDARBeanCollection.propertyListener.propertyChange: evt=" + propertyChangeEvent));
                IDARBeanCollection.this.propertySupport.firePropertyChange(propertyChangeEvent);
            }
        };
        this.beanListener = new BeanListenerAdapter(){

            public void beanLoaded(BeanEvent beanEvent) {
                Debug.println((String)("IDARBeanCollection.beanLoaded: evt=" + beanEvent));
                IDARReference iDARReference = beanEvent.getReference();
                IDARModelBean iDARModelBean = beanEvent.getBean();
                if (iDARReference != null && iDARModelBean != null) {
                    IDARBeanCollection.this.removeRefX(iDARReference);
                    IDARBeanCollection.this.beans.add(iDARModelBean);
                    iDARModelBean.addPropertyChangePersistanceListener(IDARBeanCollection.this.persistListener);
                    iDARModelBean.addPropertyChangeListener(IDARBeanCollection.this.propertyListener);
                    Debug.println((String)("IDARBeanCollection.beanLoaded: new collection state " + IDARBeanCollection.this.toString()));
                }
            }

            public void beanRenamed(BeanEvent beanEvent) {
                Debug.println((String)("IDARBeanCollection.beanRenamed: evt=" + beanEvent));
                IDARBeanCollection.this.support.firePropertyChange("beans", null, beanEvent.getBean());
            }

            public void beanPersisted(BeanEvent beanEvent) {
                Debug.println((String)("IDARBeanCollection.beanPersisted: evt=" + beanEvent));
                IDARBeanCollection.this.support.firePropertyChange("beans", null, beanEvent.getBean());
            }
        };
    }

    public IDARBeanCollection(IDARReference iDARReference, String[] stringArray) {
        this();
        this.configuration = iDARReference;
        this.setDescriptors(stringArray);
    }

    public IDARBeanCollection(IDARReference iDARReference, Set set) {
        this();
        this.configuration = iDARReference;
        this.descriptorSet = new HashSet();
        this.descriptorSet.addAll(set);
    }

    public IDARReference getParentConfiguration() {
        return this.configuration;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangePersistanceListenerToElements(PropertyChangeListener propertyChangeListener) {
        this.persistSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangePersistanceListenerToElements(String string, PropertyChangeListener propertyChangeListener) {
        this.persistSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListenerToElements(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListenerToElements(String string, PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangePersistanceListenerFromElements(PropertyChangeListener propertyChangeListener) {
        this.persistSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangePersistanceListenerFromElements(String string, PropertyChangeListener propertyChangeListener) {
        this.persistSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListenerFromElements(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListenerFromElements(String string, PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void setDescriptors(String[] stringArray) {
        this.descriptorSet = new HashSet();
        for (int i = 0; i < stringArray.length; ++i) {
            this.descriptorSet.add(stringArray[i]);
        }
    }

    public String[] getDescriptors() {
        String[] stringArray = new String[this.descriptorSet.size()];
        this.descriptorSet.toArray(stringArray);
        return stringArray;
    }

    public Set getDescriptorSet() {
        return this.descriptorSet;
    }

    public int size() {
        int n = 0;
        if (this.references != null) {
            n += this.references.size();
        }
        if (this.beans != null) {
            n += this.beans.size();
        }
        return n;
    }

    public void synchronize() throws NoSuchBeanException, RetrievalException {
        Debug.println((int)6, (String)"IDARBeanCollection.synchronize");
        this.clear();
        String[] stringArray = this.getDescriptors();
        for (int i = 0; i < stringArray.length; ++i) {
            this.collectReferences(stringArray[i]);
        }
    }

    public boolean add(Object object) {
        if (object instanceof IDARReference) {
            return this.addReference((IDARReference)object);
        }
        if (object instanceof IDARModelBean) {
            return this.addBean((IDARModelBean)object);
        }
        return false;
    }

    public boolean addBean(IDARModelBean iDARModelBean) {
        Debug.println((String)("IDARBeanCollection.addBean: bean=" + iDARModelBean));
        if (iDARModelBean != null && this.beans.add(iDARModelBean)) {
            iDARModelBean.addPropertyChangePersistanceListener(this.persistListener);
            iDARModelBean.addPropertyChangeListener(this.propertyListener);
            iDARModelBean.addBeanListener(this.beanListener);
            this.support.firePropertyChange("beans", null, iDARModelBean);
            return true;
        }
        return false;
    }

    public boolean addReference(IDARReference iDARReference) {
        boolean bl = false;
        if (iDARReference != null) {
            if (iDARReference.beanHasBeenLoaded()) {
                try {
                    this.beans.add(iDARReference.getBean());
                }
                catch (IDARBeanException iDARBeanException) {
                    iDARBeanException.printStackTrace();
                }
            } else {
                iDARReference.addBeanListener(this.beanListener);
                bl = this.references.add(iDARReference);
            }
        }
        return bl;
    }

    public boolean remove(Object object) {
        Debug.println((int)6, (String)("IDARBeanCollection.remove: o=" + object));
        if (object instanceof IDARReference) {
            return this.removeReference((IDARReference)object);
        }
        if (object instanceof IDARModelBean) {
            return this.removeBean((IDARModelBean)object);
        }
        return false;
    }

    public boolean removeBean(IDARModelBean iDARModelBean) {
        Debug.println((String)("IDARBeanCollection.removeBean: bean=" + iDARModelBean));
        if (this.removeBeanX(iDARModelBean)) {
            iDARModelBean.removePropertyChangePersistanceListener(this.persistListener);
            iDARModelBean.removePropertyChangeListener(this.propertyListener);
            iDARModelBean.removeBeanListener(this.beanListener);
            this.support.firePropertyChange("bean", iDARModelBean, null);
            return true;
        }
        if (this.removeRefX(iDARModelBean.getSelfReference())) {
            iDARModelBean.removePropertyChangePersistanceListener(this.persistListener);
            iDARModelBean.removeBeanListener(this.beanListener);
            this.support.firePropertyChange("bean", iDARModelBean, null);
            return true;
        }
        return false;
    }

    public boolean removeReference(IDARReference iDARReference) {
        if (this.removeRefX(iDARReference)) {
            iDARReference.removeBeanListener(this.beanListener);
            this.support.firePropertyChange("bean", iDARReference, null);
            return true;
        }
        return false;
    }

    public void clear() {
        Iterator iterator = this.beans.iterator();
        while (iterator.hasNext()) {
            this.remove(iterator.next());
        }
        iterator = this.references.iterator();
        while (iterator.hasNext()) {
            this.remove(iterator.next());
        }
    }

    public Set getBeans() {
        this.convertAllReferencesToBeans();
        return this.beans;
    }

    public IDARModelBean getBean(String string) {
        IDARModelBean iDARModelBean = null;
        Object object = this.beans.iterator();
        while (object.hasNext()) {
            IDARModelBean iDARModelBean2 = (IDARModelBean)object.next();
            if (!iDARModelBean2.getId().equals(string)) continue;
            iDARModelBean = iDARModelBean2;
            break;
        }
        if (iDARModelBean == null && (object = this.getReference(string)) != null) {
            try {
                iDARModelBean = ((IDARReference)object).getBean();
            }
            catch (NoSuchBeanException noSuchBeanException) {
                noSuchBeanException.printStackTrace();
            }
            catch (RetrievalException retrievalException) {
                retrievalException.printStackTrace();
            }
        }
        return iDARModelBean;
    }

    public IDARReference getReference(String string) {
        Debug.println((String)("IDARBeanCollection.getReference: id=" + string));
        BeanListenable beanListenable = null;
        if (string != null) {
            beanListenable = (IDARReference)this.refCache.get(string);
            if (beanListenable == null) {
                BeanListenable beanListenable2;
                Iterator iterator = this.references.iterator();
                while (iterator.hasNext()) {
                    beanListenable2 = (IDARReference)iterator.next();
                    if (!((IDARReference)beanListenable2).getId().equals(string)) continue;
                    beanListenable = beanListenable2;
                    this.refCache.put(string, beanListenable);
                    break;
                }
                if (beanListenable == null) {
                    iterator = this.beans.iterator();
                    while (iterator.hasNext()) {
                        beanListenable2 = (IDARModelBean)iterator.next();
                        if (!((IDARModelBean)beanListenable2).getId().equals(string)) continue;
                        beanListenable = ((IDARModelBean)beanListenable2).getSelfReference();
                        this.refCache.put(string, beanListenable);
                        break;
                    }
                }
                if (beanListenable == null) {
                    int n;
                    String[] stringArray;
                    iterator = this.references.iterator();
                    while (iterator.hasNext()) {
                        beanListenable2 = (IDARReference)iterator.next();
                        stringArray = ((IDARReference)beanListenable2).getOldIds();
                        if (stringArray == null) continue;
                        for (n = 0; n < stringArray.length; ++n) {
                            if (!string.equals(stringArray[n])) continue;
                            beanListenable = beanListenable2;
                            this.refCache.remove(stringArray[n]);
                            this.refCache.put(string, beanListenable);
                            break;
                        }
                        if (beanListenable == null) continue;
                    }
                    if (beanListenable == null) {
                        iterator = this.beans.iterator();
                        while (iterator.hasNext()) {
                            beanListenable2 = (IDARModelBean)iterator.next();
                            stringArray = ((IDARModelBean)beanListenable2).getSelfReference().getOldIds();
                            if (stringArray == null) continue;
                            for (n = 0; n < stringArray.length; ++n) {
                                if (!string.equals(stringArray[n])) continue;
                                beanListenable = ((IDARModelBean)beanListenable2).getSelfReference();
                                this.refCache.remove(stringArray[n]);
                                this.refCache.put(string, beanListenable);
                                break;
                            }
                            if (beanListenable == null) continue;
                            break;
                        }
                    }
                }
            } else if (!beanListenable.getId().equals(string)) {
                this.refCache.remove(string);
                return this.getReference(string);
            }
        }
        return beanListenable;
    }

    public Vector toReferenceVector() {
        Vector<IDARReference> vector = new Vector<IDARReference>();
        vector.addAll(this.references);
        Iterator iterator = this.beans.iterator();
        while (iterator.hasNext()) {
            IDARModelBean iDARModelBean = (IDARModelBean)iterator.next();
            if (!vector.contains(iDARModelBean.getSelfReference())) {
                vector.add(iDARModelBean.getSelfReference());
                continue;
            }
            Debug.println((String)("IDARBeanCollection.toReferenceVector: ERROR bean " + iDARModelBean.getSelfReference() + " stored as both bean and reference.  Attempt to remove ref:"));
            this.removeRefX(iDARModelBean.getSelfReference());
        }
        Collections.sort(vector, new Comparator(){

            public int compare(Object object, Object object2) {
                int n = 0;
                if (object instanceof IDARReference && object2 instanceof IDARReference) {
                    n = ((IDARReference)object).getId().compareTo(((IDARReference)object2).getId());
                }
                return n;
            }
        });
        return vector;
    }

    public Vector toBeanVector() {
        Vector vector = new Vector();
        this.convertAllReferencesToBeans();
        vector.addAll(this.beans);
        Collections.sort(vector, new Comparator(){

            public int compare(Object object, Object object2) {
                int n = 0;
                if (object instanceof IDARModelBean && object2 instanceof IDARModelBean) {
                    n = ((IDARModelBean)object).getId().compareTo(((IDARModelBean)object2).getId());
                }
                return n;
            }
        });
        return vector;
    }

    public String toString() {
        BeanListenable beanListenable;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IDARBeanCollection {");
        stringBuffer.append(this.descriptorSet.toString());
        stringBuffer.append("} REFERENCES [");
        Iterator iterator = this.references.iterator();
        while (iterator.hasNext()) {
            beanListenable = (IDARReference)iterator.next();
            stringBuffer.append(((IDARReference)beanListenable).getId() + "@" + ((IDARReference)beanListenable).thisCount + ", ");
        }
        stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length() - 1);
        stringBuffer.append("] LOADED BEANS [");
        iterator = this.beans.iterator();
        while (iterator.hasNext()) {
            beanListenable = (IDARModelBean)iterator.next();
            stringBuffer.append(((IDARModelBean)beanListenable).getId() + ", ");
        }
        stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length() - 1);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void convertAllReferencesToBeans() {
        Debug.println((String)"IDARBeanCollection.convertAllReferencesToBeans");
        Vector vector = new Vector();
        vector.addAll(this.references);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            IDARReference iDARReference = (IDARReference)enumeration.nextElement();
            try {
                IDARModelBean iDARModelBean = iDARReference.getBean();
            }
            catch (NoSuchBeanException noSuchBeanException) {
                noSuchBeanException.printStackTrace();
            }
            catch (RetrievalException retrievalException) {
                Debug.println((int)0, (String)("ERROR: UNABLE TO RETRIEVE BEAN FOR REFERENCE, " + iDARReference.getId() + ":"));
                Debug.println((int)0, (String)("MESSAGE: " + retrievalException.getMessage()));
            }
        }
    }

    private void collectReferences(String string) throws RetrievalException {
        Debug.println((String)("IDARBeanCollection.collectReferences: descriptor=" + string));
        IDARReference iDARReference = this.getParentConfiguration();
        if (string != null && iDARReference != null) {
            BeanSpace beanSpace = BeanSpace.getInstance();
            IDARReference[] iDARReferenceArray = beanSpace.getExistingInstanceReferences(iDARReference, string);
            for (int i = 0; i < iDARReferenceArray.length; ++i) {
                this.addReference(iDARReferenceArray[i]);
            }
        }
    }

    private boolean removeRefX(IDARReference iDARReference) {
        Iterator iterator = this.references.iterator();
        while (iterator.hasNext()) {
            IDARReference iDARReference2 = (IDARReference)iterator.next();
            if (!iDARReference.equals(iDARReference2)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    private boolean removeBeanX(IDARModelBean iDARModelBean) {
        Iterator iterator = this.beans.iterator();
        while (iterator.hasNext()) {
            IDARModelBean iDARModelBean2 = (IDARModelBean)iterator.next();
            if (!iDARModelBean.equals(iDARModelBean2)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }
}

