/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.objectmodel.bean;

import com.iplanet.idar.common.IDARConstants;
import com.iplanet.idar.objectmodel.BeanListenable;
import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.HttpCommand;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.AdminServerBean;
import com.iplanet.idar.objectmodel.bean.BeanAlreadyExistsException;
import com.iplanet.idar.objectmodel.bean.ConfigurationBean;
import com.iplanet.idar.objectmodel.bean.CreationException;
import com.iplanet.idar.objectmodel.bean.DeletionException;
import com.iplanet.idar.objectmodel.bean.EncryptionConfigData;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.IDARConfigurationModelBean;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.IllegalPropertyException;
import com.iplanet.idar.objectmodel.bean.LogPropertyBean;
import com.iplanet.idar.objectmodel.bean.NoSuchBeanException;
import com.iplanet.idar.objectmodel.bean.PersistenceException;
import com.iplanet.idar.objectmodel.bean.RetrievalException;
import com.iplanet.idar.objectmodel.bean.SystemBean;
import com.iplanet.idar.objectmodel.bean.TaskParameters;
import com.iplanet.idar.objectmodel.bean.TaskResult;
import com.iplanet.idar.objectmodel.bean.UniqueNameException;
import com.iplanet.idar.server.ServerStatusEvent;
import com.iplanet.idar.server.ServerStatusListener;
import com.iplanet.idar.task.TaskAdapter;
import com.iplanet.idar.task.TaskEvent;
import com.iplanet.idar.task.TaskGroup;
import com.iplanet.idar.task.idar.HupTask;
import com.iplanet.idar.task.idar.PingTask;
import com.iplanet.idar.task.idar.RestartTask;
import com.iplanet.idar.task.idar.RetrieveAuditRecordsTask;
import com.iplanet.idar.task.idar.RetrieveLogRecordsTask;
import com.iplanet.idar.task.idar.StartTask;
import com.iplanet.idar.task.idar.StopTask;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.LDAPComm;
import com.iplanet.idar.ui.task.IplanetTaskEventManager;
import com.netscape.management.client.util.Debug;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.util.DN;

public class IDARBean
extends IDARModelBean
implements IDARConstants,
LDAPComm {
    private boolean isPointerMismatched = false;
    private IDARReference oldSharedConfigurationRef = null;
    private String serverRoot = null;
    private String hostName = null;
    private String serverId = null;
    private IDARReference systemRef = null;
    private IDARReference configRef = null;
    private IDARReference currentLogRef = null;
    private EncryptionConfigData encryptionData = null;
    private LDAPConnection ldc = null;
    String illegalityMessage = null;
    private AdminServerBean adminServer;
    StartTask startTask = null;
    RestartTask restartTask = null;
    StopTask stopTask = null;
    HupTask hupTask = null;
    PingTask pingTask = null;
    RetrieveLogRecordsTask logTask = null;
    RetrieveAuditRecordsTask auditTask = null;
    private Vector statusListeners = new Vector();
    private String statusMessage = IDARResourceSet.getString("idar", "status_unknown");
    private int statusCode = 0;
    IDARStatusThread statusThread = null;
    private static long STATUS_SLEEP_TIME = 15000L;

    public IDARBean() {
        this.createTasks();
        this.encryptionData = new EncryptionConfigData();
    }

    public boolean isDirty() {
        SystemBean systemBean;
        Debug.println((String)("IDARBean.isDirty: bean=" + super.isDirty() + " ed=" + this.encryptionData.isDirty()));
        boolean bl = super.isDirty();
        if (!bl && !(bl = this.encryptionData.isDirty()) && (systemBean = this.getSystemBean()) != null) {
            IDARReference iDARReference = systemBean.getLogProperty();
            bl = this.currentLogRef != null && !this.currentLogRef.equals(iDARReference) || this.currentLogRef == null && iDARReference != null;
        }
        return bl;
    }

    public void setLDAPConnection(Object object) {
        if (object instanceof LDAPConnection) {
            this.ldc = (LDAPConnection)((LDAPConnection)object).clone();
        } else {
            Debug.println((String)"IDARBean.setLDAPConnection: ERROR - trying to set wrong kind of connection");
        }
    }

    public LDAPConnection getLDAPConnection() {
        return this.ldc;
    }

    public boolean isLegal() {
        boolean bl = true;
        this.illegalityMessage = null;
        if (null == this.getSharedConfigurationDn()) {
            bl = false;
            this.illegalityMessage = IDARResourceSet.getString("error", "ERR_NO_CONFIGURATION");
        } else if (null == this.getSystemConfigurationDn()) {
            bl = false;
            this.illegalityMessage = IDARResourceSet.getString("error", "ERR_NO_SYSTEM");
        } else if (this.isPointerMismatched) {
            bl = false;
            this.illegalityMessage = IDARResourceSet.getString("error", "POINTER_MISMATCH");
        } else if (this.isErroneouslyUsingSyslogOnWindows()) {
            bl = false;
            this.illegalityMessage = IDARResourceSet.getString("error", "SYSLOG_ON_WINDOWS");
        }
        return bl;
    }

    public String getIllegalityExplanationMessage() {
        this.isLegal();
        return this.illegalityMessage;
    }

    public boolean isQuestionable() {
        return false;
    }

    public String getQuestionableExplanationMessage() {
        return null;
    }

    public boolean isDeletable() {
        return true;
    }

    public String getPredeletionMessage() {
        return null;
    }

    public IDARReference[] getSubscribers() {
        return null;
    }

    public String getIdField() {
        return "ids-proxy-con-server-name";
    }

    protected static String getIdPrefix() {
        return "idar-server";
    }

    public String getDescriptor() {
        return IDARBean.getIdPrefix();
    }

    public String getServerName() {
        return this.getId();
    }

    public void setServerName(String string) throws UniqueNameException {
        this.setId(string);
    }

    public DN getSystemConfigurationDn() {
        DN dN = null;
        if (this.systemRef != null) {
            dN = new DN(this.systemRef.getHandle());
        }
        return dN;
    }

    public EncryptionConfigData getEncryptionData() {
        return this.encryptionData;
    }

    public void setEncryptionData(EncryptionConfigData encryptionConfigData) {
        if (this.encryptionData.isDirty()) {
            Debug.println((int)7, (String)"IDARBean.setEncryptionData: EncryptionData is Dirty");
            this.encryptionData = encryptionConfigData;
            this.setDirty(true);
        } else {
            Debug.println((int)7, (String)"IDARBean.setEncryptionData: data is not dirty");
        }
    }

    public String getSystemConfigurationDnString() {
        String string = null;
        DN dN = this.getSystemConfigurationDn();
        if (dN != null) {
            string = dN.toString();
        }
        Debug.println((String)("IDARBean.getSystemConfigurationDnString: " + string));
        return string;
    }

    public String getSystemConfigurationName() {
        String string = null;
        if (this.systemRef != null) {
            string = this.systemRef.getId();
        }
        return string;
    }

    public String getSharedConfigurationName() {
        String string = null;
        if (this.configRef != null) {
            string = this.configRef.getId();
        }
        return string;
    }

    public void setSystemConfiguration(BeanListenable beanListenable) {
        IDARReference iDARReference;
        Debug.println((String)("IDARBean.setSystemConfiguration: bl=" + beanListenable));
        if (beanListenable != null && !(iDARReference = beanListenable.getSelfReference()).equals(this.systemRef)) {
            this.systemRef = iDARReference;
            this.setDirty(true);
        }
    }

    public void setSharedConfiguration(BeanListenable beanListenable) {
        IDARReference iDARReference;
        Debug.println((String)("setting IDARBean shared config to =" + beanListenable));
        if (beanListenable != null && !(iDARReference = beanListenable.getSelfReference()).equals(this.configRef)) {
            this.oldSharedConfigurationRef = this.configRef;
            this.configRef = iDARReference;
            this.setDirty(true);
        }
    }

    public DN getSharedConfigurationDn() {
        DN dN = null;
        if (this.configRef != null) {
            dN = new DN(this.configRef.getHandle());
        }
        return dN;
    }

    public DN getOldShareConfigurationDn() {
        DN dN = null;
        if (this.oldSharedConfigurationRef != null) {
            dN = new DN(this.oldSharedConfigurationRef.getHandle());
        }
        return dN;
    }

    public String getSharedConfigurationDnString() {
        String string = null;
        DN dN = this.getSharedConfigurationDn();
        if (dN != null) {
            string = dN.toString();
        }
        return string;
    }

    private boolean isErroneouslyUsingSyslogOnWindows() {
        LogPropertyBean logPropertyBean;
        SystemBean systemBean;
        boolean bl = false;
        if (this.getOS() == 0 && (systemBean = this.getSystemBean()) != null && (logPropertyBean = systemBean.getLogPropertyBean()) != null) {
            String string = logPropertyBean.getLogSyslogCode();
            if (string != null && !string.trim().equals("")) {
                bl = true;
            } else {
                string = logPropertyBean.getAuditSyslogCode();
                if (string != null && !string.trim().equals("")) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    private boolean checkPointerMismatched(DN dN, DN dN2, DN dN3, DN dN4) {
        boolean bl = true;
        DN dN5 = dN.getParent();
        if (dN5 != null && dN.isDescendantOf(dN5) && (dN2 == null || dN2.isDescendantOf(dN5) && dN3 == null || dN3.isDescendantOf(dN5) && dN4 == null || dN4.isDescendantOf(dN5))) {
            bl = false;
        }
        return bl;
    }

    public ConfigurationBean getConfigurationBean() {
        ConfigurationBean configurationBean = null;
        if (this.configRef != null) {
            try {
                configurationBean = (ConfigurationBean)this.configRef.getBean();
            }
            catch (IDARBeanException iDARBeanException) {
                iDARBeanException.printStackTrace();
            }
        }
        return configurationBean;
    }

    public IDARReference getSystemConfiguration() {
        return this.systemRef;
    }

    public SystemBean getSystemBean() {
        SystemBean systemBean = null;
        if (this.systemRef != null) {
            try {
                systemBean = (SystemBean)this.systemRef.getBean();
            }
            catch (IDARBeanException iDARBeanException) {
                iDARBeanException.printStackTrace();
            }
        }
        return systemBean;
    }

    private String getGroupsBaseDnString() {
        String string = null;
        if (this.configRef != null) {
            string = new DN("ou=groups," + this.configRef.getHandle()).toString();
        }
        return string;
    }

    private String getEventsBaseDnString() {
        String string = null;
        if (this.configRef != null) {
            string = new DN("ou=rules," + this.configRef.getHandle()).toString();
        }
        return string;
    }

    private String getActionsBaseDnString() {
        String string = null;
        if (this.configRef != null) {
            string = new DN("ou=actions," + this.configRef.getHandle()).toString();
        }
        return string;
    }

    private String getPropertiesBaseDnString() {
        String string = null;
        if (this.configRef != null) {
            string = new DN("ou=properties," + this.configRef.getHandle()).toString();
        }
        return string;
    }

    public String getServerRoot() {
        return this.serverRoot;
    }

    public String getIdarRoot() {
        String string = null;
        String string2 = this.getServerRoot();
        if (string2 != null) {
            StringBuffer stringBuffer = new StringBuffer(string2);
            if (this.getOS() == 0) {
                stringBuffer.append("\\");
            } else {
                stringBuffer.append("/");
            }
            stringBuffer.append(this.getId());
            string = stringBuffer.toString();
        }
        return string;
    }

    public AdminServerBean getAdminServerBean() {
        if (this.adminServer == null) {
            this.adminServer = new AdminServerBean(this);
        }
        return this.adminServer;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getOS() {
        int n = 1;
        if (this.serverRoot != null && -1 != this.serverRoot.indexOf(92)) {
            n = 0;
        }
        return n;
    }

    public void setCommand(HttpCommand httpCommand) {
        super.setCommand(httpCommand);
        if (this.startTask != null) {
            this.startTask.setAuthentication(httpCommand.getUserId(), httpCommand.getPassword());
        }
        if (this.restartTask != null) {
            this.restartTask.setAuthentication(httpCommand.getUserId(), httpCommand.getPassword());
        }
        if (this.stopTask != null) {
            this.stopTask.setAuthentication(httpCommand.getUserId(), httpCommand.getPassword());
        }
        if (this.hupTask != null) {
            this.hupTask.setAuthentication(httpCommand.getUserId(), httpCommand.getPassword());
        }
        if (this.pingTask != null) {
            this.pingTask.setAuthentication(httpCommand.getUserId(), httpCommand.getPassword());
        }
        if (this.logTask != null) {
            this.logTask.setAuthentication(httpCommand.getUserId(), httpCommand.getPassword());
        }
        if (this.auditTask != null) {
            this.auditTask.setAuthentication(httpCommand.getUserId(), httpCommand.getPassword());
        }
    }

    public void persist() throws IllegalPropertyException, NoSuchBeanException, PersistenceException, UniqueNameException {
        IDARConfigurationModelBean iDARConfigurationModelBean;
        BeanListenable beanListenable;
        Object object;
        Object object2;
        Object object3;
        Debug.println((int)0);
        if (this.oldSharedConfigurationRef != null) {
            object3 = this.getSharedConfigurationDn();
            object2 = this.getOldShareConfigurationDn();
            Debug.println((String)("oldconfig=" + object2));
            Debug.println((String)("new config=" + object3));
            object = this.getServerName();
            this.getCommand().subscribeToConfiguration(object3.toString(), this.getServerName());
            try {
                this.getCommand().unsubscribeFromConfiguration(object2.toString(), this.getServerName());
            }
            catch (IDARBeanException iDARBeanException) {
                // empty catch block
            }
            try {
                beanListenable = BeanSpace.getInstance().getBeanReferenceByDn((DN)object3, "configuration", IDARReference.NULL_REFERENCE);
                iDARConfigurationModelBean = (ConfigurationBean)((IDARReference)beanListenable).getBean();
                IDARReference iDARReference = BeanSpace.getInstance().getBeanReferenceByDn((DN)object2, "configuration", IDARReference.NULL_REFERENCE);
                ConfigurationBean configurationBean = (ConfigurationBean)iDARReference.getBean();
                ((ConfigurationBean)iDARConfigurationModelBean).addBelongsTo((String)object);
                if (configurationBean != null) {
                    configurationBean.removeBelongsTo((String)object);
                }
            }
            catch (IDARBeanException iDARBeanException) {
                throw new PersistenceException("subscribe/unsubscribe failed: " + iDARBeanException.getMessage());
            }
        }
        try {
            object3 = this.getSystemBean();
            if (object3 != null) {
                object2 = this.getId();
                object = ((SystemBean)object3).getLogProperty();
                Debug.println((String)("IDARBean.persist: logRef=" + object));
                if (this.currentLogRef != null && object != null && !this.currentLogRef.equals(object) || this.currentLogRef != null || object != null) {
                    Debug.println((String)"IDARBean.persist: log property change detected");
                    beanListenable = null;
                    if (this.currentLogRef != null) {
                        beanListenable = (LogPropertyBean)this.currentLogRef.getBean();
                    }
                    iDARConfigurationModelBean = null;
                    if (object != null) {
                        iDARConfigurationModelBean = (LogPropertyBean)((IDARReference)object).getBean();
                    }
                    if (beanListenable != null) {
                        ((IDARConfigurationModelBean)beanListenable).removeBelongsTo((String)object2);
                        ((LogPropertyBean)beanListenable).persist();
                    }
                    if (iDARConfigurationModelBean != null) {
                        iDARConfigurationModelBean.addBelongsTo((String)object2);
                        ((LogPropertyBean)iDARConfigurationModelBean).persist();
                    }
                    this.currentLogRef = object;
                } else {
                    Debug.println((String)"IDARBean.persist: Log property has not changed");
                }
            } else {
                Debug.println((String)"IDARBean.persist:  ERROR accessing system bean");
            }
        }
        catch (IDARBeanException iDARBeanException) {
            throw new PersistenceException(IDARResourceSet.getString("error", "LOG_BELONGS_TO"));
        }
        object3 = new TaskParameters();
        ((TaskParameters)object3).addParameter("ids-proxy-con-server-name", this.getServerName());
        ((TaskParameters)object3).addParameter("ids-proxy-sch-global-config-dn", this.getSystemConfigurationDnString());
        ((TaskParameters)object3).addParameter("ids-proxy-sch-group-base", this.getGroupsBaseDnString());
        ((TaskParameters)object3).addParameter("ids-proxy-sch-rule-base", this.getEventsBaseDnString());
        ((TaskParameters)object3).addParameter("ids-proxy-sch-action-base", this.getActionsBaseDnString());
        ((TaskParameters)object3).addParameter("ids-proxy-sch-property-base", this.getPropertiesBaseDnString());
        ((TaskParameters)object3).addParameter("nsserverid", this.serverId);
        ((TaskParameters)object3).addParameter("serverroot", this.serverRoot);
        ((TaskParameters)object3).addParameter("serverhostname", this.hostName);
        if (this.encryptionData != null) {
            if (this.ldc != null) {
                try {
                    if (!this.ldc.isConnected()) {
                        this.ldc.connect(3, this.ldc.getHost(), this.ldc.getPort(), this.ldc.getAuthenticationDN(), this.ldc.getAuthenticationPassword());
                    } else {
                        Debug.println((int)6, (String)"IDARBean.persist: ERROR - cannot connect to LDAP server");
                    }
                    this.encryptionData.writeToDirectory(this.ldc, this.getSelfReference().getHandle());
                    this.ldc.disconnect();
                }
                catch (LDAPException lDAPException) {
                    Debug.println((String)"IDARBean.persist: ERROR - could not write encryption data");
                    if (Debug.isEnabled()) {
                        lDAPException.printStackTrace();
                    }
                    throw new PersistenceException(IDARResourceSet.getString("error", "LDAP_WRITE_ERROR"));
                }
            } else {
                Debug.println((String)"IDARBean.persist: ERROR - no ldap connection");
            }
        }
        super.doPersist((TaskParameters)object3);
        this.setDirty(false);
    }

    public void synchronize() throws RetrievalException, NoSuchBeanException {
        Debug.println((int)9, (String)"IDARBean.synchronize");
        TaskResult taskResult = super.doSynchronize();
        String string = null;
        DN dN = null;
        DN dN2 = null;
        DN dN3 = null;
        DN dN4 = null;
        string = taskResult.getAttributeValue("ids-proxy-sch-group-base");
        DN dN5 = new DN(string);
        if (dN5.toString().equals("")) {
            Debug.println((String)("IDARBean.synchronize:  ERROR: illegal or missing group dn " + string));
            dN = null;
        } else {
            dN = dN5;
        }
        string = taskResult.getAttributeValue("ids-proxy-sch-rule-base");
        if (string != null) {
            dN5 = new DN(string);
            if (dN5.toString().equals("")) {
                Debug.println((String)("IDARBean.synchronize:  illegal event dn " + string));
                dN2 = null;
            } else {
                dN2 = dN5;
            }
        }
        if ((string = taskResult.getAttributeValue("ids-proxy-sch-action-base")) != null) {
            dN5 = new DN(string);
            if (dN5.toString().equals("")) {
                Debug.println((String)("IDARBean.synchronize:  illegal action dn " + string));
                dN3 = null;
            } else {
                dN3 = dN5;
            }
        }
        if ((string = taskResult.getAttributeValue("ids-proxy-sch-property-base")) != null) {
            dN5 = new DN(string);
            if (dN5.toString().equals("")) {
                Debug.println((String)("IDARBean.synchronize:  illegal property dn " + string));
                dN4 = null;
            } else {
                dN4 = dN5;
            }
        }
        this.isPointerMismatched = this.checkPointerMismatched(dN, dN2, dN3, dN4);
        if (!this.isPointerMismatched) {
            this.setSharedConfiguration(BeanSpace.getInstance().getBeanReferenceByDn(dN.getParent(), "configuration", IDARReference.NULL_REFERENCE));
        }
        if ((dN5 = new DN(string = taskResult.getAttributeValue("ids-proxy-sch-global-config-dn"))).toString().equals("")) {
            Debug.println((String)("IDARBean.synchronize:  ERROR: illegal or missing global dn " + string));
            this.setSystemConfiguration(null);
        } else {
            IDARReference iDARReference = BeanSpace.getInstance().getBeanReferenceByDn(dN5, "system", IDARReference.NULL_REFERENCE);
            this.setSystemConfiguration(iDARReference);
            if (iDARReference == null) {
                String string2 = "SYSTEM DN," + dN5 + ", DOES NOT EXIST!!!!";
                throw new RetrievalException(string2);
            }
            try {
                SystemBean systemBean = (SystemBean)iDARReference.getBean();
                if (systemBean != null) {
                    this.currentLogRef = systemBean.getLogProperty();
                }
            }
            catch (IDARBeanException iDARBeanException) {
                iDARBeanException.printStackTrace();
            }
        }
        if (this.ldc != null) {
            try {
                if (!this.ldc.isConnected()) {
                    this.ldc.connect(3, this.ldc.getHost(), this.ldc.getPort(), this.ldc.getAuthenticationDN(), this.ldc.getAuthenticationPassword());
                } else {
                    Debug.println((int)6, (String)"IDARBean.synchronize: ERROR - cannot connect to LDAP server");
                }
                this.encryptionData.readFromDirectory(this.ldc, this.getSelfReference().getHandle());
                this.ldc.disconnect();
            }
            catch (LDAPException lDAPException) {
                if (Debug.isEnabled()) {
                    lDAPException.printStackTrace();
                }
                throw new RetrievalException(IDARResourceSet.getString("error", "LDAP_WRITE_ERROR"));
            }
        } else {
            Debug.println((String)"IDARBean.synchronize: ERROR - no ldap connection");
        }
        this.serverRoot = taskResult.getAttributeValue("serverroot");
        this.hostName = taskResult.getAttributeValue("serverhostname");
        this.serverId = taskResult.getAttributeValue("nsserverid");
        this.startStatusThread();
        this.setDirty(false);
    }

    public StartTask getStartTask() {
        return this.startTask;
    }

    public RestartTask getRestartTask() {
        return this.restartTask;
    }

    public StopTask getStopTask() {
        return this.stopTask;
    }

    public HupTask getHupTask() {
        return this.hupTask;
    }

    public PingTask getPingTask() {
        return this.pingTask;
    }

    public RetrieveLogRecordsTask getRetrieveLogRecordsTask() {
        return this.logTask;
    }

    public RetrieveAuditRecordsTask getRetrieveAuditRecordsTask() {
        return this.auditTask;
    }

    private void createTasks() {
        Object object;
        this.startTask = new StartTask(this);
        this.startTask.addTaskListener(new TaskAdapter(){

            public void taskStarted(TaskEvent taskEvent) {
                IDARBean.this.setStatusMessage(IDARResourceSet.getString("idar", "status_starting"));
            }

            public void taskStopped(TaskEvent taskEvent) {
                if (IDARBean.this.startTask.getExecutionStatus() == 0) {
                    IDARBean.this.setStatusMessage(IDARResourceSet.getString("idar", "status_started"));
                    IDARBean.this.setStatusCode(1);
                } else {
                    IDARBean.this.setStatusMessage(IDARResourceSet.getString("idar", "status_start_failure"));
                    IDARBean.this.setStatusCode(0);
                }
            }
        });
        this.stopTask = new StopTask(this);
        this.stopTask.addTaskListener(new TaskAdapter(){

            public void taskStarted(TaskEvent taskEvent) {
                IDARBean.this.setStatusMessage(IDARResourceSet.getString("idar", "status_stopping"));
            }

            public void taskStopped(TaskEvent taskEvent) {
                if (IDARBean.this.stopTask.getExecutionStatus() == 0) {
                    IDARBean.this.setStatusMessage(IDARResourceSet.getString("idar", "status_stopped"));
                    IDARBean.this.setStatusCode(2);
                } else {
                    IDARBean.this.setStatusMessage(IDARResourceSet.getString("idar", "status_stop_failure"));
                    IDARBean.this.setStatusCode(0);
                }
            }
        });
        this.restartTask = new RestartTask(this);
        this.restartTask.addTaskListener(new TaskAdapter(){

            public void taskStarted(TaskEvent taskEvent) {
                IDARBean.this.setStatusMessage(IDARResourceSet.getString("idar", "status_restarting"));
            }

            public void taskStopped(TaskEvent taskEvent) {
                if (IDARBean.this.restartTask.getExecutionStatus() == 0) {
                    IDARBean.this.setStatusMessage(IDARResourceSet.getString("idar", "status_started"));
                    IDARBean.this.setStatusCode(1);
                } else {
                    IDARBean.this.setStatusMessage(IDARResourceSet.getString("idar", "status_restart_failure"));
                    IDARBean.this.setStatusCode(0);
                }
            }
        });
        this.hupTask = new HupTask(this);
        this.hupTask.addTaskListener(new TaskAdapter(){

            public void taskStarted(TaskEvent taskEvent) {
                IDARBean.this.setStatusMessage(IDARResourceSet.getString("idar", "status_hupping"));
            }

            public void taskStopped(TaskEvent taskEvent) {
                if (IDARBean.this.hupTask.getExecutionStatus() == 0) {
                    IDARBean.this.setStatusMessage(IDARResourceSet.getString("idar", "status_hupped"));
                    IDARBean.this.setStatusCode(1);
                } else {
                    IDARBean.this.setStatusMessage(IDARResourceSet.getString("idar", "status_hup_failure"));
                    IDARBean.this.setStatusCode(0);
                }
            }
        });
        this.pingTask = new PingTask(this);
        this.pingTask.addTaskListener(new TaskAdapter(){

            public void taskStopped(TaskEvent taskEvent) {
                if (IDARBean.this.pingTask.getExecutionStatus() == 0) {
                    int n = IDARBean.this.pingTask.getPingResult();
                    IDARBean.this.setStatusCode(n);
                    if (n == 1) {
                        IDARBean.this.setStatusMessage(IDARResourceSet.getString("idar", "status_started"));
                    } else {
                        IDARBean.this.setStatusMessage(IDARResourceSet.getString("idar", "status_stopped"));
                    }
                } else {
                    IDARBean.this.setStatusCode(0);
                    IDARBean.this.setStatusMessage(IDARResourceSet.getString("idar", "status_unknown"));
                }
            }
        });
        try {
            object = (IplanetTaskEventManager)this.pingTask.getEventManager();
            ((IplanetTaskEventManager)object).showProgressOnFramework(false);
            ((IplanetTaskEventManager)object).showStatusMessagesOnFramework(false);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.logTask = new RetrieveLogRecordsTask(this);
        this.auditTask = new RetrieveAuditRecordsTask(this);
        object = new TaskGroup();
        ((TaskGroup)object).addTask(this.startTask);
        ((TaskGroup)object).addTask(this.stopTask);
        ((TaskGroup)object).addTask(this.restartTask);
        ((TaskGroup)object).addTask(this.hupTask);
    }

    public boolean isNeedingRestart() {
        return false;
    }

    IDARReference invokeCreate(IDARReference iDARReference, String string, String string2, TaskParameters taskParameters) throws BeanAlreadyExistsException, CreationException {
        throw new CreationException("Create not defined for IDARBean");
    }

    void invokeDelete(IDARReference iDARReference) throws NoSuchBeanException, DeletionException {
        throw new DeletionException("Delete not defined for IDARBean");
    }

    IDARReference invokeRename(IDARReference iDARReference, String string) throws PersistenceException, NoSuchBeanException {
        throw new PersistenceException("Rename not defined for IDARBean");
    }

    TaskResult invokePersist(IDARReference iDARReference, TaskParameters taskParameters) throws PersistenceException, NoSuchBeanException {
        HttpCommand httpCommand = this.getCommand();
        if (httpCommand != null) {
            return httpCommand.persistServer(iDARReference, taskParameters);
        }
        throw new PersistenceException("Bean management command not set by instantiator");
    }

    TaskResult invokeSynchronize(IDARReference iDARReference) throws RetrievalException, NoSuchBeanException {
        HttpCommand httpCommand = this.getCommand();
        if (httpCommand != null) {
            return httpCommand.synchronizeServer(iDARReference);
        }
        throw new RetrievalException("Bean management command not set by instantiator");
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    protected void setStatusMessage(String string) {
        this.statusMessage = string;
        this.fireStatusMessageChanged();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    protected void setStatusCode(int n) {
        if (n != this.statusCode) {
            this.statusCode = n;
            this.fireStatusChanged();
        }
    }

    public void addServerStatusListener(ServerStatusListener serverStatusListener) {
        if (serverStatusListener != null && !this.statusListeners.contains(serverStatusListener)) {
            this.statusListeners.add(serverStatusListener);
        }
    }

    public void removeServerStatusListener(ServerStatusListener serverStatusListener) {
        this.statusListeners.remove(serverStatusListener);
    }

    public void fireStatusChanged() {
        String string = this.getStatusMessage();
        int n = this.getStatusCode();
        Enumeration enumeration = this.statusListeners.elements();
        while (enumeration.hasMoreElements()) {
            ServerStatusListener serverStatusListener = (ServerStatusListener)enumeration.nextElement();
            serverStatusListener.statusChanged(new ServerStatusEvent(n, string));
        }
    }

    public void fireStatusMessageChanged() {
        String string = this.getStatusMessage();
        int n = this.getStatusCode();
        Enumeration enumeration = this.statusListeners.elements();
        while (enumeration.hasMoreElements()) {
            ServerStatusListener serverStatusListener = (ServerStatusListener)enumeration.nextElement();
            serverStatusListener.statusMessageChanged(new ServerStatusEvent(n, string));
        }
    }

    public void startStatusThread() {
        Debug.println((String)"IDARBean.startStatusThread");
        if (this.statusThread == null) {
            this.statusThread = new IDARStatusThread();
            try {
                this.statusThread.checkAccess();
                this.statusThread.setPriority(1);
            }
            catch (SecurityException securityException) {
                Debug.println((String)"Access to Status Thread denied by security manager");
            }
        }
        try {
            this.statusThread.start();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    public void stopStatusThread() {
        if (this.statusThread != null) {
            this.statusThread.run = false;
        }
    }

    public String getLocalizableDescriptor() {
        return IDARResourceSet.getString("configType", "CONFIGURATION_DESCRIPTOR");
    }

    class IDARStatusThread
    extends Thread {
        boolean run;

        IDARStatusThread() {
            this.setName("iDAR Status");
        }

        public void run() {
            Debug.println((String)"IDARBean.IDARStatusThread.run");
            this.run = true;
            while (this.run) {
                Debug.println((String)("IDARBean.IDARStatusThread.run; run=" + this.run));
                boolean bl = false;
                StartTask startTask = IDARBean.this.getStartTask();
                StopTask stopTask = IDARBean.this.getStopTask();
                if (!startTask.isExecuting() && !stopTask.isExecuting()) {
                    PingTask pingTask = IDARBean.this.getPingTask();
                    if (pingTask.isExecutable()) {
                        pingTask.execute();
                    } else {
                        Debug.println((String)("IDARBean.statusThread: ping task is currently unexecutable because " + pingTask.getUnexecutableMessage()));
                    }
                }
                try {
                    IDARStatusThread.sleep(STATUS_SLEEP_TIME);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

