/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.objectmodel.bean;

import com.iplanet.idar.common.IDARConstants;
import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.IDARReference;
import com.iplanet.idar.objectmodel.bean.AttributeValuePair;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.IllegalPropertyException;
import com.iplanet.idar.objectmodel.bean.NetworkGroupBean;
import com.iplanet.idar.objectmodel.bean.NoSuchBeanException;
import com.iplanet.idar.objectmodel.bean.PersistenceException;
import com.iplanet.idar.objectmodel.bean.PropertyBean;
import com.iplanet.idar.objectmodel.bean.RetrievalException;
import com.iplanet.idar.objectmodel.bean.TaskParameters;
import com.iplanet.idar.objectmodel.bean.TaskResult;
import com.iplanet.idar.objectmodel.bean.UniqueNameException;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.netscape.management.client.util.Debug;
import java.nio.charset.CharacterCodingException;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.util.DN;

public class ForbiddenEntryPropertyBean
extends PropertyBean
implements IDARConstants {
    public static final int EXCLUDE_ENTIRE_ENTRY = 0;
    public static final int EXCLUDE_ATTRIBUTES = 1;
    public static final int PERMIT_ATTRIBUTES = 2;
    private String illegalityMessage = null;
    String questionableMessage;
    private Vector vExactDns = new Vector();
    private Vector vDnExpressions = new Vector();
    private Vector vAVAs = new Vector();
    private Vector vAtts = new Vector();
    int mode = 0;

    protected static String getIdPrefix() {
        return "forbidden-entry";
    }

    public boolean isLegal() {
        Object object;
        int n;
        Debug.println((int)5);
        this.illegalityMessage = null;
        boolean bl = true;
        for (n = 0; n < this.vAVAs.size(); ++n) {
            object = (AttributeValuePair)this.vAVAs.elementAt(n);
            Debug.println((int)5, (String)("validating value: " + ((AttributeValuePair)object).getAttributeName()));
            try {
                IDARUtilities.toUSASCII(((AttributeValuePair)object).getAttributeName().toCharArray());
                continue;
            }
            catch (CharacterCodingException characterCodingException) {
                bl = false;
                this.illegalityMessage = IDARResourceSet.getString("illegal", "NON_ASCII_CHARACTER_SET", ((AttributeValuePair)object).getAttributeName());
                return bl;
            }
        }
        for (n = 0; n < this.vAtts.size(); ++n) {
            object = (String)this.vAtts.elementAt(n);
            try {
                IDARUtilities.toUSASCII(((String)object).toCharArray());
                continue;
            }
            catch (CharacterCodingException characterCodingException) {
                bl = false;
                this.illegalityMessage = IDARResourceSet.getString("illegal", "NON_ASCII_CHARACTER_SET", (String)object);
                return bl;
            }
        }
        return bl;
    }

    public String getIllegalityExplanationMessage() {
        this.isLegal();
        return this.illegalityMessage;
    }

    public boolean isQuestionable() {
        boolean bl = false;
        this.questionableMessage = null;
        if (this.vExactDns.size() == 0 && this.vDnExpressions.size() == 0 && this.vAVAs.size() == 0) {
            this.questionableMessage = IDARResourceSet.getString("questionable", "NO_ENTRY_MATCHING_CRITERIA");
            bl = true;
        }
        return bl;
    }

    public String getQuestionableExplanationMessage() {
        this.isQuestionable();
        return this.questionableMessage;
    }

    public boolean isDeletable() {
        return true;
    }

    public String getPredeletionMessage() {
        return super.getPredeletionMessage();
    }

    public IDARReference[] getSubscribers() {
        Object[] objectArray;
        Vector<IDARReference> vector = new Vector<IDARReference>();
        try {
            objectArray = BeanSpace.getInstance().retrieveBeanCollection(this.getParentConfiguration(), "network-group");
            Vector vector2 = objectArray.toBeanVector();
            String string = this.getId();
            Enumeration enumeration = vector2.elements();
            block2: while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e instanceof NetworkGroupBean) {
                    NetworkGroupBean networkGroupBean = (NetworkGroupBean)e;
                    Vector vector3 = networkGroupBean.getForbiddenEntryPropertyIds();
                    if (vector3 == null) continue;
                    Enumeration enumeration2 = vector3.elements();
                    while (enumeration2.hasMoreElements()) {
                        String string2 = enumeration2.nextElement().toString();
                        if (string2 == null || !string2.equals(string)) continue;
                        vector.add(networkGroupBean.getSelfReference());
                        continue block2;
                    }
                    continue;
                }
                Debug.println((String)"ForbiddenEntryPropertyBean.getSubscribers: WARNING: could not interogate bean");
            }
        }
        catch (IDARBeanException iDARBeanException) {
            Debug.println((String)"ForbiddenEntryPropertyBean.getSubscribers: WARNING: could not get bean collection");
        }
        objectArray = new IDARReference[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Vector getExactDns() {
        return this.vExactDns;
    }

    public void addExactDn(DN dN) {
        this.vExactDns.addElement(dN);
    }

    public void setExactDns(Vector vector) {
        this.vExactDns = vector;
    }

    public Vector getDnExpressions() {
        return this.vDnExpressions;
    }

    public void addDnExpression(String string) {
        this.vDnExpressions.addElement(string);
    }

    public void setDnExpressions(Vector vector) {
        this.vDnExpressions = vector;
    }

    public Vector getAttributeValueAssociations() {
        return this.vAVAs;
    }

    public void addAttributeValueAssociation(AttributeValuePair attributeValuePair) {
        this.vAVAs.addElement(attributeValuePair);
    }

    public void setAttributeValueAssociations(Vector vector) {
        this.vAVAs = vector;
    }

    public Vector getAttributes() {
        return this.vAtts;
    }

    public void addAttribute(String string) {
        this.vAtts.addElement(string);
    }

    public void setAttributes(Vector vector) {
        this.vAtts = vector;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public String getDescriptor() {
        return ForbiddenEntryPropertyBean.getIdPrefix();
    }

    public void persist() throws IllegalPropertyException, NoSuchBeanException, PersistenceException, UniqueNameException {
        TaskParameters taskParameters = new TaskParameters();
        Object object = this.vExactDns.elements();
        while (object.hasMoreElements()) {
            taskParameters.addParameter("ids-proxy-con-dn-exact", object.nextElement().toString());
        }
        object = this.vDnExpressions.elements();
        while (object.hasMoreElements()) {
            taskParameters.addParameter("ids-proxy-con-dn-regexp", object.nextElement().toString());
        }
        object = this.vAVAs.elements();
        while (object.hasMoreElements()) {
            taskParameters.addParameter("ids-proxy-con-ava", object.nextElement().toString());
        }
        if (this.mode != 0) {
            object = this.mode == 1 ? "ids-proxy-con-forbidden-return" : "ids-proxy-con-permitted-return";
            Enumeration enumeration = this.vAtts.elements();
            while (enumeration.hasMoreElements()) {
                taskParameters.addParameter((String)object, enumeration.nextElement().toString());
            }
        }
        super.doPersist(taskParameters);
    }

    public void synchronize() throws RetrievalException, NoSuchBeanException {
        String[] stringArray;
        TaskResult taskResult = super.doSynchronize();
        this.vExactDns.clear();
        String[] stringArray2 = taskResult.getAttributeValues("ids-proxy-con-dn-exact");
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                this.vExactDns.addElement(new DN(stringArray2[i]));
            }
        }
        this.vDnExpressions.clear();
        String[] stringArray3 = taskResult.getAttributeValues("ids-proxy-con-dn-regexp");
        if (stringArray3 != null) {
            for (int i = 0; i < stringArray3.length; ++i) {
                this.vDnExpressions.addElement(stringArray3[i]);
            }
        }
        this.vAVAs.clear();
        String[] stringArray4 = taskResult.getAttributeValues("ids-proxy-con-ava");
        if (stringArray4 != null) {
            for (int i = 0; i < stringArray4.length; ++i) {
                this.vAVAs.addElement(new AttributeValuePair(stringArray4[i]));
            }
        }
        this.vAtts.clear();
        String[] stringArray5 = taskResult.getAttributeValues("ids-proxy-con-forbidden-return");
        if (stringArray5 != null) {
            for (int i = 0; i < stringArray5.length; ++i) {
                this.vAtts.addElement(stringArray5[i]);
            }
        }
        if ((stringArray = taskResult.getAttributeValues("ids-proxy-con-permitted-return")) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.vAtts.addElement(stringArray[i]);
            }
        }
        this.mode = stringArray5 == null && stringArray == null ? 0 : (stringArray5 != null ? 1 : 2);
    }

    public String getLocalizableDescriptor() {
        return IDARResourceSet.getString("configType", "FORBIDDEN_ENTRY_PROPERTY_DESCRIPTOR");
    }
}

