/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.objectmodel.bean;

import com.iplanet.idar.objectmodel.bean.CipherSetup;
import com.netscape.management.client.util.Debug;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchResults;

public class EncryptionConfigData {
    private boolean sslServerOn = false;
    private Hashtable cipherSetupTable = new Hashtable(5);
    private String cipherPrefs = "+fortezza,+fortezza_null,+fortezza_rc4_128_sha,+rsa_3des_sha,+rsa_des_sha,+rsa_fips_3des_sha,+rsa_fips_des_sha,-rsa_null_md5,+rsa_rc2_40_md5,+rsa_rc4_128_md5,+rsa_rc4_40_md5,+rsa_rc4_des40_sha,+rsa_rc4_128_sha";
    private String cipherPrefsSslV2 = "+rc4,+rc4export,+rc2,+rc2export,+des,+desede3";
    private String cipherPrefsTLS = "+tls_rsa_export1024_with_des_cbc_sha,+tls_rsa_export1024_with_rc4_56_sha";
    private boolean ssl3On = false;
    private boolean ssl2On = false;
    private boolean securityIsDomestic;
    private boolean error = false;
    private boolean dirty = false;
    public static final String NS_CERT_FILE = "nsCertfile";
    public static final String NS_KEY_FILE = "nsKeyfile";
    public static final String NS_SSL3_CIPHERS = "nsSSL3Ciphers";
    public static final String NS_SSL3 = "nsSSL3";
    public static final String NS_SSL2_CIPHERS = "nsSSL2Ciphers";
    public static final String NS_SSL2 = "nsSSL2";
    public static final String NS_SERVER_SECURITY = "nsServerSecurity";
    public static final String IDAR_CONFIG_DN = "cn=configuration,";
    public static final String IDAR_ENCRYPTION_CONFIG_DN = "cn=encryption, cn=configuration,";
    public static final String NS_SSL3_SESSION_TIMEOUT = "nsSSL3SessionTimeout";
    public static final String NS_SSL_SESSION_TIMEOUT = "nsSSLSessionTimeout";
    public static final String NS_SSL_CLIENT_AUTH = "nsSSLClientAuth";
    public static final String NS_SSL_TIMEOUT = "nsSSLTimeout";
    private static final String SSL3 = "ssl3";
    private static final String TLS = "tls";
    public static final String NS_ENCRYPTION_MODULE = "nsEncryptionModule";
    public static final String NS_SSL_ACTIVATION = "nsSSLActivation";
    public static final String NS_SSL_TOKEN = "nsSSLToken";
    public static final String NS_SSL_PERSONALITY_SSL = "nsSSLPersonalitySSL";
    public static final String CIPHER_PREFS = "+fortezza,+fortezza_null,+fortezza_rc4_128_sha,+rsa_3des_sha,+rsa_des_sha,+rsa_fips_3des_sha,+rsa_fips_des_sha,-rsa_null_md5,+rsa_rc2_40_md5,+rsa_rc4_128_md5,+rsa_rc4_40_md5,+rsa_rc4_des40_sha,+rsa_rc4_128_sha";
    public static final String CIPHER_PREFS_TLS = "+tls_rsa_export1024_with_des_cbc_sha,+tls_rsa_export1024_with_rc4_56_sha";
    public static final String CIPHER_PREFS_SSL_V2 = "+rc4,+rc4export,+rc2,+rc2export,+des,+desede3";

    public void readFromDirectory(LDAPConnection lDAPConnection, String string) throws LDAPException {
        try {
            Debug.println((int)7, (String)"EncryptionConfigData.readFromDirectory()");
            String string2 = IDAR_ENCRYPTION_CONFIG_DN + string;
            String string3 = IDAR_CONFIG_DN + string;
            LDAPEntry lDAPEntry = lDAPConnection.read(string3);
            LDAPEntry lDAPEntry2 = lDAPConnection.read(string2);
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string2, 1, "objectclass=nsEncryptionModule", null, false);
            Debug.println((int)9, (String)"EncryptionConfigData.readFromDirectory(): **************************************************");
            if (lDAPEntry != null) {
                Object object;
                Debug.println((int)9, (String)("EncryptionConfigData.readFromDirectory: configuration dn[" + string3 + "] exists. Now reading..."));
                String string4 = EncryptionConfigData.getAttrValue(lDAPEntry, NS_SERVER_SECURITY);
                this.setSslServerOn(string4.equalsIgnoreCase("on"));
                if (lDAPEntry2 != null) {
                    string4 = EncryptionConfigData.getAttrValue(lDAPEntry2, NS_SSL3);
                    this.setSsl3On(string4.equalsIgnoreCase("on"));
                    string4 = EncryptionConfigData.getAttrValue(lDAPEntry2, NS_SSL2);
                    this.setSsl2On(string4.equalsIgnoreCase("on"));
                    object = EncryptionConfigData.getAttrValue(lDAPEntry2, NS_SSL3_CIPHERS);
                    this.setCipherPrefs(this.getCipherPrefsByType(SSL3, (String)object));
                    this.setCipherPrefsTLS(this.getCipherPrefsByType(TLS, (String)object));
                    object = EncryptionConfigData.getAttrValue(lDAPEntry2, NS_SSL2_CIPHERS);
                    this.setCipherPrefsSslV2((String)object);
                } else {
                    Debug.println((int)0, (String)"EncryptionConfigData.readFromDirectory: encryptionEntry is null");
                }
                if (lDAPSearchResults != null) {
                    while (lDAPSearchResults.hasMoreElements()) {
                        Debug.println((int)9, (String)("EncryptionConfigData.readFromDirectory: encryption dn[" + string2 + "] exists. Now reading..."));
                        LDAPEntry lDAPEntry3 = (LDAPEntry)lDAPSearchResults.nextElement();
                        object = new CipherSetup();
                        String string5 = lDAPEntry3.getDN();
                        int n = string5.indexOf(44);
                        ((CipherSetup)object).setFamily(string5.substring(string5.indexOf(61) + 1, n));
                        string4 = EncryptionConfigData.getAttrValue(lDAPEntry3, NS_SSL_ACTIVATION);
                        Debug.println((int)7, (String)("EncryptionConfigData.readFromDirectory: nsSslActivation=" + string4));
                        ((CipherSetup)object).setEnabled(string4.equalsIgnoreCase("on"));
                        ((CipherSetup)object).setSelectedDevice(EncryptionConfigData.getAttrValue(lDAPEntry3, NS_SSL_TOKEN));
                        ((CipherSetup)object).setSelectedCertificate(EncryptionConfigData.getAttrValue(lDAPEntry3, NS_SSL_PERSONALITY_SSL));
                        if (object != null && ((CipherSetup)object).getFamily() != null) {
                            if (this.cipherSetupTable.put(((CipherSetup)object).getFamily(), object) != null) {
                                Debug.println((int)0, (String)"EncryptionConfigData.readFromDirectory: cipher conflict ignored");
                            }
                            Debug.println((String)("EncryptionConfigData.readFromDirectory: read prefs for " + ((CipherSetup)object).getFamily()));
                        } else {
                            Debug.println((int)0, (String)"EncryptionConfigData.readFromDirectory: ERROR: null cipher setup or family");
                        }
                        ((CipherSetup)object).endInitialization();
                        Debug.println((int)9, (String)("EncryptionConfigData.readFromDirectory() Successfully read cipher prefs for dn:" + string5));
                        Debug.println((int)9, (String)((CipherSetup)object).toString());
                    }
                } else {
                    Debug.println((String)"EncryptionConfigData.readFromDirectory: encryptionEntry is null");
                }
            } else {
                Debug.println((int)0, (String)("EncryptionConfigData.readFromDirectory: cannot seem to read ldap entry: " + string3));
            }
            this.error = false;
            this.dirty = false;
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() == 32) {
                this.sslServerOn = false;
                this.error = false;
            }
            this.error = true;
            throw lDAPException;
        }
    }

    public void writeToDirectory(LDAPConnection lDAPConnection, String string) throws LDAPException {
        try {
            Debug.println((int)0, (String)("EncryptionConfigData.writeToDirectory: writing to directory for server= " + string));
            String string2 = IDAR_CONFIG_DN + string;
            LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
            String[] stringArray = new String[]{"top", "nsConfig", "nsAdminObject"};
            lDAPAttributeSet.add(new LDAPAttribute("objectclass", stringArray));
            String string3 = this.sslServerOn ? "on" : "off";
            lDAPAttributeSet.add(new LDAPAttribute(NS_SERVER_SECURITY, string3));
            LDAPEntry lDAPEntry = new LDAPEntry(string2, lDAPAttributeSet);
            EncryptionConfigData.addOrModifyLDAPEntry(lDAPConnection, lDAPEntry);
            String string4 = IDAR_ENCRYPTION_CONFIG_DN + string;
            LDAPAttributeSet lDAPAttributeSet2 = new LDAPAttributeSet();
            String[] stringArray2 = new String[]{"top", "nsEncryptionConfig"};
            lDAPAttributeSet2.add(new LDAPAttribute("objectclass", stringArray2));
            String string5 = LDAPDN.explodeDN((String)string, (boolean)true)[0];
            string3 = "alias/" + string5.toLowerCase() + "-cert7.db";
            lDAPAttributeSet2.add(new LDAPAttribute(NS_CERT_FILE, string3));
            string3 = "alias/" + string5.toLowerCase() + "-key3.db";
            lDAPAttributeSet2.add(new LDAPAttribute(NS_KEY_FILE, string3));
            string3 = this.sslServerOn ? "on" : "off";
            lDAPAttributeSet2.add(new LDAPAttribute(NS_SSL3, string3));
            lDAPAttributeSet2.add(new LDAPAttribute(NS_SSL3_CIPHERS, this.cipherPrefs + "," + this.cipherPrefsTLS));
            lDAPAttributeSet2.add(new LDAPAttribute(NS_SSL2, string3));
            lDAPAttributeSet2.add(new LDAPAttribute(NS_SSL2_CIPHERS, this.cipherPrefsSslV2));
            LDAPEntry lDAPEntry2 = new LDAPEntry(string4, lDAPAttributeSet2);
            EncryptionConfigData.addOrModifyLDAPEntry(lDAPConnection, lDAPEntry2);
            Enumeration enumeration = this.cipherSetupTable.keys();
            while (enumeration.hasMoreElements()) {
                CipherSetup cipherSetup = (CipherSetup)this.cipherSetupTable.get(enumeration.nextElement());
                LDAPAttributeSet lDAPAttributeSet3 = new LDAPAttributeSet();
                if (cipherSetup.getSelectedDevice().length() >= 1) {
                    lDAPAttributeSet3.add(new LDAPAttribute(NS_SSL_TOKEN, cipherSetup.getSelectedDevice()));
                }
                if (cipherSetup.getSelectedCertificate().length() >= 1) {
                    lDAPAttributeSet3.add(new LDAPAttribute(NS_SSL_PERSONALITY_SSL, cipherSetup.getSelectedCertificate()));
                }
                String string6 = cipherSetup.isEnabled() && this.sslServerOn ? "on" : "off";
                lDAPAttributeSet3.add(new LDAPAttribute(NS_SSL_ACTIVATION, string6));
                String[] stringArray3 = new String[]{"top", NS_ENCRYPTION_MODULE};
                lDAPAttributeSet3.add(new LDAPAttribute("objectclass", stringArray3));
                String string7 = "cn=" + cipherSetup.getFamily() + "," + IDAR_ENCRYPTION_CONFIG_DN + string;
                LDAPEntry lDAPEntry3 = new LDAPEntry(string7, lDAPAttributeSet3);
                Debug.println((String)("EncryptionConfigData.writeToDirectory entry=" + lDAPEntry3));
                EncryptionConfigData.addOrModifyLDAPEntry(lDAPConnection, lDAPEntry3);
                Debug.println((int)0, (String)("EncryptionConfigData.writeToDirectory() Successfully wrote the following cipher prefs for dn: " + string7));
                Debug.println((int)0, (String)cipherSetup.toString());
            }
            this.error = false;
            this.dirty = false;
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("EncryptionConfigData.writeToDirectory: ERROR - Unable to write to directory :" + lDAPException.toString()));
            this.error = true;
            throw lDAPException;
        }
    }

    static void addOrModifyLDAPEntry(LDAPConnection lDAPConnection, LDAPEntry lDAPEntry) throws LDAPException {
        try {
            lDAPConnection.add(lDAPEntry);
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() != 68) {
                Debug.println((int)0, (String)("EncryptionPanel.addOrModifyEntry: exception for " + lDAPEntry));
                throw lDAPException;
            }
            Debug.println((String)("EncryptionConfigData.addOrModifyLDAPEntry: modify entry that already exist. entry=" + lDAPEntry.toString()));
            LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
            Enumeration enumeration = lDAPEntry.getAttributeSet().getAttributes();
            while (enumeration.hasMoreElements()) {
                LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
                lDAPModificationSet.add(2, lDAPAttribute);
            }
            lDAPConnection.modify(lDAPEntry.getDN(), lDAPModificationSet);
        }
    }

    public boolean initializationError() {
        return this.error;
    }

    public static String getAttrValue(LDAPEntry lDAPEntry, String string) {
        Enumeration enumeration;
        LDAPAttribute lDAPAttribute;
        if (lDAPEntry != null && (lDAPAttribute = lDAPEntry.getAttribute(string)) != null && (enumeration = lDAPAttribute.getStringValues()).hasMoreElements()) {
            return (String)enumeration.nextElement();
        }
        return "";
    }

    public boolean isSecurityIsDomestic() {
        return this.securityIsDomestic;
    }

    public void setSecurityIsDomestic(boolean bl) {
        if (this.securityIsDomestic != bl) {
            this.securityIsDomestic = bl;
            this.dirty = true;
        }
    }

    public CipherSetup findOrCreateCipherSetup(String string) {
        Debug.println((int)7, (String)"EncryptionConfigData.findOrCreateCipherSetup");
        CipherSetup cipherSetup = (CipherSetup)this.cipherSetupTable.get(string);
        if (cipherSetup == null) {
            cipherSetup = new CipherSetup();
            cipherSetup.setFamily(string);
            this.cipherSetupTable.put(cipherSetup.getFamily(), cipherSetup);
        }
        return cipherSetup;
    }

    public CipherSetup getCipher(String string) {
        return (CipherSetup)this.cipherSetupTable.get(string);
    }

    public boolean isCipherFamilyEnabled() {
        Enumeration enumeration = this.cipherSetupTable.keys();
        boolean bl = false;
        while (enumeration.hasMoreElements() && !bl) {
            CipherSetup cipherSetup = (CipherSetup)this.cipherSetupTable.get(enumeration.nextElement());
            bl = cipherSetup.isEnabled();
        }
        return bl;
    }

    public boolean areCipherFamiliesComplete() {
        Debug.println((int)5, (String)"EncryptionConfigData.areCipherFamiliesComplete()");
        Enumeration enumeration = this.cipherSetupTable.keys();
        boolean bl = true;
        Debug.println((int)5, (String)"EncryptionConfigData.areCipherFamiliesComplete(): Checking modules...");
        while (enumeration.hasMoreElements() && bl) {
            CipherSetup cipherSetup = (CipherSetup)this.cipherSetupTable.get(enumeration.nextElement());
            Debug.println((int)9, (String)("EncryptionConfigData.areCipherFamiliesComplete():  Family Name= " + cipherSetup.getFamily() + "\n"));
            Debug.println((int)9, (String)("EncryptionConfigData.areCipherFamiliesComplete():  Enabled= " + cipherSetup.isEnabled() + "\n"));
            Debug.println((int)9, (String)("EncryptionConfigData.areCipherFamiliesComplete():  hasDevice= " + cipherSetup.hasSelectedDevice() + "\n"));
            Debug.println((int)9, (String)("EncryptionConfigData.areCipherFamiliesComplete():  hasCertificate= " + cipherSetup.hasSelectedCertificate() + "\n"));
            if (cipherSetup.isEnabled()) {
                bl = cipherSetup.hasSelectedDevice() && cipherSetup.hasSelectedCertificate();
            }
            Debug.println((int)9, (String)("EncryptionConfigData.areCipherFamiliesComplete()=" + bl));
        }
        return bl;
    }

    public boolean areCipherFamiliesCompleteAndEnabled() {
        Debug.println((int)5, (String)"EncryptionConfigData.areCipherFamiliesCompleteAndEnabled()");
        Enumeration enumeration = this.cipherSetupTable.keys();
        boolean bl = false;
        Debug.println((int)5, (String)"EncryptionConfigData.areCipherFamiliesCompleteAndEnabled(): Checking modules...");
        while (enumeration.hasMoreElements() && !bl) {
            CipherSetup cipherSetup = (CipherSetup)this.cipherSetupTable.get(enumeration.nextElement());
            Debug.println((int)9, (String)("EncryptionConfigData.areCipherFamiliesCompleteAndEnabled():  Family Name= " + cipherSetup.getFamily() + "\n"));
            Debug.println((int)9, (String)("EncryptionConfigData.areCipherFamiliesCompleteAndEnabled():  Enabled= " + cipherSetup.isEnabled() + "\n"));
            Debug.println((int)9, (String)("EncryptionConfigData.areCipherFamiliesCompleteAndEnabled():  hasDevice= " + cipherSetup.hasSelectedDevice() + "\n"));
            Debug.println((int)9, (String)("EncryptionConfigData.areCipherFamiliesCompleteAndEnabled():  hasCertificate= " + cipherSetup.hasSelectedCertificate() + "\n"));
            if (cipherSetup.isEnabled()) {
                bl = cipherSetup.hasSelectedDevice() && cipherSetup.hasSelectedCertificate();
            }
            Debug.println((int)9, (String)("EncryptionConfigData.areCipherFamiliesCompleteAndEnabled()=" + bl));
        }
        return bl;
    }

    public boolean isSslServerOn() {
        Debug.println((int)5, (String)("EncryptionConfigData.isSslServerOn: " + this.sslServerOn));
        return this.sslServerOn;
    }

    public void setSslServerOn(boolean bl) {
        Debug.println((String)("EncryptionConfigData.setSslServerOn: " + bl));
        if (this.sslServerOn != bl) {
            this.sslServerOn = bl;
            this.dirty = true;
        }
    }

    public boolean isSsl3On() {
        return this.ssl3On;
    }

    public void setSsl3On(boolean bl) {
        if (this.ssl3On != bl) {
            this.ssl3On = bl;
            this.dirty = true;
        }
    }

    public boolean isSsl2On() {
        return this.ssl2On;
    }

    public void setSsl2On(boolean bl) {
        if (this.ssl2On != bl) {
            this.ssl2On = bl;
            this.dirty = true;
        }
    }

    private String getCipherPrefsByType(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.startsWith(TLS, 1)) {
                stringBuffer.append(",");
                stringBuffer.append(string4);
                continue;
            }
            stringBuffer2.append(",");
            stringBuffer2.append(string4);
        }
        if (string.equals(SSL3)) {
            string3 = stringBuffer2.toString().substring(1);
        } else if (string.equals(TLS)) {
            string3 = stringBuffer.toString().substring(1);
        }
        return string3;
    }

    public String getCipherPrefs() {
        return this.cipherPrefs;
    }

    public void setCipherPrefs(String string) {
        Debug.println((int)9, (String)("EncryptionConfigData.setCipherPrefs(" + string + ")"));
        if (this.cipherPrefs != null && !this.cipherPrefs.equals(string) || this.cipherPrefs == null && string != null) {
            this.cipherPrefs = string;
            this.dirty = true;
        }
        Debug.println((int)9, (String)("EncryptionConfigData.setCipherPrefs dirty = " + this.dirty));
    }

    public String getCipherPrefsSslV2() {
        return this.cipherPrefsSslV2;
    }

    public void setCipherPrefsSslV2(String string) {
        Debug.println((int)9, (String)("EncryptionConfigData.setCipherPrefsSsl2(" + string + ")"));
        if (this.cipherPrefsSslV2 != null && !this.cipherPrefsSslV2.equals(string) || this.cipherPrefsSslV2 == null && string != null) {
            this.cipherPrefsSslV2 = string;
            this.dirty = true;
        }
    }

    public String getCipherPrefsTLS() {
        return this.cipherPrefsTLS;
    }

    public void setCipherPrefsTLS(String string) {
        Debug.println((int)9, (String)("EncryptionConfigData.setCipherPrefsTLS(" + string + ")"));
        if (this.cipherPrefsTLS != null && !this.cipherPrefsTLS.equals(string) || this.cipherPrefsTLS == null && string != null) {
            this.cipherPrefsTLS = string;
            this.dirty = true;
        }
        Debug.println((int)6, (String)("EncryptionConfigData.setCipherPrefsTLS dirty = " + this.dirty));
    }

    public boolean isDirty() {
        Debug.println((int)6, (String)("EncryptionConfigData.isDirty: this.dirty = " + this.dirty));
        return this.dirty;
    }
}

