#
# Copyright C 2002-2003 Sun Microsystems, Inc.
# All rights reserved. Use is subject to license terms.
#
# 
# Sun, Sun Microsystems, and the Sun logo are trademarks or registered
# trademarks of Sun Microsystems, Inc. in the United States and other
# countries.
# 
# Federal Acquisitions: Commercial Software--Government Users Subject to
# Standard License Terms and Conditions
#

#
# $Revision: 1.11.2.1 $ $Date: 2004/03/01 15:26:36 $
#

namespace eval dps52cfgUnix {

    proc emit { xName fName cName } {
	upvar $xName x
	
	set oName [file join $x(root) $fName]
	mkdir [file dirname $oName] 0755
	set oFile [dpsWriteOpen $oName 0755]
	
	puts $oFile "#!/bin/sh"
	puts $oFile "#"
	puts $oFile "# PROPRIETARY/CONFIDENTIAL. Use of this product is subject to"
	puts $oFile "# license terms. Copyright C 2001-2003 Sun Microsystems, Inc."
	puts $oFile "# All rights reserved."
	puts $oFile "#"
	puts $oFile "\"[file join $x(root) bin/base/jre/bin/java]\" -cp \"[file join $x(root) java/jars/dps522.jar]:[file join $x(root) java/ldapjdk.jar]:[file join $x(root) java/mcc52.jar]\" $cName \"\$@\""
	
	close $oFile
	
    }
    
    proc main { xName } {
	upvar $xName x
	
	emit x bin/dps_utilities/dpsconfig2ldif com.iplanet.idar.util.IDARPrintConfig
	emit x bin/dps_utilities/dpsldif2config com.iplanet.idar.task.ImportConfigurationLdif
	emit x bin/dps_utilities/migratefromidar50 com.iplanet.idar.util.MigrateConfig3

	if [spanInstall x] {
	    set cwd [pwd]
	    set javaJars [file join $x(currentInstallDirectory) java jars]
	    cd $javaJars
	    if [catch {glob dps*.jar} jarList] {
	    } else {
		cd [file join $x(root) java jars]
		foreach i $jarList {
		    catch {exec ln -s [file join $javaJars $i] $i} result
		}
	    }
	    cd $cwd
	}
	
	return 0
    }

}
