/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.task;

import com.iplanet.idar.task.AbstractTask;
import com.iplanet.idar.ui.task.TaskButton;
import java.awt.Component;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TaskButtonRenderer
implements TableCellRenderer,
TableCellEditor {
    protected Hashtable buttons = new Hashtable();
    protected transient Vector listeners = new Vector();
    protected JPanel emptyPanel = new JPanel();

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JComponent jComponent = this.emptyPanel;
        if (object != null && object instanceof AbstractTask) {
            AbstractTask abstractTask = (AbstractTask)object;
            TaskButton taskButton = (TaskButton)this.buttons.get(abstractTask);
            if (taskButton == null) {
                taskButton = new TaskButton(abstractTask);
                this.buttons.put(abstractTask, taskButton);
            }
            jComponent = taskButton;
        }
        return jComponent;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        return this.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        if (cellEditorListener != null && !this.listeners.contains(cellEditorListener)) {
            this.listeners.add(cellEditorListener);
        }
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        if (cellEditorListener != null) {
            this.listeners.remove(cellEditorListener);
        }
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public Object getCellEditorValue() {
        return null;
    }

    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    protected void fireEditingCanceled() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            CellEditorListener cellEditorListener = (CellEditorListener)enumeration.nextElement();
            cellEditorListener.editingCanceled(changeEvent);
        }
    }

    protected void fireEditingStopped() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            CellEditorListener cellEditorListener = (CellEditorListener)enumeration.nextElement();
            cellEditorListener.editingStopped(changeEvent);
        }
    }
}

