/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.task;

import com.iplanet.idar.task.AbstractTask;
import com.iplanet.idar.task.TaskAdapter;
import com.iplanet.idar.task.TaskEvent;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.JButtonFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JTable;

public class TaskButton
extends JButton {
    private static final String CANCEL = IDARResourceSet.getString("button", "CANCEL");
    ActionListener buttonListener;
    TaskAdapter taskListener;
    AbstractTask task;
    JTable table;

    public TaskButton(AbstractTask abstractTask) {
        this.task = abstractTask;
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TaskButton.this.task != null) {
                    if (TaskButton.this.task.isExecutable()) {
                        if (TaskButton.this.task.isExecuting()) {
                            TaskButton.this.task.cancel();
                        } else {
                            TaskButton.this.task.execute();
                        }
                    } else {
                        Debug.println((String)("TaskButton.actionPerformed: unexecutable " + TaskButton.this.task.getName() + " message=" + TaskButton.this.task.getUnexecutableMessage()));
                    }
                } else {
                    Debug.println((String)"TaskButton.actionPerformed: null task");
                }
            }
        });
        this.taskListener = new TaskAdapter(){

            public void taskExecutable(TaskEvent taskEvent) {
                TaskButton.this.updateButton();
            }

            public void taskUnexecutable(TaskEvent taskEvent) {
                TaskButton.this.updateButton();
            }

            public void taskEnabled(TaskEvent taskEvent) {
                TaskButton.this.updateButton();
            }

            public void taskDisabled(TaskEvent taskEvent) {
                TaskButton.this.updateButton();
            }

            public void taskStarted(TaskEvent taskEvent) {
                TaskButton.this.updateButton();
            }

            public void taskStopped(TaskEvent taskEvent) {
                TaskButton.this.updateButton();
            }
        };
        if (abstractTask != null) {
            abstractTask.addTaskListener(this.taskListener);
            this.setText(abstractTask.getName());
            JButtonFactory.initializeMnemonic((JButton)this);
            this.setToolTipText(abstractTask.getDescription());
        }
        this.updateButton();
    }

    private void updateButton() {
        if (this.task != null) {
            Debug.println((int)7, (String)("TaskButton.updateButton: task=" + this.task + " cancelable=" + this.task.isCancelable() + " executing=" + this.task.isExecuting() + " executable=" + this.task.isExecutable() + " enabled=" + this.task.isEnabled()));
            if (this.task.isExecuting()) {
                if (this.task.isCancelable()) {
                    this.setText(CANCEL);
                    this.setEnabled(true);
                } else {
                    this.setText(this.task.getName());
                    this.setEnabled(false);
                }
            } else {
                this.setText(this.task.getName());
                this.setEnabled(this.task.isExecutable() && this.task.isEnabled());
            }
            JButtonFactory.initializeMnemonic((JButton)this);
            this.repaint();
        }
    }
}

