/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.server.configuration;

import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.bean.IDARBean;
import com.iplanet.idar.objectmodel.bean.LogPropertyBean;
import com.iplanet.idar.objectmodel.bean.NoSuchBeanException;
import com.iplanet.idar.objectmodel.bean.RetrievalException;
import com.iplanet.idar.objectmodel.bean.SystemBean;
import com.iplanet.idar.objectmodel.bean.UnknownBeanTypeException;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.ImageFactory;
import com.iplanet.idar.ui.server.configuration.IDARLogView;
import com.iplanet.idar.ui.server.configuration.IDARServerNode;
import com.iplanet.idar.ui.server.configuration.LogFileNode;
import com.iplanet.idar.ui.server.configuration.ManagingConfigurationView;
import com.netscape.management.client.ResourceObject;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class LoggingNode
extends ResourceObject {
    private ConsoleInfo info;
    private IDARBean idarBean;
    private LogPropertyBean logBean;
    private SystemBean systemBean;
    private IDARLogView logView = null;
    private ManagingConfigurationView mView = null;
    private PropertyChangeListener logPropertyChangeListener = null;
    private PropertyChangeListener logFileNameListener = null;
    private LogFileNode errorLog;
    private LogFileNode auditLog;

    public LoggingNode(ConsoleInfo consoleInfo, IDARBean iDARBean, ManagingConfigurationView managingConfigurationView) {
        super(IDARResourceSet.getString("config", "LOGS"));
        this.mView = managingConfigurationView;
        this.info = consoleInfo;
        this.idarBean = iDARBean;
        this.systemBean = iDARBean.getSystemBean();
        this.logFileNameListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LoggingNode.this.setChildren(LoggingNode.this.logBean);
                TreeNode treeNode = LoggingNode.this.getRoot();
                if (treeNode instanceof IDARServerNode) {
                    ((IDARServerNode)((Object)treeNode)).treeStructureChanged(LoggingNode.this);
                }
            }
        };
        this.logPropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (LoggingNode.this.logBean != null) {
                    LoggingNode.this.logBean.removePropertyChangePersistanceListener("ids-proxy-con-log-file", LoggingNode.this.logFileNameListener);
                    LoggingNode.this.logBean.removePropertyChangePersistanceListener("ids-proxy-con-audit-file", LoggingNode.this.logFileNameListener);
                }
                LoggingNode.this.logBean = LoggingNode.this.getLogPropertyBean(LoggingNode.this.systemBean);
                if (LoggingNode.this.logBean != null) {
                    LoggingNode.this.logBean.addPropertyChangePersistanceListener("ids-proxy-con-log-file", LoggingNode.this.logFileNameListener);
                    LoggingNode.this.logBean.addPropertyChangePersistanceListener("ids-proxy-con-audit-file", LoggingNode.this.logFileNameListener);
                    LoggingNode.this.setChildren(LoggingNode.this.logBean);
                }
            }
        };
        if (this.systemBean != null) {
            this.systemBean.addPropertyChangePersistanceListener("ids-proxy-con-include-logproperty", this.logPropertyChangeListener);
            this.logBean = this.getLogPropertyBean(this.systemBean);
        }
        this.setAllowsChildren(true);
        this.setChildren(this.logBean);
    }

    public void setChildren(LogPropertyBean logPropertyBean) {
        TreeNode treeNode;
        Debug.println((int)6, (String)("LoggingNode.setChildren: bean=" + logPropertyBean));
        if (this.errorLog == null) {
            this.errorLog = new LogFileNode(this.info, IDARResourceSet.getString("propertyLogOutput", "LOG_FILE"), this.idarBean.getRetrieveLogRecordsTask());
            this.add((MutableTreeNode)((Object)this.errorLog));
        }
        String string = "";
        if (logPropertyBean != null) {
            string = logPropertyBean.getAuditFileName();
        }
        if (this.auditLog == null) {
            if (string != null && !string.trim().equals("")) {
                this.auditLog = new LogFileNode(this.info, IDARResourceSet.getString("propertyLogOutput", "AUDIT_FILE"), this.idarBean.getRetrieveAuditRecordsTask());
                this.add((MutableTreeNode)((Object)this.auditLog));
            }
        } else if (string == null || string.trim().equals("")) {
            this.remove((MutableTreeNode)((Object)this.auditLog));
            this.auditLog = null;
        }
        if ((treeNode = this.getRoot()) instanceof IDARServerNode) {
            ((IDARServerNode)((Object)treeNode)).treeStructureChanged(this);
        }
    }

    public LogPropertyBean getLogPropertyBean(SystemBean systemBean) {
        LogPropertyBean logPropertyBean = null;
        if (systemBean != null) {
            try {
                String string = systemBean.getLogPropertyId();
                logPropertyBean = (LogPropertyBean)BeanSpace.getInstance().retrieveBean(string, "log", systemBean.getParentConfiguration());
                if (logPropertyBean != null) {
                    logPropertyBean.addPropertyChangePersistanceListener("ids-proxy-con-log-file", this.logFileNameListener);
                    logPropertyBean.addPropertyChangePersistanceListener("ids-proxy-con-audit-file", this.logFileNameListener);
                }
            }
            catch (RetrievalException retrievalException) {
                Debug.println((int)0, (String)("ERROR: UNABLE TO RETRIEVE DATA: " + retrievalException.getLocalizedMessage()));
            }
            catch (UnknownBeanTypeException unknownBeanTypeException) {
                unknownBeanTypeException.printStackTrace();
            }
            catch (NoSuchBeanException noSuchBeanException) {
                noSuchBeanException.printStackTrace();
            }
        }
        return logPropertyBean;
    }

    public Icon getIcon() {
        return ImageFactory.getImage("LOG_FILES");
    }

    public Component getCustomPanel() {
        if (this.logView == null) {
            this.logView = new IDARLogView(this.info, this.idarBean);
            this.logView.setBorder(BorderFactory.createRaisedBevelBorder());
            this.mView.addView(this.logView);
        }
        this.mView.showView(this.logView.getTitleText());
        return this.mView;
    }
}

