/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.server.configuration;

import com.iplanet.idar.objectmodel.bean.CipherSetup;
import com.iplanet.idar.objectmodel.bean.EncryptionConfigData;
import com.iplanet.idar.objectmodel.bean.IDARBean;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.common.components.IDARJButtonFactory;
import com.iplanet.idar.ui.common.configuration.BlankPanelEvent;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.iplanet.idar.ui.common.configuration.LoadErrorPanel;
import com.iplanet.idar.ui.server.configuration.IDARCipherPreferenceDialog;
import com.iplanet.idar.ui.server.configuration.IDARServerNode;
import com.netscape.management.client.Framework;
import com.netscape.management.client.IFramework;
import com.netscape.management.client.components.ButtonFactory;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.security.EncryptionOptions;
import com.netscape.management.client.security.EncryptionPanel;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import netscape.ldap.LDAPException;

public class IDAREncryptionPanel
extends ConfigurationView
implements EncryptionOptions,
SuiConstants {
    private EncryptionPanel pnlEncryption;
    private static final String TITLE = IDARResourceSet.getString("encryptionConfiguration", "TITLE");
    private static final String UNKNOWN_CONFIG_MESSAGE = IDARResourceSet.getString("error", "UNKNOWN_CONFIG_MESSAGE");
    private static final String UNKNOWN_CONFIG_TITLE = IDARResourceSet.getString("error", "UNKNOWN_CONFIG_TITLE");
    private static final String NO_CONFIGURATION = IDARResourceSet.getString("error", "ERR_NO_CONFIGURATION");
    private static final String NO_SYSTEM = IDARResourceSet.getString("error", "ERR_NO_SYSTEM");
    private static final String HELP_TOPIC = "System-Encryption";
    private Framework configFramework;
    private String currentConfig = null;
    private IDARServerNode node;
    private EncryptionConfigData encryptConfig;
    private JButton butRefresh;
    private CardLayout cardLayout;
    private JPanel pnlLoading;
    private JPanel pnlContent;
    protected static final String CONTENT = "content";
    protected static final String LOAD = "load";

    public IDAREncryptionPanel() {
        Debug.println((int)6, (String)"IDAREncryptionPanel");
    }

    public void setDataModel(IDARModelBean iDARModelBean, boolean bl) {
        Debug.println((int)7, (String)"IDAREncryptionPanel.setDataModel");
        if (iDARModelBean != null) {
            IDARBean iDARBean = (IDARBean)iDARModelBean;
            this.encryptConfig = iDARBean.getEncryptionData();
            if (this.encryptConfig.initializationError()) {
                this.initError();
            } else {
                this.initEncryptionPanel();
            }
        }
        super.setDataModel(iDARModelBean, bl);
    }

    protected String getSIE(ConsoleInfo consoleInfo) {
        String string = consoleInfo.getCurrentDN();
        Debug.println((int)6, (String)("IDAREncryptionPanel.getSIE: currentDN= " + string));
        return string.substring(string.indexOf("cn=") + 3, string.indexOf(","));
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    public void resetContent() throws ConfigurationViewException {
        Debug.println((int)5, (String)"IDAREncryptionPanel.resetContent");
        Debug.println((int)9, (String)("IDAREncryptionPanel.resetContent before isSecurityEnabled()=" + this.isSecurityEnabled()));
        if (this.pnlEncryption != null) {
            this.pnlEncryption.reset();
        }
        Debug.println((int)9, (String)("IDAREncryptionPanel.resetContent after isSecurityEnabled()=" + this.isSecurityEnabled()));
    }

    public void applyChanges() throws ConfigurationViewException {
        Debug.println((int)5, (String)"IDAREncryptionPanel.applyChanges");
        IDARBean iDARBean = (IDARBean)this.getDataModel();
        if (iDARBean != null) {
            if (this.encryptConfig.isSslServerOn()) {
                if (!this.encryptConfig.areCipherFamiliesComplete()) {
                    Debug.println((int)5, (String)("IDAREncryptionPanel.applyChanges: ERROR-" + IDARResourceSet.getString("error", "ERR_CIPHER_INCOMPLETE")));
                    throw new ConfigurationViewException(IDARResourceSet.getString("error", "ERR_CIPHER_INCOMPLETE"));
                }
                if (!this.encryptConfig.areCipherFamiliesCompleteAndEnabled()) {
                    Debug.println((int)5, (String)("IDAREncryptionPanel.applyChanges: ERROR-" + IDARResourceSet.getString("error", "ERR_SSL_NO_CIPHERS")));
                    throw new ConfigurationViewException(IDARResourceSet.getString("error", "ERR_SSL_NO_CIPHERS"));
                }
                if (iDARBean.getSystemBean().getLdapsPort() == null) {
                    Debug.println((int)5, (String)("IDAREncryptionPanel.applyChanges: ERROR-" + IDARResourceSet.getString("error", "ERR_NO_SPORT")));
                    throw new ConfigurationViewException(IDARResourceSet.getString("error", "ERR_NO_SPORT"));
                }
                Debug.println((int)5, (String)"IDAREncryptionPanel.applyChanges: OK to save.");
                if (!IDARUtilities.isPINFilePresent(iDARBean)) {
                    JOptionPane.showMessageDialog(IDARUtilities.getParentFrame(this), IDARResourceSet.getString("encryptionConfiguration", "SSL_ENABLED_WARNING_MSG"), IDARResourceSet.getString("encryptionConfiguration", "SSL_ENABLED_WARNING_TITLE"), 2);
                }
            } else {
                if (iDARBean.getSystemBean().getLdapsPort() != null) {
                    Debug.println((int)5, (String)("IDAREncryptionPanel.applyChanges: ERROR-" + IDARResourceSet.getString("error", "ERR_SSL_NOT_ENABLED")));
                    throw new ConfigurationViewException(IDARResourceSet.getString("error", "ERR_SSL_NOT_ENABLED"));
                }
                Debug.println((int)0, (String)"IDAREncryptionPanel.applyChanges: ERROR-Unable to determine settings!");
            }
            iDARBean.setEncryptionData(this.encryptConfig);
            this.pnlEncryption.setSaved();
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return TITLE;
    }

    protected void initComponents() {
        Debug.println((int)6, (String)"IDAREncryptionPanel.initComponents");
        this.initEncryptionPanel();
    }

    protected void initError() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        LoadErrorPanel loadErrorPanel = new LoadErrorPanel();
        loadErrorPanel.addReloadButtonActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleInfo consoleInfo = IDAREncryptionPanel.this.getConsoleInfo();
                IDARBean iDARBean = (IDARBean)IDAREncryptionPanel.this.getDataModel();
                if (iDARBean != null && consoleInfo != null) {
                    try {
                        IDAREncryptionPanel.this.encryptConfig.readFromDirectory(consoleInfo.getLDAPConnection(), iDARBean.getSelfReference().getHandle());
                        IDAREncryptionPanel.this.initEncryptionPanel();
                    }
                    catch (LDAPException lDAPException) {
                        if (Debug.isEnabled()) {
                            lDAPException.printStackTrace();
                        }
                        JOptionPane.showMessageDialog(IDARUtilities.getParentFrame(IDAREncryptionPanel.this), IDARResourceSet.getString("error", "ENCRYPTION_CONFIG_LOAD_ERROR"), IDARResourceSet.getString("error", "TITLE"), 0);
                    }
                }
            }
        });
        this.add((Component)loadErrorPanel, "Center");
    }

    protected void initEncryptionPanel() {
        Debug.println((int)6, (String)"IDAREncryptionPanel.initEncryptionPanel");
        this.removeAll();
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        this.pnlLoading = this.createLoadPanel();
        this.pnlContent = this.createContentPanel();
        this.add(LOAD, this.pnlLoading);
        this.add(CONTENT, this.pnlContent);
        this.cardLayout.show(this, CONTENT);
    }

    private JPanel createLoadPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel(IDARResourceSet.getString("general", "LOADING"), 0), "Center");
        return jPanel;
    }

    private EncryptionPanel createEncryptionPanel() {
        Debug.println((int)5, (String)"IDAREncryptionPanel.createEncryptionPanel()");
        ConsoleInfo consoleInfo = this.getConsoleInfo();
        String string = null;
        EncryptionPanel encryptionPanel = null;
        if (consoleInfo != null) {
            string = this.getSIE(consoleInfo);
        } else {
            Debug.println((int)0, (String)("IDAREncryptionPanel.initEncryptionPanel: ERROR - ConsoleInfo = " + consoleInfo));
        }
        if (string != null) {
            Debug.println((int)9, (String)"IDAREncryptionPanel.createEncryptionPanel(): creating new encryption panel now...");
            encryptionPanel = new EncryptionPanel(consoleInfo, string, (EncryptionOptions)this);
            Debug.println((int)9, (String)"IDAREncryptionPanel.createEncryptionPanel(): creating new encryption panel now...done");
        } else {
            Debug.println((int)0, (String)("IDAREncryptionPanel.initEncryptionPanel: sie=" + string));
        }
        return encryptionPanel;
    }

    private JPanel createContentPanel() {
        Debug.println((int)9, (String)"IDAREncryptionPanel.createContentPanel()");
        this.pnlEncryption = this.createEncryptionPanel();
        JPanel jPanel = new JPanel();
        this.butRefresh = IDARJButtonFactory.create(IDARResourceSet.getString("serverLogView", "REFRESH"));
        ButtonFactory.resizeButton((JButton)this.butRefresh);
        this.butRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IDAREncryptionPanel.this.cardLayout.show(IDAREncryptionPanel.this, IDAREncryptionPanel.LOAD);
                if (!SwingUtilities.isEventDispatchThread()) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(this){
                            private final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                2.access$200(this.this$1).paintImmediately(2.access$200(this.this$1).getVisibleRect());
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                } else {
                    IDAREncryptionPanel.this.paintImmediately(IDAREncryptionPanel.this.getVisibleRect());
                }
                EncryptionDataLoader encryptionDataLoader = new EncryptionDataLoader();
                encryptionDataLoader.setPriority(3);
                encryptionDataLoader.start();
            }

            static /* synthetic */ IDAREncryptionPanel access$200(2 var0) {
                return var0.IDAREncryptionPanel.this;
            }
        });
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this.butRefresh, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.pnlEncryption, gridBagConstraints);
        return jPanel;
    }

    public void commenceProgressBar() {
        Debug.println((int)6, (String)"IDAREncryptionView.commenceProgressBar");
        final IFramework iFramework = IDARUtilities.getFramework(this);
        if (iFramework != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    iFramework.changeStatusItemState("StatusItemProgress", (Object)new Integer(-1));
                }
            });
        }
    }

    public void stopProgressBar() {
        Debug.println((int)6, (String)"IDAREncryptionView.stopProgressBar");
        IFramework iFramework = null;
        iFramework = IDARUtilities.getFramework(this);
        if (iFramework != null) {
            iFramework.changeStatusItemState("StatusItemProgress", (Object)new Integer(0));
        }
    }

    public void showCipherPreferenceDialog(String string) {
        Frame frame = IDARUtilities.getParentFrame(this);
        Debug.println((int)6, (String)("IDAREncryptionPanel.showCipherPreferenceDialog: cipher = " + string));
        CipherSetup cipherSetup = this.encryptConfig.getCipher(string);
        Debug.println((int)9, (String)"IDAREncryptionPanel.showCipherPreferenceDialog: setting dialog to the following cipher settings: \n");
        Debug.println((int)9, (String)("IDAREncryptionPanel.showCipherPreferenceDialog: ****SSLV2****\n" + this.encryptConfig.getCipherPrefsSslV2() + "\n"));
        Debug.println((int)9, (String)("IDAREncryptionPanel.showCipherPreferenceDialog: ****SSLV3****\n" + this.encryptConfig.getCipherPrefs() + "\n"));
        Debug.println((int)9, (String)("IDAREncryptionPanel.showCipherPreferenceDialog: ****TLS****\n" + this.encryptConfig.getCipherPrefsTLS() + "\n"));
        IDARCipherDialog iDARCipherDialog = new IDARCipherDialog(frame, this.encryptConfig.getCipherPrefsSslV2(), this.encryptConfig.getCipherPrefs(), this.encryptConfig.getCipherPrefsTLS());
        Debug.println((int)9, (String)"IDAREncryptionPanel.showCipherPreferenceDialog: retieving the following cipher settings from dialog: \n");
        Debug.println((int)9, (String)("IDAREncryptionPanel.showCipherPreferenceDialog: ****SSLV2****\n" + this.encryptConfig.getCipherPrefsSslV2() + "\n"));
        Debug.println((int)9, (String)("IDAREncryptionPanel.showCipherPreferenceDialog: ****SSLV3****\n" + this.encryptConfig.getCipherPrefs() + "\n"));
        Debug.println((int)9, (String)("IDAREncryptionPanel.showCipherPreferenceDialog: ****TLS****\n" + this.encryptConfig.getCipherPrefsTLS() + "\n"));
        iDARCipherDialog.showModal();
        if (!iDARCipherDialog.isCancel()) {
            this.encryptConfig.setCipherPrefs(iDARCipherDialog.getCipherPreference("V3"));
            this.encryptConfig.setCipherPrefsSslV2(iDARCipherDialog.getCipherPreference("V2"));
            this.encryptConfig.setCipherPrefsTLS(iDARCipherDialog.getCipherPreference("TLS"));
        }
    }

    public void showContent() {
        this.cardLayout.show(this, CONTENT);
        this.paintImmediately(this.getVisibleRect());
    }

    public boolean isSecurityEnabled() {
        Debug.println((int)5, (String)("IDAREncryptionPanel.isSecurityEnabled = " + this.encryptConfig.isSslServerOn()));
        return this.encryptConfig.isSslServerOn();
    }

    public void securityEnabledChanged(boolean bl) {
        Debug.println((int)5, (String)("IDAREncryptionPanel.securityEnabledChanged: enable = " + bl));
        this.encryptConfig.setSslServerOn(bl);
        this.fireBlankPanelEvent(new BlankPanelEvent("IDAREncryptionPanel.securityEnabledChanged"));
    }

    public boolean isCipherFamilyEnabled(String string) {
        Debug.println((int)5, (String)("IDAREncryptionPanel.isCipherFamilyEnabled: cipher = " + string));
        CipherSetup cipherSetup = this.encryptConfig.getCipher(string);
        return cipherSetup != null && cipherSetup.isEnabled();
    }

    public void cipherFamilyEnabledChanged(String string, boolean bl) {
        Debug.println((int)5, (String)("IDAREncryptionPanel.cipherFamilyEnabledChanged: cipher = " + string + ", enabled = " + bl));
        CipherSetup cipherSetup = this.encryptConfig.findOrCreateCipherSetup(string);
        cipherSetup.setEnabled(bl);
        this.fireBlankPanelEvent(new BlankPanelEvent("IDAREncryptionPanel.cipherFamilyEnabledChanged"));
    }

    public String getSelectedCertificate(String string) {
        Debug.println((int)5, (String)("IDAREncryptionPanel.getSelectedCertificate: cipher = " + string));
        CipherSetup cipherSetup = this.encryptConfig.getCipher(string);
        return cipherSetup == null ? null : cipherSetup.getSelectedCertificate();
    }

    public void selectedCertificateChanged(String string, String string2) {
        Debug.println((int)5, (String)("IDAREncryptionPanel.selectedCertificateChanged: cipher = " + string + ", cert = " + string2));
        CipherSetup cipherSetup = this.encryptConfig.findOrCreateCipherSetup(string);
        cipherSetup.setSelectedCertificate(string2);
        this.fireBlankPanelEvent(new BlankPanelEvent("IDAREncryptionPanel.selectedCertificateChanged"));
    }

    public String getSelectedDevice(String string) {
        Debug.println((int)5, (String)("IDAREncryptionPanel.getSelectedDevice: cipher = " + string));
        CipherSetup cipherSetup = this.encryptConfig.getCipher(string);
        return cipherSetup == null ? null : cipherSetup.getSelectedDevice();
    }

    public void selectedDeviceChanged(String string, String string2) {
        Debug.println((int)5, (String)("IDAREncryptionPanel.selectedDeviceChanged: cipher = " + string + ", dev = " + string2));
        CipherSetup cipherSetup = this.encryptConfig.findOrCreateCipherSetup(string);
        cipherSetup.setSelectedDevice(string2);
        this.fireBlankPanelEvent(new BlankPanelEvent("IDAREncryptionPanel.selectedDeviceChanged"));
    }

    public void setSecurityIsDomestic(boolean bl) {
        Debug.println((int)5, (String)("IDAREncryptionPanel.setSecurityIsDomestic: yes = " + bl));
        this.encryptConfig.setSecurityIsDomestic(bl);
    }

    class IDARCipherDialog
    extends IDARCipherPreferenceDialog {
        public IDARCipherDialog(Frame frame, String string, String string2, String string3) {
            super(frame, string, string2, string3);
        }

        public void cipherStateChanged(String string, String string2, boolean bl) {
            Debug.println((int)7, (String)("IDARCipherDialog.cipherStateChanged: cipher=" + string2 + ":" + bl));
            IDAREncryptionPanel.this.fireBlankPanelEvent(new BlankPanelEvent("IDARCipherDialog.cipherStateChanged"));
        }
    }

    class EncryptionDataLoader
    extends Thread {
        EncryptionDataLoader() {
            this.setName("EncryptionDataLoader");
        }

        public void run() {
            Debug.println((int)9, (String)"IDAREncryptionPanel.EncryptionDataLoader.run");
            IDAREncryptionPanel.this.commenceProgressBar();
            IDAREncryptionPanel.this.remove(IDAREncryptionPanel.this.pnlContent);
            ConsoleInfo consoleInfo = IDAREncryptionPanel.this.getConsoleInfo();
            IDARBean iDARBean = (IDARBean)IDAREncryptionPanel.this.getDataModel();
            if (iDARBean != null && consoleInfo != null) {
                try {
                    IDAREncryptionPanel.this.encryptConfig.readFromDirectory(consoleInfo.getLDAPConnection(), iDARBean.getSelfReference().getHandle());
                }
                catch (LDAPException lDAPException) {
                    Debug.println((int)0, (String)"IDAREncryptionPanel.EncryptionDataLoader.run: LDAP ERROR RELOADING DATA\n");
                    Debug.println((int)0, (String)"IDAREncryptionPanel.EncryptionDataLoader.run: SERVER RETURN THIS MESSAGE:\n");
                    Debug.println((int)0, (String)("IDAREncryptionPanel.EncryptionDataLoader.run: " + lDAPException.getMessage() + "\n"));
                }
            }
            IDAREncryptionPanel.this.pnlContent = IDAREncryptionPanel.this.createContentPanel();
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ EncryptionDataLoader this$1;
                {
                    this.this$1 = encryptionDataLoader;
                }

                public void run() {
                    EncryptionDataLoader.access$500(this.this$1).stopProgressBar();
                    Debug.println((int)9, (String)"IDAREncryptionPanel.EncryptionDataLoader.run: adding new panel to content...");
                    EncryptionDataLoader.access$500(this.this$1).add("content", IDAREncryptionPanel.access$300(EncryptionDataLoader.access$500(this.this$1)));
                    EncryptionDataLoader.access$500(this.this$1).showContent();
                    Debug.println((int)9, (String)"IDAREncryptionPanel.EncryptionDataLoader.run: done. ");
                }
            });
        }

        static /* synthetic */ IDAREncryptionPanel access$500(EncryptionDataLoader encryptionDataLoader) {
            return encryptionDataLoader.IDAREncryptionPanel.this;
        }
    }
}

