/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.system;

import com.iplanet.idar.objectmodel.bean.SystemBean;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class UnixPropertiesView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "System-Settings-Unix";
    private BlankPanel pnlUnixSettings;
    private JLabel lblUserID;
    private JTextField tfUserID;
    private JTextField tfWorkingDirectory;
    private JLabel lblWorkingDirectory;

    public UnixPropertiesView() {
        this((ConsoleInfo)null);
    }

    public UnixPropertiesView(ConsoleInfo consoleInfo) {
        this.setConsoleInfo(consoleInfo);
        this.initComponents();
    }

    public UnixPropertiesView(ConsoleInfo consoleInfo, SystemBean systemBean) {
        this.setConsoleInfo(consoleInfo);
        this.setDataModel(systemBean);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            // empty catch block
        }
    }

    public void resetContent() throws ConfigurationViewException {
        SystemBean systemBean = (SystemBean)this.getDataModel();
        if (systemBean != null) {
            this.setViewEnabled(true);
            this.tfUserID.setText(systemBean.getUserId());
            this.tfWorkingDirectory.setText(systemBean.getWorkingDirectory());
        } else {
            this.setViewEnabled(false);
        }
    }

    public void applyChanges() throws ConfigurationViewException {
        SystemBean systemBean = (SystemBean)this.getDataModel();
        if (systemBean != null) {
            systemBean.setUserId(this.tfUserID.getText());
            systemBean.setWorkingDirectory(this.tfWorkingDirectory.getText());
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("systemSettings", "UNIX");
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    private void setViewEnabled(boolean bl) {
        this.setEnabled(bl);
        this.tfUserID.setEnabled(bl);
        this.tfWorkingDirectory.setEnabled(bl);
        this.pnlUnixSettings.setEnabled(bl);
        this.lblUserID.setEnabled(bl);
        this.lblWorkingDirectory.setEnabled(bl);
        if (bl) {
            ((TitledBorder)this.pnlUnixSettings.getBorder()).setTitleColor(Color.black);
            this.tfUserID.setBackground(Color.white);
            this.tfWorkingDirectory.setBackground(Color.white);
        } else {
            ((TitledBorder)this.pnlUnixSettings.getBorder()).setTitleColor(Color.gray);
            this.tfUserID.setBackground(null);
            this.tfWorkingDirectory.setBackground(null);
        }
    }

    protected void initComponents() {
        this.pnlUnixSettings = new BlankPanel();
        this.pnlUnixSettings.addBlankPanelListener(this);
        this.lblUserID = new JLabel(IDARResourceSet.getString("systemSettings", "USER_ID") + ":");
        this.tfUserID = new JTextField();
        this.tfWorkingDirectory = new JTextField();
        this.lblWorkingDirectory = new JLabel(IDARResourceSet.getString("systemSettings", "WORKING_DIRECTORY") + ":");
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.pnlUnixSettings.setLayout(new GridBagLayout());
        this.pnlUnixSettings.setBorder(new TitledBorder(IDARResourceSet.getString("systemSettings", "UNIX_PROPERTIES")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 13;
        this.pnlUnixSettings.add((Component)this.lblUserID, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlUnixSettings.add((Component)this.tfUserID, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 13;
        this.pnlUnixSettings.add((Component)this.lblWorkingDirectory, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlUnixSettings.add((Component)this.tfWorkingDirectory, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlUnixSettings, gridBagConstraints);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new UnixPropertiesView(new ConsoleInfo(), null));
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

