/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.rule;

import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.OnSSLRuleBean;
import com.iplanet.idar.objectmodel.bean.UniqueNameException;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.ImageFactory;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.iplanet.idar.ui.configurator.rule.ActionToExecuteView;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.TitlePanel;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class OnSSLRuleView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "Event-OnSSL";
    private ConsoleInfo info;
    private OnSSLRuleBean model;
    private ConfigurationView viewRule;
    private TitlePanel pnlTitle;
    private JLabel lblName;
    private JTextField tfName;

    public OnSSLRuleView() {
        this.initComponents();
    }

    public OnSSLRuleView(ConsoleInfo consoleInfo, OnSSLRuleBean onSSLRuleBean) {
        this.initComponents();
        this.setConsoleInfo(consoleInfo);
        this.setDataModel(onSSLRuleBean);
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            configurationViewException.printStackTrace();
        }
    }

    public void setDataModel(IDARModelBean iDARModelBean, boolean bl) {
        super.setDataModel(iDARModelBean, bl);
        this.viewRule.setDataModel(iDARModelBean);
    }

    public void setConsoleInfo(ConsoleInfo consoleInfo) {
        super.setConsoleInfo(consoleInfo);
        if (this.viewRule != null) {
            this.viewRule.setConsoleInfo(consoleInfo);
        }
    }

    protected void initComponents() {
        this.pnlTitle = new TitlePanel();
        this.pnlTitle.setIcon((Icon)ImageFactory.getImage("RULE"));
        this.pnlTitle.setText(IDARResourceSet.getString("ruleOnSSL", "TITLE"));
        this.tfName = new JTextField();
        this.lblName = new JLabel(IDARResourceSet.getString("ruleGeneral", "RULE_NAME") + ":");
        this.lblName.setLabelFor(this.tfName);
        this.viewRule = new ActionToExecuteView();
        this.viewRule.addBlankPanelListener(this);
        this.viewRule.setBorder(BorderFactory.createTitledBorder(this.viewRule.getTitleText()));
        BlankPanel blankPanel = new BlankPanel();
        blankPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        blankPanel.add((Component)this.pnlTitle, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        blankPanel.add((Component)this.lblName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.insets.right = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        blankPanel.add((Component)this.tfName, gridBagConstraints);
        this.setLayout(new BorderLayout());
        this.add((Component)blankPanel, "North");
        this.add((Component)this.viewRule.getPanel(), "Center");
    }

    public void resetContent() throws ConfigurationViewException {
        IDARModelBean iDARModelBean = super.getDataModel();
        if (iDARModelBean != null) {
            this.tfName.setText(iDARModelBean.getId());
            this.viewRule.resetContent();
        }
    }

    public void applyChanges() throws ConfigurationViewException {
        if (this.tfName.getText().trim().equals("")) {
            throw new ConfigurationViewException(IDARResourceSet.getString("error", "ERR_NO_ID"));
        }
        OnSSLRuleBean onSSLRuleBean = (OnSSLRuleBean)super.getDataModel();
        if (onSSLRuleBean != null && !onSSLRuleBean.getName().equals(this.tfName.getText())) {
            try {
                onSSLRuleBean.setName(this.tfName.getText());
            }
            catch (UniqueNameException uniqueNameException) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "UNIQUE_NAME", this.tfName.getText()));
            }
        }
        this.viewRule.applyChanges();
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("ruleOnSSL", "TITLE");
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    public void setData() {
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new OnSSLRuleView(null, null));
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

