/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.rule;

import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.OnBindRuleBean;
import com.iplanet.idar.objectmodel.bean.UniqueNameException;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.ImageFactory;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.iplanet.idar.ui.configurator.rule.ActionToExecuteView;
import com.iplanet.idar.ui.configurator.rule.SettingsView;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.TitlePanel;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class OnBindRuleView
extends ConfigurationView
implements SuiConstants {
    private OnBindRuleBean model;
    private JLabel lblName;
    private JTextField tfName;
    private TitlePanel pnlTitle;
    private JTabbedPane tabViews;
    private ActionToExecuteView viewRule;
    private ConfigurationView viewSettings;

    public OnBindRuleView() {
        this.initComponents();
    }

    public OnBindRuleView(ConsoleInfo consoleInfo, OnBindRuleBean onBindRuleBean) {
        this.initComponents();
        this.setConsoleInfo(consoleInfo);
        this.setDataModel(onBindRuleBean);
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            configurationViewException.printStackTrace();
        }
    }

    public void setDataModel(IDARModelBean iDARModelBean, boolean bl) {
        super.setDataModel(iDARModelBean, bl);
        this.viewRule.setDataModel(iDARModelBean);
        this.viewSettings.setDataModel(iDARModelBean);
    }

    public void setConsoleInfo(ConsoleInfo consoleInfo) {
        super.setConsoleInfo(consoleInfo);
        if (this.viewRule != null) {
            this.viewRule.setConsoleInfo(consoleInfo);
            this.viewSettings.setConsoleInfo(consoleInfo);
        }
    }

    protected void initComponents() {
        Border border = BorderFactory.createEmptyBorder(9, 9, 9, 9);
        this.setBorder(border);
        this.pnlTitle = new TitlePanel();
        this.pnlTitle.setIcon((Icon)ImageFactory.getImage("RULE"));
        this.pnlTitle.setText(IDARResourceSet.getString("ruleOnBind", "TITLE"));
        this.tfName = new JTextField();
        this.lblName = new JLabel(IDARResourceSet.getString("ruleGeneral", "RULE_NAME") + ":");
        this.lblName.setLabelFor(this.tfName);
        this.tabViews = new JTabbedPane();
        this.viewRule = new ActionToExecuteView();
        this.viewRule.setNote(IDARResourceSet.getString("ruleOnBind", "NOTE"));
        this.viewSettings = new SettingsView();
        this.viewRule.addBlankPanelListener(this);
        this.viewSettings.addBlankPanelListener(this);
        this.tabViews.addTab(this.viewRule.getTitleText(), null, this.viewRule.getPanel());
        this.tabViews.addTab(this.viewSettings.getTitleText(), null, this.viewSettings.getPanel());
        this.setLayout(new BorderLayout());
        BlankPanel blankPanel = new BlankPanel();
        blankPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        blankPanel.add((Component)this.pnlTitle, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        blankPanel.add((Component)this.lblName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.insets.right = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        blankPanel.add((Component)this.tfName, gridBagConstraints);
        this.add((Component)blankPanel, "North");
        this.add((Component)this.tabViews, "Center");
    }

    public String getHelpTopic() {
        return ((ConfigurationView)this.tabViews.getSelectedComponent()).getHelpTopic();
    }

    public void resetContent() throws ConfigurationViewException {
        IDARModelBean iDARModelBean = super.getDataModel();
        if (iDARModelBean != null) {
            this.tfName.setText(iDARModelBean.getId());
            this.viewRule.resetContent();
            this.viewSettings.resetContent();
        }
    }

    public void applyChanges() throws ConfigurationViewException {
        OnBindRuleBean onBindRuleBean = (OnBindRuleBean)super.getDataModel();
        if (onBindRuleBean != null) {
            if (this.tfName.getText().trim().equals("")) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "ERR_NO_ID"));
            }
            if (!onBindRuleBean.getName().equals(this.tfName.getText())) {
                try {
                    onBindRuleBean.setName(this.tfName.getText());
                }
                catch (UniqueNameException uniqueNameException) {
                    throw new ConfigurationViewException(IDARResourceSet.getString("error", "UNIQUE_NAME", this.tfName.getText()));
                }
            }
            try {
                this.viewRule.applyChanges();
            }
            catch (ConfigurationViewException configurationViewException) {
                this.tabViews.setSelectedComponent(this.viewRule.getPanel());
                throw configurationViewException;
            }
            try {
                this.viewSettings.applyChanges();
            }
            catch (ConfigurationViewException configurationViewException) {
                this.tabViews.setSelectedComponent(this.viewSettings.getPanel());
                throw configurationViewException;
            }
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("ruleOnBind", "TITLE");
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new OnBindRuleView(null, null));
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

