/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.property;

import com.iplanet.idar.objectmodel.bean.SizeLimitPropertyBean;
import com.iplanet.idar.objectmodel.bean.UniqueNameException;
import com.iplanet.idar.ui.common.DNDialog;
import com.iplanet.idar.ui.common.FilteredInputDocument;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.common.ImageFactory;
import com.iplanet.idar.ui.common.components.IDARJButtonFactory;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.BlankPanelEvent;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.netscape.management.client.components.ButtonFactory;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.TitlePanel;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import netscape.ldap.util.DN;

public class SizeLimitPropertyView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "Property-SearchSizeLimit";
    private TitlePanel pnlTitle;
    private JLabel lblName;
    private JTextField tfName;
    private BlankPanel pnlLimit;
    private JRadioButton radNoLimit;
    private JRadioButton radLimit;
    private JTextField tfLimit;
    private JTextArea txtDN;
    private JPanel pnlDNBar;
    private JButton butAddDN;
    private JButton butRemoveDN;
    private JButton butEditDN;
    private JTable tblDN;
    private SizeLimitTableModel tableModel;
    private JPopupMenu popup;
    protected static final String ONE_LEVEL = IDARResourceSet.getString("propertySearchSizeLimit", "ONE");
    protected static final String SUBTREE_LEVEL = IDARResourceSet.getString("propertySearchSizeLimit", "SUBTREE");
    protected static final String SEARCH_DN = IDARResourceSet.getString("propertySearchSizeLimit", "SEARCH_DN");
    protected static final String TYPE = IDARResourceSet.getString("propertySearchSizeLimit", "TYPE");

    public SizeLimitPropertyView() {
        this.initComponents();
    }

    public SizeLimitPropertyView(ConsoleInfo consoleInfo) {
        super.setConsoleInfo(consoleInfo);
        this.initComponents();
    }

    public void resetContent() throws ConfigurationViewException {
        try {
            SizeLimitPropertyBean sizeLimitPropertyBean = (SizeLimitPropertyBean)super.getDataModel();
            if (sizeLimitPropertyBean != null) {
                Object e;
                this.tfName.setText(sizeLimitPropertyBean.getId());
                boolean bl = sizeLimitPropertyBean.isEnforcingSizeLimit();
                if (sizeLimitPropertyBean.isEnforcingSizeLimit()) {
                    this.radLimit.setSelected(true);
                    this.tfLimit.setText(sizeLimitPropertyBean.getSizeLimit().toString());
                } else {
                    this.radNoLimit.setSelected(true);
                }
                this.tableModel.removeAll();
                Enumeration enumeration = sizeLimitPropertyBean.getOneLevelSearchDns().elements();
                while (enumeration.hasMoreElements()) {
                    e = enumeration.nextElement();
                    if (!(e instanceof DN)) continue;
                    this.tableModel.addDnOne((DN)e);
                }
                enumeration = sizeLimitPropertyBean.getSubtreeLevelSearchDns().elements();
                while (enumeration.hasMoreElements()) {
                    e = enumeration.nextElement();
                    if (!(e instanceof DN)) continue;
                    this.tableModel.addDnSub((DN)e);
                }
                this.setEnablement();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void applyChanges() throws ConfigurationViewException {
        block11: {
            try {
                SizeLimitPropertyBean sizeLimitPropertyBean = (SizeLimitPropertyBean)super.getDataModel();
                if (sizeLimitPropertyBean == null) break block11;
                if (this.tfName.getText().trim().equals("")) {
                    throw new ConfigurationViewException(IDARResourceSet.getString("error", "ERR_NO_ID"));
                }
                if (!sizeLimitPropertyBean.getName().equals(this.tfName.getText())) {
                    try {
                        sizeLimitPropertyBean.setName(this.tfName.getText());
                    }
                    catch (UniqueNameException uniqueNameException) {
                        throw new ConfigurationViewException(IDARResourceSet.getString("error", "UNIQUE_NAME", this.tfName.getText()));
                    }
                }
                String string = this.tfLimit.getText().trim();
                if (this.radLimit.isSelected() && string.equals("")) {
                    throw new ConfigurationViewException(IDARResourceSet.getString("error", "MISSING_SIZE_LIMIT"));
                }
                Integer n = null;
                if (this.radLimit.isSelected() && !string.trim().equals("")) {
                    try {
                        n = new Integer(string.toString());
                        sizeLimitPropertyBean.setSizeLimit(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ConfigurationViewException(IDARResourceSet.getString("error", "NUMBER_FORMAT") + ": " + string);
                    }
                } else {
                    sizeLimitPropertyBean.setNoSizeLimit();
                }
                sizeLimitPropertyBean.setOneLevelSearchDns(this.tableModel.getDnOnes());
                sizeLimitPropertyBean.setSubtreeLevelSearchDns(this.tableModel.getDnSubs());
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("propertySearchSizeLimit", "TITLE");
    }

    protected void initComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.pnlTitle = new TitlePanel();
        this.pnlTitle.setIcon((Icon)ImageFactory.getImage("PROPERTY"));
        this.pnlTitle.setText(this.getTitleText());
        this.tfName = new JTextField();
        this.lblName = new JLabel(IDARResourceSet.getString("propertyGeneral", "PROPERTY") + ":");
        this.lblName.setLabelFor(this.tfName);
        int n = 0;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.pnlTitle, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.lblName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.tfName, gridBagConstraints);
        this.pnlLimit = new BlankPanel();
        this.pnlLimit.addBlankPanelListener(this);
        this.pnlLimit.setBorder(BorderFactory.createTitledBorder(IDARResourceSet.getString("propertySearchSizeLimit", "CONSTRAINT")));
        this.radNoLimit = new JRadioButton();
        this.radNoLimit.setText(IDARResourceSet.getString("propertySearchSizeLimit", "NO_SIZE_LIMIT"));
        this.radNoLimit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SizeLimitPropertyView.this.setEnablement();
            }
        });
        this.radLimit = new JRadioButton();
        this.radLimit.setText(IDARResourceSet.getString("propertySearchSizeLimit", "SIZE_LIMIT") + ":");
        this.radLimit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SizeLimitPropertyView.this.setEnablement();
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radLimit);
        buttonGroup.add(this.radNoLimit);
        this.radLimit.setSelected(true);
        this.tfLimit = new JTextField(6);
        this.tfLimit.setDocument(FilteredInputDocument.allowDigitsOnly());
        this.tfLimit.getAccessibleContext().setAccessibleDescription(IDARResourceSet.getString("propertySearchSizeLimit", "SIZE_LIMIT"));
        this.pnlLimit.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.pnlLimit.add((Component)this.radNoLimit, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        this.pnlLimit.add((Component)this.radLimit, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        this.pnlLimit.add((Component)this.tfLimit, gridBagConstraints);
        this.txtDN = new JTextArea();
        this.txtDN.setText(IDARResourceSet.getString("propertySearchSizeLimit", "DN_SCOPE") + ":");
        this.txtDN.setEditable(false);
        this.txtDN.setBackground(this.getBackground());
        this.txtDN.setLineWrap(true);
        this.txtDN.setWrapStyleWord(true);
        this.initPopUpMenu();
        this.butAddDN = IDARJButtonFactory.create(IDARResourceSet.getString("button", "ADD"));
        this.butAddDN.setToolTipText(IDARResourceSet.getString("tooltip", "add_search_dn"));
        ButtonFactory.resizeButton((JButton)this.butAddDN);
        this.butAddDN.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SizeLimitPropertyView.this.popup.show(SizeLimitPropertyView.this, SizeLimitPropertyView.this.butAddDN.getX() + SizeLimitPropertyView.this.butAddDN.getWidth(), SizeLimitPropertyView.this.butAddDN.getY() + SizeLimitPropertyView.this.pnlDNBar.getY());
            }
        });
        this.butEditDN = IDARJButtonFactory.create(IDARResourceSet.getString("button", "EDIT"));
        this.butEditDN.setToolTipText(IDARResourceSet.getString("tooltip", "edit_search_dn"));
        ButtonFactory.resizeButton((JButton)this.butEditDN);
        this.butEditDN.setEnabled(false);
        this.butEditDN.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = SizeLimitPropertyView.this.tblDN.getSelectedRow();
                if (n != -1) {
                    DN dN = (DN)SizeLimitPropertyView.this.tableModel.getValueAt(n, 0);
                    String string = (String)SizeLimitPropertyView.this.tableModel.getValueAt(n, 1);
                    if (string.equals(ONE_LEVEL)) {
                        DNDialog dNDialog = new DNDialog(IDARUtilities.getParentFrame(SizeLimitPropertyView.this), SizeLimitPropertyView.this.getConsoleInfo(), SizeLimitPropertyView.this.getDataModel().getParentConfiguration(), dN);
                        dNDialog.showModal();
                        if (!dNDialog.isCancel()) {
                            dN = dNDialog.getDN();
                            SizeLimitPropertyView.this.tableModel.setValueAt(dN, n, 0);
                            SizeLimitPropertyView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(SizeLimitPropertyView.this.tableModel)));
                        }
                    } else if (string.equals(SUBTREE_LEVEL)) {
                        DNDialog dNDialog = new DNDialog(IDARUtilities.getParentFrame(SizeLimitPropertyView.this), SizeLimitPropertyView.this.getConsoleInfo(), SizeLimitPropertyView.this.getDataModel().getParentConfiguration(), dN);
                        dNDialog.showModal();
                        if (!dNDialog.isCancel()) {
                            dN = dNDialog.getDN();
                            SizeLimitPropertyView.this.tableModel.setValueAt(dN, n, 0);
                            SizeLimitPropertyView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(SizeLimitPropertyView.this.tableModel)));
                        }
                    }
                }
            }
        });
        this.butRemoveDN = IDARJButtonFactory.create(IDARResourceSet.getString("button", "REMOVE"));
        this.butRemoveDN.setToolTipText(IDARResourceSet.getString("tooltip", "remove_search_dn"));
        ButtonFactory.resizeButton((JButton)this.butRemoveDN);
        this.butRemoveDN.setEnabled(false);
        this.butRemoveDN.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = SizeLimitPropertyView.this.tblDN.getSelectedRow();
                if (n != -1) {
                    SizeLimitPropertyView.this.tableModel.removeElement(n);
                }
                SizeLimitPropertyView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(SizeLimitPropertyView.this.tableModel)));
            }
        });
        this.pnlDNBar = new JPanel();
        this.pnlDNBar.setLayout(new FlowLayout(0));
        this.pnlDNBar.add(this.butAddDN);
        this.pnlDNBar.add(this.butEditDN);
        this.pnlDNBar.add(this.butRemoveDN);
        this.tableModel = new SizeLimitTableModel();
        this.tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                SizeLimitPropertyView.this.setEnablement();
            }
        });
        this.tblDN = new JTable(this.tableModel);
        this.tblDN.setToolTipText(IDARResourceSet.getString("tooltip", "list_of_search_dns"));
        this.tblDN.setPreferredScrollableViewportSize(new Dimension(500, 100));
        this.tblDN.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                SizeLimitPropertyView.this.setEnablement();
            }
        });
        this.tblDN.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    SizeLimitPropertyView.this.butEditDN.doClick();
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.pnlLimit, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 2;
        this.add((Component)this.txtDN, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.pnlDNBar, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new JScrollPane(this.tblDN), gridBagConstraints);
    }

    protected void initPopUpMenu() {
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setText(ONE_LEVEL);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DNDialog dNDialog = new DNDialog(IDARUtilities.getParentFrame(SizeLimitPropertyView.this), SizeLimitPropertyView.this.getConsoleInfo(), SizeLimitPropertyView.this.getDataModel().getParentConfiguration());
                dNDialog.showModal();
                if (!dNDialog.isCancel()) {
                    SizeLimitPropertyView.this.tableModel.addDnOne(dNDialog.getDN());
                    SizeLimitPropertyView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(SizeLimitPropertyView.this.tableModel)));
                }
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem();
        jMenuItem2.setText(SUBTREE_LEVEL);
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DNDialog dNDialog = new DNDialog(IDARUtilities.getParentFrame(SizeLimitPropertyView.this), SizeLimitPropertyView.this.getConsoleInfo(), SizeLimitPropertyView.this.getDataModel().getParentConfiguration());
                dNDialog.showModal();
                if (!dNDialog.isCancel()) {
                    SizeLimitPropertyView.this.tableModel.addDnSub(dNDialog.getDN());
                    SizeLimitPropertyView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(SizeLimitPropertyView.this.tableModel)));
                }
            }
        });
        this.popup = new JPopupMenu();
        this.popup.add(jMenuItem);
        this.popup.add(jMenuItem2);
    }

    private void setEnablement() {
        boolean bl = this.tblDN.getRowCount() != 0 && this.tblDN.getSelectedRow() != -1 && this.tblDN.getRowCount() > this.tblDN.getSelectedRow();
        this.butRemoveDN.setEnabled(bl);
        this.butEditDN.setEnabled(bl);
        if (this.radNoLimit.isSelected()) {
            this.tfLimit.setEnabled(false);
            this.tfLimit.setBackground(null);
        } else {
            this.tfLimit.setEnabled(true);
            this.tfLimit.setBackground(Color.white);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new SizeLimitPropertyView());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public class SizeLimitTableModel
    extends AbstractTableModel {
        private Vector data = new Vector();

        public Object getValueAt(int n, int n2) {
            Object object = null;
            try {
                DNStruct dNStruct = (DNStruct)this.data.elementAt(n);
                switch (n2) {
                    case 0: {
                        object = dNStruct.value;
                        break;
                    }
                    case 1: {
                        object = dNStruct.type;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                arrayIndexOutOfBoundsException.printStackTrace();
            }
            return object;
        }

        public void setValueAt(Object object, int n, int n2) {
            try {
                DNStruct dNStruct = (DNStruct)this.data.elementAt(n);
                switch (n2) {
                    case 0: {
                        dNStruct.value = object;
                        break;
                    }
                    case 1: {
                        dNStruct.type = object.toString();
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                arrayIndexOutOfBoundsException.printStackTrace();
            }
            this.fireTableDataChanged();
        }

        public void addDnOne(DN dN) {
            this.data.addElement(new DNStruct(dN, ONE_LEVEL));
            this.fireTableDataChanged();
        }

        public void addDnSub(DN dN) {
            this.data.addElement(new DNStruct(dN, SUBTREE_LEVEL));
            this.fireTableDataChanged();
        }

        public Vector getDnOnes() {
            Vector<DN> vector = new Vector<DN>();
            Enumeration enumeration = this.data.elements();
            while (enumeration.hasMoreElements()) {
                DNStruct dNStruct = (DNStruct)enumeration.nextElement();
                if (!dNStruct.type.equals(ONE_LEVEL)) continue;
                vector.addElement((DN)dNStruct.value);
            }
            return vector;
        }

        public Vector getDnSubs() {
            Vector<DN> vector = new Vector<DN>();
            Enumeration enumeration = this.data.elements();
            while (enumeration.hasMoreElements()) {
                DNStruct dNStruct = (DNStruct)enumeration.nextElement();
                if (!dNStruct.type.equals(SUBTREE_LEVEL)) continue;
                vector.addElement((DN)dNStruct.value);
            }
            return vector;
        }

        public void removeElement(int n) {
            this.data.removeElementAt(n);
            this.fireTableDataChanged();
        }

        public int getRowCount() {
            return this.data.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return n == 0 ? SEARCH_DN : TYPE;
        }

        public void removeAll() {
            this.data.clear();
        }

        private class DNStruct {
            public Object value;
            public String type;

            DNStruct(Object object, String string) {
                this.value = object;
                this.type = string;
            }

            public String toString() {
                return "value=" + this.value.toString() + " type=" + this.type;
            }
        }
    }
}

