/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.property;

import com.iplanet.idar.objectmodel.bean.ForbiddenEntryPropertyBean;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.UniqueNameException;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.ImageFactory;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.iplanet.idar.ui.configurator.property.AttributeFilteringView;
import com.iplanet.idar.ui.configurator.property.EntryMatchView;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.TitlePanel;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class ForbiddenEntryPropertyView
extends ConfigurationView
implements SuiConstants {
    private TitlePanel pnlTitle;
    private JLabel lblName;
    private JTextField tfName;
    private JTabbedPane tabViews;
    private ConfigurationView viewEntryMatch;
    private ConfigurationView viewAttributeFiltering;

    public ForbiddenEntryPropertyView() {
        this.initComponents();
    }

    public ForbiddenEntryPropertyView(ConsoleInfo consoleInfo) {
        this.setConsoleInfo(consoleInfo);
        this.initComponents();
    }

    public void setConsoleInfo(ConsoleInfo consoleInfo) {
        if (consoleInfo != null) {
            super.setConsoleInfo(consoleInfo);
            if (this.viewEntryMatch != null) {
                this.viewEntryMatch.setConsoleInfo(consoleInfo);
            }
            if (this.viewAttributeFiltering != null) {
                this.viewAttributeFiltering.setConsoleInfo(consoleInfo);
            }
        }
    }

    public void setDataModel(IDARModelBean iDARModelBean) {
        this.viewEntryMatch.setDataModel(iDARModelBean);
        this.viewAttributeFiltering.setDataModel(iDARModelBean);
        super.setDataModel(iDARModelBean);
    }

    public String getHelpTopic() {
        return ((ConfigurationView)this.tabViews.getSelectedComponent()).getHelpTopic();
    }

    public void applyChanges() throws ConfigurationViewException {
        block10: {
            try {
                ForbiddenEntryPropertyBean forbiddenEntryPropertyBean = (ForbiddenEntryPropertyBean)super.getDataModel();
                if (forbiddenEntryPropertyBean == null) break block10;
                if (this.tfName.getText().trim().equals("")) {
                    throw new ConfigurationViewException(IDARResourceSet.getString("error", "ERR_NO_ID"));
                }
                if (!forbiddenEntryPropertyBean.getName().equals(this.tfName.getText())) {
                    try {
                        forbiddenEntryPropertyBean.setName(this.tfName.getText());
                    }
                    catch (UniqueNameException uniqueNameException) {
                        throw new ConfigurationViewException(IDARResourceSet.getString("error", "UNIQUE_NAME", this.tfName.getText()));
                    }
                }
                try {
                    this.viewEntryMatch.applyChanges();
                }
                catch (ConfigurationViewException configurationViewException) {
                    this.tabViews.setSelectedComponent(this.viewEntryMatch.getPanel());
                    throw configurationViewException;
                }
                try {
                    this.viewAttributeFiltering.applyChanges();
                }
                catch (ConfigurationViewException configurationViewException) {
                    this.tabViews.setSelectedComponent(this.viewAttributeFiltering.getPanel());
                    throw configurationViewException;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public void resetContent() throws ConfigurationViewException {
        try {
            ForbiddenEntryPropertyBean forbiddenEntryPropertyBean = (ForbiddenEntryPropertyBean)super.getDataModel();
            if (forbiddenEntryPropertyBean != null) {
                this.tfName.setText(forbiddenEntryPropertyBean.getId());
                this.viewEntryMatch.setDataModel(forbiddenEntryPropertyBean);
                this.viewEntryMatch.resetContent();
                this.viewAttributeFiltering.setDataModel(forbiddenEntryPropertyBean);
                this.viewAttributeFiltering.resetContent();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("propertyForbiddenEntry", "TITLE");
    }

    protected void initComponents() {
        this.pnlTitle = new TitlePanel();
        this.pnlTitle.setIcon((Icon)ImageFactory.getImage("PROPERTY"));
        this.pnlTitle.setText(this.getTitleText());
        this.tfName = new JTextField();
        this.lblName = new JLabel();
        this.lblName.setText(IDARResourceSet.getString("propertyGeneral", "PROPERTY") + ":");
        this.lblName.setLabelFor(this.tfName);
        this.tabViews = new JTabbedPane();
        ConsoleInfo consoleInfo = this.getConsoleInfo();
        this.viewEntryMatch = new EntryMatchView(consoleInfo);
        this.viewAttributeFiltering = new AttributeFilteringView(consoleInfo);
        this.viewEntryMatch.addBlankPanelListener(this);
        this.viewAttributeFiltering.addBlankPanelListener(this);
        this.tabViews.addTab(this.viewEntryMatch.getTitleText(), null, this.viewEntryMatch.getPanel());
        this.tabViews.addTab(this.viewAttributeFiltering.getTitleText(), null, this.viewAttributeFiltering.getPanel());
        this.setLayout(new BorderLayout());
        BlankPanel blankPanel = new BlankPanel();
        blankPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        blankPanel.add((Component)this.pnlTitle, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        blankPanel.add((Component)this.lblName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.insets.right = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        blankPanel.add((Component)this.tfName, gridBagConstraints);
        this.add((Component)blankPanel, "North");
        this.add((Component)this.tabViews, "Center");
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new ForbiddenEntryPropertyView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

