/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.property;

import com.iplanet.idar.objectmodel.bean.AttributeValuePair;
import com.iplanet.idar.objectmodel.bean.ForbiddenEntryPropertyBean;
import com.iplanet.idar.ui.common.AttributeValueDialog;
import com.iplanet.idar.ui.common.DNDialog;
import com.iplanet.idar.ui.common.DNExpressionDialog;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.IDARUtilities;
import com.iplanet.idar.ui.common.components.IDARJButtonFactory;
import com.iplanet.idar.ui.common.configuration.BlankPanelEvent;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import netscape.ldap.util.DN;

public class EntryMatchView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "Property-ForbiddenEntry-EntryMatching";
    private JTextArea txtNote;
    private JPanel pnlDNBar;
    private JButton butAddDN;
    private JButton butRemoveDN;
    private JButton butEditDN;
    private JTable tblEntrySpecifications;
    private EntryMatchTableModel tableModel;
    private JPopupMenu popup;
    protected static final String DN_EXACT = IDARResourceSet.getString("propertyForbiddenEntryMatch", "DN_EXACT");
    protected static final String DN_REGEXP = IDARResourceSet.getString("propertyForbiddenEntryMatch", "DN_REGEXP");
    protected static final String AVA = IDARResourceSet.getString("propertyForbiddenEntryMatch", "AVA");
    protected static final String CRITERIA = IDARResourceSet.getString("propertyForbiddenEntryMatch", "CRITERIA");
    protected static final String TYPE = IDARResourceSet.getString("propertyForbiddenEntryMatch", "CRITERIA_TYPE");

    public EntryMatchView() {
        this.initComponents();
        this.initPopUpMenu();
    }

    public EntryMatchView(ConsoleInfo consoleInfo) {
        this.setConsoleInfo(consoleInfo);
        this.initComponents();
        this.initPopUpMenu();
    }

    public void resetContent() throws ConfigurationViewException {
        ForbiddenEntryPropertyBean forbiddenEntryPropertyBean = (ForbiddenEntryPropertyBean)this.getDataModel();
        if (forbiddenEntryPropertyBean != null) {
            this.tableModel.removeAll();
            Vector vector = new Vector();
            vector.addAll(forbiddenEntryPropertyBean.getExactDns());
            vector.addAll(forbiddenEntryPropertyBean.getDnExpressions());
            vector.addAll(forbiddenEntryPropertyBean.getAttributeValueAssociations());
            this.tableModel.setData(vector);
        }
    }

    public void applyChanges() throws ConfigurationViewException {
        ForbiddenEntryPropertyBean forbiddenEntryPropertyBean = (ForbiddenEntryPropertyBean)this.getDataModel();
        if (forbiddenEntryPropertyBean != null) {
            forbiddenEntryPropertyBean.setExactDns(this.tableModel.getExactDns());
            forbiddenEntryPropertyBean.setDnExpressions(this.tableModel.getDnExpressions());
            forbiddenEntryPropertyBean.setAttributeValueAssociations(this.tableModel.getAvas());
        }
    }

    protected void initComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.txtNote = new JTextArea();
        this.txtNote.setText(IDARResourceSet.getString("propertyForbiddenEntryMatch", "NOTE"));
        this.txtNote.setEditable(false);
        this.txtNote.setBackground(this.getBackground());
        this.txtNote.setLineWrap(true);
        this.txtNote.setWrapStyleWord(true);
        this.butAddDN = IDARJButtonFactory.create(IDARResourceSet.getString("button", "ADD"));
        this.butAddDN.setToolTipText(IDARResourceSet.getString("tooltip", "add_entry_match_criteria"));
        this.butAddDN.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EntryMatchView.this.popup.show(EntryMatchView.this, EntryMatchView.this.butAddDN.getX() + EntryMatchView.this.butAddDN.getWidth(), EntryMatchView.this.butAddDN.getY() + EntryMatchView.this.pnlDNBar.getY());
            }
        });
        this.butRemoveDN = IDARJButtonFactory.create(IDARResourceSet.getString("button", "REMOVE"));
        this.butRemoveDN.setToolTipText(IDARResourceSet.getString("tooltip", "remove_entry_match_criteria"));
        this.butRemoveDN.setEnabled(false);
        this.butRemoveDN.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = EntryMatchView.this.tblEntrySpecifications.getSelectedRow();
                if (n != -1) {
                    EntryMatchView.this.tableModel.removeElement(n);
                }
                EntryMatchView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(EntryMatchView.this.tableModel)));
            }
        });
        this.butEditDN = IDARJButtonFactory.create(IDARResourceSet.getString("button", "EDIT"));
        this.butEditDN.setToolTipText(IDARResourceSet.getString("tooltip", "edit_entry_match_criteria"));
        this.butEditDN.setEnabled(false);
        this.butEditDN.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = EntryMatchView.this.tblEntrySpecifications.getSelectedRow();
                if (n != -1) {
                    Object object = EntryMatchView.this.tableModel.getValueAt(n, 0);
                    if (object instanceof DN) {
                        DN dN = (DN)object;
                        DNDialog dNDialog = new DNDialog(IDARUtilities.getParentFrame(EntryMatchView.this), EntryMatchView.this.getConsoleInfo(), EntryMatchView.this.getDataModel().getParentConfiguration(), dN);
                        dNDialog.showModal();
                        if (!dNDialog.isCancel()) {
                            dN = dNDialog.getNormalizedDN();
                            EntryMatchView.this.tableModel.setValueAt(dN, n, 0);
                            EntryMatchView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(EntryMatchView.this.tableModel)));
                        }
                    } else if (object instanceof AttributeValuePair) {
                        AttributeValuePair attributeValuePair = (AttributeValuePair)object;
                        AttributeValueDialog attributeValueDialog = new AttributeValueDialog(IDARUtilities.getParentFrame(EntryMatchView.this), EntryMatchView.this.getConsoleInfo(), attributeValuePair);
                        attributeValueDialog.showModal();
                        if (!attributeValueDialog.isCancel()) {
                            attributeValuePair = attributeValueDialog.getAttributeValuePair();
                            EntryMatchView.this.tableModel.setValueAt(attributeValuePair, n, 0);
                            EntryMatchView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(EntryMatchView.this.tableModel)));
                        }
                    } else if (object instanceof String) {
                        String string = (String)object;
                        DNExpressionDialog dNExpressionDialog = new DNExpressionDialog(IDARUtilities.getParentFrame(EntryMatchView.this), EntryMatchView.this.getConsoleInfo(), EntryMatchView.this.getDataModel().getParentConfiguration(), string);
                        dNExpressionDialog.showModal();
                        if (!dNExpressionDialog.isCancel()) {
                            string = dNExpressionDialog.getExpression();
                            EntryMatchView.this.tableModel.setValueAt(string, n, 0);
                            EntryMatchView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(EntryMatchView.this.tableModel)));
                        }
                    }
                }
            }
        });
        this.pnlDNBar = new JPanel();
        this.pnlDNBar.setLayout(new FlowLayout(0));
        this.pnlDNBar.add(this.butAddDN);
        this.pnlDNBar.add(this.butEditDN);
        this.pnlDNBar.add(this.butRemoveDN);
        this.tableModel = new EntryMatchTableModel();
        this.tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                EntryMatchView.this.setEnablement();
            }
        });
        this.tblEntrySpecifications = new JTable(this.tableModel);
        this.tblEntrySpecifications.setToolTipText(IDARResourceSet.getString("tooltip", "list_of_entry_match_criteria"));
        this.tblEntrySpecifications.setPreferredScrollableViewportSize(new Dimension(500, 100));
        this.tblEntrySpecifications.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                EntryMatchView.this.setEnablement();
            }
        });
        this.tblEntrySpecifications.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    EntryMatchView.this.butEditDN.doClick();
                }
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 2;
        this.add((Component)this.txtNote, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.pnlDNBar, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new JScrollPane(this.tblEntrySpecifications), gridBagConstraints);
    }

    protected void initPopUpMenu() {
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setText(DN_EXACT);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DNDialog dNDialog = new DNDialog(IDARUtilities.getParentFrame(EntryMatchView.this), EntryMatchView.this.getConsoleInfo(), EntryMatchView.this.getDataModel().getParentConfiguration());
                dNDialog.showModal();
                if (!dNDialog.isCancel()) {
                    DN dN = dNDialog.getNormalizedDN();
                    EntryMatchView.this.tableModel.addExactDn(dN);
                    EntryMatchView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(EntryMatchView.this.tableModel)));
                }
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem();
        jMenuItem2.setText(DN_REGEXP);
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DNExpressionDialog dNExpressionDialog = new DNExpressionDialog(IDARUtilities.getParentFrame(EntryMatchView.this), EntryMatchView.this.getConsoleInfo(), EntryMatchView.this.getDataModel().getParentConfiguration());
                dNExpressionDialog.showModal();
                if (!dNExpressionDialog.isCancel()) {
                    String string = dNExpressionDialog.getExpression();
                    EntryMatchView.this.tableModel.addDnExpression(string);
                    EntryMatchView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(EntryMatchView.this.tableModel)));
                }
            }
        });
        JMenuItem jMenuItem3 = new JMenuItem();
        jMenuItem3.setText(AVA);
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttributeValueDialog attributeValueDialog = new AttributeValueDialog(IDARUtilities.getParentFrame(EntryMatchView.this));
                attributeValueDialog.showModal();
                if (!attributeValueDialog.isCancel()) {
                    AttributeValuePair attributeValuePair = attributeValueDialog.getAttributeValuePair();
                    EntryMatchView.this.tableModel.addAva(attributeValuePair);
                    EntryMatchView.this.fireBlankPanelEvent(new BlankPanelEvent(new TableModelEvent(EntryMatchView.this.tableModel)));
                }
            }
        });
        this.popup = new JPopupMenu();
        this.popup.add(jMenuItem);
        this.popup.add(jMenuItem2);
        this.popup.add(jMenuItem3);
    }

    private void setEnablement() {
        boolean bl = this.tblEntrySpecifications.getRowCount() != 0 && this.tblEntrySpecifications.getSelectedRow() != -1 && this.tblEntrySpecifications.getRowCount() > this.tblEntrySpecifications.getSelectedRow();
        this.butRemoveDN.setEnabled(bl);
        this.butEditDN.setEnabled(bl);
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("propertyForbiddenEntryMatch", "TITLE");
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new EntryMatchView());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public class EntryMatchTableModel
    extends AbstractTableModel {
        private Vector data = new Vector();

        public Object getValueAt(int n, int n2) {
            Object object = null;
            try {
                EMTMStruct eMTMStruct = (EMTMStruct)this.data.elementAt(n);
                switch (n2) {
                    case 0: {
                        object = eMTMStruct.value;
                        break;
                    }
                    case 1: {
                        object = eMTMStruct.type;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                arrayIndexOutOfBoundsException.printStackTrace();
            }
            return object;
        }

        public void setValueAt(Object object, int n, int n2) {
            try {
                EMTMStruct eMTMStruct = (EMTMStruct)this.data.elementAt(n);
                switch (n2) {
                    case 0: {
                        eMTMStruct.value = object;
                        break;
                    }
                    case 1: {
                        eMTMStruct.type = object.toString();
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                arrayIndexOutOfBoundsException.printStackTrace();
            }
            this.fireTableDataChanged();
        }

        public void setData(Vector vector) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e instanceof DN) {
                    this.addExactDn((DN)e);
                    continue;
                }
                if (e instanceof AttributeValuePair) {
                    this.addAva((AttributeValuePair)e);
                    continue;
                }
                if (!(e instanceof String)) continue;
                this.addDnExpression((String)e);
            }
            this.fireTableDataChanged();
        }

        public void addExactDn(DN dN) {
            this.data.addElement(new EMTMStruct(dN, DN_EXACT));
            this.fireTableDataChanged();
        }

        public void addDnExpression(String string) {
            this.data.addElement(new EMTMStruct(string, DN_REGEXP));
            this.fireTableDataChanged();
        }

        public void addAva(AttributeValuePair attributeValuePair) {
            this.data.addElement(new EMTMStruct(attributeValuePair, AVA));
            this.fireTableDataChanged();
        }

        public Vector getExactDns() {
            Vector<Object> vector = new Vector<Object>();
            Enumeration enumeration = this.data.elements();
            while (enumeration.hasMoreElements()) {
                EMTMStruct eMTMStruct = (EMTMStruct)enumeration.nextElement();
                if (!eMTMStruct.type.equals(DN_EXACT)) continue;
                vector.addElement(eMTMStruct.value);
            }
            return vector;
        }

        public Vector getDnExpressions() {
            Vector<Object> vector = new Vector<Object>();
            Enumeration enumeration = this.data.elements();
            while (enumeration.hasMoreElements()) {
                EMTMStruct eMTMStruct = (EMTMStruct)enumeration.nextElement();
                if (!eMTMStruct.type.equals(DN_REGEXP)) continue;
                vector.addElement(eMTMStruct.value);
            }
            return vector;
        }

        public Vector getAvas() {
            Vector<Object> vector = new Vector<Object>();
            Enumeration enumeration = this.data.elements();
            while (enumeration.hasMoreElements()) {
                EMTMStruct eMTMStruct = (EMTMStruct)enumeration.nextElement();
                if (!eMTMStruct.type.equals(AVA)) continue;
                vector.addElement(eMTMStruct.value);
            }
            return vector;
        }

        public void removeElement(int n) {
            this.data.removeElementAt(n);
            this.fireTableDataChanged();
        }

        public int getRowCount() {
            return this.data.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return n == 0 ? CRITERIA : TYPE;
        }

        public void removeAll() {
            this.data.clear();
        }

        private class EMTMStruct {
            public Object value;
            public String type;

            EMTMStruct(Object object, String string) {
                this.value = object;
                this.type = string;
            }

            public String toString() {
                return "value=" + this.value.toString() + " type=" + this.type;
            }
        }
    }
}

