/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.group;

import com.iplanet.idar.objectmodel.bean.NetworkGroupBean;
import com.iplanet.idar.ui.common.FilteredInputDocument;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ServerLoadView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "NetworkGroup-ServerLoad";
    JTextArea txtNote;
    JTextField tfMaxSimultaneousOperationsPerConnection;
    JTextField tfMaxTotalOperationsPerConnection;
    JTextField tfMaxConnections;
    JTextField tfMaxConnectionsFromIP;
    private JCheckBox chkMaxSimultaneousOperationsPerConnection;
    private JCheckBox chkMaxTotalOperationsPerConnection;
    private JCheckBox chkMaxConnections;
    private JCheckBox chkMaxConnectionsFromIP;

    public ServerLoadView() {
        this.initComponents();
    }

    public ServerLoadView(ConsoleInfo consoleInfo, NetworkGroupBean networkGroupBean) {
        this.setConsoleInfo(consoleInfo);
        this.setDataModel(networkGroupBean);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            Debug.println((int)6, (String)("Unable to resetContent in Constructor. Model = " + networkGroupBean));
        }
    }

    protected void initComponents() {
        this.txtNote = new JTextArea();
        this.txtNote.setText(IDARResourceSet.getString("groupServerLoad", "NOTE"));
        this.txtNote.setEditable(false);
        this.txtNote.setBackground(this.getBackground());
        this.txtNote.setLineWrap(true);
        this.txtNote.setWrapStyleWord(true);
        this.chkMaxSimultaneousOperationsPerConnection = new JCheckBox(IDARResourceSet.getString("groupServerLoad", "MAX_SIM_OPS") + ":");
        this.chkMaxSimultaneousOperationsPerConnection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServerLoadView.this.setButtonEnablement();
            }
        });
        this.tfMaxSimultaneousOperationsPerConnection = new JTextField(6);
        this.tfMaxSimultaneousOperationsPerConnection.getAccessibleContext().setAccessibleDescription(IDARResourceSet.getString("groupServerLoad", "MAX_SIM_OPS"));
        this.tfMaxSimultaneousOperationsPerConnection.setDocument(FilteredInputDocument.allowDigitsOnly());
        this.chkMaxTotalOperationsPerConnection = new JCheckBox(IDARResourceSet.getString("groupServerLoad", "MAX_TOTAL_OPS") + ":");
        this.chkMaxTotalOperationsPerConnection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServerLoadView.this.setButtonEnablement();
            }
        });
        this.tfMaxTotalOperationsPerConnection = new JTextField(6);
        this.tfMaxTotalOperationsPerConnection.getAccessibleContext().setAccessibleDescription(IDARResourceSet.getString("groupServerLoad", "MAX_TOTAL_OPS"));
        this.tfMaxTotalOperationsPerConnection.setDocument(FilteredInputDocument.allowDigitsOnly());
        this.chkMaxConnections = new JCheckBox(IDARResourceSet.getString("groupServerLoad", "MAX_CONNECTIONS") + ":");
        this.chkMaxConnections.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServerLoadView.this.setButtonEnablement();
            }
        });
        this.tfMaxConnections = new JTextField(6);
        this.tfMaxConnections.getAccessibleContext().setAccessibleDescription(IDARResourceSet.getString("groupServerLoad", "MAX_CONNECTIONS"));
        this.tfMaxConnections.setDocument(FilteredInputDocument.allowDigitsOnly());
        this.chkMaxConnectionsFromIP = new JCheckBox(IDARResourceSet.getString("groupServerLoad", "MAX_SIM_CONNECTIONS") + ":");
        this.chkMaxConnectionsFromIP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServerLoadView.this.setButtonEnablement();
            }
        });
        this.tfMaxConnectionsFromIP = new JTextField(6);
        this.tfMaxConnectionsFromIP.getAccessibleContext().setAccessibleDescription(IDARResourceSet.getString("groupServerLoad", "MAX_SIM_CONNECTIONS"));
        this.tfMaxConnectionsFromIP.setDocument(FilteredInputDocument.allowDigitsOnly());
        this.setLayout(new GridBagLayout());
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.txtNote, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        this.add((Component)this.chkMaxSimultaneousOperationsPerConnection, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        this.add((Component)this.tfMaxSimultaneousOperationsPerConnection, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.right = 0;
        this.add((Component)this.chkMaxTotalOperationsPerConnection, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        this.add((Component)this.tfMaxTotalOperationsPerConnection, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.right = 0;
        this.add((Component)this.chkMaxConnections, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        this.add((Component)this.tfMaxConnections, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.right = 0;
        this.add((Component)this.chkMaxConnectionsFromIP, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.tfMaxConnectionsFromIP, gridBagConstraints);
        this.setButtonEnablement();
    }

    private void setButtonEnablement() {
        if (this.chkMaxSimultaneousOperationsPerConnection.isSelected()) {
            this.tfMaxSimultaneousOperationsPerConnection.setEnabled(true);
            this.tfMaxSimultaneousOperationsPerConnection.setBackground(Color.white);
        } else {
            this.tfMaxSimultaneousOperationsPerConnection.setEnabled(false);
            this.tfMaxSimultaneousOperationsPerConnection.setBackground(null);
        }
        if (this.chkMaxTotalOperationsPerConnection.isSelected()) {
            this.tfMaxTotalOperationsPerConnection.setEnabled(true);
            this.tfMaxTotalOperationsPerConnection.setBackground(Color.white);
        } else {
            this.tfMaxTotalOperationsPerConnection.setEnabled(false);
            this.tfMaxTotalOperationsPerConnection.setBackground(null);
        }
        if (this.chkMaxConnections.isSelected()) {
            this.tfMaxConnections.setEnabled(true);
            this.tfMaxConnections.setBackground(Color.white);
        } else {
            this.tfMaxConnections.setEnabled(false);
            this.tfMaxConnections.setBackground(null);
        }
        if (this.chkMaxConnectionsFromIP.isSelected()) {
            this.tfMaxConnectionsFromIP.setEnabled(true);
            this.tfMaxConnectionsFromIP.setBackground(Color.white);
        } else {
            this.tfMaxConnectionsFromIP.setEnabled(false);
            this.tfMaxConnectionsFromIP.setBackground(null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void applyChanges() throws ConfigurationViewException {
        Integer n;
        String string;
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        if (networkGroupBean == null) return;
        if (this.chkMaxSimultaneousOperationsPerConnection.isSelected()) {
            string = this.tfMaxSimultaneousOperationsPerConnection.getText();
            if (string.equals("")) throw new ConfigurationViewException(IDARResourceSet.getString("error", "MISSING_MAX_SIM_OPS"));
            n = null;
            try {
                n = new Integer(string.toString());
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "NUMBER_FORMAT") + ": " + string);
            }
            if (n == 0) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "ZERO_MAX_SIM_OPS"));
            }
            networkGroupBean.setMaxSimulOpsPerConn(n);
        } else {
            networkGroupBean.setMaxSimulOpsPerConn(null);
        }
        if (this.chkMaxTotalOperationsPerConnection.isSelected()) {
            string = this.tfMaxTotalOperationsPerConnection.getText();
            if (string.equals("")) throw new ConfigurationViewException(IDARResourceSet.getString("error", "MISSING_MAX_TOTAL_OPS"));
            n = null;
            try {
                n = new Integer(string.toString());
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "NUMBER_FORMAT") + ": " + string);
            }
            if (n == 0) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "ZERO_MAX_TOTAL_OPS"));
            }
            networkGroupBean.setMaxOpsPerConn(n);
        } else {
            networkGroupBean.setMaxOpsPerConn(null);
        }
        if (this.chkMaxConnections.isSelected()) {
            string = this.tfMaxConnections.getText();
            if (string.equals("")) throw new ConfigurationViewException(IDARResourceSet.getString("error", "MISSING_MAX_CONNECTIONS"));
            n = null;
            try {
                n = new Integer(string.toString());
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "NUMBER_FORMAT") + ": " + string);
            }
            if (n == 0) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "ZERO_MAX_CONNECTIONS"));
            }
            networkGroupBean.setMaxConn(n);
        } else {
            networkGroupBean.setMaxConn(null);
        }
        if (this.chkMaxConnectionsFromIP.isSelected()) {
            string = this.tfMaxConnectionsFromIP.getText();
            if (string.equals("")) throw new ConfigurationViewException(IDARResourceSet.getString("error", "MISSING_MAX_SIM_CONNECTIONS"));
            n = null;
            try {
                n = new Integer(string.toString());
            }
            catch (NumberFormatException numberFormatException) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "NUMBER_FORMAT") + ": " + string);
            }
            if (n == 0) {
                throw new ConfigurationViewException(IDARResourceSet.getString("error", "ZERO_MAX_SIM_CONNECTIONS"));
            }
            networkGroupBean.setMaxSimulConnFromIp(n);
            return;
        }
        networkGroupBean.setMaxSimulConnFromIp(null);
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("groupServerLoad", "TITLE");
    }

    public void resetContent() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        Debug.println((String)("ServerLoadView.resetContent: model=" + networkGroupBean));
        if (networkGroupBean != null) {
            Integer n = networkGroupBean.getMaxSimulOpsPerConn();
            if (n != null) {
                this.chkMaxSimultaneousOperationsPerConnection.setSelected(true);
                this.tfMaxSimultaneousOperationsPerConnection.setText(n.toString());
            } else {
                this.chkMaxSimultaneousOperationsPerConnection.setSelected(false);
                this.tfMaxSimultaneousOperationsPerConnection.setText("");
                this.tfMaxSimultaneousOperationsPerConnection.setEnabled(false);
                this.tfMaxSimultaneousOperationsPerConnection.setBackground(null);
            }
            Integer n2 = networkGroupBean.getMaxOpsPerConn();
            if (n2 != null) {
                this.chkMaxTotalOperationsPerConnection.setSelected(true);
                this.tfMaxTotalOperationsPerConnection.setText(n2.toString());
            } else {
                this.chkMaxTotalOperationsPerConnection.setSelected(false);
                this.tfMaxTotalOperationsPerConnection.setText("");
                this.tfMaxTotalOperationsPerConnection.setEnabled(false);
                this.tfMaxTotalOperationsPerConnection.setBackground(null);
            }
            Integer n3 = networkGroupBean.getMaxConn();
            if (n3 != null) {
                this.chkMaxConnections.setSelected(true);
                this.tfMaxConnections.setText(n3.toString());
            } else {
                this.chkMaxConnections.setSelected(false);
                this.tfMaxConnections.setText("");
                this.tfMaxConnections.setEnabled(false);
                this.tfMaxConnections.setBackground(null);
            }
            Integer n4 = networkGroupBean.getMaxSimulConnFromIp();
            if (n4 != null && n4 != 0) {
                this.chkMaxConnectionsFromIP.setSelected(true);
                this.tfMaxConnectionsFromIP.setText(n4.toString());
            } else {
                this.chkMaxConnectionsFromIP.setSelected(false);
                this.tfMaxConnectionsFromIP.setText("");
                this.tfMaxConnectionsFromIP.setEnabled(false);
                this.tfMaxConnectionsFromIP.setBackground(null);
            }
        }
        this.setButtonEnablement();
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new ServerLoadView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

