/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.group;

import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.NetworkGroupBean;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.iplanet.idar.ui.configurator.group.SearchControlView;
import com.iplanet.idar.ui.configurator.group.SearchReferralView;
import com.iplanet.idar.ui.configurator.group.SearchScopeView;
import com.iplanet.idar.ui.configurator.group.SearchSizeView;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class SearchView
extends ConfigurationView
implements SuiConstants {
    private JTabbedPane tabViews;
    private SearchSizeView viewSearchSize;
    private SearchControlView viewSearchControl;
    private SearchScopeView viewSearchScope;
    private SearchReferralView viewSearchReferral;

    public SearchView() {
        this.initComponents();
    }

    public SearchView(ConsoleInfo consoleInfo, NetworkGroupBean networkGroupBean) {
        this.setConsoleInfo(consoleInfo);
        this.setDataModel(networkGroupBean);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            // empty catch block
        }
    }

    public void setConsoleInfo(ConsoleInfo consoleInfo) {
        super.setConsoleInfo(consoleInfo);
        if (this.viewSearchSize != null) {
            this.viewSearchSize.setConsoleInfo(consoleInfo);
            this.viewSearchControl.setConsoleInfo(consoleInfo);
            this.viewSearchScope.setConsoleInfo(consoleInfo);
            this.viewSearchReferral.setConsoleInfo(consoleInfo);
        }
    }

    public void setDataModel(IDARModelBean iDARModelBean, boolean bl) {
        Debug.println((String)("SearchView.setDataModel: model=" + iDARModelBean + " reset=" + bl));
        if (this.viewSearchSize != null) {
            this.viewSearchSize.setDataModel(iDARModelBean, bl);
            this.viewSearchControl.setDataModel(iDARModelBean, bl);
            this.viewSearchScope.setDataModel(iDARModelBean, bl);
            this.viewSearchReferral.setDataModel(iDARModelBean, bl);
        }
        super.setDataModel(iDARModelBean, bl);
    }

    public void resetContent() throws ConfigurationViewException {
        Debug.println((String)("SearchView.resetContent: model=" + this.getDataModel()));
        this.viewSearchSize.resetContent();
        this.viewSearchControl.resetContent();
        this.viewSearchScope.resetContent();
        this.viewSearchReferral.resetContent();
    }

    public void applyChanges() throws ConfigurationViewException {
        try {
            this.viewSearchSize.applyChanges();
        }
        catch (ConfigurationViewException configurationViewException) {
            this.tabViews.setSelectedComponent(this.viewSearchSize.getPanel());
            throw configurationViewException;
        }
        try {
            this.viewSearchControl.applyChanges();
        }
        catch (ConfigurationViewException configurationViewException) {
            this.tabViews.setSelectedComponent(this.viewSearchControl.getPanel());
            throw configurationViewException;
        }
        try {
            this.viewSearchScope.applyChanges();
        }
        catch (ConfigurationViewException configurationViewException) {
            this.tabViews.setSelectedComponent(this.viewSearchScope.getPanel());
            throw configurationViewException;
        }
        try {
            this.viewSearchReferral.applyChanges();
        }
        catch (ConfigurationViewException configurationViewException) {
            this.tabViews.setSelectedComponent(this.viewSearchReferral.getPanel());
            throw configurationViewException;
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("groupSearch", "TITLE");
    }

    protected void initComponents() {
        this.tabViews = new JTabbedPane();
        this.viewSearchSize = new SearchSizeView();
        this.viewSearchControl = new SearchControlView();
        this.viewSearchScope = new SearchScopeView();
        this.viewSearchReferral = new SearchReferralView();
        this.viewSearchSize.addBlankPanelListener(this);
        this.viewSearchControl.addBlankPanelListener(this);
        this.viewSearchScope.addBlankPanelListener(this);
        this.viewSearchReferral.addBlankPanelListener(this);
        this.tabViews.addTab(this.viewSearchSize.getTitleText(), null, this.viewSearchSize.getPanel());
        this.tabViews.addTab(this.viewSearchControl.getTitleText(), null, this.viewSearchControl.getPanel());
        this.tabViews.addTab(this.viewSearchScope.getTitleText(), null, this.viewSearchScope.getPanel());
        this.tabViews.addTab(this.viewSearchReferral.getTitleText(), null, this.viewSearchReferral.getPanel());
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabViews, "Center");
    }

    public String getHelpTopic() {
        String string = "";
        Component component = this.tabViews.getSelectedComponent();
        if (component instanceof ConfigurationView) {
            ConfigurationView configurationView = (ConfigurationView)component;
            string = configurationView.getHelpTopic();
        }
        return string;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new SearchView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

