/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.group;

import com.iplanet.idar.objectmodel.bean.NetworkGroupBean;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class SearchScopeView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "NetworkGroup-Search-Scope";
    JTextArea txtNote;
    BlankPanel pnlScopes;
    JRadioButton radScopeAll;
    JRadioButton radScopeBase;
    JRadioButton radScopeBaseLevel;

    public SearchScopeView() {
        this.initComponents();
    }

    public SearchScopeView(ConsoleInfo consoleInfo, NetworkGroupBean networkGroupBean) {
        this.setConsoleInfo(consoleInfo);
        this.setDataModel(networkGroupBean);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            Debug.println((int)6, (String)("Unable to resetContent in Constructor. Model = " + networkGroupBean));
        }
    }

    protected void initComponents() {
        this.pnlScopes = new BlankPanel();
        this.pnlScopes.addBlankPanelListener(this);
        this.radScopeAll = new JRadioButton(IDARResourceSet.getString("groupSearchScope", "SEARCH_ALL"));
        this.radScopeBase = new JRadioButton(IDARResourceSet.getString("groupSearchScope", "SEARCH_BASE"));
        this.radScopeBaseLevel = new JRadioButton(IDARResourceSet.getString("groupSearchScope", "SEARCH_BASE_LEVEL"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radScopeAll);
        buttonGroup.add(this.radScopeBase);
        buttonGroup.add(this.radScopeBaseLevel);
        this.radScopeAll.setSelected(true);
        this.pnlScopes.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.pnlScopes.add((Component)this.radScopeAll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.pnlScopes.add((Component)this.radScopeBase, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.pnlScopes.add((Component)this.radScopeBaseLevel, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.pnlScopes, gridBagConstraints);
    }

    public void applyChanges() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        if (networkGroupBean != null) {
            if (this.radScopeAll.isSelected()) {
                networkGroupBean.setMaxScope(new Integer(2));
            } else if (this.radScopeBaseLevel.isSelected()) {
                networkGroupBean.setMaxScope(new Integer(1));
            } else if (this.radScopeBase.isSelected()) {
                networkGroupBean.setMaxScope(new Integer(0));
            }
        } else {
            throw new ConfigurationViewException();
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("groupSearchScope", "TITLE");
    }

    public void resetContent() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        Debug.println((String)("SearchScopeView.resetContent: model=" + networkGroupBean));
        if (networkGroupBean != null) {
            Integer n = networkGroupBean.getMaxScope();
            if (n != null) {
                if (n.equals(new Integer(2))) {
                    this.radScopeAll.setSelected(true);
                }
                if (n.equals(new Integer(1))) {
                    this.radScopeBaseLevel.setSelected(true);
                }
                if (n.equals(new Integer(0))) {
                    this.radScopeBase.setSelected(true);
                }
            }
        } else {
            throw new ConfigurationViewException();
        }
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new SearchScopeView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

