/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.group;

import com.iplanet.idar.objectmodel.bean.NetworkGroupBean;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class SearchReferralView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "NetworkGroup-Search-References";
    private JTextArea txtNote;
    private JRadioButton radDiscard;
    private JRadioButton radForward;
    private JRadioButton radFollow;

    public SearchReferralView() {
        this.initComponents();
    }

    public SearchReferralView(ConsoleInfo consoleInfo, NetworkGroupBean networkGroupBean) {
        this.setConsoleInfo(consoleInfo);
        this.setDataModel(networkGroupBean);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            Debug.println((int)6, (String)("SearchReferralView: Unable to resetContent: model = " + networkGroupBean));
        }
    }

    protected void initComponents() {
        this.txtNote = new JTextArea();
        this.txtNote.setText(IDARResourceSet.getString("groupSearchReferrals", "NOTE"));
        this.txtNote.setEditable(false);
        this.txtNote.setBackground(this.getBackground());
        this.txtNote.setLineWrap(true);
        this.txtNote.setWrapStyleWord(true);
        this.radDiscard = new JRadioButton(IDARResourceSet.getString("groupSearchReferrals", "SEARCH_REF_DISCARD"));
        this.radFollow = new JRadioButton(IDARResourceSet.getString("groupSearchReferrals", "SEARCH_REF_FOLLOW"));
        this.radForward = new JRadioButton(IDARResourceSet.getString("groupSearchReferrals", "SEARCH_REF_FORWARD"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radDiscard);
        buttonGroup.add(this.radFollow);
        buttonGroup.add(this.radForward);
        this.setLayout(new GridBagLayout());
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.txtNote, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        this.add((Component)this.radDiscard, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        this.add((Component)this.radForward, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.radFollow, gridBagConstraints);
    }

    public void applyChanges() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        if (networkGroupBean != null) {
            if (this.radDiscard.isSelected()) {
                networkGroupBean.setSearchReference("discard");
            } else if (this.radForward.isSelected()) {
                networkGroupBean.setSearchReference("forward");
            } else {
                networkGroupBean.setSearchReference("follow");
            }
        } else {
            Debug.println((String)("SearchReferralView:applyChanges(): model= " + networkGroupBean));
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("groupSearchReferrals", "TITLE");
    }

    public void resetContent() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        Debug.println((String)("SearchReferralView.resetContent: model=" + networkGroupBean));
        if (networkGroupBean != null) {
            String string = networkGroupBean.getSearchReference();
            if (string.equals("discard")) {
                this.radDiscard.setSelected(true);
            } else if (string.equals("forward")) {
                this.radForward.setSelected(true);
            } else {
                this.radFollow.setSelected(true);
            }
        } else {
            Debug.println((String)("SearchReferralView:resetContent(): model= " + networkGroupBean));
        }
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new SearchReferralView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

