/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.group;

import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.configuration.InvalidInputEvent;
import com.iplanet.idar.ui.common.configuration.ValidInputEvent;
import com.iplanet.idar.ui.configurator.group.NetworkDialogView;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NetworkQuadMaskCriteriaView
extends NetworkDialogView
implements SuiConstants {
    private JLabel lblIp;
    private JTextField ipMaskWithQuad;
    private JLabel lblQuad;
    private JTextField ipQuad;

    public NetworkQuadMaskCriteriaView() {
        this.initComponents();
    }

    public void setIP(String string) {
        this.ipMaskWithQuad.setText(string);
    }

    public void setQuad(String string) {
        this.ipQuad.setText(string);
    }

    public boolean isValidInput() {
        String string = "^(\\d{1,3}[.]\\d{1,3}[.]\\d{1,3}[.]\\d{1,3})$";
        String string2 = "^0[.]0[.]0[.]0$";
        Pattern pattern = null;
        Pattern pattern2 = null;
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        Perl5Matcher perl5Matcher = new Perl5Matcher();
        try {
            pattern = perl5Compiler.compile(string2);
            pattern2 = perl5Compiler.compile(string);
        }
        catch (MalformedPatternException malformedPatternException) {
            Debug.println((int)6, (String)"Bad regular expression pattern in isValidInput()");
            Debug.println((String)malformedPatternException.getMessage());
            malformedPatternException.printStackTrace();
        }
        String string3 = this.ipMaskWithQuad.getText().trim();
        String string4 = this.ipQuad.getText().trim();
        boolean bl = false;
        if (string3 != null && perl5Matcher.matches(string3, pattern2) && perl5Matcher.matches(string4, pattern2) && !perl5Matcher.matches(string3, pattern) && !perl5Matcher.matches(string4, pattern)) {
            bl = true;
        }
        return bl;
    }

    public void checkValidity() {
        if (this.ipMaskWithQuad.getText().trim().equals("") || this.ipQuad.getText().trim().equals("")) {
            this.fireInvalidInputEvent(new InvalidInputEvent(null));
        } else {
            this.fireValidInputEvent(new ValidInputEvent(null));
        }
    }

    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        this.ipMaskWithQuad = new JTextField(15);
        this.ipMaskWithQuad.setMinimumSize(this.ipMaskWithQuad.getPreferredSize());
        this.ipMaskWithQuad.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                NetworkQuadMaskCriteriaView.this.checkValidity();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                NetworkQuadMaskCriteriaView.this.checkValidity();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                NetworkQuadMaskCriteriaView.this.checkValidity();
            }
        });
        this.ipQuad = new JTextField(15);
        this.ipQuad.setMinimumSize(this.ipQuad.getPreferredSize());
        this.ipQuad.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                NetworkQuadMaskCriteriaView.this.checkValidity();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                NetworkQuadMaskCriteriaView.this.checkValidity();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                NetworkQuadMaskCriteriaView.this.checkValidity();
            }
        });
        this.lblQuad = new JLabel(IDARResourceSet.getString("groupNetworkQuadCriteria", "QUAD") + ":");
        this.lblQuad.setLabelFor(this.ipQuad);
        this.lblIp = new JLabel(IDARResourceSet.getString("groupNetworkQuadCriteria", "QUAD_CLIENTS"));
        this.lblIp.setLabelFor(this.ipMaskWithQuad);
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.lblIp, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.ipMaskWithQuad, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.lblQuad, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 0, 0, 9);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.ipQuad, gridBagConstraints);
    }

    public String getIPAddress() {
        return this.ipMaskWithQuad.getText().trim();
    }

    public String getQuad() {
        return this.ipQuad.getText().trim();
    }

    public JPanel getPanel() {
        return this;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new NetworkQuadMaskCriteriaView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

