/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.group;

import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.configuration.InvalidInputEvent;
import com.iplanet.idar.ui.common.configuration.ValidInputEvent;
import com.iplanet.idar.ui.configurator.group.NetworkDialogView;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NetworkIPCriteriaView
extends NetworkDialogView
implements SuiConstants {
    private JLabel lblIp;
    private JTextField ipIp;
    private ConsoleInfo info;
    private IDARModelBean model;

    public NetworkIPCriteriaView() {
        this.initComponents();
    }

    public NetworkIPCriteriaView(ConsoleInfo consoleInfo) {
        this.info = consoleInfo;
        this.initComponents();
    }

    public void setIP(String string) {
        this.ipIp.setText(string);
    }

    public boolean isValidInput() {
        String string = "^(\\d{1,3}[.]\\d{1,3}[.]\\d{1,3}[.]\\d{1,3})$";
        String string2 = "^0[.]0[.]0[.]0$";
        Pattern pattern = null;
        Pattern pattern2 = null;
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        Perl5Matcher perl5Matcher = new Perl5Matcher();
        try {
            pattern = perl5Compiler.compile(string2);
            pattern2 = perl5Compiler.compile(string);
        }
        catch (MalformedPatternException malformedPatternException) {
            Debug.println((int)6, (String)"Bad regular expression pattern in isValidInput()");
            Debug.println((String)malformedPatternException.getMessage());
            malformedPatternException.printStackTrace();
        }
        String string3 = this.ipIp.getText().trim();
        boolean bl = false;
        if (string3 != null && perl5Matcher.matches(string3, pattern2) && !perl5Matcher.matches(string3, pattern)) {
            bl = true;
        }
        return bl;
    }

    public void checkValidity() {
        if (this.ipIp.getText().trim().equals("")) {
            this.fireInvalidInputEvent(new InvalidInputEvent(null));
        } else {
            this.fireValidInputEvent(new ValidInputEvent(null));
        }
    }

    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        this.ipIp = new JTextField(25);
        this.ipIp.setMinimumSize(this.ipIp.getPreferredSize());
        this.ipIp.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                NetworkIPCriteriaView.this.checkValidity();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                NetworkIPCriteriaView.this.checkValidity();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                NetworkIPCriteriaView.this.checkValidity();
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 0);
        this.lblIp = new JLabel(IDARResourceSet.getString("groupNetworkIPCriteria", "IP_CLIENTS"));
        this.lblIp.setLabelFor(this.ipIp);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.lblIp, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.ipIp, gridBagConstraints);
    }

    public String getIPAddress() {
        return this.ipIp.getText().trim();
    }

    public JPanel getPanel() {
        return this;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new NetworkIPCriteriaView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

