/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.group;

import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.configuration.InvalidInputEvent;
import com.iplanet.idar.ui.common.configuration.ValidInputEvent;
import com.iplanet.idar.ui.configurator.group.NetworkDialogView;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NetworkDomainCriteriaView
extends NetworkDialogView
implements SuiConstants {
    private JLabel lblDomainName;
    private JTextField tfDomainName;

    public NetworkDomainCriteriaView() {
        this.initComponents();
    }

    public void setDomainName(String string) {
        this.tfDomainName.setText(string);
    }

    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        this.tfDomainName = new JTextField(25);
        this.tfDomainName.setMinimumSize(this.tfDomainName.getPreferredSize());
        this.tfDomainName.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                NetworkDomainCriteriaView.this.checkValidity();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                NetworkDomainCriteriaView.this.checkValidity();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                NetworkDomainCriteriaView.this.checkValidity();
            }
        });
        this.lblDomainName = new JLabel(IDARResourceSet.getString("groupNetworkDomainCriteria", "DOMAIN_CLIENTS"));
        this.lblDomainName.setLabelFor(this.tfDomainName);
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.lblDomainName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.tfDomainName, gridBagConstraints);
    }

    public boolean isValidInput() {
        String string = "^\\D+$";
        Pattern pattern = null;
        Perl5Compiler perl5Compiler = new Perl5Compiler();
        Perl5Matcher perl5Matcher = new Perl5Matcher();
        try {
            pattern = perl5Compiler.compile(string);
        }
        catch (MalformedPatternException malformedPatternException) {
            Debug.println((int)6, (String)"Bad regular expression pattern in NetworkBitMaskCriteriaView.isValidInput()");
            Debug.println((String)malformedPatternException.getMessage());
            malformedPatternException.printStackTrace();
        }
        String string2 = this.tfDomainName.getText().trim();
        boolean bl = false;
        if (string2 != null && perl5Matcher.matches(string2, pattern)) {
            bl = true;
        }
        return bl;
    }

    public void checkValidity() {
        if (this.tfDomainName.getText().trim().equals("")) {
            this.fireInvalidInputEvent(new InvalidInputEvent(null));
        } else {
            this.fireValidInputEvent(new ValidInputEvent(null));
        }
    }

    public String getDomainName() {
        return this.tfDomainName.getText();
    }

    public JPanel getPanel() {
        return this;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new NetworkDomainCriteriaView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

