/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.group;

import com.iplanet.idar.objectmodel.bean.GroupBean;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.NetworkGroupBean;
import com.iplanet.idar.objectmodel.bean.UniqueNameException;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.ImageFactory;
import com.iplanet.idar.ui.common.components.IDARScrollPane;
import com.iplanet.idar.ui.common.configuration.BlankPanel;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.iplanet.idar.ui.configurator.group.AttributeView;
import com.iplanet.idar.ui.configurator.group.CompatibilityView;
import com.iplanet.idar.ui.configurator.group.DataHidingView;
import com.iplanet.idar.ui.configurator.group.EncryptionView;
import com.iplanet.idar.ui.configurator.group.ForwardingView;
import com.iplanet.idar.ui.configurator.group.GeneralView;
import com.iplanet.idar.ui.configurator.group.LDAPServersView;
import com.iplanet.idar.ui.configurator.group.NetworkView;
import com.iplanet.idar.ui.configurator.group.ReferralView;
import com.iplanet.idar.ui.configurator.group.SearchView;
import com.iplanet.idar.ui.configurator.group.ServerLoadView;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.TitlePanel;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class GroupView
extends ConfigurationView
implements SuiConstants {
    private GroupBean model;
    private GeneralView events;
    private NetworkView network;
    private EncryptionView encryption;
    private LDAPServersView ldapServers;
    private CompatibilityView compatibility;
    private ForwardingView forwarding;
    private DataHidingView dataHiding;
    private SearchView search;
    private AttributeView attribute;
    private ReferralView referral;
    private ServerLoadView serverLoad;
    private TitlePanel pnlTitle;
    private JList lstViews;
    private final JPanel pnlViews = new JPanel();
    private final CardLayout cardLayout = new CardLayout();
    private JTextField tfName;
    private JLabel lblName;
    private JCheckBox chkEnabled;

    public GroupView() {
        this.initComponents();
    }

    public GroupView(ConsoleInfo consoleInfo, GroupBean groupBean) {
        super.setConsoleInfo(consoleInfo);
        super.setDataModel(groupBean);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            // empty catch block
        }
    }

    public void setConsoleInfo(ConsoleInfo consoleInfo) {
        super.setConsoleInfo(consoleInfo);
        if (this.events != null) {
            this.events.setConsoleInfo(consoleInfo);
            this.network.setConsoleInfo(consoleInfo);
            this.encryption.setConsoleInfo(consoleInfo);
            this.ldapServers.setConsoleInfo(consoleInfo);
            this.compatibility.setConsoleInfo(consoleInfo);
            this.forwarding.setConsoleInfo(consoleInfo);
            this.dataHiding.setConsoleInfo(consoleInfo);
            this.search.setConsoleInfo(consoleInfo);
            this.attribute.setConsoleInfo(consoleInfo);
            this.referral.setConsoleInfo(consoleInfo);
            this.serverLoad.setConsoleInfo(consoleInfo);
        }
    }

    public void setDataModel(IDARModelBean iDARModelBean) {
        Debug.println((String)("GroupView.setDataModel model=" + iDARModelBean));
        if (this.events != null) {
            this.events.setDataModel(iDARModelBean, false);
            this.network.setDataModel(iDARModelBean, false);
            this.encryption.setDataModel(iDARModelBean, false);
            this.ldapServers.setDataModel(iDARModelBean, false);
            this.compatibility.setDataModel(iDARModelBean, false);
            this.forwarding.setDataModel(iDARModelBean, false);
            this.dataHiding.setDataModel(iDARModelBean, false);
            this.search.setDataModel(iDARModelBean, false);
            this.attribute.setDataModel(iDARModelBean, false);
            this.referral.setDataModel(iDARModelBean, false);
            this.serverLoad.setDataModel(iDARModelBean, false);
        }
        super.setDataModel(iDARModelBean);
    }

    protected void initComponents() {
        this.events = new GeneralView();
        this.network = new NetworkView();
        this.encryption = new EncryptionView();
        this.ldapServers = new LDAPServersView();
        this.compatibility = new CompatibilityView();
        this.forwarding = new ForwardingView();
        this.dataHiding = new DataHidingView();
        this.search = new SearchView();
        this.attribute = new AttributeView();
        this.referral = new ReferralView();
        this.serverLoad = new ServerLoadView();
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        if (networkGroupBean != null) {
            this.setDataModel(networkGroupBean);
        }
        this.pnlTitle = new TitlePanel();
        this.pnlTitle.setIcon((Icon)ImageFactory.getImage("GROUP"));
        this.pnlTitle.setText(this.getTitleText());
        this.tfName = new JTextField();
        this.lblName = new JLabel();
        this.lblName.setLabelFor(this.tfName);
        this.lblName.setText(IDARResourceSet.getString("groupGeneral", "NAME") + ":");
        this.tfName = new JTextField();
        this.chkEnabled = new JCheckBox();
        this.chkEnabled.setText(IDARResourceSet.getString("groupGeneral", "ENABLED"));
        BlankPanel blankPanel = new BlankPanel();
        blankPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        blankPanel.add((Component)this.pnlTitle, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        blankPanel.add((Component)this.lblName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        blankPanel.add((Component)this.tfName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 9;
        gridBagConstraints.insets.left = 9;
        gridBagConstraints.insets.bottom = 9;
        gridBagConstraints.insets.right = 9;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        blankPanel.add((Component)this.chkEnabled, gridBagConstraints);
        this.pnlViews.setLayout(this.cardLayout);
        Vector<String> vector = new Vector<String>();
        String string = this.ldapServers.getTitleText();
        vector.add(string);
        this.pnlViews.add(string, this.createScrollablePane(this.ldapServers));
        string = this.network.getTitleText();
        vector.add(string);
        this.pnlViews.add(string, this.createScrollablePane(this.network));
        string = this.events.getTitleText();
        vector.add(string);
        this.pnlViews.add(string, this.createScrollablePane(this.events));
        string = this.encryption.getTitleText();
        vector.add(string);
        this.pnlViews.add(string, this.createScrollablePane(this.encryption));
        string = this.compatibility.getTitleText();
        vector.add(string);
        this.pnlViews.add(string, this.createScrollablePane(this.compatibility));
        string = this.forwarding.getTitleText();
        vector.add(string);
        this.pnlViews.add(string, this.createScrollablePane(this.forwarding));
        string = this.dataHiding.getTitleText();
        vector.add(string);
        this.pnlViews.add(string, this.createScrollablePane(this.dataHiding));
        string = this.search.getTitleText();
        vector.add(string);
        this.pnlViews.add(string, this.createScrollablePane(this.search));
        string = this.attribute.getTitleText();
        vector.add(string);
        this.pnlViews.add(string, this.createScrollablePane(this.attribute));
        string = this.referral.getTitleText();
        vector.add(string);
        this.pnlViews.add(string, this.createScrollablePane(this.referral));
        string = this.serverLoad.getTitleText();
        vector.add(string);
        this.pnlViews.add(string, this.createScrollablePane(this.serverLoad));
        this.lstViews = new JList(vector);
        this.lstViews.setToolTipText(IDARResourceSet.getString("tooltip", "group_views"));
        this.lstViews.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                GroupView.this.cardLayout.show(GroupView.this.pnlViews, (String)GroupView.this.lstViews.getSelectedValue());
            }
        });
        this.lstViews.setSelectedIndex(0);
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(9);
        borderLayout.setVgap(9);
        this.setLayout(borderLayout);
        this.add("North", blankPanel);
        this.add("West", new JScrollPane(this.lstViews));
        this.add("Center", this.pnlViews);
    }

    private IDARScrollPane createScrollablePane(ConfigurationView configurationView) {
        IDARScrollPane iDARScrollPane = new IDARScrollPane(configurationView);
        iDARScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.pnlViews.add(configurationView.getTitleText(), iDARScrollPane);
        configurationView.addBlankPanelListener(this);
        configurationView.setConsoleInfo(this.getConsoleInfo());
        return iDARScrollPane;
    }

    public void resetContent() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)super.getDataModel();
        Debug.println((String)("GroupView.resetContent: model=" + networkGroupBean));
        if (networkGroupBean != null) {
            this.tfName.setText(networkGroupBean.getId());
            this.chkEnabled.setSelected(networkGroupBean.isEnabled());
            this.events.resetContent();
            this.network.resetContent();
            this.encryption.resetContent();
            this.ldapServers.resetContent();
            this.compatibility.resetContent();
            this.forwarding.resetContent();
            this.dataHiding.resetContent();
            this.search.resetContent();
            this.attribute.resetContent();
            this.referral.resetContent();
            this.serverLoad.resetContent();
        }
    }

    public void applyChanges() throws ConfigurationViewException {
        if (this.tfName.getText().trim().equals("")) {
            throw new ConfigurationViewException(IDARResourceSet.getString("error", "ERR_NO_ID"));
        }
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)super.getDataModel();
        if (networkGroupBean != null) {
            if (!networkGroupBean.getName().equals(this.tfName.getText())) {
                try {
                    networkGroupBean.setName(this.tfName.getText());
                }
                catch (UniqueNameException uniqueNameException) {
                    throw new ConfigurationViewException(IDARResourceSet.getString("error", "UNIQUE_NAME", this.tfName.getText()));
                }
            }
            networkGroupBean.setEnabled(this.chkEnabled.isSelected());
            try {
                this.events.applyChanges();
            }
            catch (ConfigurationViewException configurationViewException) {
                this.cardLayout.show(this.pnlViews, this.events.getTitleText());
                this.lstViews.setSelectedValue(this.events.getTitleText(), true);
                throw configurationViewException;
            }
            try {
                this.network.applyChanges();
            }
            catch (ConfigurationViewException configurationViewException) {
                this.cardLayout.show(this.pnlViews, this.network.getTitleText());
                this.lstViews.setSelectedValue(this.network.getTitleText(), true);
                throw configurationViewException;
            }
            try {
                this.encryption.applyChanges();
            }
            catch (ConfigurationViewException configurationViewException) {
                this.cardLayout.show(this.pnlViews, this.encryption.getTitleText());
                this.lstViews.setSelectedValue(this.encryption.getTitleText(), true);
                throw configurationViewException;
            }
            try {
                this.ldapServers.applyChanges();
            }
            catch (ConfigurationViewException configurationViewException) {
                this.cardLayout.show(this.pnlViews, this.ldapServers.getTitleText());
                this.lstViews.setSelectedValue(this.ldapServers.getTitleText(), true);
                throw configurationViewException;
            }
            try {
                this.compatibility.applyChanges();
            }
            catch (ConfigurationViewException configurationViewException) {
                this.cardLayout.show(this.pnlViews, this.compatibility.getTitleText());
                this.lstViews.setSelectedValue(this.compatibility.getTitleText(), true);
                throw configurationViewException;
            }
            try {
                this.forwarding.applyChanges();
            }
            catch (ConfigurationViewException configurationViewException) {
                this.cardLayout.show(this.pnlViews, this.forwarding.getTitleText());
                this.lstViews.setSelectedValue(this.forwarding.getTitleText(), true);
                throw configurationViewException;
            }
            try {
                this.dataHiding.applyChanges();
            }
            catch (ConfigurationViewException configurationViewException) {
                this.cardLayout.show(this.pnlViews, this.dataHiding.getTitleText());
                this.lstViews.setSelectedValue(this.dataHiding.getTitleText(), true);
                throw configurationViewException;
            }
            try {
                this.search.applyChanges();
            }
            catch (ConfigurationViewException configurationViewException) {
                this.cardLayout.show(this.pnlViews, this.search.getTitleText());
                this.lstViews.setSelectedValue(this.search.getTitleText(), true);
                throw configurationViewException;
            }
            try {
                this.attribute.applyChanges();
            }
            catch (ConfigurationViewException configurationViewException) {
                this.cardLayout.show(this.pnlViews, this.attribute.getTitleText());
                this.lstViews.setSelectedValue(this.attribute.getTitleText(), true);
                throw configurationViewException;
            }
            try {
                this.referral.applyChanges();
            }
            catch (ConfigurationViewException configurationViewException) {
                this.cardLayout.show(this.pnlViews, this.referral.getTitleText());
                this.lstViews.setSelectedValue(this.referral.getTitleText(), true);
                throw configurationViewException;
            }
            try {
                this.serverLoad.applyChanges();
            }
            catch (ConfigurationViewException configurationViewException) {
                this.cardLayout.show(this.pnlViews, this.serverLoad.getTitleText());
                this.lstViews.setSelectedValue(this.serverLoad.getTitleText(), true);
                throw configurationViewException;
            }
        }
    }

    public boolean isDirty() {
        return this.model.isDirty();
    }

    public String getHelpTopic() {
        ConfigurationView configurationView;
        String string = "";
        int n = this.lstViews.getSelectedIndex();
        IDARScrollPane iDARScrollPane = (IDARScrollPane)this.pnlViews.getComponent(n);
        if (iDARScrollPane != null && (configurationView = (ConfigurationView)iDARScrollPane.getViewport().getView()) != null) {
            string = configurationView.getHelpTopic();
        }
        return string;
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("group", "TITLE");
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new GroupView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

