/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.group;

import com.iplanet.idar.objectmodel.bean.NetworkGroupBean;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ForwardingOperationsView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "NetworkGroup-Forwarding-Operations";
    private JCheckBox chkPermitSearch;
    private JCheckBox chkPermitCompare;
    private JCheckBox chkPermitAdd;
    private JCheckBox chkPermitDelete;
    private JCheckBox chkPermitModify;
    private JCheckBox chkPermitModifyRDN;
    private JCheckBox chkPermitExtended;

    public ForwardingOperationsView() {
        this.initComponents();
    }

    public ForwardingOperationsView(ConsoleInfo consoleInfo, NetworkGroupBean networkGroupBean) {
        this.setConsoleInfo(consoleInfo);
        this.setDataModel(networkGroupBean);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            // empty catch block
        }
    }

    protected void initComponents() {
        this.chkPermitSearch = new JCheckBox();
        this.chkPermitCompare = new JCheckBox();
        this.chkPermitAdd = new JCheckBox();
        this.chkPermitDelete = new JCheckBox();
        this.chkPermitModify = new JCheckBox();
        this.chkPermitModifyRDN = new JCheckBox();
        this.chkPermitExtended = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.chkPermitSearch.setText(IDARResourceSet.getString("groupForwardingOperations", "PERMIT_SEARCH"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.chkPermitSearch, gridBagConstraints);
        this.chkPermitCompare.setText(IDARResourceSet.getString("groupForwardingOperations", "PERMIT_COMPARE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.chkPermitCompare, gridBagConstraints);
        this.chkPermitAdd.setText(IDARResourceSet.getString("groupForwardingOperations", "PERMIT_ADD"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.chkPermitAdd, gridBagConstraints);
        this.chkPermitDelete.setText(IDARResourceSet.getString("groupForwardingOperations", "PERMIT_DELETE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.chkPermitDelete, gridBagConstraints);
        this.chkPermitModify.setText(IDARResourceSet.getString("groupForwardingOperations", "PERMIT_MODIFY"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.chkPermitModify, gridBagConstraints);
        this.chkPermitModifyRDN.setText(IDARResourceSet.getString("groupForwardingOperations", "PERMIT_MODIFY_RDN"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.chkPermitModifyRDN, gridBagConstraints);
        this.chkPermitExtended.setText(IDARResourceSet.getString("groupForwardingOperations", "PERMIT_EXTENDED"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.chkPermitExtended, gridBagConstraints);
    }

    public void applyChanges() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        if (networkGroupBean != null) {
            networkGroupBean.setPermitOpSearch(this.chkPermitSearch.isSelected());
            networkGroupBean.setPermitOpCompare(this.chkPermitCompare.isSelected());
            networkGroupBean.setPermitOpAdd(this.chkPermitAdd.isSelected());
            networkGroupBean.setPermitOpDelete(this.chkPermitDelete.isSelected());
            networkGroupBean.setPermitOpModify(this.chkPermitModify.isSelected());
            networkGroupBean.setPermitOpModRdn(this.chkPermitModifyRDN.isSelected());
            networkGroupBean.setPermitOpExtended(this.chkPermitExtended.isSelected());
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("groupForwardingOperations", "TITLE");
    }

    public void resetContent() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        Debug.println((String)("ForwardingOperationView.resetContent: model=" + networkGroupBean));
        if (networkGroupBean != null) {
            this.chkPermitSearch.setSelected(networkGroupBean.getPermitOpSearch());
            this.chkPermitCompare.setSelected(networkGroupBean.getPermitOpCompare());
            this.chkPermitAdd.setSelected(networkGroupBean.getPermitOpAdd());
            this.chkPermitDelete.setSelected(networkGroupBean.getPermitOpDelete());
            this.chkPermitModify.setSelected(networkGroupBean.getPermitOpModify());
            this.chkPermitModifyRDN.setSelected(networkGroupBean.getPermitOpModRdn());
            this.chkPermitExtended.setSelected(networkGroupBean.getPermitOpExtended());
        }
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new ForwardingOperationsView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

