/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.idar.ui.configurator.group;

import com.iplanet.idar.objectmodel.BeanSpace;
import com.iplanet.idar.objectmodel.bean.IDARBeanCollection;
import com.iplanet.idar.objectmodel.bean.IDARBeanException;
import com.iplanet.idar.objectmodel.bean.IDARModelBean;
import com.iplanet.idar.objectmodel.bean.NetworkGroupBean;
import com.iplanet.idar.ui.common.DynamicComboBoxModel;
import com.iplanet.idar.ui.common.DynamicListModel;
import com.iplanet.idar.ui.common.IDARResourceSet;
import com.iplanet.idar.ui.common.NewItemListener;
import com.iplanet.idar.ui.common.configuration.ConfigurationView;
import com.iplanet.idar.ui.common.configuration.ConfigurationViewException;
import com.iplanet.idar.ui.task.TaskButton;
import com.iplanet.idar.ui.task.configuration.IplanetCreateAndEditObjectTask;
import com.iplanet.idar.ui.task.configuration.IplanetEditObjectTask;
import com.netscape.management.client.components.ButtonFactory;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class EntryHidingView
extends ConfigurationView
implements SuiConstants {
    private static final String HELP_TOPIC = "NetworkGroup-DataHiding-Entry";
    private JTextArea txtNote;
    private JComboBox cbEntryProperties;
    private JButton butNew;
    private JButton butEdit;
    private NewItemListener newItemListener;
    protected final IplanetEditObjectTask editTask = new IplanetEditObjectTask();
    protected final IplanetCreateAndEditObjectTask createTask = new IplanetCreateAndEditObjectTask("forbidden-entry");

    public EntryHidingView() {
        this.initComponents();
    }

    public EntryHidingView(ConsoleInfo consoleInfo, NetworkGroupBean networkGroupBean) {
        this.setConsoleInfo(consoleInfo);
        this.setDataModel(networkGroupBean);
        this.initComponents();
        try {
            this.resetContent();
        }
        catch (ConfigurationViewException configurationViewException) {
            Debug.println((int)6, (String)("Unable to resetContent in Constructor. Model = " + networkGroupBean));
        }
    }

    public void setConsoleInfo(ConsoleInfo consoleInfo) {
        super.setConsoleInfo(consoleInfo);
        this.createTask.setConsoleInfo(consoleInfo);
        this.editTask.setConsoleInfo(consoleInfo);
    }

    public void setDataModel(IDARModelBean iDARModelBean, boolean bl) {
        super.setDataModel(iDARModelBean, bl);
        this.createTask.setParentConfiguration(iDARModelBean.getParentConfiguration());
    }

    protected void initComponents() {
        this.txtNote = new JTextArea();
        this.cbEntryProperties = new JComboBox(new DynamicComboBoxModel());
        this.cbEntryProperties.setToolTipText(IDARResourceSet.getString("tooltip", "selected_entry_hiding_property"));
        this.cbEntryProperties.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EntryHidingView.this.setEnablement();
            }
        });
        this.butNew = new TaskButton(this.createTask);
        ButtonFactory.resizeButton((JButton)this.butNew);
        this.newItemListener = new NewItemListener(this.butNew);
        this.butEdit = new TaskButton(this.editTask);
        ButtonFactory.resizeButton((JButton)this.butEdit);
        this.setLayout(new GridBagLayout());
        this.txtNote.setText(IDARResourceSet.getString("groupDataHidingEntry", "NOTE"));
        this.txtNote.setEditable(false);
        this.txtNote.setBackground(this.getBackground());
        this.txtNote.setLineWrap(true);
        this.txtNote.setWrapStyleWord(true);
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        this.add((Component)this.txtNote, gridBagConstraints);
        gridBagConstraints.insets = new Insets(9, 9, 9, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.right = 0;
        this.add((Component)this.cbEntryProperties, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.add((Component)this.butNew, gridBagConstraints);
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        this.add((Component)this.butEdit, gridBagConstraints);
    }

    private DynamicComboBoxModel getListModel() {
        DynamicComboBoxModel dynamicComboBoxModel;
        block5: {
            Debug.println((int)5);
            dynamicComboBoxModel = null;
            IDARModelBean iDARModelBean = this.getDataModel();
            if (iDARModelBean != null) {
                try {
                    IDARBeanCollection iDARBeanCollection = BeanSpace.getInstance().retrieveBeanCollection(iDARModelBean.getParentConfiguration(), "forbidden-entry");
                    if (iDARBeanCollection != null) {
                        DynamicComboBoxModel dynamicComboBoxModel2 = (DynamicComboBoxModel)this.cbEntryProperties.getModel();
                        dynamicComboBoxModel2.setBeanCollection(iDARBeanCollection);
                        this.newItemListener.setModel(dynamicComboBoxModel2);
                        break block5;
                    }
                    Debug.println((int)6, (String)"collection is null");
                }
                catch (IDARBeanException iDARBeanException) {
                    iDARBeanException.printStackTrace();
                }
            } else {
                Debug.println((int)6, (String)("Unable to set data model. Model = " + iDARModelBean));
            }
        }
        return dynamicComboBoxModel;
    }

    public void applyChanges() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        if (networkGroupBean != null) {
            Object object = this.cbEntryProperties.getSelectedItem();
            if (object != null) {
                String string = object.toString();
                if (!string.equals("") && !string.equals(DynamicListModel.NONE)) {
                    networkGroupBean.setForbiddenEntryPropertyId(this.cbEntryProperties.getSelectedItem().toString());
                } else {
                    networkGroupBean.setForbiddenEntryPropertyId(null);
                }
            }
        } else {
            throw new ConfigurationViewException();
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitleText() {
        return IDARResourceSet.getString("groupDataHidingEntry", "TITLE");
    }

    public void resetContent() throws ConfigurationViewException {
        NetworkGroupBean networkGroupBean = (NetworkGroupBean)this.getDataModel();
        Debug.println((String)("EntryHidingView.resetContent: model=" + networkGroupBean));
        if (networkGroupBean != null) {
            Serializable serializable;
            if (this.cbEntryProperties.getModel() instanceof DynamicComboBoxModel && (serializable = this.getListModel()) != null) {
                this.cbEntryProperties.setModel(serializable);
            }
            if (!((Vector)(serializable = networkGroupBean.getForbiddenEntryPropertyIds())).isEmpty()) {
                this.cbEntryProperties.setSelectedItem(((Vector)serializable).firstElement());
            } else {
                this.cbEntryProperties.setSelectedItem(DynamicComboBoxModel.NONE);
            }
        } else {
            throw new ConfigurationViewException();
        }
        this.setEnablement();
    }

    public String getHelpTopic() {
        return HELP_TOPIC;
    }

    protected void setEnablement() {
        this.editTask.setObject(((DynamicComboBoxModel)this.cbEntryProperties.getModel()).getSelectedReference());
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new EntryHidingView());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

